/**
 * JASMINe
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.rules.probes.parsers;

import org.objectweb.jasmine.rules.probes.helpers.NetworkProbe;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NetworkParser {

    /**
     * Creates a networkProbe from a node
     * 
     * @param node
     *            a XML node
     * @return a NetworkProbe
     */
    public NetworkProbe createNetworkProbe(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        // The attributes
        String timestamp = null;
        String hostname = null;
        String ip = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node attribute = namedNodeMap.item(i);
            String nodeName = attribute.getNodeName();

            if (nodeName.equals("timestamp"))
                timestamp = attribute.getNodeValue();

            if (nodeName.equals("hostname"))
                hostname = attribute.getNodeValue();

            if (nodeName.equals("ip")) {
                ip = attribute.getNodeValue();
            }
        }

        // The children nodes
        NodeList children = node.getChildNodes();

        Node method = children.item(1);
        Node value = method.getChildNodes().item(1);
        Node netStatsSum = value.getChildNodes().item(0);
        NodeList grandChildren = netStatsSum.getChildNodes();

        Long txBytesNetwork = null;
        Long rxBytesNetwork = null;

        for (int i = 0; i < grandChildren.getLength(); ++i) {
            Node grandChild = grandChildren.item(i);
            String nameChild = grandChild.getNodeName();
            String tmp = grandChild.getTextContent();

            if (nameChild.equals("TxBytes"))
                txBytesNetwork = Long.valueOf(tmp);

            if (nameChild.equals("RxBytes"))
                rxBytesNetwork = Long.valueOf(tmp);
        }

        return new NetworkProbe(timestamp, hostname, ip, txBytesNetwork,
                rxBytesNetwork);
    }
}

/*
 * <probe timestamp="1156235439042" hostname="frecb000707.frec.bull.fr"
 * ip="129.183.91.53"> <name>network</name> <method> <name>getData</name>
 * <value> <NetStatsSum> <TxBytes>9504</TxBytes> <RxBytes>9976</RxBytes>
 * </NetStatsSum> <NetStats> <sit0> <TxCompr>0</TxCompr> <RxFifo>0</RxFifo>
 * <RxPackets>0</RxPackets> <TxDrop>0</TxDrop> <RxMulti>0</RxMulti> <TxCarr>0</TxCarr>
 * <TxBytes>0</TxBytes> <TxFifo>0</TxFifo> <RxDrop>0</RxDrop> <TxColls>0</TxColls>
 * <TxPacktes>0</TxPacktes> <RxCompr>0</RxCompr> <RxErrs>0</RxErrs>
 * <RxBytes>0</RxBytes> <RxFrame>0</RxFrame> <TxErrs>0</TxErrs> </sit0> <lo>
 * <TxCompr>0</TxCompr> <RxFifo>0</RxFifo> <RxPackets>23</RxPackets>
 * <TxDrop>0</TxDrop> <RxMulti>0</RxMulti> <TxCarr>0</TxCarr> <TxBytes>9504</TxBytes>
 * <TxFifo>0</TxFifo> <RxDrop>0</RxDrop> <TxColls>0</TxColls> <TxPacktes>23</TxPacktes>
 * <RxCompr>0</RxCompr> <RxErrs>0</RxErrs> <RxBytes>9504</RxBytes> <RxFrame>0</RxFrame>
 * <TxErrs>0</TxErrs> </lo> <eth0> <TxCompr>0</TxCompr> <RxFifo>0</RxFifo>
 * <RxPackets>6</RxPackets> <TxDrop>0</TxDrop> <RxMulti>0</RxMulti> <TxCarr>0</TxCarr>
 * <TxBytes>0</TxBytes> <TxFifo>0</TxFifo> <RxDrop>0</RxDrop> <TxColls>0</TxColls>
 * <TxPacktes>0</TxPacktes> <RxCompr>0</RxCompr> <RxErrs>0</RxErrs>
 * <RxBytes>472</RxBytes> <RxFrame>0</RxFrame> <TxErrs>0</TxErrs> </eth0>
 * </NetStats> </value> </method> </probe>
 */