/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.rules.probes.parsers;

import org.objectweb.jasmine.rules.probes.helpers.MemoryProbe;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MemoryParser {
    public MemoryProbe createMemoryProbe(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String timestamp = null;
        String hostname = null;
        String ip = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node attribute = namedNodeMap.item(i);
            String nodeName = attribute.getNodeName();
            if (nodeName.equals("timestamp")) {
                timestamp = attribute.getNodeValue();
            }
            if (nodeName.equals("hostname")) {
                hostname = attribute.getNodeValue();
            }
            if (!nodeName.equals("ip")) continue;
            ip = attribute.getNodeValue();
        }
        NodeList children = node.getChildNodes();
        Node method = children.item(1);
        Node value = method.getChildNodes().item(1);
        Node MemStats = value.getChildNodes().item(0);
        NodeList grandChildren = MemStats.getChildNodes();
        Long cachedMemory = null;
        Long swapUsedMemory = null;
        Long memTotalMemory = null;
        Float swapUsedPerMemory = null;
        Long buffersMemory = null;
        Long memUsedMemory = null;
        Long swapTotalMemory = null;
        Long memFreeMemory = null;
        Long swapFreeMemory = null;
        Float memUsedPerMemory = null;
        for (int i = 0; i < grandChildren.getLength(); ++i) {
            Node grandChild = grandChildren.item(i);
            String nameChild = grandChild.getNodeName();
            String tmp = grandChild.getTextContent();
            if (nameChild.equals("Cached")) {
                cachedMemory = Long.valueOf(tmp);
            }
            if (nameChild.equals("SwapUsed")) {
                swapUsedMemory = Long.valueOf(tmp);
            }
            if (nameChild.equals("MemTotal")) {
                memTotalMemory = Long.valueOf(tmp);
            }
            if (nameChild.equals("SwapUsedPer")) {
                swapUsedPerMemory = Float.valueOf(tmp);
            }
            if (nameChild.equals("Buffers")) {
                buffersMemory = Long.valueOf(tmp);
            }
            if (nameChild.equals("MemUsed")) {
                memUsedMemory = Long.valueOf(tmp);
            }
            if (nameChild.equals("SwapTotal")) {
                swapTotalMemory = Long.valueOf(tmp);
            }
            if (nameChild.equals("MemFree")) {
                memFreeMemory = Long.valueOf(tmp);
            }
            if (nameChild.equals("SwapFree")) {
                swapFreeMemory = Long.valueOf(tmp);
            }
            if (!nameChild.equals("MemUsedPer")) continue;
            memUsedPerMemory = Float.valueOf(tmp);
        }
        return new MemoryProbe(timestamp, hostname, ip, cachedMemory, swapUsedMemory, memTotalMemory, swapUsedPerMemory.floatValue(), buffersMemory, memUsedMemory, swapTotalMemory, memFreeMemory, swapFreeMemory, memUsedPerMemory.floatValue());
    }
}

