/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: EventswitchOutput.java 7191 2010-11-25 07:55:57Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.api;

/**
 * Output to the JASMINe Eventswitch.
 * Corresponds to(<code>-jasmine url</code> option).
 * @author danesa
 * @author durieuxp
 */
public class EventswitchOutput extends JasmineOutput {

    /**
     * URL corresponding to a JSAMINe endpoint address.
     */
    private String url;

    private String port;

    private String host;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    /**
     * Indicates whether some other object is "equal to" this one.
     * @param obj The other object to compare
     * @return true if both objects are the same.
     */
    public boolean equals(Object obj) {
        if (! (obj instanceof EventswitchOutput)) {
            return false;
        }
        EventswitchOutput other = (EventswitchOutput) obj;
        if (! super.equals(obj)) {
            return false;
        }
        if (other.getHost() == null) {
            if (host != null) return false;
        } else {
            if (! other.getHost().equals(host)) return false;
        }
        if (other.getPort() == null) {
            if (port != null) return false;
        } else {
            if (! other.getPort().equals(port)) return false;
        }
        if (other.getUrl() == null) {
            if (url != null) return false;
        } else {
            if (! other.getUrl().equals(url)) return false;
        }
        return true;
    }

    /**
     * @return string representation of the object.
     */
    public String toString() {
        return super.toString() + ": EVENTSWITCH " + url + " " + host + " "  + port;
    }
}
