/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: FileOutput.java 7087 2010-11-10 08:36:08Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.api;

/**
 * Output to a file. Used by probes that support <code>-f path</code> option.
 * @author danesa
 * @author durieuxp
 */
public class FileOutput extends JasmineOutput {

    /**
     * Path to the file that contains the probe output.
     */
    String path;

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    /**
     * Indicates whether some other object is "equal to" this one.
     * @param obj The other object to compare
     * @return true if both objects are the same.
     */
    public boolean equals(Object obj) {
        if (! (obj instanceof FileOutput)) {
            return false;
        }
        FileOutput other = (FileOutput) obj;
        boolean ret = super.equals(obj);
        if (ret == true) {
            ret =
                other.getPath().equals(path);
        }
        return ret;
    }

    /**
     * @return string representation of the object.
     */
    public String toString() {
        return super.toString() + ": FILE " + path;
    }
}
