/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineCommand.java 7202 2010-11-26 09:55:28Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.api;

import java.util.List;

/**
 * JASMINe Commnad definition.
 * @author danesa
 */
public class JasmineCommand  {

    /**
     * JASMINe command name.
     * Examples:
     * - mbean
     * - dump
     */
    String name;

    /**
     *  Probe or command targets
     */
    List<JasmineTarget> targetList;

    public JasmineCommand() {

    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<JasmineTarget> getTargetList() {
        return targetList;
    }

    public void setTargetList(List<JasmineTarget> targetList) {
        this.targetList = targetList;
    }
}
