/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineMbeanCommand.java 7202 2010-11-26 09:55:28Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.api;

/**
 * JASMINe <code>mbean</code> commnad definition.
 * @author danesa
 */
public class JasmineMbeanCommand extends JasmineCommand {

    /**
     * Corresponds to the -v argument.
     */
    boolean verbose;

    /**
     * Defines ObjectName filter for the MBeans to query or poll.
     * Filter may be an exact match of a MBean OBJECT_NAME or contain wildcards according to the JMX conventions.
     * Corresponds to the -name argument.
     * TODO argument name to be changed in the future -> -filter ??
     */
    String filter;

    /**
     * Corresponds to the -query access argument.
     */
    boolean query;

    /**
     * Corresponds to the -info access argument.
     */
    boolean info;

    /**
     * Corresponds to the -get access argument.
     * The argument's value is an attribute name.
     */
    String attributeToGet;

    public JasmineMbeanCommand() {
        super();
        name = "mbeans";
    }

    public String getAttributeToGet() {
        return attributeToGet;
    }

    public void setAttributeToGet(String attributeToGet) {
        this.attributeToGet = attributeToGet;
    }

    public boolean isVerbose() {
        return verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getFilter() {
        return filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean isQuery() {
        return query;
    }

    public void setQuery(boolean query) {
        this.query = query;
    }

    public boolean isInfo() {
        return info;
    }

    public void setInfo(boolean info) {
        this.info = info;
    }

}
