/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineProbe.java 7079 2010-11-09 12:19:37Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.api;

import java.util.List;

/**
 * JASMINe Probe definition. Also contains state information and probe identifier.
 * @author danesa
 * @author durieuxp
 */
public class JasmineProbe {

    /**
     * Probe identifier. Provided by the JASMINe Probe Manager.
     */
    int id;

    /**
     * JASMINe probe name.
     * Examples:
     * - stat
     * - poll
     */
    String name;

    /**
     *  Probe targets
     */
    List<JasmineTarget> targetList;

    /**
     *  Probe outputs.
     */
    List<JasmineOutput> outputList;

    /**
     *  State Management
     */
    int state;

    public static final int PROBE_STOPPED = 0;
    public static final int PROBE_STARTED = 1;
    public static final int PROBE_RUNNING = 2;
    public static final int PROBE_FAILED  = 3;

    /**
     * Probe execution period in seconds.
     */
    int period = 10;

    /**
     * Period for refreshing MBeans used by the probe.
     */
    int refreshPeriod;

    /**
     * Separator used to delimit the obtained monitoring data.
     */
    String separator = ";";

    String error;

    public String getSeparator() {
        return separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<JasmineTarget> getTargetList() {
        return targetList;
    }

    public void setTargetList(List<JasmineTarget> targetList) {
        this.targetList = targetList;
    }

    public int getPeriod() {
        return period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getRefreshPeriod() {
        return refreshPeriod;
    }

    public void setRefreshPeriod(int refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }


    public List<JasmineOutput> getOutputList() {
        return outputList;
    }

    public void setOutputList(List<JasmineOutput> outputList) {
        this.outputList = outputList;
    }

    public int getState() {
        return state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getError() {
        return error;
    }

    public void setError(String mess) {
        this.error = mess;
    }

}