/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineProbeDataModel.java 7540 2011-01-27 10:52:19Z danesa $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.api;

import java.util.Date;

import javax.management.AttributeList;

/**
 * Data returned by probes
 * @author durieuxp
 *
 */
public class JasmineProbeDataModel {
    /**
     * Collect operation time.
     */
    private Date timestamp;

    public Date getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Date t) {
        timestamp = t;
    }

   /**
    * Identifier of the JasmineTarget.
    */
   private String targetId;

   public String getTargetId() {
       return targetId;
   }

   public void setTargetId(String s) {
       targetId = s;
   }
    /**
     * The target URL.
     */
    private String targetUrl;

    public String getTargetUrl() {
        return targetUrl;
    }

    public void setTargetUrl(String s) {
        targetUrl = s;
    }

    /**
     * Domain of the target.
     */
    private String domain;

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return domain;
    }

    /**
     * Server name of the target.
     */
    private String server;

    public void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        return server;
    }

    /**
     * resource Jmx ObjectName of the resource
     * not always an ObjectName, but must follow the Objectname structure:
     * <domain>:<name>=<value>,...
     */
    private String resource;

    public String getResource() {
        return resource;
    }

    public void setResource(String s) {
        resource = s;
    }

    /**
     * probe identifier of the Probe
     */
    private int probeId;

    public int getProbeId() {
        return probeId;
    }

    public void setProbeId(int value) {
        probeId = value;
    }

    /**
     * Each probe can collect a Set of indicators at each polling.
     * Indicators have the type Attribute, where value is an Object
     * that can be a Date, int, long, Float, or String.
     */
    private AttributeList indicators;

    public AttributeList getIndicators() {
        return indicators;
    }

    public void setIndicators(AttributeList list) {
        indicators = list;
    }

}
