/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.itests;

import au.com.bytecode.opencsv.CSVReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.itests.JOnASLauncher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IndicatorDfTest
extends JOnASLauncher {
    final String name = "tst_DfAll";

    @Test
    public void testIndicatorCreateDfAll() throws Exception {
        logger.debug((Object)">> testIndicatorCreateDfAll", new Object[0]);
        JasmineIndicator indicatorDfAll = new JasmineIndicator();
        indicatorDfAll.setName("tst_DfAll");
        indicatorDfAll.setType("df");
        this.getProxyMXBean().createIndicator(indicatorDfAll);
        JasmineIndicator ji = this.getProxyMXBean().getIndicator("tst_DfAll");
        Assert.assertEquals((String)ji.getName(), (String)"tst_DfAll", (String)("Invalid indicator name. (Actual = " + ji.getName() + ", Expected = " + "tst_DfAll" + ")"));
        Assert.assertEquals((String)ji.getType(), (String)"df", (String)("Invalid indicator type. (Actual = " + ji.getType() + ", Expected = df)"));
        Map props = ji.getProperties();
        Assert.assertEquals((int)props.size(), (int)0, (String)("Invalid indicator properties size. (Actual = " + props.size() + ", Expected = 0)"));
    }

    @Test
    public void testOutputFileCreateDfAll() throws Exception {
        logger.debug((Object)">> testOutputFileDfAll", new Object[0]);
        final String fileName = this.getTmpDirPath() + "tst_DfAll" + ".csv";
        JasmineOutput outputDfAll = new JasmineOutput();
        outputDfAll.setName("tst_DfAll");
        outputDfAll.setType("file");
        HashMap<String, String> props = new HashMap<String, String>(){
            {
                this.put("path", fileName);
            }
        };
        outputDfAll.setProperties((Map)props);
        this.getProxyMXBean().createOutput(outputDfAll);
        JasmineOutput jo = this.getProxyMXBean().getOutput("tst_DfAll");
        Assert.assertEquals((String)jo.getName(), (String)"tst_DfAll", (String)("Invalid output name. (Actual = " + jo.getName() + ", Expected = " + "tst_DfAll" + ")"));
        Assert.assertEquals((String)jo.getType(), (String)"file", (String)("Invalid output type. (Actual = " + jo.getType() + ", Expected = file)"));
        Map propsActual = jo.getProperties();
        Assert.assertEquals((int)propsActual.size(), (int)1, (String)("Invalid output properties size. (Actual = " + propsActual.size() + ", Expected = 1)"));
        Assert.assertEquals((String)((String)propsActual.get("path")), (String)fileName, (String)("Invalid output properties values. (Actual = " + (String)propsActual.get("path") + ", Expected = " + fileName + ")"));
    }

    @Test(dependsOnMethods={"testIndicatorCreateDfAll", "testOutputFileCreateDfAll"})
    public void testProbeCreateDfAll() throws Exception {
        logger.debug((Object)">> testProbeCreateDfAll", new Object[0]);
        int period = 2;
        JasmineProbe probeDfAll = new JasmineProbe();
        probeDfAll.setId("tst_DfAll");
        ArrayList<String> ji = new ArrayList<String>(Arrays.asList("tst_DfAll"));
        probeDfAll.setIndicatorList(ji);
        ArrayList<String> jo = new ArrayList<String>(Arrays.asList("tst_DfAll"));
        probeDfAll.setOutputList(jo);
        ArrayList<String> jt = new ArrayList<String>(Arrays.asList("agent0"));
        probeDfAll.setTargetList(jt);
        probeDfAll.setPeriod(2);
        this.getProxyMXBean().createProbe(probeDfAll);
        JasmineProbe jp = this.getProxyMXBean().getProbe("tst_DfAll");
        Assert.assertEquals((String)jp.getId(), (String)"tst_DfAll", (String)("Invalid probe id. (Actual = " + jp.getId() + ", Expected = " + "tst_DfAll" + ")"));
        Assert.assertEquals((String)jp.getId(), (String)"tst_DfAll", (String)("Invalid probe id. (Actual = " + jp.getId() + ", Expected = " + "tst_DfAll" + ")"));
        Assert.assertEquals((int)jp.getPeriod(), (int)2, (String)("Invalid probe period. (Actual = " + jp.getPeriod() + ", Expected = " + 2 + ")"));
        Assert.assertEquals((int)jp.getStatus(), (int)0, (String)("Invalid probe status. (Actual = " + jp.getStatus() + ", Expected = " + 0 + ")"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testProbeCreateDfAll"})
    public void testProbeStartStopDfAll() throws Exception {
        logger.debug((Object)">> testProbeStartStopDfAll", new Object[0]);
        int period = 2;
        String fileName = this.getTmpDirPath() + "tst_DfAll.csv";
        this.getProxyMXBean().startProbe("tst_DfAll");
        JasmineProbe jp = this.getProxyMXBean().getProbe("tst_DfAll");
        if (jp.getStatus() != 1 && jp.getStatus() != 2) {
            Assert.fail((String)("Invalid probe status (Actual = " + jp.printStatus() + ", Expected = STARTED|RUNNING)"));
        }
        Thread.sleep(4000L);
        this.getProxyMXBean().stopProbe("tst_DfAll");
        jp = this.getProxyMXBean().getProbe("tst_DfAll");
        Assert.assertEquals((int)jp.getStatus(), (int)0, (String)("Invalid probe status. (Actual = " + jp.printStatus() + ", Expected = STOPPED)"));
        CSVReader reader = null;
        boolean emptyOutput = true;
        try {
            String[] nextLine;
            reader = new CSVReader((Reader)new FileReader(fileName), ';');
            while ((nextLine = reader.readNext()) != null) {
                emptyOutput = false;
                int diskUsed = Integer.parseInt(nextLine[6]);
                if (diskUsed >= 0 && diskUsed <= 100) continue;
                Assert.fail((String)("The 'disk used' collected value for Df is NOT a pourcentage value (" + diskUsed + ")"));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse((boolean)emptyOutput, (String)"There is no collects for the probe tst_DfAll");
    }

    @Test(dependsOnMethods={"testProbeStartStopDfAll"})
    public void testProbeRemoveDfAll() throws Exception {
        logger.debug((Object)">> testProbeRemoveDfAll", new Object[0]);
        this.getProxyMXBean().removeProbe("tst_DfAll");
        boolean ko = true;
        try {
            this.getProxyMXBean().getProbe("tst_DfAll");
        }
        catch (Exception e) {
            ko = false;
        }
        Assert.assertFalse((boolean)ko, (String)"The probe 'tst_DfAll' should no more exist");
    }

    @Test(dependsOnMethods={"testProbeRemoveDfAll"})
    public void testOuputFileRemoveDfAll() throws Exception {
        logger.debug((Object)">> testOuputFileRemoveDfAll", new Object[0]);
        this.getProxyMXBean().removeOutput("tst_DfAll");
        boolean ko = true;
        try {
            this.getProxyMXBean().getOutput("tst_DfAll");
        }
        catch (Exception e) {
            ko = false;
        }
        Assert.assertFalse((boolean)ko, (String)"The output file 'tst_DfAll' should no more exist");
    }

    @Test(dependsOnMethods={"testProbeRemoveDfAll"})
    public void testIndicatorRemoveDfAll() throws Exception {
        logger.debug((Object)">> testIndicatorRemoveDfAll", new Object[0]);
        this.getProxyMXBean().removeIndicator("tst_DfAll");
        boolean ko = true;
        try {
            this.getProxyMXBean().getIndicator("tst_DfAll");
        }
        catch (Exception e) {
            ko = false;
        }
        Assert.assertFalse((boolean)ko, (String)"The indicator 'tst_DfAll' should no more exist");
    }
}

