/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.itests;

import au.com.bytecode.opencsv.CSVReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.itests.JOnASLauncher;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class IndicatorLewysTest
extends JOnASLauncher {
    private static boolean isLinux = false;

    @BeforeClass
    public void setOsType() throws Exception {
        if ("Linux".equals(System.getProperty("os.name"))) {
            isLinux = true;
        }
    }

    @Test
    public void testTargetAgent0() throws Exception {
        logger.debug((Object)">> testTargetAgent0", new Object[0]);
        String targetName = "agent0";
        try {
            this.getProxyMXBean().getTarget("agent0");
        }
        catch (JasmineProbeException e) {
            Assert.fail((String)"The target 'agent0' is not defined");
        }
    }

    @Test
    public void testIndicatorCreateLewysKernelLinux() throws Exception {
        logger.debug((Object)">> testIndicatorCreateLewysKernelLinux", new Object[0]);
        if (isLinux) {
            String name = "tst_KernelLinux";
            JasmineIndicator indicatorLewysKernelLinux = new JasmineIndicator();
            indicatorLewysKernelLinux.setName("tst_KernelLinux");
            indicatorLewysKernelLinux.setType("lewys");
            HashMap<String, String> props = new HashMap<String, String>(){
                {
                    this.put("cmd", "kernel");
                    this.put("resources", "Interrupts,Context switches,Processes");
                }
            };
            indicatorLewysKernelLinux.setProperties((Map)props);
            this.getProxyMXBean().createIndicator(indicatorLewysKernelLinux);
            JasmineIndicator ji = this.getProxyMXBean().getIndicator("tst_KernelLinux");
            Assert.assertEquals((String)ji.getName(), (String)"tst_KernelLinux", (String)("Invalid indicator name. (Actual = " + ji.getName() + ", Expected = " + "tst_KernelLinux" + ")"));
            Assert.assertEquals((String)ji.getType(), (String)"lewys", (String)("Invalid indicator type. (Actual = " + ji.getType() + ", Expected = df)"));
            Map propsActual = ji.getProperties();
            Assert.assertEquals((int)propsActual.size(), (int)2, (String)("Invalid indicator properties size. (Actual = " + propsActual.size() + ", Expected = 2)"));
        } else {
            logger.info((Object)">> testIndicatorCreateLewysKernelLinux skipped", new Object[0]);
        }
    }

    @Test
    public void testOutputFileCreateLewysKernelLinux() throws Exception {
        logger.debug((Object)">> testOutputFileCreateLewysKernelLinux", new Object[0]);
        if (isLinux) {
            String name = "tst_KernelLinux";
            final String fileName = this.getTmpDirPath() + "tst_KernelLinux" + ".csv";
            JasmineOutput outputDfAll = new JasmineOutput();
            outputDfAll.setName("tst_KernelLinux");
            outputDfAll.setType("file");
            HashMap<String, String> props = new HashMap<String, String>(){
                {
                    this.put("path", fileName);
                }
            };
            outputDfAll.setProperties((Map)props);
            this.getProxyMXBean().createOutput(outputDfAll);
            JasmineOutput jo = this.getProxyMXBean().getOutput("tst_KernelLinux");
            Assert.assertEquals((String)jo.getName(), (String)"tst_KernelLinux", (String)("Invalid output name. (Actual = " + jo.getName() + ", Expected = " + "tst_KernelLinux" + ")"));
            Assert.assertEquals((String)jo.getType(), (String)"file", (String)("Invalid output type. (Actual = " + jo.getType() + ", Expected = file)"));
            Map propsActual = jo.getProperties();
            Assert.assertEquals((int)propsActual.size(), (int)1, (String)("Invalid output properties size. (Actual = " + propsActual.size() + ", Expected = 1)"));
            Assert.assertEquals((String)((String)propsActual.get("path")), (String)fileName, (String)("Invalid output properties values. (Actual = " + (String)propsActual.get("path") + ", Expected = " + fileName + ")"));
        } else {
            logger.info((Object)">> testOutputFileCreateLewysKernelLinux skipped", new Object[0]);
        }
    }

    @Test(dependsOnMethods={"testTargetAgent0", "testIndicatorCreateLewysKernelLinux", "testOutputFileCreateLewysKernelLinux"})
    public void testProbeCreateLewysKernelLinux() throws Exception {
        logger.debug((Object)">> testProbeCreateLewysKernelLinux", new Object[0]);
        if (isLinux) {
            String name = "tst_KernelLinux";
            int period = 2;
            JasmineProbe probeLewysKernelLinux = new JasmineProbe();
            probeLewysKernelLinux.setId("tst_KernelLinux");
            ArrayList<String> ji = new ArrayList<String>(Arrays.asList("tst_KernelLinux"));
            probeLewysKernelLinux.setIndicatorList(ji);
            ArrayList<String> jo = new ArrayList<String>(Arrays.asList("tst_KernelLinux"));
            probeLewysKernelLinux.setOutputList(jo);
            ArrayList<String> jt = new ArrayList<String>(Arrays.asList("agent0"));
            probeLewysKernelLinux.setTargetList(jt);
            probeLewysKernelLinux.setPeriod(2);
            this.getProxyMXBean().createProbe(probeLewysKernelLinux);
            JasmineProbe jp = this.getProxyMXBean().getProbe("tst_KernelLinux");
            Assert.assertEquals((String)jp.getId(), (String)"tst_KernelLinux", (String)("Invalid probe id. (Actual = " + jp.getId() + ", Expected = " + "tst_KernelLinux" + ")"));
            Assert.assertEquals((String)jp.getId(), (String)"tst_KernelLinux", (String)("Invalid probe id. (Actual = " + jp.getId() + ", Expected = " + "tst_KernelLinux" + ")"));
            Assert.assertEquals((int)jp.getPeriod(), (int)2, (String)("Invalid probe period. (Actual = " + jp.getPeriod() + ", Expected = " + 2 + ")"));
            Assert.assertEquals((int)jp.getStatus(), (int)0, (String)("Invalid probe status. (Actual = " + jp.getStatus() + ", Expected = " + 0 + ")"));
        } else {
            logger.info((Object)">> testProbeCreateLewysKernelLinux skipped", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testProbeCreateLewysKernelLinux"})
    public void testProbeStartStopLewysKernelLinux() throws Exception {
        logger.debug((Object)">> testProbeStartStopLewysKernelLinux", new Object[0]);
        String name = "tst_KernelLinux";
        int period = 2;
        String fileName = this.getTmpDirPath() + "tst_KernelLinux" + ".csv";
        this.getProxyMXBean().startProbe("tst_KernelLinux");
        JasmineProbe jp = this.getProxyMXBean().getProbe("tst_KernelLinux");
        if (jp.getStatus() != 1 && jp.getStatus() != 2) {
            Assert.fail((String)("Invalid probe status (Actual = " + jp.printStatus() + ", Expected = STARTED|RUNNING)"));
        }
        Thread.sleep(4000L);
        this.getProxyMXBean().stopProbe("tst_KernelLinux");
        jp = this.getProxyMXBean().getProbe("tst_KernelLinux");
        Assert.assertEquals((int)jp.getStatus(), (int)0, (String)("Invalid probe status. (Actual = " + jp.getStatus() + ", Expected = " + 0 + ")"));
        CSVReader reader = null;
        boolean emptyOutput = true;
        try {
            reader = new CSVReader((Reader)new FileReader(fileName), ';');
            while (reader.readNext() != null) {
                emptyOutput = false;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse((boolean)emptyOutput, (String)"There is no collects for the probe tst_KernelLinux");
    }
}

