/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.itests;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.ow2.jasmine.probe.JProbeManagerMXBean;
import org.ow2.jasmine.probe.collector.JasmineCollectorService;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionService;
import org.ow2.jasmine.probe.outer.JasmineOuterService;
import org.ow2.jasmine.probe.probescheduler.SchedulerService;
import org.ow2.jonas.depmonitor.MonitoringService;
import org.ow2.jonas.launcher.jonas.JOnAS;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;

public class JOnASLauncher {
    protected static Log logger = LogFactory.getLog(JOnASLauncher.class);
    private static final long ONE_SECOND = 1000L;
    private static final long WAITING_SERVICES_TIME = 45000L;
    private static final int COLLECTOR_SERVICES_NUMBER = 9;
    private static final int OUTER_SERVICES_NUMBER = 3;
    private static volatile Lock lock = new ReentrantReadWriteLock().writeLock();
    private static int count = 0;
    private static JOnAS jpServer = null;
    private static BundleContext bundleContext = null;
    private static boolean ready = false;
    private static boolean stopping = false;
    private static boolean lastCallStopping = false;
    private static String JASMINE_PROBE_MANAGER_MXBEAN_NAME = "jasmine:dest=probe-manager";
    private static JProbeManagerMXBean proxyMXBean = null;
    private static String tmpDirPath;
    private static String configurationDirPath;
    private static String JMX_CLIENT_JAR_NAME;
    private static String jmxClientJarName;
    private static final String PORT_DEFAULT = "4099";
    private static int portNumber;
    private static final String SERVER_DEFAULT = "jasmine-probe";
    private static String serverName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeSuite
    public void startServer() throws Exception {
        try {
            lock.lock();
            if (jpServer == null) {
                jpServer = new JOnAS(true);
                bundleContext = jpServer.getFramework().getBundleContext();
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            jpServer.start();
                        }
                        catch (Exception e) {
                            logger.error((Object)"Cannot start the server", new Object[]{e});
                            throw new IllegalStateException("Cannot start the server", e);
                        }
                    }
                }.start();
                long maxWaitTime = System.currentTimeMillis() + 45000L;
                ServiceReference serviceManagerServiceReference = null;
                while (serviceManagerServiceReference == null && System.currentTimeMillis() < maxWaitTime) {
                    serviceManagerServiceReference = this.getBundleContext().getServiceReference(MonitoringService.class.getName());
                    if (serviceManagerServiceReference != null) continue;
                    Thread.sleep(1000L);
                }
                this.waitJasmineProbeServices();
                ready = true;
                logger.info((Object)"The JasmineProbe server is ready, tests can be launched...", new Object[0]);
            } else {
                logger.info((Object)"The JasmineProbe server is already launched, tests can be launched...", new Object[0]);
            }
            ++count;
        }
        finally {
            lock.unlock();
        }
    }

    public void waitJasmineProbeServices() throws InterruptedException, InvalidSyntaxException {
        ServiceReference[] serviceReferences;
        ServiceReference serviceReference;
        long maxWaitTime = System.currentTimeMillis() + 45000L;
        do {
            if ((serviceReference = this.getBundleContext().getServiceReference(SchedulerService.class.getName())) != null) continue;
            Thread.sleep(1000L);
        } while (serviceReference == null && System.currentTimeMillis() < maxWaitTime);
        Assert.assertNotNull((Object)serviceReference, (String)"Scheduler Service is not registered");
        maxWaitTime = System.currentTimeMillis() + 45000L;
        do {
            if ((serviceReference = this.getBundleContext().getServiceReference(JmxConnectionService.class.getName())) != null) continue;
            Thread.sleep(1000L);
        } while (serviceReference == null && System.currentTimeMillis() < maxWaitTime);
        Assert.assertNotNull((Object)serviceReference, (String)"JMX Connection Service is not registered");
        maxWaitTime = System.currentTimeMillis() + 45000L;
        do {
            if ((serviceReferences = this.getBundleContext().getServiceReferences(JasmineOuterService.class.getName(), null)) != null && serviceReferences.length >= 3) continue;
            Thread.sleep(1000L);
        } while ((serviceReferences == null || serviceReferences.length < 3) && System.currentTimeMillis() < maxWaitTime);
        Assert.assertNotNull((Object)serviceReferences, (String)"Output Service not registered");
        Assert.assertEquals((int)serviceReferences.length, (int)3, (String)"All the Outer Services are not registered");
        maxWaitTime = System.currentTimeMillis() + 45000L;
        do {
            if ((serviceReferences = this.getBundleContext().getServiceReferences(JasmineCollectorService.class.getName(), null)) != null && serviceReferences.length > 9) continue;
            Thread.sleep(1000L);
        } while ((serviceReferences == null || serviceReferences.length <= 9) && System.currentTimeMillis() < maxWaitTime);
        Assert.assertNotNull((Object)serviceReferences, (String)"Collector Service not registered");
        Assert.assertEquals((int)serviceReferences.length, (int)9, (String)"All the Collectors Services are not registered");
        logger.info((Object)"The jasmine-probe services are ready.", new Object[0]);
    }

    @BeforeSuite(dependsOnMethods={"startServer"})
    public void setup() throws MalformedObjectNameException {
        configurationDirPath = System.getProperty("jonas.base");
        Assert.assertNotNull((Object)configurationDirPath, (String)"jonas.base directory path not defined");
        configurationDirPath = configurationDirPath.concat(File.separator + "conf" + File.separator);
        logger.info((Object)("The configuration directory used for probe-config files is : '" + configurationDirPath + "'"), new Object[0]);
        tmpDirPath = System.getProperty("java.io.tmp");
        Assert.assertNotNull((Object)tmpDirPath, (String)"tmp directory path not defined");
        tmpDirPath = tmpDirPath.concat(File.separator);
        logger.info((Object)("The tmp directory used for output files is : '" + tmpDirPath + "'"), new Object[0]);
        jmxClientJarName = System.getProperty("jonas.root");
        Assert.assertNotNull((Object)configurationDirPath, (String)"jonas.root directory path not defined");
        jmxClientJarName = jmxClientJarName.concat(File.separator + JMX_CLIENT_JAR_NAME);
        logger.info((Object)("The JMX JProbe client jar file used is : '" + jmxClientJarName + "'"), new Object[0]);
        portNumber = Integer.parseInt(System.getProperty("the.carol.port", PORT_DEFAULT));
        serverName = System.getProperty("jonas.name", SERVER_DEFAULT);
        ArrayList<MBeanServer> mbServers = MBeanServerFactory.findMBeanServer(null);
        if (mbServers.size() == 0) {
            Assert.fail((String)"No MBeanServer !!!");
        }
        if (mbServers.size() > 1) {
            logger.info((Object)"Warning: There is severals MBeanServer, get the first one", new Object[0]);
        }
        MBeanServer mbeanServer = mbServers.get(0);
        ObjectName objectName = new ObjectName(JASMINE_PROBE_MANAGER_MXBEAN_NAME);
        proxyMXBean = JMX.newMXBeanProxy(mbeanServer, objectName, JProbeManagerMXBean.class);
        logger.info((Object)"Probe Manager MXBean proxy initialized.", new Object[0]);
    }

    @AfterSuite
    public void stopServer() throws Exception {
        lock.lock();
        if (--count == 1) {
            lastCallStopping = true;
        }
        if (count == 0 && jpServer != null) {
            stopping = true;
            logger.info((Object)"The JasmineProbe server is being stopped.", new Object[0]);
            jpServer.stop();
            jpServer = null;
        }
        lock.unlock();
    }

    public boolean isReady() {
        return ready;
    }

    public void waitReady() throws InterruptedException {
        while (!ready) {
            Thread.sleep(1000L);
        }
    }

    public void waitStopping() throws InterruptedException {
        while (!stopping) {
            Thread.sleep(1000L);
        }
    }

    public void waitStoppingSoon() throws InterruptedException {
        while (!lastCallStopping) {
            Thread.sleep(1000L);
        }
    }

    protected BundleContext getBundleContext() {
        return bundleContext;
    }

    protected JProbeManagerMXBean getProxyMXBean() {
        return proxyMXBean;
    }

    protected String getTmpDirPath() {
        return tmpDirPath;
    }

    protected String getConfigurationDirPath() {
        return configurationDirPath;
    }

    protected String getJmxClientJarName() {
        return jmxClientJarName;
    }

    protected int getPortNumber() {
        return portNumber;
    }

    protected String getServerName() {
        return serverName;
    }

    protected String getJmxUrl() {
        return "service:jmx:rmi:///jndi/rmi://localhost:" + portNumber + "/jrmpconnector_" + serverName;
    }

    static {
        JMX_CLIENT_JAR_NAME = "jprobe-client.jar";
    }
}

