/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.itests;

import au.com.bytecode.opencsv.CSVReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.itests.JOnASLauncher;
import org.ow2.jasmine.probe.itests.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ChangeTest
extends JOnASLauncher {
    final String name = "tst_change";
    final int period = 1;

    @Test
    public void testIndicatorCreate() throws Exception {
        logger.debug((Object)">> testIndicatorCreate", new Object[0]);
        JasmineIndicator indicator = new JasmineIndicator();
        indicator.setName("tst_change");
        indicator.setType("jmx");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("target", "agent0");
        props.put("mbean", "java.lang:type=Threading");
        props.put("attr", "ThreadCount,PeakThreadCount,TotalStartedThreadCount");
        indicator.setProperties(props);
        this.getProxyMXBean().createIndicator(indicator);
        JasmineIndicator ji = this.getProxyMXBean().getIndicator("tst_change");
        Assert.assertEquals((String)ji.getName(), (String)"tst_change", (String)("Invalid indicator name. (Actual = " + ji.getName() + ", Expected = " + "tst_change" + ")"));
        Assert.assertEquals((String)ji.getType(), (String)"jmx", (String)("Invalid indicator type. (Actual = " + ji.getType() + ", Expected = jmx)"));
        Map propsActual = ji.getProperties();
        Assert.assertEquals((int)propsActual.size(), (int)props.size(), (String)("Invalid indicator properties size. (Actual = " + props.size() + ", Expected = " + props.size() + ")"));
    }

    @Test
    public void testOutputFileCreate() throws Exception {
        logger.debug((Object)">> testOutputFileCreate", new Object[0]);
        String fileName = this.getTmpDirPath() + "tst_change" + ".csv";
        JasmineOutput output = new JasmineOutput();
        output.setName("tst_change");
        output.setType("file");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("path", fileName);
        output.setProperties(props);
        this.getProxyMXBean().createOutput(output);
        JasmineOutput jo = this.getProxyMXBean().getOutput("tst_change");
        Assert.assertEquals((String)jo.getName(), (String)"tst_change", (String)("Invalid output name. (Actual = " + jo.getName() + ", Expected = " + "tst_change" + ")"));
        Assert.assertEquals((String)jo.getType(), (String)"file", (String)("Invalid output type. (Actual = " + jo.getType() + ", Expected = file)"));
        Map propsActual = jo.getProperties();
        Assert.assertEquals((int)propsActual.size(), (int)1, (String)("Invalid output properties size. (Actual = " + propsActual.size() + ", Expected = 1)"));
        Assert.assertEquals((String)((String)propsActual.get("path")), (String)fileName, (String)("Invalid output properties values. (Actual = " + (String)propsActual.get("path") + ", Expected = " + fileName + ")"));
    }

    @Test(dependsOnMethods={"testIndicatorCreate", "testOutputFileCreate"})
    public void testProbeCreate() throws Exception {
        logger.debug((Object)">> testProbeCreate", new Object[0]);
        JasmineProbe probe = new JasmineProbe();
        probe.setId("tst_change");
        ArrayList<String> ji = new ArrayList<String>(Arrays.asList("tst_change"));
        probe.setIndicatorList(ji);
        ArrayList<String> jo = new ArrayList<String>(Arrays.asList("tst_change"));
        probe.setOutputList(jo);
        ArrayList<String> jt = new ArrayList<String>(Arrays.asList("agent0"));
        probe.setTargetList(jt);
        probe.setPeriod(1);
        this.getProxyMXBean().createProbe(probe);
        JasmineProbe jp = this.getProxyMXBean().getProbe("tst_change");
        Assert.assertEquals((String)jp.getId(), (String)"tst_change", (String)("Invalid probe id. (Actual = " + jp.getId() + ", Expected = " + "tst_change" + ")"));
        Assert.assertEquals((String)jp.getId(), (String)"tst_change", (String)("Invalid probe id. (Actual = " + jp.getId() + ", Expected = " + "tst_change" + ")"));
        Assert.assertEquals((int)jp.getPeriod(), (int)1, (String)("Invalid probe period. (Actual = " + jp.getPeriod() + ", Expected = " + 1 + ")"));
        Assert.assertEquals((int)jp.getStatus(), (int)0, (String)("Invalid probe status. (Actual = " + jp.getStatus() + ", Expected = " + 0 + ")"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testProbeCreate"})
    public void testProbeStart() throws Exception {
        logger.debug((Object)">> testProbeStart", new Object[0]);
        String fileName = this.getTmpDirPath() + "tst_change" + ".csv";
        this.getProxyMXBean().startProbe("tst_change");
        JasmineProbe jp = this.getProxyMXBean().getProbe("tst_change");
        if (jp.getStatus() != 1 && jp.getStatus() != 2) {
            Assert.fail((String)("Invalid probe status (Actual = " + jp.printStatus() + ", Expected = STARTED|RUNNING)"));
        }
        Thread.sleep(2000L);
        this.getProxyMXBean().stopProbe("tst_change");
        jp = this.getProxyMXBean().getProbe("tst_change");
        Assert.assertEquals((int)jp.getStatus(), (int)0, (String)("Invalid probe status. (Actual = " + jp.printStatus() + ", Expected = STOPPED)"));
        CSVReader reader = null;
        boolean emptyOutput = true;
        try {
            String[] nextLine;
            reader = new CSVReader((Reader)new FileReader(fileName), ';');
            while ((nextLine = reader.readNext()) != null) {
                emptyOutput = false;
                String indicatorName = Util.getNameOfFullName(nextLine[5]);
                if ("tst_change.ThreadCount".equals(indicatorName) || "tst_change.PeakThreadCount".equals(indicatorName) || "tst_change.TotalStartedThreadCount".equals(indicatorName)) continue;
                Assert.fail((String)("Invalid indicator name: " + indicatorName));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse((boolean)emptyOutput, (String)"There is no collects for the probe tst_change");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testProbeStart"})
    public void testInjectorChange() throws Exception {
        logger.debug((Object)">> testInjectorChange", new Object[0]);
        String fileName = this.getTmpDirPath() + "tst_change" + ".csv";
        this.getProxyMXBean().startProbe("tst_change");
        JasmineIndicator ji = this.getProxyMXBean().getIndicator("tst_change");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("target", "agent0");
        props.put("mbean", "java.lang:type=Threading");
        props.put("attr", "ThreadCount,PeakThreadCount");
        ji.setProperties(props);
        long timeChange = System.currentTimeMillis();
        this.getProxyMXBean().changeIndicator(ji);
        Thread.sleep(3000L);
        this.getProxyMXBean().stopProbe("tst_change");
        CSVReader reader = null;
        boolean emptyOutput = true;
        try {
            String[] nextLine;
            reader = new CSVReader((Reader)new FileReader(fileName), ';');
            while ((nextLine = reader.readNext()) != null) {
                emptyOutput = false;
                String indicatorName = Util.getNameOfFullName(nextLine[5]);
                long time = Long.parseLong(nextLine[0]);
                if (!("tst_change.ThreadCount".equals(indicatorName) || "tst_change.PeakThreadCount".equals(indicatorName) || "tst_change.TotalStartedThreadCount".equals(indicatorName))) {
                    Assert.fail((String)("Invalid indicator name: " + indicatorName));
                }
                if (!"tst_change.TotalStartedThreadCount".equals(indicatorName) || time <= timeChange) continue;
                Assert.fail((String)("The indicator tst_change.TotalStartedThreadCount must no more collected since the time " + timeChange));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse((boolean)emptyOutput, (String)"There is no collects for the probe tst_change");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testInjectorChange"})
    public void testOutputChange() throws Exception {
        long time;
        String[] nextLine;
        logger.debug((Object)">> testOutputChange", new Object[0]);
        String fileName1 = this.getTmpDirPath() + "tst_change" + ".csv";
        String fileName2 = this.getTmpDirPath() + "tst_change" + "_2.csv";
        this.getProxyMXBean().startProbe("tst_change");
        JasmineOutput jo = this.getProxyMXBean().getOutput("tst_change");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("path", fileName2);
        jo.setProperties(props);
        long timeChange = System.currentTimeMillis();
        this.getProxyMXBean().changeOutput(jo);
        Thread.sleep(3000L);
        this.getProxyMXBean().stopProbe("tst_change");
        CSVReader reader = null;
        boolean emptyOutput = true;
        try {
            reader = new CSVReader((Reader)new FileReader(fileName1), ';');
            while ((nextLine = reader.readNext()) != null) {
                emptyOutput = false;
                time = Long.parseLong(nextLine[0]);
                if (time <= timeChange) continue;
                Assert.fail((String)("There must be no more collected since the time " + timeChange + " in the file " + fileName1));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse((boolean)emptyOutput, (String)"There is no collects for the probe tst_change in the first output");
        reader = null;
        emptyOutput = true;
        try {
            reader = new CSVReader((Reader)new FileReader(fileName2), ';');
            while ((nextLine = reader.readNext()) != null) {
                emptyOutput = false;
                time = Long.parseLong(nextLine[0]);
                if (time >= timeChange) continue;
                Assert.fail((String)("There must be no collect before the time " + timeChange + " in the file " + fileName2));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Assert.assertFalse((boolean)emptyOutput, (String)"There is no collects for the probe tst_change in the second output");
    }
}

