/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.jmxconnection.simple;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.probe.jmxconnection.api.JmxConnection;
import org.ow2.jasmine.probe.jmxconnection.api.JmxConnectionException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="JmxConnectionService", public_factory=false)
@Provides
public class JmxConnectionImpl
implements JmxConnection,
Pojo {
    private InstanceManager __IM;
    private boolean __Fnature;
    @ServiceProperty(value="basic")
    private String nature;
    private static Log logger = LogFactory.getLog(JmxConnection.class);
    private boolean __Fconnectors;
    private Map<String, JMXConnector> connectors;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __McreateConnector$java_lang_String$java_lang_String$java_util_Map;
    private boolean __McloseConnector$java_lang_String;
    private boolean __MgetConnection$java_lang_String;

    String __getnature() {
        if (!this.__Fnature) {
            return this.nature;
        }
        return (String)this.__IM.onGet((Object)this, "nature");
    }

    void __setnature(String string) {
        if (!this.__Fnature) {
            this.nature = string;
            return;
        }
        this.__IM.onSet((Object)this, "nature", (Object)string);
    }

    Map __getconnectors() {
        if (!this.__Fconnectors) {
            return this.connectors;
        }
        return (Map)this.__IM.onGet((Object)this, "connectors");
    }

    void __setconnectors(Map map) {
        if (!this.__Fconnectors) {
            this.connectors = map;
            return;
        }
        this.__IM.onSet((Object)this, "connectors", (Object)map);
    }

    public JmxConnectionImpl() {
        this(null);
    }

    private JmxConnectionImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setconnectors(Collections.synchronizedMap(new HashMap()));
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        System.out.println("JmxConnection service activated.");
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() {
        System.out.println("JmxConnection service stopped.");
    }

    @Override
    public void createConnector(String string, String string2, Map<String, Object> map) throws JmxConnectionException {
        if (!this.__McreateConnector$java_lang_String$java_lang_String$java_util_Map) {
            this.__createConnector(string, string2, map);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createConnector$java_lang_String$java_lang_String$java_util_Map", new Object[]{string, string2, map});
            this.__createConnector(string, string2, map);
            this.__IM.onExit((Object)this, "createConnector$java_lang_String$java_lang_String$java_util_Map", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createConnector$java_lang_String$java_lang_String$java_util_Map", throwable);
            throw throwable;
        }
    }

    private void __createConnector(String targetName, String targetUrl, Map<String, Object> env) throws JmxConnectionException {
        JMXServiceURL serviceUrl = null;
        try {
            serviceUrl = new JMXServiceURL(targetUrl);
        }
        catch (MalformedURLException e) {
            throw new JmxConnectionException(e);
        }
        JMXConnector connector = null;
        try {
            connector = JMXConnectorFactory.connect(serviceUrl, env);
            logger.info((Object)"Connector created for target {0} with url {1}.", new Object[]{targetName, targetUrl});
        }
        catch (SecurityException e) {
            logger.info((Object)"SecurityException raised for target {0} with url {1}.", new Object[]{targetName, targetUrl});
            throw new JmxConnectionException(e);
        }
        catch (IOException e) {
            logger.info((Object)"IOException raised when trying to connect to target {0} with url {1} ({2}).", new Object[]{targetName, targetUrl, e.getMessage()});
            throw new JmxConnectionException(e);
        }
        this.__getconnectors().put(targetName, connector);
    }

    @Override
    public void closeConnector(String string) throws IOException {
        if (!this.__McloseConnector$java_lang_String) {
            this.__closeConnector(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "closeConnector$java_lang_String", new Object[]{string});
            this.__closeConnector(string);
            this.__IM.onExit((Object)this, "closeConnector$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "closeConnector$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __closeConnector(String target) throws IOException {
        if (target == null) {
            return;
        }
        if (this.__getconnectors().containsKey(target)) {
            JMXConnector connector = (JMXConnector)this.__getconnectors().get(target);
            this.__getconnectors().remove(target);
            try {
                connector.close();
                logger.info((Object)"JMX connection clossed with target {0}", new Object[]{target});
            }
            catch (IOException e) {
                logger.warn((Object)"Exception when trying to close JMX connector for target {0} ({1})", new Object[]{e.toString()});
                throw e;
            }
        }
    }

    @Override
    public MBeanServerConnection getConnection(String string) throws IOException {
        MBeanServerConnection mBeanServerConnection;
        if (!this.__MgetConnection$java_lang_String) {
            return this.__getConnection(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getConnection$java_lang_String", new Object[]{string});
            mBeanServerConnection = this.__getConnection(string);
            this.__IM.onExit((Object)this, "getConnection$java_lang_String", (Object)mBeanServerConnection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getConnection$java_lang_String", throwable);
            throw throwable;
        }
        return mBeanServerConnection;
    }

    private MBeanServerConnection __getConnection(String target) throws IOException {
        MBeanServerConnection mbsc = null;
        if (target == null) {
            return null;
        }
        if (this.__getconnectors().containsKey(target)) {
            JMXConnector connector = (JMXConnector)this.__getconnectors().get(target);
            mbsc = connector.getMBeanServerConnection();
        }
        return mbsc;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("connectors")) {
                this.__Fconnectors = true;
            }
            if (set.contains("nature")) {
                this.__Fnature = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("createConnector$java_lang_String$java_lang_String$java_util_Map")) {
                this.__McreateConnector$java_lang_String$java_lang_String$java_util_Map = true;
            }
            if (set.contains("closeConnector$java_lang_String")) {
                this.__McloseConnector$java_lang_String = true;
            }
            if (set.contains("getConnection$java_lang_String")) {
                this.__MgetConnection$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

