/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.jmxclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.jasmine.probe.JProbeManagerMXBean;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.PropertyMissingException;
import org.ow2.jasmine.probe.TypeNotSupportedException;

public class JmxClient {
    private static String host = "localhost";
    private static String port = "4099";
    private static String server = "jasmine-probe";
    private static String MXBEAN = "jasmine:dest=probe-manager";
    private static JProbeManagerMXBean proxy = null;
    private static Map<String, String> params = new HashMap<String, String>();
    private static Map<String, String> properties = new HashMap<String, String>();
    private static List<String> outputs = new ArrayList<String>();
    private static List<String> indicators = new ArrayList<String>();
    private static boolean startProbe = false;
    private static boolean verbose = false;
    private static String id = null;

    public static void main(String[] args) {
        if (args.length == 0) {
            JmxClient.help();
            return;
        }
        String command = null;
        for (int argn = 0; argn < args.length; ++argn) {
            boolean nextArgument;
            String arg = args[argn];
            boolean bl = nextArgument = argn < args.length - 1;
            if (arg.equals("-host") && nextArgument) {
                host = args[++argn];
                continue;
            }
            if (arg.equals("-port") && nextArgument) {
                port = args[++argn];
                continue;
            }
            if (arg.equals("-server") && nextArgument) {
                server = args[++argn];
                continue;
            }
            if (arg.equals("-d") && nextArgument) {
                String keyval;
                int index;
                if ((index = (keyval = args[++argn]).indexOf("=")) < 1) {
                    System.err.println("Bad syntax: -d should define a property");
                    continue;
                }
                String key = keyval.substring(0, index);
                String value = keyval.substring(index + 1);
                properties.put(key, value);
                continue;
            }
            if (arg.equals("-o") && nextArgument) {
                outputs.add(args[++argn]);
                continue;
            }
            if (arg.equals("-i") && nextArgument) {
                indicators.add(args[++argn]);
                continue;
            }
            if (arg.equals("-n") && nextArgument) {
                if (id == null) {
                    id = args[++argn];
                    continue;
                }
                System.err.println("Bad syntax: name defined twice. Take: " + id);
                continue;
            }
            if (arg.equals("-v") || arg.equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (arg.equals("-start")) {
                startProbe = true;
                continue;
            }
            if (arg.startsWith("-") && nextArgument) {
                params.put(arg.substring(1), args[++argn]);
                continue;
            }
            int index = arg.indexOf("=");
            if (index > 0) {
                String key = arg.substring(0, index);
                String value = arg.substring(index + 1);
                properties.put(key, value);
                continue;
            }
            if (command == null) {
                command = arg;
                continue;
            }
            if (id == null) {
                id = arg;
                continue;
            }
            System.err.println("Bad syntax: <" + arg + "> has been ignored");
        }
        JmxClient.getMXBeanProxy();
        try {
            if ("help".equals(command) || command == null) {
                JmxClient.help();
            } else if ("indicator-create".equals(command)) {
                JmxClient.createIndicator();
            } else if ("indicator-change".equals(command)) {
                JmxClient.changeIndicator();
            } else if ("indicator-list".equals(command)) {
                JmxClient.listIndicators();
            } else if ("indicator-remove".equals(command)) {
                JmxClient.removeIndicator();
            } else if ("indicator-types".equals(command)) {
                JmxClient.listIndicatorTypes();
            } else if ("indicator-properties".equals(command)) {
                JmxClient.listIndicatorProperties();
            } else if ("output-create".equals(command)) {
                JmxClient.createOutput();
            } else if ("output-change".equals(command)) {
                JmxClient.changeOutput();
            } else if ("output-list".equals(command)) {
                JmxClient.listOutputs();
            } else if ("output-remove".equals(command)) {
                JmxClient.removeOutput();
            } else if ("output-types".equals(command)) {
                JmxClient.listOutputTypes();
            } else if ("output-properties".equals(command)) {
                JmxClient.listOutputProperties();
            } else if ("target-create".equals(command)) {
                JmxClient.createTarget();
            } else if ("target-list".equals(command)) {
                JmxClient.listTargets();
            } else if ("target-remove".equals(command)) {
                JmxClient.removeTarget();
            } else if ("probe-create".equals(command)) {
                JmxClient.createProbe();
            } else if ("probe-change".equals(command)) {
                JmxClient.changeProbe();
            } else if ("probe-list".equals(command)) {
                JmxClient.listProbes();
            } else if ("probe-remove".equals(command)) {
                JmxClient.removeProbe();
            } else if ("probe-start".equals(command)) {
                JmxClient.startProbe();
            } else if ("probe-stop".equals(command)) {
                JmxClient.stopProbe();
            } else if ("save-config".equals(command)) {
                JmxClient.saveConfig();
            } else if ("load-config".equals(command)) {
                JmxClient.loadConfig();
            } else {
                System.err.println("command not found: " + command);
            }
        }
        catch (JasmineProbeException e) {
            System.err.println("Operation failed: " + e.getMessage());
        }
    }

    private static void createIndicator() throws JasmineProbeException {
        JasmineIndicator indic = new JasmineIndicator();
        if (id == null) {
            System.err.println("option -n missing");
            return;
        }
        indic.setName(id);
        String type = params.get("t");
        if (type == null) {
            System.err.println("option -t missing");
            return;
        }
        indic.setType(type);
        int scale = 1;
        if (params.get("scale") != null) {
            scale = new Integer(params.get("scale"));
        }
        indic.setScale(scale);
        indic.setProperties(properties);
        try {
            proxy.createIndicator(indic);
        }
        catch (TypeNotSupportedException e) {
            System.out.println(e.getMessage());
            System.out.println("Supported indicator types are:");
            JmxClient.listIndicatorTypes();
            return;
        }
        catch (PropertyMissingException e) {
            System.out.println(e.getMessage());
            JmxClient.listIndicatorProperties();
            return;
        }
        System.out.println("indicator " + id + " created");
    }

    private static void changeIndicator() throws JasmineProbeException {
        JasmineIndicator indic = new JasmineIndicator();
        if (id == null) {
            System.err.println("option -n missing");
            return;
        }
        indic.setName(id);
        String type = params.get("t");
        indic.setType(type);
        indic.setProperties(properties);
        try {
            proxy.changeIndicator(indic);
        }
        catch (TypeNotSupportedException e) {
            System.out.println(e.getMessage());
            System.out.println("Supported Indicator types :");
            JmxClient.listIndicatorTypes();
            return;
        }
        catch (PropertyMissingException e) {
            System.out.println(e.getMessage());
            JmxClient.listIndicatorProperties();
            return;
        }
        System.out.println("indicator " + id + " changed");
    }

    private static void listIndicators() throws JasmineProbeException {
        block6: {
            block5: {
                if (id != null) break block5;
                String[] idList = proxy.listIndicators();
                for (int i = 0; i < idList.length; ++i) {
                    if (verbose) {
                        JasmineIndicator indic = proxy.getIndicator(idList[i]);
                        System.out.println(indic.toLine());
                        continue;
                    }
                    System.out.println(idList[i]);
                }
                break block6;
            }
            JasmineIndicator indic = proxy.getIndicator(id);
            if (indic == null) {
                System.out.println(id + " not found");
                return;
            }
            System.out.println(indic.toString());
            if (!verbose) break block6;
            System.out.println("List of probes using this indicator:");
            Set<String> probes = proxy.getIndicatorCurrentUse(id);
            for (String pid : probes) {
                JasmineProbe probe = proxy.getProbe(pid);
                if (probe == null) {
                    System.err.println(id + " not found");
                    continue;
                }
                System.out.println(pid + "   (" + probe.printStatus() + ")");
            }
        }
    }

    private static void listIndicatorTypes() throws JasmineProbeException {
        Set<String> liste = proxy.getIndicatorTypes();
        for (String type : liste) {
            System.out.println(type);
        }
    }

    private static void listIndicatorProperties() throws JasmineProbeException {
        String type = params.get("t");
        if (type == null) {
            System.err.println("option -t missing");
            return;
        }
        List<JasminePropertyInfo> props = proxy.getIndicatorPropertyInfos(type);
        if (props == null) {
            System.err.println("invalid type; " + type);
            return;
        }
        System.out.println("The properties flagged with * are mandatory:");
        for (JasminePropertyInfo prop : props) {
            System.out.println(prop.toString());
        }
    }

    private static void removeIndicator() throws JasmineProbeException {
        if (id == null) {
            System.err.println("option -n missing");
            return;
        }
        proxy.removeIndicator(id);
        System.out.println("indicator removed");
    }

    private static void createTarget() throws JasmineProbeException {
        JasmineTarget target = new JasmineTarget();
        if (id == null) {
            System.err.println("option -n missing (name)");
            return;
        }
        target.setName(id);
        String url = params.get("u");
        if (id == null) {
            System.err.println("option -u missing (url)");
            return;
        }
        target.setUrl(url);
        proxy.createTarget(target);
        System.out.println("target " + id + " created");
    }

    private static void listTargets() throws JasmineProbeException {
        if (id == null) {
            String[] idList = proxy.listTargets();
            for (int i = 0; i < idList.length; ++i) {
                if (verbose) {
                    JasmineTarget target = proxy.getTarget(idList[i]);
                    System.out.println(target.toLine());
                    continue;
                }
                System.out.println(idList[i]);
            }
        } else {
            JasmineTarget target = proxy.getTarget(id);
            if (target == null) {
                System.out.println(id + " not found");
                return;
            }
            System.out.println(target.toString());
        }
    }

    private static void removeTarget() throws JasmineProbeException {
        if (id == null) {
            System.err.println("option -n missing");
            return;
        }
        proxy.removeTarget(id);
        System.out.println("target removed");
    }

    private static void createOutput() throws JasmineProbeException {
        JasmineOutput output = new JasmineOutput();
        if (id == null) {
            System.err.println("option -n missing");
            return;
        }
        output.setName(id);
        String type = params.get("t");
        if (type == null) {
            System.err.println("option -t missing");
            return;
        }
        output.setType(type);
        output.setProperties(properties);
        try {
            proxy.createOutput(output);
        }
        catch (TypeNotSupportedException e) {
            System.out.println(e.getMessage());
            System.out.println("Supported Output types :");
            JmxClient.listOutputTypes();
            return;
        }
        catch (PropertyMissingException e) {
            System.out.println(e.getMessage());
            JmxClient.listOutputProperties();
            return;
        }
        System.out.println("output " + id + " created");
    }

    private static void changeOutput() throws JasmineProbeException {
        JasmineOutput output = new JasmineOutput();
        if (id == null) {
            System.err.println("option -n missing");
            return;
        }
        output.setName(id);
        String type = params.get("t");
        output.setType(type);
        output.setProperties(properties);
        try {
            proxy.changeOutput(output);
        }
        catch (TypeNotSupportedException e) {
            System.out.println(e.getMessage());
            System.out.println("Supported Output types :");
            JmxClient.listOutputTypes();
            return;
        }
        catch (PropertyMissingException e) {
            System.out.println(e.getMessage());
            JmxClient.listOutputProperties();
            return;
        }
        System.out.println("output " + id + " changed");
    }

    private static void listOutputs() throws JasmineProbeException {
        block6: {
            block5: {
                if (id != null) break block5;
                String[] idList = proxy.listOutputs();
                for (int i = 0; i < idList.length; ++i) {
                    if (verbose) {
                        JasmineOutput output = proxy.getOutput(idList[i]);
                        System.out.println(output.toLine());
                        continue;
                    }
                    System.out.println(idList[i]);
                }
                break block6;
            }
            JasmineOutput output = proxy.getOutput(id);
            if (output == null) {
                System.out.println(id + " not found");
                return;
            }
            System.out.println(output.toString());
            if (!verbose) break block6;
            System.out.println("List of probes using this output:");
            Set<String> probes = proxy.getOutputCurrentUse(id);
            for (String pid : probes) {
                JasmineProbe probe = proxy.getProbe(pid);
                if (probe == null) {
                    System.err.println(id + " not found");
                    continue;
                }
                System.out.println(pid + "   (" + probe.printStatus() + ")");
            }
        }
    }

    private static void listOutputTypes() throws JasmineProbeException {
        Set<String> liste = proxy.getOutputTypes();
        for (String type : liste) {
            System.out.println(type);
        }
    }

    private static void listOutputProperties() throws JasmineProbeException {
        String type = params.get("t");
        if (type == null) {
            System.err.println("option -t missing");
            return;
        }
        List<JasminePropertyInfo> props = proxy.getOutputPropertyInfos(type);
        if (props == null) {
            System.err.println("invalid type; " + type);
            return;
        }
        System.out.println("The properties flagged with * are mandatory:");
        for (JasminePropertyInfo prop : props) {
            System.out.println(prop.toString());
        }
    }

    private static void removeOutput() throws JasmineProbeException {
        if (id == null) {
            System.err.println("option -n missing");
            return;
        }
        proxy.removeOutput(id);
        System.out.println("output removed");
    }

    private static void loadConfig() throws JasmineProbeException {
        String path = params.get("f");
        if (path == null) {
            System.err.println("option -f missing");
            return;
        }
        proxy.loadConfig(path);
        System.out.println("config has been loaded");
    }

    private static void saveConfig() throws JasmineProbeException {
        String path = params.get("f");
        proxy.saveConfig(path);
        System.out.println("config has been saved");
    }

    private static void createProbe() throws JasmineProbeException {
        JasmineProbe probe = new JasmineProbe();
        if (id == null) {
            System.err.println("option -n missing");
            return;
        }
        probe.setId(id);
        int period = 10;
        if (params.get("p") != null) {
            period = new Integer(params.get("p"));
        }
        probe.setPeriod(period);
        probe.setOutputList(outputs);
        probe.setIndicatorList(indicators);
        proxy.createProbe(probe);
        System.out.println("probe " + id + " created");
        if (startProbe) {
            proxy.startProbe(id);
            System.out.println("probe " + id + " started");
        }
    }

    private static void changeProbe() throws JasmineProbeException {
        JasmineProbe probe = new JasmineProbe();
        if (id == null) {
            System.err.println("option -n missing");
            return;
        }
        probe.setId(id);
        int period = -1;
        if (params.get("p") != null) {
            period = new Integer(params.get("p"));
        }
        probe.setPeriod(period);
        probe.setOutputList(outputs);
        probe.setIndicatorList(indicators);
        proxy.changeProbe(probe);
        System.out.println("probe " + id + " changed");
    }

    private static void listProbes() throws JasmineProbeException {
        if (id == null) {
            String[] idList = proxy.listProbes();
            for (int i = 0; i < idList.length; ++i) {
                if (verbose) {
                    JasmineProbe probe = proxy.getProbe(idList[i]);
                    System.out.println(probe.toLine());
                    continue;
                }
                System.out.println(idList[i]);
            }
        } else {
            JasmineProbe probe = proxy.getProbe(id);
            if (probe == null) {
                System.out.println(id + " not found");
                return;
            }
            System.out.println(probe.toString());
        }
    }

    private static void startProbe() throws JasmineProbeException {
        if (id == null) {
            proxy.startAllProbes();
            System.out.println("all probes started");
        } else {
            proxy.startProbe(id);
            System.out.println("probe started");
        }
    }

    private static void stopProbe() throws JasmineProbeException {
        if (id == null) {
            proxy.stopAllProbes();
            System.out.println("all probes stopped");
        } else {
            proxy.stopProbe(id);
            System.out.println("probe stopped");
        }
    }

    private static void removeProbe() throws JasmineProbeException {
        if (id == null) {
            proxy.removeAllProbes();
            System.out.println("all probes removed");
        } else {
            proxy.removeProbe(id);
            System.out.println("probe removed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void help() {
        ClassLoader classLoader;
        InputStream in0;
        String filename = "help.txt";
        if (id != null) {
            filename = id + "-help.txt";
        }
        if ((in0 = (classLoader = Thread.currentThread().getContextClassLoader()).getResourceAsStream(filename)) == null) {
            System.out.println("This help file is not available: " + filename);
            return;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(in0));
        OutputStreamWriter out = new OutputStreamWriter(System.out);
        try {
            boolean goOn = true;
            char[] buf = new char[2048];
            while (goOn) {
                int read = in.read(buf);
                if (read > 0) {
                    out.write(buf, 0, read);
                    out.flush();
                    continue;
                }
                goOn = false;
                System.out.println();
            }
        }
        catch (IOException e) {
            System.err.println("Error reading help: " + e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    System.err.println("Error closing the BufferedReader: " + e);
                }
            }
        }
    }

    private static void getMXBeanProxy() {
        String url = "service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/jrmpconnector_" + server;
        try {
            JMXServiceURL jmxUrl = new JMXServiceURL(url);
            JMXConnector connector = JMXConnectorFactory.connect(jmxUrl);
            MBeanServerConnection mbsc = connector.getMBeanServerConnection();
            ObjectName objectName = new ObjectName(MXBEAN);
            proxy = JMX.newMXBeanProxy(mbsc, objectName, JProbeManagerMXBean.class);
        }
        catch (MalformedURLException e) {
            System.err.println("ERROR trying to build JMXServiceURL with " + url + ":\n" + e.getMessage());
        }
        catch (MalformedObjectNameException e) {
            System.err.println(MXBEAN + " is a bad object name.: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("ERROR trying to connect: " + e.getMessage());
        }
    }
}

