/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.slope.internal;

import java.util.Iterator;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;

public class SlopeCollector
extends JCollector {
    private JasmineCollector numerator;
    private JasmineCollector denominator;
    private Number numprevious = null;
    private Number denprevious = null;

    public SlopeCollector(String key, JasmineIndicator indic, int period, JasmineCollector n, JasmineCollector d) {
        super(key, indic, period);
        this.numerator = n;
        this.denominator = d;
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        JasmineSingleResult jsr1;
        this.logger.debug((Object)"", new Object[0]);
        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        JasmineSingleNumberResult jsr = new JasmineSingleNumberResult();
        long timestamp = System.currentTimeMillis();
        Number result = 0;
        Number numval = null;
        Number denval = null;
        JasmineIndicatorValue jivnum = this.numerator.getLastResult();
        if (jivnum == null) {
            this.logger.warn((Object)"No result available on source indicator for numerator", new Object[0]);
            return null;
        }
        JasmineIndicatorValue jivden = this.denominator.getLastResult();
        if (jivden == null) {
            this.logger.warn((Object)"No result available on source indicator for denominator", new Object[0]);
            return null;
        }
        if (jivnum.getValues().size() > 1 || jivden.getValues().size() > 1) {
            this.logger.warn((Object)"Slope on multivalued indicator not supported", new Object[0]);
            throw new JasmineCollectorException("Slope on multivalued indicator not supported");
        }
        Iterator i$ = jivnum.getValues().iterator();
        if (i$.hasNext()) {
            jsr1 = (JasmineSingleResult)i$.next();
            numval = (Number)jsr1.getValue();
        }
        if ((i$ = jivden.getValues().iterator()).hasNext()) {
            jsr1 = (JasmineSingleResult)i$.next();
            denval = (Number)jsr1.getValue();
        }
        if (this.numprevious == null || this.denprevious == null) {
            this.logger.debug((Object)"First call: No previous value yet", new Object[0]);
            this.numprevious = numval;
            this.denprevious = denval;
            return null;
        }
        Long diff1 = this.diffValues(numval, this.numprevious);
        Long diff2 = this.diffValues(denval, this.denprevious);
        result = this.divideValues(diff1, diff2);
        if (this.indicator.getScale() != 1) {
            result = this.divideValues(result, this.indicator.getScale());
        }
        jsr.setTimestamp(timestamp);
        jsr.setValue((Object)result);
        jsr.setName(this.indicator.getName());
        jiv.setName(this.indicator.getName());
        jiv.addValue((JasmineSingleResult)jsr);
        return jiv;
    }

    public void stopPolling() {
        this.logger.debug((Object)"", new Object[0]);
    }

    public void startPolling() {
        this.logger.debug((Object)"", new Object[0]);
    }
}

