/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.util.Collection;
import java.util.List;
import javax.management.Attribute;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleBooleanResult;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.JasmineSingleStringResult;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.collectors.jmx.Metric;
import org.ow2.jasmine.probe.collectors.jmx.internal.FragmentUtil;
import org.ow2.jasmine.probe.util.CsvConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxCollector
extends JCollector {
    private String pattern;
    private ObjectName objname = null;
    private Collection<String> attrlist;
    private List<Metric> metrics = null;
    private JasmineIndicatorValue cached = null;
    private boolean stopped = false;

    public JmxCollector(String name, JasmineIndicator indicator, int period, String mbean, String csv) {
        super(name, indicator, period);
        this.pattern = mbean;
        this.attrlist = CsvConverter.csv2list((String)csv);
    }

    public Collection<String> geAttrlist() {
        return this.attrlist;
    }

    public ObjectName getObjectName() throws JasmineCollectorException {
        if (this.objname == null) {
            try {
                this.objname = ObjectName.getInstance(this.pattern);
            }
            catch (MalformedObjectNameException e) {
                throw new JasmineCollectorException("Malformed pattern: " + this.pattern + " (" + e.toString() + " )");
            }
            catch (NullPointerException e) {
                throw new JasmineCollectorException("Null pattern");
            }
        }
        return this.objname;
    }

    protected boolean hasAttributes() {
        if (this.attrlist == null || this.attrlist.isEmpty()) {
            return false;
        }
        if (this.attrlist.size() == 1) {
            for (String elem : this.attrlist) {
                if (!"all".equals(elem)) continue;
                return false;
            }
        }
        return true;
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        if (this.cached != null) {
            this.logger.debug((Object)"cached value returned", new Object[0]);
            return this.cached;
        }
        if (this.metrics == null) {
            this.logger.warn((Object)"No result ready to return", new Object[0]);
            return null;
        }
        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        String name = this.getIndicator().getName();
        this.logger.debug((Object)name, new Object[0]);
        jiv.setName(name);
        for (Metric metric : this.metrics) {
            if (metric.getAttributeList().size() == 0) {
                this.logger.warn((Object)("Result with no value: " + metric.toString()), new Object[0]);
                continue;
            }
            for (Attribute att : metric.getAttributeList()) {
                if (att.getValue() == null) {
                    this.logger.warn((Object)("No value for " + att.getName() + " in this indicator: " + this.getName()), new Object[0]);
                    continue;
                }
                List<Attribute> decomposedList = FragmentUtil.getFragments(att);
                for (Attribute dAtt : decomposedList) {
                    JasmineSingleResult jsr = this.getJsr(dAtt, metric.getTimestamp(), this.indicator.getScale());
                    jsr.addProperty("mbean", metric.getMBean().toString());
                    if (jsr == null) continue;
                    jiv.addValue(jsr);
                }
            }
        }
        jiv.addMetadata("target", this.metrics.get(0).getTarget());
        String key = "server";
        jiv.addMetadata(key, this.metrics.get(0).getProperties().get(key));
        key = "domain";
        jiv.addMetadata(key, this.metrics.get(0).getProperties().get(key));
        key = "url";
        jiv.addMetadata(key, this.metrics.get(0).getProperties().get(key));
        this.cached = jiv;
        this.metrics = null;
        return jiv;
    }

    private JasmineSingleResult getJsr(Attribute att, long timestamp, int scale) throws JasmineCollectorException {
        JasmineSingleStringResult jsr = null;
        Object value = att.getValue();
        if (value instanceof String) {
            String s = (String)value;
            jsr = new JasmineSingleStringResult();
            jsr.setValue((Object)s);
        } else if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            jsr = new JasmineSingleBooleanResult();
            jsr.setValue((Object)b);
        } else {
            try {
                Number numberValue = (Number)value;
                jsr = new JasmineSingleNumberResult();
                if (scale != 1) {
                    numberValue = this.divideValues(numberValue, scale);
                }
                jsr.setValue((Object)numberValue);
            }
            catch (ClassCastException cce) {
                this.logger.warn((Object)("Attribute " + att.getName() + " is not a number, nor a String. Currently no result (JasmineSingleResult) returned for it !"), new Object[0]);
                return null;
            }
        }
        jsr.setName(att.getName());
        jsr.setTimestamp(timestamp);
        return jsr;
    }

    public void stopPolling() {
        this.logger.debug((Object)"", new Object[0]);
        this.stopped = true;
    }

    public void startPolling() {
        this.logger.debug((Object)"", new Object[0]);
        this.stopped = false;
    }

    public boolean needResult() {
        if (this.stopped) {
            return false;
        }
        if (this.metrics == null) {
            return true;
        }
        long timestamp = this.metrics.get(0).getTimestamp();
        return this.oldvalue(timestamp);
    }

    public void addResult(List<Metric> metrics) {
        if (metrics.size() == 0) {
            this.logger.warn((Object)"Empty metric list", new Object[0]);
            return;
        }
        this.logger.debug((Object)"", new Object[0]);
        this.metrics = metrics;
        this.cached = null;
    }

    private boolean oldvalue(long timestamp) {
        long now = System.currentTimeMillis();
        return now - timestamp > (long)(this.period * 1000);
    }
}

