/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.openmbean.CompositeData;
import org.ow2.jasmine.probe.collectors.jmx.internal.FragmentNameException;
import org.ow2.jasmine.probe.collectors.jmx.internal.FragmentUtil;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollector;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxUtil {
    private static Log logger = LogFactory.getLog(JmxCollector.class);

    public static Set<ObjectName> getMBeans(MBeanServerConnection cnx, ObjectName on) throws IOException {
        QueryExp query = null;
        return cnx.queryNames(on, query);
    }

    public static List<String> getMBeanAttNames(MBeanServerConnection cnx, ObjectName on) throws IOException, JMException {
        MBeanAttributeInfo[] attsInfo;
        ArrayList<String> attNames = new ArrayList<String>();
        MBeanInfo mbeanInfo = cnx.getMBeanInfo(on);
        for (MBeanAttributeInfo attInfo : attsInfo = mbeanInfo.getAttributes()) {
            String attName = attInfo.getName();
            attNames.add(attName);
        }
        return attNames;
    }

    public static Attribute getAttributeFragment(MBeanServerConnection cnx, ObjectName objname, String name) throws IOException, JMException, FragmentNameException {
        String attName = FragmentUtil.getAttributeName(name);
        logger.debug((Object)"Fragment name: {0}, Attribute name: {1}, MBean OBJECT_NAME: {2}", new Object[]{name, attName, objname});
        try {
            String itemName = FragmentUtil.getItemName(name);
            logger.debug((Object)"Gen Attribute for item {0}", new Object[]{itemName});
            return JmxUtil.genItemAttribute(cnx, objname, attName, itemName);
        }
        catch (FragmentNameException fe) {
            try {
                String elemName = FragmentUtil.getElementName(name);
                logger.debug((Object)"Gen Attribute for element {0}", new Object[]{elemName});
                return JmxUtil.genElemAttribute(cnx, objname, attName, elemName);
            }
            catch (FragmentNameException fee) {
                throw new FragmentNameException((Object)((Object)fe) + " - " + (Object)((Object)fee));
            }
        }
    }

    public static Attribute genItemAttribute(MBeanServerConnection cnx, ObjectName objname, String attName, String key) throws IOException, JMException, FragmentNameException {
        if (FragmentUtil.isFragmentName(key)) {
            logger.warn((Object)"Support for composite key {0} not implemented yet !", new Object[]{key});
            return null;
        }
        Object attValue = cnx.getAttribute(objname, attName);
        if (attValue instanceof CompositeData) {
            CompositeData compValue = (CompositeData)attValue;
            Set<String> keys = compValue.getCompositeType().keySet();
            for (String _key : keys) {
                if (!key.equals(_key)) continue;
                Object item = compValue.get(key);
                String itemAttName = FragmentUtil.getNameForItem(attName, key);
                return new Attribute(itemAttName, item);
            }
            throw new FragmentNameException("Attribute " + attName + " of MBean " + objname + " has a CompositeData value, but non of its keys is equal to " + key);
        }
        if (attValue instanceof Map) {
            Map mapValue = (Map)attValue;
            Set keys = mapValue.keySet();
            for (Object _key : keys) {
                if (!key.equals(_key)) continue;
                Object item = mapValue.get(key);
                String itemAttName = FragmentUtil.getNameForItem(attName, key);
                return new Attribute(itemAttName, item);
            }
            throw new FragmentNameException("Attribute " + attName + " of MBean " + objname + " has a Map type value, but non of its keys is equal to " + key);
        }
        throw new FragmentNameException("Attribute " + attName + " of MBean " + objname + " has neither a Map type value, nor a CompositeData value !");
    }

    public static Attribute genElemAttribute(MBeanServerConnection cnx, ObjectName objname, String attName, String elemName) throws IOException, JMException, FragmentNameException {
        Object attValue = cnx.getAttribute(objname, attName);
        if (!attValue.getClass().isArray()) {
            throw new FragmentNameException("Attribute " + attName + " in MBean " + objname + " is not array, so cannot get element " + elemName);
        }
        int brackLeftIndex = elemName.indexOf(FragmentUtil.BRACKLEFT);
        int brackRightIndex = elemName.indexOf(FragmentUtil.BRACKRIGHT);
        String indexes = elemName.substring(brackLeftIndex + 1, brackRightIndex);
        logger.debug((Object)"Indexes: ", new Object[]{indexes.toString()});
        if (indexes.contains(FragmentUtil.COMMA)) {
            logger.warn((Object)"Support for multi-indexed elements {0} not implemented yet !", new Object[]{elemName});
            return null;
        }
        if (brackRightIndex == elemName.length() - 1) {
            try {
                int index = Integer.parseInt(indexes);
                try {
                    Object[] sArray = (Object[])attValue;
                    return new Attribute(elemName, sArray[index]);
                }
                catch (ClassCastException cc) {
                    try {
                        Array arrayval = (Array)attValue;
                        Object elem = Array.get(arrayval, index);
                        return new Attribute(elemName, elem);
                    }
                    catch (ClassCastException ccc) {
                        logger.warn((Object)"Support for indexed elements other then Array or Object[] not implemented yet ! Unsupported element: ", new Object[]{elemName});
                        return null;
                    }
                }
            }
            catch (NumberFormatException nfe) {
                throw new FragmentNameException("Element " + elemName + " of attribute " + attName + " in MBean " + objname + " has unsupported index form.");
            }
        }
        logger.warn((Object)"Support for complex elements {0} not implemented yet !", new Object[]{elemName});
        return null;
    }
}

