/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.manager;

import java.util.ArrayList;
import java.util.List;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collector.JasmineCollectorService;
import org.ow2.jasmine.probe.manager.internal.JProbeManager;
import org.ow2.jasmine.probe.outer.JasmineOuter;
import org.ow2.jasmine.probe.outer.JasmineOuterException;
import org.ow2.jasmine.probe.outer.JasmineOuterService;
import org.ow2.jasmine.probe.probescheduler.SchedulerException;
import org.ow2.jasmine.probe.probescheduler.TaskReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JProbe
implements Runnable {
    protected static Log logger = LogFactory.getLog(JProbe.class);
    private JasmineProbe probeDef;
    private JProbeManager probeMgr;
    private TaskReference task;
    private List<JasmineCollector> collectors;
    private List<JasmineOuter> outers;

    public JProbe(JasmineProbe def, JProbeManager mgr) {
        this.probeDef = def;
        this.probeMgr = mgr;
        def.setError("");
    }

    public JasmineProbe getProbeDef() {
        return this.probeDef;
    }

    public int getStatus() {
        return this.probeDef.getStatus();
    }

    public void setStatus(int state) {
        this.probeDef.setStatus(state);
    }

    public void setError(String mess) {
        this.probeDef.setError(mess);
    }

    public void resume() throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        this.buildOuterList();
        this.buildCollectorList();
        for (JasmineCollector collector : this.collectors) {
            collector.startPolling();
        }
        try {
            long ms = (long)this.probeDef.getPeriod() * 1000L;
            this.task = this.probeMgr.getScheduler().schedulePeriodicTask(null, (Runnable)this, 0L, ms);
            logger.debug((Object)(this.probeDef.getId() + " should be started now"), new Object[0]);
            this.probeDef.setStatus(1);
        }
        catch (SchedulerException e) {
            logger.error((Object)"Error when trying to start probe : {0}: {1}", new Object[]{this.probeDef.getId(), e});
            this.probeMgr.setProbeState(this, 3, e.getMessage());
        }
    }

    public void suspend() {
        logger.debug((Object)"", new Object[0]);
        if (this.task != null) {
            this.task.cancel(true);
            this.task = null;
        }
        for (JasmineCollector collector : this.collectors) {
            collector.stopPolling();
        }
        this.outers = new ArrayList<JasmineOuter>();
        this.collectors = new ArrayList<JasmineCollector>();
        this.probeDef.setStatus(0);
    }

    public void run() {
        logger.debug((Object)"", new Object[0]);
        JasmineProbeResult result = new JasmineProbeResult(this.probeDef.getId());
        for (JasmineCollector collector : this.collectors) {
            try {
                JasmineIndicatorValue val = collector.getLastResult();
                if (val != null) {
                    result.addValue(val);
                    continue;
                }
                logger.debug((Object)("No result found for " + collector.getName()), new Object[0]);
            }
            catch (JasmineCollectorException e) {
                logger.warn((Object)("Cannot get results on " + collector.getName() + " :" + (Object)((Object)e)), new Object[0]);
            }
            catch (NullPointerException e) {
                logger.error((Object)"NPE in run method", new Object[0]);
                e.printStackTrace();
            }
        }
        for (JasmineOuter outer : this.outers) {
            outer.publishData(result);
        }
    }

    private void buildOuterList() throws JasmineProbeException {
        this.outers = new ArrayList<JasmineOuter>();
        for (String outputname : this.probeDef.getOutputList()) {
            JasmineOutput output = this.probeMgr.getOutput(outputname);
            if (output == null) {
                logger.error((Object)("unknown output : " + outputname), new Object[0]);
                throw new JasmineProbeException("unknown output : " + outputname);
            }
            JasmineOuterService jos = this.probeMgr.getOuterService(output.getType());
            if (jos == null) {
                logger.error((Object)"No OuterService found for {0} having type {1}", new Object[]{outputname, output.getType()});
                throw new JasmineProbeException("No OuterService found for " + outputname);
            }
            JasmineOuter jo = null;
            try {
                jo = jos.getOuter(output);
            }
            catch (JasmineOuterException e) {
                logger.error((Object)("Could not get the Outer for " + outputname + ": " + (Object)((Object)e)), new Object[0]);
                throw new JasmineProbeException("Could not get the Outer for " + outputname);
            }
            this.outers.add(jo);
        }
    }

    private void buildCollectorList() throws JasmineProbeException {
        this.collectors = new ArrayList<JasmineCollector>();
        for (String indicname : this.probeDef.getIndicatorList()) {
            JasmineIndicator indic = this.probeMgr.getIndicator(indicname);
            if (indic == null) {
                logger.error((Object)("unknown indicator : " + indicname), new Object[0]);
                throw new JasmineProbeException("unknown indicator : " + indicname);
            }
            JasmineCollectorService jcs = this.probeMgr.getCollectorService(indic.getType());
            if (jcs == null) {
                logger.error((Object)"No CollectorService found for {0} having type {1}", new Object[]{indicname, indic.getType()});
                throw new JasmineProbeException("No CollectorService found for " + indicname);
            }
            JasmineCollector coll = null;
            try {
                coll = jcs.getCollector(indic, this.probeDef.getPeriod(), this.probeDef.getId());
            }
            catch (JasmineCollectorException e) {
                logger.error((Object)("Could not get the Collector for " + indicname + ": " + (Object)((Object)e)), new Object[0]);
                throw new JasmineProbeException("Could not get the Collector for " + indicname);
            }
            this.collectors.add(coll);
        }
    }
}

