/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.correlate.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelateCollector
extends JCollector {
    private int ope;
    private Collection<JasmineCollector> sources;

    public CorrelateCollector(String key, JasmineIndicator indic, int period, int ope, Collection<JasmineCollector> sources) {
        super(key, indic, period);
        this.ope = ope;
        this.sources = sources;
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        this.logger.debug((Object)"", new Object[0]);
        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        JasmineSingleNumberResult jsr = new JasmineSingleNumberResult();
        HashMap jsrProps = new HashMap();
        long timestamp = System.currentTimeMillis();
        Number result = 0;
        ArrayList<JasmineSingleResult> jsrList = new ArrayList<JasmineSingleResult>();
        String domain = null;
        String server = null;
        String target = null;
        for (JasmineCollector elem : this.sources) {
            String t;
            String s;
            String d;
            JasmineIndicatorValue jivs = elem.getLastResult();
            if (jivs == null) {
                this.logger.warn((Object)"No result available on source indicator {0}", new Object[]{elem.getName()});
                break;
            }
            if (jivs.getValues().isEmpty()) {
                this.logger.warn((Object)"No result available on source indicator {0}", new Object[]{elem.getName()});
                break;
            }
            if (jivs.getValues().size() > 1) {
                this.logger.warn((Object)"Correlation on multivalued indicator not supported", new Object[0]);
                throw new JasmineCollectorException("Correlation on multivalued indicator not supported");
            }
            Iterator i$ = jivs.getValues().iterator();
            if (i$.hasNext()) {
                JasmineSingleResult jsr1 = (JasmineSingleResult)i$.next();
                HashMap jsr1Props = jsr1.getProperties();
                jsrProps.putAll(jsr1Props);
                jsrList.add(jsr1);
            }
            if ((d = (String)jivs.getMetadata().get("domain")) != null) {
                if (domain == null) {
                    domain = d;
                } else if (!d.equals(domain)) {
                    domain = "misc";
                }
            }
            if ((s = (String)jivs.getMetadata().get("server")) != null) {
                if (server == null) {
                    server = s;
                } else if (!s.equals(server)) {
                    server = "misc";
                }
            }
            if ((t = jivs.getTarget()) == null) continue;
            if (target == null) {
                target = t;
                continue;
            }
            if (t.equals(target)) continue;
            target = "misc";
        }
        if (jsrList.isEmpty()) {
            this.logger.warn((Object)"No result available for correlate indicator {0}", new Object[]{this.indicator.getName()});
        }
        switch (this.ope) {
            case 1: {
                result = this.addJsr(jsrList);
                break;
            }
            case 2: {
                result = this.diffJsr(jsrList);
                break;
            }
            case 3: {
                result = this.multiplyJsr(jsrList);
                break;
            }
            case 4: {
                result = Float.valueOf(this.divideJsr(jsrList));
                break;
            }
            case 5: {
                result = Float.valueOf(100.0f * this.divideJsr(jsrList));
                break;
            }
            default: {
                throw new JasmineCollectorException("Bad correlate operation");
            }
        }
        if (this.indicator.getScale() != 1) {
            result = Float.valueOf(this.divideValues(result, this.indicator.getScale()));
        }
        jsr.setTimestamp(timestamp);
        jsr.setValue((Object)result);
        jsr.setName(this.indicator.getName());
        jsr.setProperties(jsrProps);
        jiv.setName(this.indicator.getName());
        jiv.addValue((JasmineSingleResult)jsr);
        jiv.addMetadata("domain", domain);
        jiv.addMetadata("server", server);
        jiv.setTarget(target);
        return jiv;
    }

    public void stopPolling() {
        this.logger.debug((Object)"", new Object[0]);
    }

    public void startPolling() {
        this.logger.debug((Object)"", new Object[0]);
    }
}

