/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.collectors.jmx.Metric;
import org.ow2.jasmine.probe.collectors.jmx.internal.FragmentNameException;
import org.ow2.jasmine.probe.collectors.jmx.internal.FragmentUtil;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollector;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxUtil;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionException;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionFactory;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxWorker
extends Thread {
    private Log logger = LogFactory.getLog(JCollector.class);
    private boolean started = false;
    private String targetName;
    private String url;
    private long collectorTimeout = 1000L;
    private static final long DEFAULT_TIMEOUT = 1000L;
    private Collection<JmxCollector> collectors = new ArrayList<JmxCollector>();
    private JmxConnectionService jmxService;
    private Map<String, String> props = new HashMap<String, String>();
    private JmxConnectionFactory cfactory = null;
    private String serverName = null;
    private String domainName = null;
    private boolean serverNameSet = false;
    private String error;

    public JmxWorker(JasmineTarget target, JmxConnectionService jmxConnectionService) {
        this.logger.debug((Object)target.getName(), new Object[0]);
        this.targetName = target.getName();
        this.url = target.getUrl();
        this.props = target.getProperties();
        this.jmxService = jmxConnectionService;
    }

    public synchronized void remove() {
        this.started = false;
    }

    public synchronized void addCollector(JmxCollector col) {
        this.collectors.add(col);
        if (!this.started) {
            this.started = true;
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.started) {
            ArrayList<JmxCollector> topoll = new ArrayList<JmxCollector>();
            JmxWorker jmxWorker = this;
            synchronized (jmxWorker) {
                for (JmxCollector coll : this.collectors) {
                    if (!coll.needResult()) continue;
                    topoll.add(coll);
                }
            }
            if (!topoll.isEmpty()) {
                long t = System.currentTimeMillis();
                MBeanServerConnection cnx = null;
                try {
                    cnx = this.getMBeanServerConnection();
                }
                catch (JmxConnectionException e) {
                    this.logger.warn((Object)("Cannot get Jmx Access:" + (Object)((Object)e)), new Object[0]);
                }
                if (cnx != null) {
                    this.setServerAndDomain(cnx);
                    for (JmxCollector coll : topoll) {
                        List<Metric> metrics = this.collect(cnx, coll);
                        coll.addResult(metrics);
                    }
                }
            }
            jmxWorker = this;
            synchronized (jmxWorker) {
                try {
                    this.wait(this.collectorTimeout);
                }
                catch (InterruptedException e) {
                    this.logger.warn((Object)(this.getName() + ": collector interrupted"), new Object[]{e});
                }
                catch (Exception e) {
                    this.logger.warn((Object)(this.getName() + ": collector exception"), new Object[]{e});
                }
            }
        }
    }

    private MBeanServerConnection getMBeanServerConnection() throws JmxConnectionException {
        if (this.cfactory == null) {
            this.cfactory = this.jmxService.getJmxConnectionFactory(this.url, this.props);
        }
        return this.cfactory.getMBeanServerConnection();
    }

    private void setServerAndDomain(MBeanServerConnection cnx) {
        block12: {
            if (this.serverNameSet) {
                return;
            }
            try {
                this.domainName = "unknown_domain";
                this.serverName = "unknown";
                ObjectName on = ObjectName.getInstance("*:j2eeType=J2EEServer,*");
                Set<ObjectName> ons = cnx.queryNames(on, null);
                if (!ons.isEmpty()) {
                    Iterator<ObjectName> onames = ons.iterator();
                    ObjectName serverOn = onames.next();
                    this.domainName = serverOn.getDomain();
                    String name = serverOn.getKeyProperty("name");
                    if (name != null) {
                        this.serverNameSet = true;
                        this.serverName = name;
                    }
                    return;
                }
                on = ObjectName.getInstance("Catalina:*");
                ons = cnx.queryNames(on, null);
                if (!ons.isEmpty()) {
                    this.domainName = "Catalina";
                    this.serverName = this.targetName;
                    this.serverNameSet = true;
                    return;
                }
                on = ObjectName.getInstance("org.mortbay.jetty:type=server,*");
                ons = cnx.queryNames(on, null);
                if (!ons.isEmpty()) {
                    this.domainName = "org.mortbay.jetty";
                    Iterator<ObjectName> onames = ons.iterator();
                    ObjectName serverOn = onames.next();
                    String serverId = serverOn.getKeyProperty("id");
                    this.serverName = serverId != null ? serverId : this.targetName;
                    this.serverNameSet = true;
                    return;
                }
            }
            catch (JMException e) {
                if (this.error == null) {
                    this.error = e.toString();
                    this.logger.warn((Object)"Cannot get server and domain names for target {0} ({1})", new Object[]{this.targetName, this.error});
                } else if (!this.error.equals(e.toString())) {
                    this.error = e.toString();
                    this.logger.warn((Object)"Cannot get server and domain names for target {0} ({1})", new Object[]{this.targetName, this.error});
                }
            }
            catch (IOException e) {
                if (this.error == null) {
                    this.error = e.toString();
                    this.logger.error((Object)"A communication problem occurred with target {0} ({1})", new Object[]{this.targetName, this.error});
                }
                if (this.error.equals(e.toString())) break block12;
                this.error = e.toString();
                this.logger.error((Object)"A communication problem occurred with target {0} ({1})", new Object[]{this.targetName, this.error});
            }
        }
    }

    private List<Metric> collect(MBeanServerConnection cnx, JmxCollector col) {
        LinkedList<Metric> metrics = new LinkedList<Metric>();
        try {
            ObjectName objname = col.getObjectName();
            if (objname.isPattern()) {
                this.logger.debug((Object)("collect pattern:" + objname.toString()), new Object[0]);
                Set<ObjectName> onset = JmxUtil.getMBeans(cnx, objname);
                if (onset.isEmpty()) {
                    this.logger.warn((Object)"No MBeans found for pattern {0} in this collector (indicator: {1})", new Object[]{objname.toString(), col.getIndicator().getName()});
                }
                for (ObjectName on : onset) {
                    Metric m = this.getMBeanMetric(cnx, on, col);
                    if (m == null) continue;
                    metrics.add(m);
                }
            } else {
                this.logger.debug((Object)("collect single mbean:" + objname.toString()), new Object[0]);
                if (cnx.isRegistered(objname)) {
                    Metric m = this.getMBeanMetric(cnx, objname, col);
                    if (m != null) {
                        metrics.add(m);
                    }
                } else {
                    this.logger.error((Object)"Cannot collect from MBean {0} (does not exists)", new Object[]{objname});
                }
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("getAttributes error on JmxServer: " + e), new Object[0]);
        }
        this.logger.debug((Object)("nb of metrics found: " + metrics.size()), new Object[0]);
        return metrics;
    }

    private Metric getMBeanMetric(MBeanServerConnection cnx, ObjectName objname, JmxCollector col) throws IOException, JMException {
        this.logger.debug((Object)("mbean:" + objname.toString()), new Object[0]);
        List<String> allAttNames = JmxUtil.getMBeanAttNames(cnx, objname);
        AttributeList attl = new AttributeList();
        long time = System.currentTimeMillis();
        attl = !col.hasAttributes() ? this.getAllAttributes(cnx, objname, time, allAttNames) : this.getAttributesForProvidedNames(cnx, objname, time, allAttNames, col.getName(), col.geAttrlist());
        if (attl.isEmpty()) {
            this.logger.warn((Object)("No metrics found for indicator: " + col.getIndicator().getName() + ", for mbean: " + objname.toString() + ", and target: " + this.targetName), new Object[0]);
            return null;
        }
        Metric metric = new Metric(time, objname, attl, this.targetName);
        metric.setProperty("server", this.serverName);
        metric.setProperty("domain", this.domainName);
        metric.setProperty("url", this.url);
        return metric;
    }

    private AttributeList getAllAttributes(MBeanServerConnection cnx, ObjectName objname, long time, List<String> allAttNames) throws IOException, JMException {
        AttributeList attl = cnx.getAttributes(objname, allAttNames.toArray(new String[0]));
        this.logger.debug((Object)"all attributes to poll:", new Object[0]);
        for (String nameToPoll : allAttNames) {
            this.logger.debug((Object)nameToPoll, new Object[0]);
        }
        return attl;
    }

    private AttributeList getAttributesForProvidedNames(MBeanServerConnection cnx, ObjectName objname, long time, List<String> allAttNames, String colName, Collection<String> names) throws IOException, JMException {
        AttributeList attl = new AttributeList();
        HashMap<String, String> attNamesToPoll = new HashMap<String, String>();
        HashMap<String, Attribute> attsToPoll = new HashMap<String, Attribute>();
        for (String name : names) {
            if (FragmentUtil.isFragmentName(name)) {
                try {
                    String attName = FragmentUtil.getAttributeName(name);
                    if (allAttNames.contains(attName)) {
                        attNamesToPoll.put(name, attName);
                        continue;
                    }
                    this.logger.error((Object)"Cannot poll fragment {0} (no attribute named {1} exists in MBean {2})", new Object[]{name, attName, objname});
                }
                catch (FragmentNameException e) {
                    this.logger.error((Object)"Cannot poll fragment {0}, incorrect format !", new Object[0]);
                }
                continue;
            }
            if (allAttNames.contains(name)) {
                attNamesToPoll.put(name, name);
                continue;
            }
            this.logger.error((Object)"Cannot poll attribute {0} (does not exists in MBean {1})", new Object[]{name, objname});
        }
        if (attNamesToPoll.keySet().isEmpty()) {
            this.logger.info((Object)"No attributes to poll in this MBean (based on collector {0} definition and {1} metadata)", new Object[]{colName, objname});
            return null;
        }
        this.logger.debug((Object)"names to poll:", new Object[0]);
        for (String nameToPoll : attNamesToPoll.keySet()) {
            this.logger.debug((Object)nameToPoll, new Object[0]);
        }
        this.logger.debug((Object)"corresponding attribute names:", new Object[0]);
        String[] attNames = new String[attNamesToPoll.keySet().size()];
        int i = 0;
        for (String nameToPoll : attNamesToPoll.keySet()) {
            attNames[i++] = (String)attNamesToPoll.get(nameToPoll);
            this.logger.debug(attNamesToPoll.get(nameToPoll), new Object[0]);
        }
        AttributeList atts = cnx.getAttributes(objname, attNames);
        for (String nameToPoll : attNamesToPoll.keySet()) {
            String attName = (String)attNamesToPoll.get(nameToPoll);
            attsToPoll.put(nameToPoll, this.getAttribute(atts, attName));
        }
        for (String name : attsToPoll.keySet()) {
            if (FragmentUtil.isFragmentName(name)) {
                try {
                    Attribute att = JmxUtil.getAttributeFragment(name, (Attribute)attsToPoll.get(name));
                    attl.add(att);
                }
                catch (FragmentNameException e) {
                    this.logger.error((Object)"Cannot poll fragment {0} ({1})", new Object[]{name, e.toString()});
                }
                continue;
            }
            attl.add((Attribute)attsToPoll.get(name));
        }
        return attl;
    }

    private Attribute getAttribute(AttributeList atts, String attName) {
        for (Attribute att : atts.asList()) {
            if (!att.getName().equals(attName)) continue;
            return att;
        }
        return null;
    }
}

