/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.correlate.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.ConstantCollector;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.collectors.JCollectorService;
import org.ow2.jasmine.probe.collectors.correlate.internal.CorrelateCollector;
import org.ow2.jasmine.probe.probemanager.ProbeManager;
import org.ow2.jasmine.probe.util.CsvConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="CorrelateCollectorService")
@Provides
public class CorrelateCollectorService
extends JCollectorService
implements Pojo {
    private InstanceManager __IM;
    public static final String PROP_OP = "op";
    public static final String PROP_SOURCES = "sources";
    public static final int OP_ADD = 1;
    public static final int OP_SUB = 2;
    public static final int OP_MUL = 3;
    public static final int OP_DIV = 4;
    public static final int OP_PERCENT = 5;
    private boolean __FindicatorType;
    @ServiceProperty(name="indicator.type", value="correlate")
    private String indicatorType;
    private boolean __FprobeManager;
    @Requires
    ProbeManager probeManager;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$int$java_lang_String;
    private boolean __MgetDependantIndicators$org_ow2_jasmine_probe_JasmineIndicator;
    private boolean __MisNumeric$java_lang_String;

    String __getindicatorType() {
        if (!this.__FindicatorType) {
            return this.indicatorType;
        }
        return (String)this.__IM.onGet((Object)this, "indicatorType");
    }

    void __setindicatorType(String string) {
        if (!this.__FindicatorType) {
            this.indicatorType = string;
            return;
        }
        this.__IM.onSet((Object)this, "indicatorType", (Object)string);
    }

    ProbeManager __getprobeManager() {
        if (!this.__FprobeManager) {
            return this.probeManager;
        }
        return (ProbeManager)this.__IM.onGet((Object)this, "probeManager");
    }

    void __setprobeManager(ProbeManager probeManager) {
        if (!this.__FprobeManager) {
            this.probeManager = probeManager;
            return;
        }
        this.__IM.onSet((Object)this, "probeManager", (Object)probeManager);
    }

    public CorrelateCollectorService() {
        this(null);
    }

    private CorrelateCollectorService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setprobeManager(null);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        this.properties = new ArrayList();
        this.properties.add(new JasminePropertyInfo(PROP_OP, "correlate operation (add|sub|mul|div|percent)", true));
        this.properties.add(new JasminePropertyInfo(PROP_SOURCES, "csv list of source indicator name or constants", true));
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() {
    }

    public JasmineCollector getCollector(JasmineIndicator jasmineIndicator, int n, String string) throws JasmineCollectorException {
        JasmineCollector jasmineCollector;
        if (!this.__MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$int$java_lang_String) {
            return this.__getCollector(jasmineIndicator, n, string);
        }
        try {
            this.__IM.onEntry((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$int$java_lang_String", new Object[]{jasmineIndicator, new Integer(n), string});
            jasmineCollector = this.__getCollector(jasmineIndicator, n, string);
            this.__IM.onExit((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$int$java_lang_String", (Object)jasmineCollector);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$int$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineCollector;
    }

    private JasmineCollector __getCollector(JasmineIndicator indicator, int period, String probeid) throws JasmineCollectorException {
        String key = probeid + ":" + indicator.getName();
        JCollector collector = (JCollector)this.collectorList.get(key);
        if (collector == null) {
            if (!indicator.getType().equals(this.__getindicatorType())) {
                this.logger.error((Object)("Bad type: " + indicator.getType()), new Object[0]);
                throw new JasmineCollectorException("Bad type: " + indicator.getType());
            }
            Map props = indicator.getProperties();
            ArrayList<JasmineCollector> sources = new ArrayList<JasmineCollector>();
            Collection inames = CsvConverter.csv2list((String)((String)props.get(PROP_SOURCES)));
            if (inames == null) {
                String err = "No sources defined in " + key;
                this.logger.error((Object)err, new Object[0]);
                throw new JasmineCollectorException(err);
            }
            for (String iname : inames) {
                ConstantCollector source = null;
                if (this.isNumeric(iname)) {
                    source = new ConstantCollector(iname, indicator, period);
                } else {
                    try {
                        source = this.__getprobeManager().getCollector(iname, period, probeid);
                    }
                    catch (JasmineProbeException e) {
                        this.logger.error((Object)("Cannot get value: " + (Object)((Object)e)), new Object[0]);
                        throw new JasmineCollectorException(e.getMessage());
                    }
                }
                sources.add((JasmineCollector)source);
            }
            String operation = (String)props.get(PROP_OP);
            if (operation == null) {
                String err = "Operation not defined in " + key;
                this.logger.error((Object)err, new Object[0]);
                throw new JasmineCollectorException(err);
            }
            int ope = 0;
            if (operation.equalsIgnoreCase("add")) {
                ope = 1;
            } else if (operation.equalsIgnoreCase("sub")) {
                ope = 2;
            } else if (operation.equalsIgnoreCase("mul")) {
                ope = 3;
            } else if (operation.equalsIgnoreCase("div")) {
                ope = 4;
            } else if (operation.equalsIgnoreCase("percent")) {
                ope = 5;
            } else {
                String err = "Operation not supported in CorrelateCollectorService: " + operation;
                this.logger.error((Object)err, new Object[0]);
                throw new JasmineCollectorException(err);
            }
            collector = new CorrelateCollector(key, indicator, period, ope, sources);
            this.collectorList.put(key, collector);
        }
        return collector;
    }

    public List<String> getDependantIndicators(JasmineIndicator jasmineIndicator) {
        List<String> list;
        if (!this.__MgetDependantIndicators$org_ow2_jasmine_probe_JasmineIndicator) {
            return this.__getDependantIndicators(jasmineIndicator);
        }
        try {
            this.__IM.onEntry((Object)this, "getDependantIndicators$org_ow2_jasmine_probe_JasmineIndicator", new Object[]{jasmineIndicator});
            list = this.__getDependantIndicators(jasmineIndicator);
            this.__IM.onExit((Object)this, "getDependantIndicators$org_ow2_jasmine_probe_JasmineIndicator", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDependantIndicators$org_ow2_jasmine_probe_JasmineIndicator", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getDependantIndicators(JasmineIndicator indic) {
        ArrayList<String> ret = new ArrayList<String>();
        Map props = indic.getProperties();
        Collection inames = CsvConverter.csv2list((String)((String)props.get(PROP_SOURCES)));
        for (String iname : inames) {
            if (this.isNumeric(iname)) continue;
            ret.add(iname);
        }
        return ret;
    }

    private boolean isNumeric(String string) {
        boolean bl;
        if (!this.__MisNumeric$java_lang_String) {
            return this.__isNumeric(string);
        }
        try {
            this.__IM.onEntry((Object)this, "isNumeric$java_lang_String", new Object[]{string});
            bl = this.__isNumeric(string);
            this.__IM.onExit((Object)this, "isNumeric$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isNumeric$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isNumeric(String s) {
        return s.matches("((-|\\+)?[0-9]+(\\.[0-9]+)?)+");
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("probeManager")) {
                this.__FprobeManager = true;
            }
            if (set.contains("indicatorType")) {
                this.__FindicatorType = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("getCollector$org_ow2_jasmine_probe_JasmineIndicator$int$java_lang_String")) {
                this.__MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$int$java_lang_String = true;
            }
            if (set.contains("getDependantIndicators$org_ow2_jasmine_probe_JasmineIndicator")) {
                this.__MgetDependantIndicators$org_ow2_jasmine_probe_JasmineIndicator = true;
            }
            if (set.contains("isNumeric$java_lang_String")) {
                this.__MisNumeric$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

