/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.tcp.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.providers.tcp.protocols.DefaultProtocol;

public class LengthProtocol
extends DefaultProtocol {
    private static final Log logger = LogFactory.getLog(LengthProtocol.class);
    private static final int SIZE_INT = 4;

    public LengthProtocol() {
        super(false, 4);
    }

    public Object read(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        dis.mark(4);
        if (null == super.read(dis, 4)) {
            return null;
        }
        dis.reset();
        int length = dis.readInt();
        if (logger.isDebugEnabled()) {
            logger.debug("length: " + length);
        }
        byte[] buffer = new byte[length];
        dis.readFully(buffer);
        if (logger.isDebugEnabled()) {
            logger.debug("length read: " + buffer.length);
        }
        return buffer;
    }

    protected void writeByteArray(OutputStream os, byte[] data) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeInt(data.length);
        dos.write(data);
        dos.flush();
    }

    protected boolean isRepeat(int len, int available) {
        return true;
    }
}

