/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.df.internal;

import java.util.Collection;
import java.util.Map;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.util.CsvConverter;

public class DfCollector
extends JCollector {
    private Collection<String> diskList = null;
    private JasmineIndicatorValue cache = null;
    private JasmineIndicatorValue metrics = null;
    private int nbUsers = 1;
    private int nbUsed = 0;
    private static final long OBSOLATE_TIME = 3000L;
    private boolean stopped = false;

    public DfCollector(String probeId, JasmineIndicator indicator, int period) {
        super(probeId, indicator, period);
        Map props = indicator.getProperties();
        this.diskList = CsvConverter.csv2list((String)((String)props.get("disk")));
    }

    public Collection<String> getDiskList() {
        return this.diskList;
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        this.logger.debug((Object)"Nb users = {0}", new Object[]{this.nbUsers});
        if (this.nbUsers == 1) {
            JasmineIndicatorValue jiv = this.getJiv();
            this.metrics = null;
            return jiv;
        }
        if (this.nbUsed == 0) {
            this.cache = this.getJiv();
        }
        ++this.nbUsed;
        if (this.nbUsed == this.nbUsers) {
            this.logger.debug((Object)"Last cached result will be returned because nbUsed = {0}", new Object[]{this.nbUsed});
            this.metrics = null;
            this.nbUsed = 0;
        }
        this.logger.debug((Object)"Returned cached result", new Object[0]);
        return this.cache;
    }

    public void stopPolling() {
        this.logger.debug((Object)("Stop " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
        this.stopped = true;
    }

    public void startPolling() {
        this.logger.debug((Object)("Start " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
        this.stopped = false;
    }

    public boolean needResult() {
        if (this.stopped) {
            this.logger.debug((Object)("STOPPED, need no result for " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
            return false;
        }
        if (this.metrics == null) {
            return true;
        }
        long timestamp = this.metrics.getTimestamp();
        if (this.oldvalue(timestamp)) {
            this.metrics = null;
            return true;
        }
        return false;
    }

    public void addResult(JasmineIndicatorValue value) {
        this.logger.debug((Object)value.getName(), new Object[0]);
        this.metrics = value;
    }

    private boolean oldvalue(long timestamp) {
        long now = System.currentTimeMillis();
        return now - timestamp > (long)(this.period * 1000) + 3000L;
    }

    private JasmineIndicatorValue getJiv() throws JasmineCollectorException {
        if (this.metrics == null) {
            this.logger.debug((Object)"No value", new Object[0]);
            return null;
        }
        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        jiv.setName(this.metrics.getName());
        jiv.setValues(this.metrics.getValues());
        jiv.setMultiValue(this.metrics.isMultiValue());
        this.logger.debug((Object)("value=" + jiv), new Object[0]);
        if (this.indicator.getScale() != 1) {
            for (JasmineSingleResult jsr : jiv.getValues()) {
                long value = this.longValue((Number)jsr.getValue()) / (long)this.indicator.getScale();
                jsr.setValue((Object)value);
            }
        }
        jiv.addMetadata("server", this.getServerName());
        jiv.addMetadata("domain", this.getDomainName());
        if (this.hostName != null) {
            jiv.setTarget(this.hostName);
        } else {
            jiv.setTarget(this.getServerName());
        }
        return jiv;
    }
}

