/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.agents;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.internal.notifications.ManagerNotificationListener;
import org.mule.impl.internal.notifications.NotificationException;
import org.mule.management.agents.JmxManagementException;
import org.mule.management.agents.WrapperManagerAgent;
import org.mule.management.i18n.ManagementMessages;
import org.mule.management.mbeans.ComponentService;
import org.mule.management.mbeans.ConnectorService;
import org.mule.management.mbeans.EndpointService;
import org.mule.management.mbeans.ModelService;
import org.mule.management.mbeans.MuleConfigurationService;
import org.mule.management.mbeans.MuleService;
import org.mule.management.mbeans.StatisticsService;
import org.mule.management.support.AutoDiscoveryJmxSupportFactory;
import org.mule.management.support.JmxSupport;
import org.mule.management.support.JmxSupportFactory;
import org.mule.management.support.SimplePasswordJmxAuthenticator;
import org.mule.providers.AbstractConnector;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public class JmxAgent
implements UMOAgent {
    public static final String DEFAULT_REMOTING_URI = "service:jmx:rmi:///jndi/rmi://localhost:1099/server";
    public static final Map DEFAULT_CONNECTOR_SERVER_PROPERTIES;
    public static final String DEFAULT_JMX_AUTHENTICATOR;
    protected static final Log logger;
    protected boolean locateServer = true;
    private String name = "JMX Agent";
    private boolean createServer = true;
    private String connectorServerUrl;
    private MBeanServer mBeanServer;
    private JMXConnectorServer connectorServer;
    private Map connectorServerProperties = null;
    private boolean enableStatistics = true;
    private List registeredMBeans = new ArrayList();
    private final AtomicBoolean serverCreated = new AtomicBoolean(false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private JmxSupportFactory jmxSupportFactory = AutoDiscoveryJmxSupportFactory.getInstance();
    private JmxSupport jmxSupport = this.jmxSupportFactory.getJmxSupport();
    private Map credentials = new HashMap();

    public JmxAgent() {
        this.connectorServerProperties = new HashMap(DEFAULT_CONNECTOR_SERVER_PROPERTIES);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        if (this.connectorServerUrl != null) {
            return "JMX Agent: " + this.connectorServerUrl;
        }
        return "JMX Agent";
    }

    public void initialise() throws InitialisationException {
        Object l;
        if (this.initialized.get()) {
            return;
        }
        if (this.mBeanServer == null && !this.locateServer && !this.createServer) {
            throw new InitialisationException(ManagementMessages.createOrLocateShouldBeSet(), (Object)this);
        }
        if (this.mBeanServer == null && this.locateServer && (l = MBeanServerFactory.findMBeanServer(null)) != null && l.size() > 0) {
            this.mBeanServer = (MBeanServer)l.get(0);
        }
        if (this.mBeanServer == null && this.createServer) {
            this.mBeanServer = MBeanServerFactory.createMBeanServer();
            this.serverCreated.set(true);
        }
        if (this.mBeanServer == null) {
            throw new InitialisationException(ManagementMessages.cannotLocateOrCreateServer(), (Object)this);
        }
        if (this.connectorServerUrl != null) {
            try {
                JMXServiceURL url = new JMXServiceURL(this.connectorServerUrl);
                if (this.connectorServerProperties == null) {
                    this.connectorServerProperties = new HashMap(DEFAULT_CONNECTOR_SERVER_PROPERTIES);
                }
                if (!this.credentials.isEmpty()) {
                    JMXAuthenticator jmxAuthenticator = (JMXAuthenticator)ClassUtils.instanciateClass(DEFAULT_JMX_AUTHENTICATOR, ClassUtils.NO_ARGS);
                    ((SimplePasswordJmxAuthenticator)jmxAuthenticator).setCredentials(this.credentials);
                    this.connectorServerProperties.put("jmx.remote.authenticator", jmxAuthenticator);
                }
                this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, this.connectorServerProperties, this.mBeanServer);
            }
            catch (Exception e) {
                throw new InitialisationException(CoreMessages.failedToCreate("Jmx Connector"), e, this);
            }
        }
        l = new ManagerNotificationListener(){

            public void onNotification(UMOServerNotification notification) {
                if (notification.getAction() == 112) {
                    try {
                        JmxAgent.this.registerWrapperService();
                        JmxAgent.this.registerStatisticsService();
                        JmxAgent.this.registerMuleService();
                        JmxAgent.this.registerConfigurationService();
                        JmxAgent.this.registerModelServices();
                        JmxAgent.this.registerComponentServices();
                        JmxAgent.this.registerEndpointServices();
                        JmxAgent.this.registerConnectorServices();
                    }
                    catch (Exception e) {
                        throw new MuleRuntimeException(CoreMessages.objectFailedToInitialise("MBeans"), (Throwable)e);
                    }
                }
            }
        };
        try {
            UMOManager manager = MuleManager.getInstance();
            if (StringUtils.isBlank(manager.getId())) {
                throw new IllegalArgumentException("Manager ID is mandatory when running with JmxAgent. Give your Mule configuration a valid ID.");
            }
            MuleManager.getInstance().registerListener((UMOServerNotificationListener)l);
        }
        catch (NotificationException e) {
            throw new InitialisationException(e, (Object)this);
        }
        this.initialized.compareAndSet(false, true);
    }

    public void start() throws UMOException {
        if (this.connectorServer != null) {
            try {
                logger.info((Object)"Starting JMX agent connector Server");
                this.connectorServer.start();
            }
            catch (Exception e) {
                throw new JmxManagementException(CoreMessages.failedToStart("Jmx Connector"), (Throwable)e);
            }
        }
    }

    public void stop() throws UMOException {
        if (this.connectorServer != null) {
            try {
                this.connectorServer.stop();
            }
            catch (Exception e) {
                throw new JmxManagementException(CoreMessages.failedToStop("Jmx Connector"), (Throwable)e);
            }
        }
    }

    public void dispose() {
        if (this.mBeanServer != null) {
            Iterator iterator = this.registeredMBeans.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                try {
                    this.mBeanServer.unregisterMBean(objectName);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to unregister MBean: " + objectName + ". Error is: " + e.getMessage()));
                }
            }
            if (this.serverCreated.get()) {
                MBeanServerFactory.releaseMBeanServer(this.mBeanServer);
            }
            this.mBeanServer = null;
        }
        this.initialized.set(false);
    }

    public void registered() {
    }

    public void unregistered() {
    }

    protected void registerWrapperService() throws UMOException {
        WrapperManagerAgent wmAgent = new WrapperManagerAgent();
        UMOManager manager = MuleManager.getInstance();
        if (manager.lookupAgent(wmAgent.getName()) == null) {
            manager.registerAgent(wmAgent);
        }
    }

    protected void registerStatisticsService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName() + ":type=org.mule.Statistics,name=AllStatistics");
        StatisticsService mBean = new StatisticsService();
        mBean.setManager(MuleManager.getInstance());
        mBean.setEnabled(this.isEnableStatistics());
        logger.debug((Object)("Registering statistics with name: " + on));
        this.mBeanServer.registerMBean(mBean, on);
        this.registeredMBeans.add(on);
    }

    protected void registerModelServices() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        Iterator iterator = MuleManager.getInstance().getModels().values().iterator();
        while (iterator.hasNext()) {
            UMOModel model = (UMOModel)iterator.next();
            ModelService serviceMBean = new ModelService(model);
            String rawName = serviceMBean.getName() + "(" + serviceMBean.getType() + ")";
            String name = this.jmxSupport.escape(rawName);
            ObjectName on = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName() + ":type=org.mule.Model,name=" + name);
            logger.debug((Object)("Registering model with name: " + on));
            this.mBeanServer.registerMBean(serviceMBean, on);
            this.registeredMBeans.add(on);
        }
    }

    protected void registerMuleService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName() + ":type=org.mule.ManagementContext,name=MuleServerInfo");
        MuleService serviceMBean = new MuleService();
        logger.debug((Object)("Registering mule with name: " + on));
        this.mBeanServer.registerMBean(serviceMBean, on);
        this.registeredMBeans.add(on);
    }

    protected void registerConfigurationService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName() + ":type=org.mule.Configuration,name=GlobalConfiguration");
        MuleConfigurationService serviceMBean = new MuleConfigurationService();
        logger.debug((Object)("Registering configuration with name: " + on));
        this.mBeanServer.registerMBean(serviceMBean, on);
        this.registeredMBeans.add(on);
    }

    protected void registerComponentServices() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        Iterator iterator = MuleManager.getInstance().getModels().values().iterator();
        while (iterator.hasNext()) {
            UMOModel model = (UMOModel)iterator.next();
            Iterator iter = model.getComponentNames();
            while (iter.hasNext()) {
                String rawName = iter.next().toString();
                String name = this.jmxSupport.escape(rawName);
                ObjectName on = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName() + ":type=org.mule.Component,name=" + name);
                ComponentService serviceMBean = new ComponentService(rawName);
                logger.debug((Object)("Registering component with name: " + on));
                this.mBeanServer.registerMBean(serviceMBean, on);
                this.registeredMBeans.add(on);
            }
        }
    }

    protected void registerEndpointServices() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        Iterator iter = MuleManager.getInstance().getConnectors().values().iterator();
        while (iter.hasNext()) {
            UMOConnector connector = (UMOConnector)iter.next();
            if (connector instanceof AbstractConnector) {
                Iterator iterator = ((AbstractConnector)connector).getReceivers().values().iterator();
                while (iterator.hasNext()) {
                    EndpointService mBean = new EndpointService((UMOMessageReceiver)iterator.next());
                    String rawName = mBean.getName();
                    String name = this.jmxSupport.escape(rawName);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Attempting to register service with name: " + this.jmxSupport.getDomainName() + ":type=org.mule.Endpoint,component=" + this.jmxSupport.escape(mBean.getComponentName()) + ",name=" + name));
                    }
                    ObjectName on = this.jmxSupport.getObjectName(this.jmxSupport.getDomainName() + ":type=org.mule.Endpoint,component=" + this.jmxSupport.escape(mBean.getComponentName()) + ",name=" + name);
                    this.mBeanServer.registerMBean(mBean, on);
                    this.registeredMBeans.add(on);
                    logger.info((Object)("Registered Endpoint Service with name: " + on));
                }
                continue;
            }
            logger.warn((Object)("Connector: " + connector + " is not an istance of AbstractConnector, cannot obtain Endpoint MBeans from it"));
        }
    }

    protected void registerConnectorServices() throws MalformedObjectNameException, NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException {
        Iterator iter = MuleManager.getInstance().getConnectors().values().iterator();
        while (iter.hasNext()) {
            UMOConnector connector = (UMOConnector)iter.next();
            ConnectorService mBean = new ConnectorService(connector);
            String rawName = mBean.getName();
            String name = this.jmxSupport.escape(rawName);
            String stringName = this.jmxSupport.getDomainName() + ":type=org.mule.Connector,name=" + name;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attempting to register service with name: " + stringName));
            }
            ObjectName oName = this.jmxSupport.getObjectName(stringName);
            this.mBeanServer.registerMBean(mBean, oName);
            this.registeredMBeans.add(oName);
            logger.info((Object)("Registered Connector Service with name " + oName));
        }
    }

    public boolean isCreateServer() {
        return this.createServer;
    }

    public void setCreateServer(boolean createServer) {
        this.createServer = createServer;
    }

    public boolean isLocateServer() {
        return this.locateServer;
    }

    public void setLocateServer(boolean locateServer) {
        this.locateServer = locateServer;
    }

    public String getConnectorServerUrl() {
        return this.connectorServerUrl;
    }

    public void setConnectorServerUrl(String connectorServerUrl) {
        this.connectorServerUrl = connectorServerUrl;
    }

    public boolean isEnableStatistics() {
        return this.enableStatistics;
    }

    public void setEnableStatistics(boolean enableStatistics) {
        this.enableStatistics = enableStatistics;
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public Map getConnectorServerProperties() {
        return this.connectorServerProperties;
    }

    public void setConnectorServerProperties(Map connectorServerProperties) {
        this.connectorServerProperties = connectorServerProperties;
    }

    public JmxSupportFactory getJmxSupportFactory() {
        return this.jmxSupportFactory;
    }

    public void setJmxSupportFactory(JmxSupportFactory jmxSupportFactory) {
        this.jmxSupportFactory = jmxSupportFactory;
    }

    public void setCredentials(Map newCredentials) {
        this.credentials.clear();
        if (newCredentials != null && !newCredentials.isEmpty()) {
            this.credentials.putAll(newCredentials);
        }
    }

    static {
        DEFAULT_JMX_AUTHENTICATOR = SimplePasswordJmxAuthenticator.class.getName();
        logger = LogFactory.getLog((Class)JmxAgent.class);
        HashMap<String, String> props = new HashMap<String, String>(1);
        props.put("jmx.remote.jndi.rebind", "true");
        DEFAULT_CONNECTOR_SERVER_PROPERTIES = Collections.unmodifiableMap(props);
    }
}

