/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.mule.config.i18n.CoreMessages;
import org.mule.providers.http.HttpConstants;
import org.mule.providers.tcp.TcpConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOMessageReceiver;

public class HttpConnector
extends TcpConnector {
    public static final String HTTP_STATUS_PROPERTY = "http.status";
    public static final String HTTP_VERSION_PROPERTY = "http.version";
    public static final String HTTP_CUSTOM_HEADERS_MAP_PROPERTY = "http.custom.headers";
    public static final String HTTP_METHOD_PROPERTY = "http.method";
    public static final String HTTP_REQUEST_PROPERTY = "http.request";
    public static final String HTTP_PARAMS_PROPERTY = "http.params";
    public static final String HTTP_GET_BODY_PARAM_PROPERTY = "http.get.body.param";
    public static final String DEFAULT_HTTP_GET_BODY_PARAM_PROPERTY = "body";
    public static final String HTTP_POST_BODY_PARAM_PROPERTY = "http.post.body.param";
    public static final String HTTP_COOKIE_SPEC_PROPERTY = "cookieSpec";
    public static final String HTTP_COOKIES_PROPERTY = "cookies";
    public static final String HTTP_ENABLE_COOKIES_PROPERTY = "enableCookies";
    public static final String COOKIE_SPEC_NETSCAPE = "netscape";
    public static final String COOKIE_SPEC_RFC2109 = "rcf2109";
    private String proxyHostname = null;
    private int proxyPort = 80;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private String cookieSpec;
    private boolean enableCookies = false;
    protected HttpConnectionManager clientConnectionManager;

    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        if (this.clientConnectionManager == null) {
            this.clientConnectionManager = new MultiThreadedHttpConnectionManager();
            HttpConnectionManagerParams params = new HttpConnectionManagerParams();
            if (this.getSendBufferSize() != -1) {
                params.setSendBufferSize(this.getSendBufferSize());
            }
            if (this.getReceiveBufferSize() != -1) {
                params.setReceiveBufferSize(this.getReceiveBufferSize());
            }
            if (this.getSendTimeout() != -1) {
                params.setSoTimeout(this.getSendTimeout());
            }
            if (this.getSendSocketLinger() != -1) {
                params.setLinger(this.getSendSocketLinger());
            }
            params.setTcpNoDelay(this.isSendTcpNoDelay());
            params.setMaxTotalConnections(this.getDispatcherThreadingProfile().getMaxThreadsActive());
            params.setDefaultMaxConnectionsPerHost(this.getDispatcherThreadingProfile().getMaxThreadsActive());
            this.clientConnectionManager.setParams(params);
        }
    }

    public UMOMessageReceiver registerListener(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        Map endpointProperties;
        if (endpoint != null && (endpointProperties = endpoint.getProperties()) != null) {
            HashMap newProperties = new HashMap(endpointProperties.size());
            Iterator entries = endpointProperties.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Object key = entry.getKey();
                Object normalizedKey = HttpConstants.ALL_HEADER_NAMES.get(key);
                if (normalizedKey != null) {
                    key = normalizedKey;
                }
                newProperties.put(key, entry.getValue());
            }
            endpoint.setProperties(newProperties);
        }
        return super.registerListener(component, endpoint);
    }

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        String key = endpoint.getEndpointURI().toString();
        int i = key.indexOf(63);
        if (i > -1) {
            key = key.substring(0, i);
        }
        return key;
    }

    public String getProtocol() {
        return "http";
    }

    public String getProxyHostname() {
        return this.proxyHostname;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyHostname(String host) {
        this.proxyHostname = host;
    }

    public void setProxyPassword(String string) {
        this.proxyPassword = string;
    }

    public void setProxyPort(int port) {
        this.proxyPort = port;
    }

    public void setProxyUsername(String string) {
        this.proxyUsername = string;
    }

    public Map getReceivers() {
        return this.receivers;
    }

    public String getCookieSpec() {
        return this.cookieSpec;
    }

    public void setCookieSpec(String cookieSpec) {
        if (!COOKIE_SPEC_NETSCAPE.equalsIgnoreCase(cookieSpec) && !COOKIE_SPEC_RFC2109.equalsIgnoreCase(cookieSpec)) {
            throw new IllegalArgumentException(CoreMessages.propertyHasInvalidValue(HTTP_COOKIE_SPEC_PROPERTY, cookieSpec).toString());
        }
        this.cookieSpec = cookieSpec;
    }

    public boolean isEnableCookies() {
        return this.enableCookies;
    }

    public void setEnableCookies(boolean enableCookies) {
        this.enableCookies = enableCookies;
    }

    public HttpConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public void setClientConnectionManager(HttpConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }
}

