/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms.transformers;

import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.mule.impl.RequestContext;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsConstants;
import org.mule.providers.jms.JmsMessageUtils;
import org.mule.transaction.TransactionCoordination;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.ClassUtils;

public abstract class AbstractJmsTransformer
extends AbstractTransformer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Message transformToMessage(Object src) throws TransformerException {
        Message message;
        Session session;
        block28: {
            Message message2;
            block26: {
                UMOTransaction muleTx2;
                block27: {
                    session = null;
                    try {
                        try {
                            Message result;
                            if (src instanceof Message) {
                                result = (Message)src;
                                result.clearProperties();
                            } else {
                                session = this.getSession();
                                result = JmsMessageUtils.toMessage(src, session);
                            }
                            UMOEventContext ctx = RequestContext.getEventContext();
                            if (ctx == null) {
                                this.logger.warn((Object)"There is no current event context");
                                message2 = result;
                                Object var7_9 = null;
                                if (session == null || this.endpoint == null) break block26;
                                muleTx2 = TransactionCoordination.getInstance().getTransaction();
                                break block27;
                            }
                            this.setJmsProperties(ctx.getMessage(), result);
                            message = result;
                            break block28;
                        }
                        catch (TransformerException tex) {
                            throw tex;
                        }
                        catch (Exception e) {
                            throw new TransformerException(this, (Throwable)e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        if (session != null && this.endpoint != null) {
                            UMOTransaction muleTx2 = TransactionCoordination.getInstance().getTransaction();
                            JmsConnector connector = (JmsConnector)this.endpoint.getConnector();
                            if (muleTx2 == null) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug((Object)("Closing non-transacted jms session: " + session));
                                }
                                connector.closeQuietly(session);
                            } else if (!muleTx2.hasResource(connector.getConnection())) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug((Object)("Closing an orphaned, but transacted jms session: " + session + ", transaction: " + muleTx2));
                                }
                                connector.closeQuietly(session);
                            }
                        }
                        session = null;
                        throw throwable;
                    }
                }
                JmsConnector connector = (JmsConnector)this.endpoint.getConnector();
                if (muleTx2 == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Closing non-transacted jms session: " + session));
                    }
                    connector.closeQuietly(session);
                } else if (!muleTx2.hasResource(connector.getConnection())) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Closing an orphaned, but transacted jms session: " + session + ", transaction: " + muleTx2));
                    }
                    connector.closeQuietly(session);
                }
            }
            session = null;
            return message2;
        }
        Object var7_10 = null;
        if (session != null && this.endpoint != null) {
            UMOTransaction muleTx2 = TransactionCoordination.getInstance().getTransaction();
            JmsConnector connector = (JmsConnector)this.endpoint.getConnector();
            if (muleTx2 == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Closing non-transacted jms session: " + session));
                }
                connector.closeQuietly(session);
            } else if (!muleTx2.hasResource(connector.getConnection())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Closing an orphaned, but transacted jms session: " + session + ", transaction: " + muleTx2));
                }
                connector.closeQuietly(session);
            }
        }
        session = null;
        return message;
    }

    protected Object transformFromMessage(Message source) throws TransformerException {
        try {
            UMOConnector connector;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message type received is: " + ClassUtils.getSimpleName(source.getClass())));
            }
            String jmsSpec = "1.0.2b";
            UMOImmutableEndpoint endpoint = this.getEndpoint();
            if (endpoint != null && (connector = endpoint.getConnector()) instanceof JmsConnector) {
                jmsSpec = ((JmsConnector)connector).getSpecification();
            }
            return JmsMessageUtils.toObject(source, jmsSpec);
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    protected void setJmsProperties(UMOMessage umoMessage, Message msg) throws JMSException {
        Iterator iterator = umoMessage.getPropertyNames().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            if (JmsConstants.JMS_PROPERTY_NAMES.contains(key)) continue;
            Object value = umoMessage.getProperty(key);
            if ("MULE_CORRELATION_ID".equals(key)) {
                msg.setJMSCorrelationID(umoMessage.getCorrelationId());
            }
            if ("MULE_REPLYTO".equals(key) && value instanceof Destination) continue;
            key = JmsMessageUtils.encodeHeader(key);
            try {
                msg.setObjectProperty(key, value);
            }
            catch (JMSException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Unable to set property '" + key + "' of type " + ClassUtils.getSimpleName(value.getClass()) + "': " + e.getMessage()));
            }
        }
    }

    protected Session getSession() throws TransformerException, JMSException {
        if (this.endpoint != null) {
            return ((JmsConnector)this.endpoint.getConnector()).getSession(this.endpoint);
        }
        throw new TransformerException(this, (Throwable)new IllegalStateException("This transformer needs a valid endpoint"));
    }
}

