/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.lewys.internal;

import java.util.ArrayList;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.probe.JasmineCollectorInfo;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollectorService;
import org.ow2.jasmine.probe.collectors.lewys.internal.LewysCollector;
import org.ow2.jasmine.probe.probemanager.ProbeManager;

@Component(name="LewysCollectorService")
@Provides
public class LewysCollectorService
extends JCollectorService
implements Pojo {
    private InstanceManager __IM;
    public static final String SHORT_DESC = "Get system resource parameters using the LeWYS probe system.";
    public static final String LONG_DESC = "Resource names should be exactly those defined in LeWYS.";
    public static final String SOURCE_DESC = "No source indicator used.";
    public static final int SOURCE_MIN = 0;
    public static final int SOURCE_MAX = 0;
    public static final String PROP_CMD = "cmd";
    public static final String PROP_CMD_DESC = "lewys command. One of (disk|memory|network|cpu|kernel)";
    public static final String PROP_RESOURCES = "resources";
    public static final String PROP_RESOURCES_DESC = "Comma separated list of resource names. When space characters are used in resource names, they can be replaced by '_'";
    private boolean __FosType;
    protected int osType;
    public static final int LINUX_2_4 = 10;
    public static final int LINUX_2_6 = 11;
    public static final int WINDOWS = 20;
    public static final int MAC_OS_X = 30;
    private boolean __FindicatorType;
    @ServiceProperty(name="indicator.type", value="lewys")
    private String indicatorType;
    private boolean __FprobeManager;
    @Requires
    ProbeManager probeManager;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe;

    int __getosType() {
        if (!this.__FosType) {
            return this.osType;
        }
        Object object = this.__IM.onGet((Object)this, "osType");
        Integer n = (Integer)object;
        return n;
    }

    void __setosType(int n) {
        if (!this.__FosType) {
            this.osType = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "osType", (Object)n2);
    }

    String __getindicatorType() {
        if (!this.__FindicatorType) {
            return this.indicatorType;
        }
        return (String)this.__IM.onGet((Object)this, "indicatorType");
    }

    void __setindicatorType(String string) {
        if (!this.__FindicatorType) {
            this.indicatorType = string;
            return;
        }
        this.__IM.onSet((Object)this, "indicatorType", (Object)string);
    }

    ProbeManager __getprobeManager() {
        if (!this.__FprobeManager) {
            return this.probeManager;
        }
        return (ProbeManager)this.__IM.onGet((Object)this, "probeManager");
    }

    void __setprobeManager(ProbeManager probeManager) {
        if (!this.__FprobeManager) {
            this.probeManager = probeManager;
            return;
        }
        this.__IM.onSet((Object)this, "probeManager", (Object)probeManager);
    }

    public LewysCollectorService() {
        this(null);
    }

    private LewysCollectorService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setprobeManager(null);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        this.collectorInfo = new JasmineCollectorInfo();
        this.collectorInfo.setType(this.__getindicatorType());
        this.collectorInfo.setShortDesc(SHORT_DESC);
        this.collectorInfo.setLongDesc(LONG_DESC);
        this.collectorInfo.setSourceDesc(SOURCE_DESC);
        this.collectorInfo.setSourceMin(0);
        this.collectorInfo.setSourceMax(0);
        this.properties = new ArrayList();
        this.properties.add(new JasminePropertyInfo(PROP_CMD, PROP_CMD_DESC, true));
        this.properties.add(new JasminePropertyInfo(PROP_RESOURCES, PROP_RESOURCES_DESC, false));
        this.collectorInfo.setPropertyInfos(this.properties);
        if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
            if (System.getProperty("os.version").startsWith("2.6")) {
                this.__setosType(11);
            } else {
                this.__setosType(10);
            }
        } else if (System.getProperty("os.name").startsWith("Windows")) {
            this.__setosType(20);
        } else if (System.getProperty("os.name").equals("Mac OS X")) {
            this.__setosType(30);
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() {
        this.removeCollectors(null, null);
    }

    public synchronized JasmineCollector getCollector(JasmineIndicator jasmineIndicator, JasmineProbe jasmineProbe) throws JasmineCollectorException {
        JasmineCollector jasmineCollector;
        if (!this.__MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe) {
            return this.__getCollector(jasmineIndicator, jasmineProbe);
        }
        try {
            this.__IM.onEntry((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe", new Object[]{jasmineIndicator, jasmineProbe});
            jasmineCollector = this.__getCollector(jasmineIndicator, jasmineProbe);
            this.__IM.onExit((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe", (Object)jasmineCollector);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe", throwable);
            throw throwable;
        }
        return jasmineCollector;
    }

    private JasmineCollector __getCollector(JasmineIndicator indicator, JasmineProbe probe) throws JasmineCollectorException {
        LewysCollector collector = new LewysCollector(probe.getId(), indicator, probe.getPeriod(), this.__getosType());
        collector.setProbeManager(this.__getprobeManager());
        this.addCollector(indicator.getName(), collector);
        return collector;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("probeManager")) {
                this.__FprobeManager = true;
            }
            if (set.contains("indicatorType")) {
                this.__FindicatorType = true;
            }
            if (set.contains("osType")) {
                this.__FosType = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe")) {
                this.__MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

