/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleBooleanResult;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleObjectNameResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.JasmineSingleStringResult;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.collectors.jmx.Metric;
import org.ow2.jasmine.probe.collectors.jmx.internal.ComplexValuesException;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxUtil;
import org.ow2.jasmine.probe.util.CsvConverter;

public class JmxCollector
extends JCollector {
    private String pattern;
    private ObjectName objname = null;
    private Collection<String> attrlist;
    private List<Metric> metrics = null;
    private JasmineIndicatorValue cached = null;
    private int nbUsers = 1;
    private int nbUsed = 0;
    private boolean stopped = false;

    public JmxCollector(String probeId, JasmineIndicator indicator, int period, String mbean, String csv) {
        super(probeId, indicator, period);
        this.pattern = mbean;
        this.attrlist = CsvConverter.csv2list((String)csv);
    }

    public Collection<String> getAttrlist() {
        return this.attrlist;
    }

    public ObjectName getObjectName() throws JasmineCollectorException {
        if (this.objname == null) {
            try {
                this.objname = ObjectName.getInstance(this.pattern);
            }
            catch (MalformedObjectNameException e) {
                throw new JasmineCollectorException("Malformed pattern: " + this.pattern + " (" + e.toString() + " )");
            }
            catch (NullPointerException e) {
                throw new JasmineCollectorException("Null pattern");
            }
        }
        return this.objname;
    }

    protected boolean hasAttributes() {
        if (this.attrlist == null || this.attrlist.isEmpty()) {
            return false;
        }
        if (this.attrlist.size() == 1) {
            for (String elem : this.attrlist) {
                if (!"all".equals(elem)) continue;
                return false;
            }
        }
        return true;
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        this.logger.debug((Object)"Nb users = {0}", new Object[]{this.nbUsers});
        if (this.nbUsers == 1) {
            JasmineIndicatorValue jiv = this.getJiv();
            this.metrics = null;
            return jiv;
        }
        if (this.nbUsed == 0) {
            this.cached = this.getJiv();
        }
        ++this.nbUsed;
        if (this.nbUsed == this.nbUsers) {
            this.logger.debug((Object)"Last cached result is returned because nbUsed = {0}", new Object[]{this.nbUsed});
            this.metrics = null;
            this.nbUsed = 0;
        }
        this.logger.debug((Object)"Returned cached result", new Object[0]);
        return this.cached;
    }

    private JasmineIndicatorValue getJiv() throws JasmineCollectorException {
        String name = this.getIndicatorName();
        if (this.metrics == null) {
            this.logger.warn((Object)"Cannot return value for indicator {0} (no available metrics)", new Object[]{name});
            return null;
        }
        this.logger.debug((Object)"Get indicator value for indicator {0} in probe {1}", new Object[]{name, this.probeId});
        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        jiv.setName(name);
        for (Metric metric : this.metrics) {
            if (metric.getAttributeList().size() == 0) {
                this.logger.warn((Object)("Result with no value: " + metric.toString()), new Object[0]);
                continue;
            }
            jiv.setMultiValue(metric.isMultiValue());
            Map<String, String> props = metric.getProperties();
            if (!props.isEmpty()) {
                for (String propKey : props.keySet()) {
                    String propVal = props.get(propKey);
                    jiv.addMetadata(propKey, propVal);
                }
            }
            for (Attribute att : metric.getAttributeList()) {
                if (att.getValue() == null) {
                    this.logger.warn((Object)("No value for " + att.getName() + " in indicator: " + this.getIndicatorName() + " in probe: " + this.probeId), new Object[0]);
                    continue;
                }
                try {
                    List<Attribute> decomposedList = JmxUtil.getAttributeFragments(att);
                    for (Attribute dAtt : decomposedList) {
                        JasmineSingleResult jsr = this.getJsr(dAtt, metric.getTimestamp(), this.indicator.getScale());
                        if (jsr == null) continue;
                        jsr.addProperty("mbean", metric.getMBean().toString());
                        jiv.addValue(jsr);
                    }
                }
                catch (ComplexValuesException e) {
                    e.printStackTrace();
                }
            }
        }
        jiv.setTarget(this.metrics.get(0).getTarget());
        String key = "server";
        jiv.addMetadata(key, this.metrics.get(0).getProperties().get(key));
        key = "domain";
        jiv.addMetadata(key, this.metrics.get(0).getProperties().get(key));
        key = "url";
        jiv.addMetadata(key, this.metrics.get(0).getProperties().get(key));
        return jiv;
    }

    private JasmineSingleResult getJsr(Attribute att, long timestamp, int scale) throws JasmineCollectorException {
        JasmineSingleStringResult jsr = null;
        Object value = att.getValue();
        if (value instanceof String) {
            String s = (String)value;
            jsr = new JasmineSingleStringResult();
            jsr.setValue((Object)s);
        } else if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            jsr = new JasmineSingleBooleanResult();
            jsr.setValue((Object)b);
        } else if (value instanceof ObjectName) {
            ObjectName on = (ObjectName)value;
            jsr = new JasmineSingleObjectNameResult();
            jsr.setValue((Object)on);
        } else {
            try {
                Number numberValue = (Number)value;
                jsr = new JasmineSingleNumberResult();
                if (scale != 1) {
                    numberValue = this.divideValues(numberValue, scale);
                }
                jsr.setValue((Object)numberValue);
            }
            catch (ClassCastException cce) {
                this.logger.warn((Object)("Attribute " + att.getName() + " is not a number, nor a String. Currently no result (JasmineSingleResult) returned for it !"), new Object[0]);
                return null;
            }
        }
        jsr.setName(att.getName());
        jsr.setTimestamp(timestamp);
        return jsr;
    }

    public void stopPolling() {
        this.logger.debug((Object)("Stop " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
        this.stopped = true;
    }

    public void startPolling() {
        this.logger.debug((Object)("Start " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
        this.stopped = false;
    }

    public boolean needResult() {
        if (this.stopped) {
            this.logger.debug((Object)("STOPPED, need no result for " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
            return false;
        }
        if (this.metrics == null) {
            return true;
        }
        long timestamp = this.metrics.get(0).getTimestamp();
        return this.oldvalue(timestamp);
    }

    public void addResult(List<Metric> metrics) {
        if (metrics.size() == 0) {
            this.logger.debug((Object)"Empty metric list", new Object[0]);
            return;
        }
        this.logger.debug((Object)"", new Object[0]);
        this.metrics = metrics;
    }

    private boolean oldvalue(long timestamp) {
        long now = System.currentTimeMillis();
        return now - timestamp > (long)(this.period * 1000);
    }
}

