/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.constant;

import java.util.Map;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;

public class ConstantCollector
extends JCollector {
    private String type;
    private String value;
    private Number number;

    public ConstantCollector(String probeId, JasmineIndicator indicator, int period) {
        super(probeId, indicator, period);
        Map props = indicator.getProperties();
        this.type = (String)props.get("type");
        this.value = (String)props.get("value");
        if (this.type.equalsIgnoreCase("int")) {
            this.number = Integer.parseInt(this.value);
        } else if (this.type.equalsIgnoreCase("long")) {
            this.number = Long.parseLong(this.value);
        } else if (this.type.equalsIgnoreCase("float")) {
            this.number = Float.valueOf(this.value);
        } else if (this.type.equalsIgnoreCase("double")) {
            this.number = Double.valueOf(this.value);
        }
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        this.logger.debug((Object)"", new Object[0]);
        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        JasmineSingleNumberResult jsr = new JasmineSingleNumberResult();
        jsr.setName(this.value);
        jsr.setTimestamp(System.currentTimeMillis());
        jsr.setValue((Object)this.number);
        jiv.setName(this.indicator.getName());
        jiv.addValue((JasmineSingleResult)jsr);
        jiv.setMultiValue(false);
        return jiv;
    }

    public void stopPolling() {
        this.logger.debug((Object)"Stop polling", new Object[0]);
    }

    public void startPolling() {
        this.logger.debug((Object)"Start polling", new Object[0]);
    }
}

