/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.rest.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.api.generated.JsrType;
import org.ow2.jasmine.probe.api.generated.TaskType;
import org.ow2.jasmine.probe.rest.DataTasks;
import org.ow2.jasmine.probe.rest.TasksManager;
import org.ow2.jasmine.probe.rest.impl.JTask;
import org.ow2.jasmine.probe.rest.impl.RestUtil;

public class JDataTasks
implements DataTasks {
    private TasksManager taskManager = null;

    public JDataTasks(TasksManager taskManager) {
        this.taskManager = taskManager;
    }

    @Override
    public Response getData(String id) {
        JTask task = (JTask)this.taskManager.getTask(id);
        if (task != null) {
            List<JAXBElement<JsrType>> elementsList = task.getLastResult();
            if (elementsList == null) {
                String mess = "Unavailable data for " + id;
                return RestUtil.errorResponse(new JasmineProbeException(mess), Response.Status.NOT_FOUND);
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new GenericEntity<List<JAXBElement<JsrType>>>(elementsList){}).type(MediaType.APPLICATION_XML_TYPE).build();
        }
        String mess = "Unknown task " + id;
        return RestUtil.errorResponse(new JasmineProbeException(mess), Response.Status.NOT_FOUND);
    }

    @Override
    public Response getDataTasks(UriInfo ui) {
        ArrayList<JAXBElement> elementsList = new ArrayList<JAXBElement>();
        for (String taskId : this.taskManager.getTasks()) {
            TaskType taskElement = new TaskType();
            taskElement.setId(taskId);
            URI taskUri = ui.getAbsolutePathBuilder().path(taskId).build(new Object[0]);
            taskElement.setHref(taskUri.toString());
            QName name = new QName("org.ow2.jasmine.probe:probe-config", "data");
            JAXBElement xmlElement = new JAXBElement(name, TaskType.class, (Object)taskElement);
            elementsList.add(xmlElement);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new GenericEntity<List<JAXBElement<TaskType>>>(elementsList){}).type(MediaType.APPLICATION_XML_TYPE).build();
    }
}

