/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.rest.impl;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.ow2.jasmine.probe.JasmineCollectorInfo;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.api.generated.CollectorInfoType;
import org.ow2.jasmine.probe.api.generated.PropInfoType;
import org.ow2.jasmine.probe.api.generated.ResourceType;
import org.ow2.jasmine.probe.rest.IndicatorTypes;

public class JIndicatorTypes
implements IndicatorTypes {
    private JasmineProbeManager jpManager = null;

    public JIndicatorTypes(JasmineProbeManager jpManager) {
        this.jpManager = jpManager;
    }

    @Override
    public Response getIndicatorTypes() {
        ArrayList<JAXBElement> elementsList = new ArrayList<JAXBElement>();
        for (String type : this.jpManager.getIndicatorTypes()) {
            ResourceType typeElement = new ResourceType();
            typeElement.setType(type);
            QName qname = new QName("org.ow2.jasmine.probe:probe-config", "indicatorType");
            JAXBElement xmlElement = new JAXBElement(qname, ResourceType.class, (Object)typeElement);
            elementsList.add(xmlElement);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new GenericEntity<List<JAXBElement<ResourceType>>>(elementsList){}).type(MediaType.APPLICATION_XML_TYPE).build();
    }

    @Override
    public Response getIndicatorTypeProps(String type) {
        ArrayList<JAXBElement> elementsList = new ArrayList<JAXBElement>();
        JasmineCollectorInfo info = this.jpManager.getIndicatorTypeInfo(type);
        List propertyInfos = info.getPropertyInfos();
        for (JasminePropertyInfo propertyInfo : propertyInfos) {
            PropInfoType propInfoElement = new PropInfoType();
            if (propertyInfo.isRequired()) {
                propInfoElement.setRequired("true");
            } else {
                propInfoElement.setRequired("false");
            }
            propInfoElement.setDescription(propertyInfo.getDescription());
            propInfoElement.setName(propertyInfo.getName());
            QName qname = new QName("org.ow2.jasmine.probe:probe-config", "indicatorProperty");
            JAXBElement xmlElement = new JAXBElement(qname, PropInfoType.class, (Object)propInfoElement);
            elementsList.add(xmlElement);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new GenericEntity<List<JAXBElement<PropInfoType>>>(elementsList){}).type(MediaType.APPLICATION_XML_TYPE).build();
    }

    @Override
    public Response getIndicatorTypeInfo(String type) {
        CollectorInfoType infoElement = new CollectorInfoType();
        JasmineCollectorInfo info = this.jpManager.getIndicatorTypeInfo(type);
        infoElement.setShortDesc(info.getShortDesc());
        infoElement.setLongDesc(info.getLongDesc());
        infoElement.setSourceDesc(info.getSourceDesc());
        int sMin = info.getSourceMin();
        int sMax = info.getSourceMax();
        if (sMin > 0) {
            if (sMin == sMax) {
                if (sMin == 1) {
                    infoElement.setSourcesNumber(sMin + " source is required");
                } else {
                    infoElement.setSourcesNumber(sMin + " sources are required");
                }
            } else {
                infoElement.setSourcesNumber("Minimum " + sMin + " sources required");
            }
        }
        QName name = new QName("org.ow2.jasmine.probe:probe-config", "indicatorInfo");
        JAXBElement xmlElement = new JAXBElement(name, CollectorInfoType.class, (Object)infoElement);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)xmlElement).type(MediaType.APPLICATION_XML_TYPE).build();
    }
}

