/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.rest.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.ObjectName;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineSingleBooleanResult;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleObjectNameResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.JasmineSingleStringResult;
import org.ow2.jasmine.probe.api.generated.JsrType;
import org.ow2.jasmine.probe.api.generated.PropType;
import org.ow2.jasmine.probe.api.generated.TypeNameType;
import org.ow2.jasmine.probe.api.generated.ValueType;
import org.ow2.jasmine.probe.rest.Task;
import org.ow2.jasmine.probe.rest.Tasks;

public class JTask
implements Task {
    private String probeId = null;
    private String taskId = null;
    private JasmineProbeResult lastResult = null;

    public JTask(String probeId, String taskId) {
        this.probeId = probeId;
        this.taskId = taskId;
    }

    protected List<JAXBElement<JsrType>> getLastResult() {
        if (this.lastResult == null) {
            return null;
        }
        ArrayList<JAXBElement<JsrType>> elementsList = new ArrayList<JAXBElement<JsrType>>();
        for (JasmineIndicatorValue jiv : this.lastResult.getValues()) {
            ArrayList<PropType> metaList = new ArrayList<PropType>();
            HashMap indicMeta = jiv.getMetadata();
            for (String key : indicMeta.keySet()) {
                String val = (String)indicMeta.get(key);
                PropType prop = new PropType();
                prop.setKey(key);
                prop.setValue(val);
                metaList.add(prop);
            }
            for (JasmineSingleResult jsr : jiv.getValues()) {
                JsrType jsrElement = new JsrType();
                String name = this.composeName(jiv, jsr.getName());
                jsrElement.setName(name);
                jsrElement.setTimestamp(jsr.getTimestamp());
                HashMap resProps = jsr.getProperties();
                ArrayList<PropType> propList = new ArrayList<PropType>(metaList);
                for (String key : resProps.keySet()) {
                    String val = (String)resProps.get(key);
                    PropType prop = new PropType();
                    prop.setKey(key);
                    prop.setValue(val);
                    propList.add(prop);
                }
                jsrElement.setProperty(propList);
                ValueType value = new ValueType();
                TypeNameType type = this.getValueAndType(jsr, value);
                jsrElement.setType(type);
                jsrElement.setValue(value);
                QName elementName = new QName("org.ow2.jasmine.probe:probe-config", "data");
                JAXBElement xmlElement = new JAXBElement(elementName, JsrType.class, (Object)jsrElement);
                elementsList.add((JAXBElement<JsrType>)xmlElement);
            }
        }
        return elementsList;
    }

    @Override
    public void setLastResult(JasmineProbeResult result) {
        Tasks.logger.debug((Object)"Last result for probe {0} set into task {1}", new Object[]{this.probeId, this.taskId});
        this.lastResult = result;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    private TypeNameType getValueAndType(JasmineSingleResult jsr, ValueType value) {
        if (jsr instanceof JasmineSingleNumberResult) {
            JasmineSingleNumberResult numberRes = (JasmineSingleNumberResult)jsr;
            Number numvalue = numberRes.getValue();
            try {
                Integer intvalue = (Integer)numvalue;
                value.setIntvalue(Integer.valueOf(intvalue));
                return TypeNameType.INT;
            }
            catch (ClassCastException e) {
                try {
                    Short shortvalue = (Short)numvalue;
                    value.setShortvalue(Short.valueOf(shortvalue));
                    return TypeNameType.SHORT;
                }
                catch (ClassCastException e2) {
                    try {
                        Long longvalue = (Long)numvalue;
                        value.setLongvalue(Long.valueOf(longvalue));
                        return TypeNameType.LONG;
                    }
                    catch (ClassCastException e3) {
                        try {
                            Float floatvalue = (Float)numvalue;
                            value.setFloatvalue(Float.valueOf(floatvalue.floatValue()));
                            return TypeNameType.FLOAT;
                        }
                        catch (ClassCastException e4) {
                            try {
                                Double doublevalue = (Double)numvalue;
                                value.setDoublevalue(Double.valueOf(doublevalue));
                                return TypeNameType.DOUBLE;
                            }
                            catch (ClassCastException e5) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        if (jsr instanceof JasmineSingleBooleanResult) {
            JasmineSingleBooleanResult booleanRes = (JasmineSingleBooleanResult)jsr;
            Boolean booleanvalue = (Boolean)booleanRes.getValue();
            value.setBooleanvalue(booleanvalue);
            return TypeNameType.BOOLEAN;
        }
        if (jsr instanceof JasmineSingleStringResult) {
            JasmineSingleStringResult stringRes = (JasmineSingleStringResult)jsr;
            String stringvalue = stringRes.getValue();
            value.setStringvalue(stringvalue);
            return TypeNameType.STRING;
        }
        if (jsr instanceof JasmineSingleObjectNameResult) {
            JasmineSingleObjectNameResult onRes = (JasmineSingleObjectNameResult)jsr;
            ObjectName onvalue = (ObjectName)onRes.getValue();
            value.setStringvalue(onvalue.toString());
            return TypeNameType.OBJECT_NAME;
        }
        value = null;
        return TypeNameType.UNKNOWN;
    }

    public String composeName(JasmineIndicatorValue jiv, String jsrName) {
        StringBuffer name = new StringBuffer(jiv.getName());
        if (jiv.isMultiValue() && jsrName != null && jsrName.length() != 0) {
            name.append(".");
            name.append(jsrName);
        }
        return name.toString();
    }
}

