/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.servlet.MultipartConfigElement;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationJspPropertyGroupDescriptor;
import org.apache.catalina.core.ApplicationTaglibDescriptor;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextHandler;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceEnvRef;
import org.apache.catalina.deploy.ContextService;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.InjectionTarget;
import org.apache.catalina.deploy.JspPropertyGroup;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.MessageDestination;
import org.apache.catalina.deploy.MessageDestinationRef;
import org.apache.catalina.deploy.MultipartDef;
import org.apache.catalina.deploy.ResourceBase;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.deploy.SecurityRoleRef;
import org.apache.catalina.deploy.ServletDef;
import org.apache.catalina.deploy.SessionConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class WebXml {
    protected static final String ORDER_OTHERS = "org.apache.catalina.order.others";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.deploy");
    private static final Log log = LogFactory.getLog(WebXml.class);
    private boolean overridable = false;
    private Set<String> absoluteOrdering = null;
    private Set<String> after = new LinkedHashSet<String>();
    private Set<String> before = new LinkedHashSet<String>();
    private String publicId = null;
    private boolean metadataComplete = false;
    private String name = null;
    private int majorVersion = 3;
    private int minorVersion = 0;
    private String displayName = null;
    private boolean distributable = false;
    private Map<String, String> contextParams = new HashMap<String, String>();
    private Map<String, FilterDef> filters = new LinkedHashMap<String, FilterDef>();
    private Set<FilterMap> filterMaps = new LinkedHashSet<FilterMap>();
    private Set<String> filterMappingNames = new HashSet<String>();
    private Set<String> listeners = new LinkedHashSet<String>();
    private Map<String, ServletDef> servlets = new HashMap<String, ServletDef>();
    private Map<String, String> servletMappings = new HashMap<String, String>();
    private Set<String> servletMappingNames = new HashSet<String>();
    private SessionConfig sessionConfig = new SessionConfig();
    private Map<String, String> mimeMappings = new HashMap<String, String>();
    private boolean replaceWelcomeFiles = false;
    private boolean alwaysAddWelcomeFiles = true;
    private Set<String> welcomeFiles = new LinkedHashSet<String>();
    private Map<String, ErrorPage> errorPages = new HashMap<String, ErrorPage>();
    private Map<String, String> taglibs = new HashMap<String, String>();
    private Set<JspPropertyGroup> jspPropertyGroups = new LinkedHashSet<JspPropertyGroup>();
    private Set<SecurityConstraint> securityConstraints = new HashSet<SecurityConstraint>();
    private LoginConfig loginConfig = null;
    private Set<String> securityRoles = new HashSet<String>();
    private Map<String, ContextEnvironment> envEntries = new HashMap<String, ContextEnvironment>();
    private Map<String, ContextEjb> ejbRefs = new HashMap<String, ContextEjb>();
    private Map<String, ContextLocalEjb> ejbLocalRefs = new HashMap<String, ContextLocalEjb>();
    private Map<String, ContextService> serviceRefs = new HashMap<String, ContextService>();
    private Map<String, ContextResource> resourceRefs = new HashMap<String, ContextResource>();
    private Map<String, ContextResourceEnvRef> resourceEnvRefs = new HashMap<String, ContextResourceEnvRef>();
    private Map<String, MessageDestinationRef> messageDestinationRefs = new HashMap<String, MessageDestinationRef>();
    private Map<String, MessageDestination> messageDestinations = new HashMap<String, MessageDestination>();
    private Map<String, String> localeEncodingMappings = new HashMap<String, String>();
    private URL uRL = null;
    private static final String INDENT2 = "  ";
    private static final String INDENT4 = "    ";
    private static final String INDENT6 = "      ";

    public boolean isOverridable() {
        return this.overridable;
    }

    public void setOverridable(boolean overridable) {
        this.overridable = overridable;
    }

    public void addAbsoluteOrdering(String fragmentName) {
        if (this.absoluteOrdering == null) {
            this.absoluteOrdering = new LinkedHashSet<String>();
        }
        this.absoluteOrdering.add(fragmentName);
    }

    public void addAbsoluteOrderingOthers() {
        if (this.absoluteOrdering == null) {
            this.absoluteOrdering = new LinkedHashSet<String>();
        }
        this.absoluteOrdering.add(ORDER_OTHERS);
    }

    public Set<String> getAbsoluteOrdering() {
        return this.absoluteOrdering;
    }

    public void addAfterOrdering(String fragmentName) {
        this.after.add(fragmentName);
    }

    public void addAfterOrderingOthers() {
        if (this.before.contains(ORDER_OTHERS)) {
            throw new IllegalArgumentException(sm.getString("webXml.multipleOther"));
        }
        this.after.add(ORDER_OTHERS);
    }

    public Set<String> getAfterOrdering() {
        return this.after;
    }

    public void addBeforeOrdering(String fragmentName) {
        this.before.add(fragmentName);
    }

    public void addBeforeOrderingOthers() {
        if (this.after.contains(ORDER_OTHERS)) {
            throw new IllegalArgumentException(sm.getString("webXml.multipleOther"));
        }
        this.before.add(ORDER_OTHERS);
    }

    public Set<String> getBeforeOrdering() {
        return this.before;
    }

    public String getVersion() {
        StringBuilder sb = new StringBuilder(3);
        sb.append(this.majorVersion);
        sb.append('.');
        sb.append(this.minorVersion);
        return sb.toString();
    }

    public void setVersion(String version) {
        if (version == null) {
            return;
        }
        String major = null;
        String minor = null;
        int split = version.indexOf(46);
        if (split < 0) {
            major = version;
        } else {
            major = version.substring(0, split);
            minor = version.substring(split + 1);
        }
        if (major == null || major.length() == 0) {
            this.majorVersion = 0;
        } else {
            try {
                this.majorVersion = Integer.parseInt(major);
            }
            catch (NumberFormatException nfe) {
                log.warn(sm.getString("webXml.version.nfe", major, version), nfe);
                this.majorVersion = 0;
            }
        }
        if (minor == null || minor.length() == 0) {
            this.minorVersion = 0;
        } else {
            try {
                this.minorVersion = Integer.parseInt(minor);
            }
            catch (NumberFormatException nfe) {
                log.warn(sm.getString("webXml.version.nfe", minor, version), nfe);
                this.minorVersion = 0;
            }
        }
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        if (publicId != null) {
            if ("web-app_3_0.xsd".equalsIgnoreCase(publicId) || "web-fragment_3_0.xsd".equalsIgnoreCase(publicId)) {
                this.majorVersion = 3;
                this.minorVersion = 0;
                this.publicId = publicId;
            } else if ("web-app_2_5.xsd".equalsIgnoreCase(publicId)) {
                this.majorVersion = 2;
                this.minorVersion = 5;
                this.publicId = publicId;
            } else if ("web-app_2_4.xsd".equalsIgnoreCase(publicId)) {
                this.majorVersion = 2;
                this.minorVersion = 4;
                this.publicId = publicId;
            } else if ("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN".equalsIgnoreCase(publicId)) {
                this.majorVersion = 2;
                this.minorVersion = 3;
                this.publicId = publicId;
            } else if ("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN".equalsIgnoreCase(publicId)) {
                this.majorVersion = 2;
                this.minorVersion = 2;
                this.publicId = publicId;
            } else if (!"datatypes".equals(publicId)) {
                log.warn(sm.getString("webxml.unrecognisedPublicId", publicId));
            }
        }
    }

    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    public void setMetadataComplete(boolean metadataComplete) {
        this.metadataComplete = metadataComplete;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (ORDER_OTHERS.equalsIgnoreCase(name)) {
            log.warn(sm.getString("webXml.reservedName", name));
        } else {
            this.name = name;
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isDistributable() {
        return this.distributable;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    public void addContextParam(String param, String value) {
        this.contextParams.put(param, value);
    }

    public Map<String, String> getContextParams() {
        return this.contextParams;
    }

    public void addFilter(FilterDef filter) {
        if (this.filters.containsKey(filter.getFilterName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateFilter", filter.getFilterName()));
        }
        this.filters.put(filter.getFilterName(), filter);
    }

    public Map<String, FilterDef> getFilters() {
        return this.filters;
    }

    public void addFilterMapping(FilterMap filterMap) {
        this.filterMaps.add(filterMap);
        this.filterMappingNames.add(filterMap.getFilterName());
    }

    public Set<FilterMap> getFilterMappings() {
        return this.filterMaps;
    }

    public void addListener(String className) {
        this.listeners.add(className);
    }

    public Set<String> getListeners() {
        return this.listeners;
    }

    public void addServlet(ServletDef servletDef) {
        this.servlets.put(servletDef.getServletName(), servletDef);
        if (this.overridable) {
            servletDef.setOverridable(this.overridable);
        }
    }

    public Map<String, ServletDef> getServlets() {
        return this.servlets;
    }

    public void addServletMapping(String urlPattern, String servletName) {
        this.servletMappings.put(urlPattern, servletName);
        this.servletMappingNames.add(servletName);
    }

    public Map<String, String> getServletMappings() {
        return this.servletMappings;
    }

    public void setSessionConfig(SessionConfig sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public void addMimeMapping(String extension, String mimeType) {
        this.mimeMappings.put(extension, mimeType);
    }

    public Map<String, String> getMimeMappings() {
        return this.mimeMappings;
    }

    public void setReplaceWelcomeFiles(boolean replaceWelcomeFiles) {
        this.replaceWelcomeFiles = replaceWelcomeFiles;
    }

    public void setAlwaysAddWelcomeFiles(boolean alwaysAddWelcomeFiles) {
        this.alwaysAddWelcomeFiles = alwaysAddWelcomeFiles;
    }

    public void addWelcomeFile(String welcomeFile) {
        if (this.replaceWelcomeFiles) {
            this.welcomeFiles.clear();
            this.replaceWelcomeFiles = false;
        }
        this.welcomeFiles.add(welcomeFile);
    }

    public Set<String> getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public void addErrorPage(ErrorPage errorPage) {
        this.errorPages.put(errorPage.getName(), errorPage);
    }

    public Map<String, ErrorPage> getErrorPages() {
        return this.errorPages;
    }

    public void addTaglib(String uri, String location) {
        if (this.taglibs.containsKey(uri)) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateTaglibUri", uri));
        }
        this.taglibs.put(uri, location);
    }

    public Map<String, String> getTaglibs() {
        return this.taglibs;
    }

    public void addJspPropertyGroup(JspPropertyGroup propertyGroup) {
        this.jspPropertyGroups.add(propertyGroup);
    }

    public Set<JspPropertyGroup> getJspPropertyGroups() {
        return this.jspPropertyGroups;
    }

    public void addSecurityConstraint(SecurityConstraint securityConstraint) {
        this.securityConstraints.add(securityConstraint);
    }

    public Set<SecurityConstraint> getSecurityConstraints() {
        return this.securityConstraints;
    }

    public void setLoginConfig(LoginConfig loginConfig) {
        this.loginConfig = loginConfig;
    }

    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public void addSecurityRole(String securityRole) {
        this.securityRoles.add(securityRole);
    }

    public Set<String> getSecurityRoles() {
        return this.securityRoles;
    }

    public void addEnvEntry(ContextEnvironment envEntry) {
        if (this.envEntries.containsKey(envEntry.getName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateEnvEntry", envEntry.getName()));
        }
        this.envEntries.put(envEntry.getName(), envEntry);
    }

    public Map<String, ContextEnvironment> getEnvEntries() {
        return this.envEntries;
    }

    public void addEjbRef(ContextEjb ejbRef) {
        this.ejbRefs.put(ejbRef.getName(), ejbRef);
    }

    public Map<String, ContextEjb> getEjbRefs() {
        return this.ejbRefs;
    }

    public void addEjbLocalRef(ContextLocalEjb ejbLocalRef) {
        this.ejbLocalRefs.put(ejbLocalRef.getName(), ejbLocalRef);
    }

    public Map<String, ContextLocalEjb> getEjbLocalRefs() {
        return this.ejbLocalRefs;
    }

    public void addServiceRef(ContextService serviceRef) {
        this.serviceRefs.put(serviceRef.getName(), serviceRef);
    }

    public Map<String, ContextService> getServiceRefs() {
        return this.serviceRefs;
    }

    public void addResourceRef(ContextResource resourceRef) {
        if (this.resourceRefs.containsKey(resourceRef.getName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateResourceRef", resourceRef.getName()));
        }
        this.resourceRefs.put(resourceRef.getName(), resourceRef);
    }

    public Map<String, ContextResource> getResourceRefs() {
        return this.resourceRefs;
    }

    public void addResourceEnvRef(ContextResourceEnvRef resourceEnvRef) {
        if (this.resourceEnvRefs.containsKey(resourceEnvRef.getName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateResourceEnvRef", resourceEnvRef.getName()));
        }
        this.resourceEnvRefs.put(resourceEnvRef.getName(), resourceEnvRef);
    }

    public Map<String, ContextResourceEnvRef> getResourceEnvRefs() {
        return this.resourceEnvRefs;
    }

    public void addMessageDestinationRef(MessageDestinationRef messageDestinationRef) {
        if (this.messageDestinationRefs.containsKey(messageDestinationRef.getName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateMessageDestinationRef", messageDestinationRef.getName()));
        }
        this.messageDestinationRefs.put(messageDestinationRef.getName(), messageDestinationRef);
    }

    public Map<String, MessageDestinationRef> getMessageDestinationRefs() {
        return this.messageDestinationRefs;
    }

    public void addMessageDestination(MessageDestination messageDestination) {
        if (this.messageDestinations.containsKey(messageDestination.getName())) {
            throw new IllegalArgumentException(sm.getString("webXml.duplicateMessageDestination", messageDestination.getName()));
        }
        this.messageDestinations.put(messageDestination.getName(), messageDestination);
    }

    public Map<String, MessageDestination> getMessageDestinations() {
        return this.messageDestinations;
    }

    public void addLocaleEncodingMapping(String locale, String encoding) {
        this.localeEncodingMappings.put(locale, encoding);
    }

    public Map<String, String> getLocalEncodingMappings() {
        return this.localeEncodingMappings;
    }

    public void setURL(URL url) {
        this.uRL = url;
    }

    public URL getURL() {
        return this.uRL;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32);
        buf.append("Name: ");
        buf.append(this.getName());
        buf.append(", URL: ");
        buf.append(this.getURL());
        return buf.toString();
    }

    public String toXml() {
        StringBuilder sb = new StringBuilder(2048);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<web-app xmlns=\"http://java.sun.com/xml/ns/javaee\"\n");
        sb.append("         xmlns:xsi=");
        sb.append("\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        sb.append("         xsi:schemaLocation=");
        sb.append("\"http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd\"\n");
        sb.append("         version=\"");
        sb.append(this.getVersion());
        sb.append("\"\n");
        sb.append("         metadata-complete=\"true\">\n\n");
        WebXml.appendElement(sb, INDENT2, "display-name", this.displayName);
        if (this.isDistributable()) {
            sb.append("  <distributable/>\n\n");
        }
        for (Map.Entry<String, String> entry : this.contextParams.entrySet()) {
            sb.append("  <context-param>\n");
            WebXml.appendElement(sb, INDENT4, "param-name", entry.getKey());
            WebXml.appendElement(sb, INDENT4, "param-valuee", entry.getValue());
            sb.append("  </context-param>\n");
        }
        sb.append('\n');
        for (Map.Entry<String, Object> entry : this.filters.entrySet()) {
            FilterDef filterDef = (FilterDef)entry.getValue();
            sb.append("  <filter>\n");
            WebXml.appendElement(sb, INDENT4, "description", filterDef.getDescription());
            WebXml.appendElement(sb, INDENT4, "display-name", filterDef.getDisplayName());
            WebXml.appendElement(sb, INDENT4, "filter-name", filterDef.getFilterName());
            WebXml.appendElement(sb, INDENT4, "filter-class", filterDef.getFilterClass());
            WebXml.appendElement(sb, INDENT4, "async-supported", filterDef.getAsyncSupported());
            for (Map.Entry<String, String> param : filterDef.getParameterMap().entrySet()) {
                sb.append("    <init-param>\n");
                WebXml.appendElement(sb, INDENT6, "param-name", param.getKey());
                WebXml.appendElement(sb, INDENT6, "param-value", param.getValue());
                sb.append("    </init-param>\n");
            }
            sb.append("  </filter>\n");
        }
        sb.append('\n');
        for (FilterMap filterMap : this.filterMaps) {
            sb.append("  <filter-mapping>\n");
            WebXml.appendElement(sb, INDENT4, "filter-name", filterMap.getFilterName());
            if (filterMap.getMatchAllServletNames()) {
                sb.append("    <servlet-name>*</servlet-name>\n");
            } else {
                for (String servletName : filterMap.getServletNames()) {
                    WebXml.appendElement(sb, INDENT4, "servlet-name", servletName);
                }
            }
            if (filterMap.getMatchAllUrlPatterns()) {
                sb.append("    <url-pattern>*</url-pattern>\n");
            } else {
                for (String urlPattern : filterMap.getURLPatterns()) {
                    WebXml.appendElement(sb, INDENT4, "url-pattern", urlPattern);
                }
            }
            for (String dispatcher : filterMap.getDispatcherNames()) {
                WebXml.appendElement(sb, INDENT4, "dispatcher", dispatcher);
            }
            sb.append("  </filter-mapping>\n");
        }
        sb.append('\n');
        for (String string : this.listeners) {
            sb.append("  <listener>\n");
            WebXml.appendElement(sb, INDENT4, "listener-class", string);
            sb.append("  </listener>\n");
        }
        sb.append('\n');
        for (Map.Entry entry : this.servlets.entrySet()) {
            ServletDef servletDef = (ServletDef)entry.getValue();
            sb.append("  <servlet>\n");
            WebXml.appendElement(sb, INDENT4, "description", servletDef.getDescription());
            WebXml.appendElement(sb, INDENT4, "display-name", servletDef.getDisplayName());
            WebXml.appendElement(sb, INDENT4, "servlet-name", (String)entry.getKey());
            WebXml.appendElement(sb, INDENT4, "servlet-class", servletDef.getServletClass());
            WebXml.appendElement(sb, INDENT4, "jsp-file", servletDef.getJspFile());
            for (Map.Entry<String, String> param : servletDef.getParameterMap().entrySet()) {
                sb.append("    <init-param>\n");
                WebXml.appendElement(sb, INDENT6, "param-name", param.getKey());
                WebXml.appendElement(sb, INDENT6, "param-value", param.getValue());
                sb.append("    </init-param>\n");
            }
            WebXml.appendElement(sb, INDENT4, "load-on-startup", servletDef.getLoadOnStartup());
            WebXml.appendElement(sb, INDENT4, "enabled", servletDef.getEnabled());
            WebXml.appendElement(sb, INDENT4, "async-supported", servletDef.getAsyncSupported());
            if (servletDef.getRunAs() != null) {
                sb.append("    <run-as>\n");
                WebXml.appendElement(sb, INDENT6, "role-name", servletDef.getRunAs());
                sb.append("    </run-as>\n");
            }
            for (SecurityRoleRef roleRef : servletDef.getSecurityRoleRefs()) {
                sb.append("    <security-role-ref>\n");
                WebXml.appendElement(sb, INDENT6, "role-name", roleRef.getName());
                WebXml.appendElement(sb, INDENT6, "role-link", roleRef.getLink());
                sb.append("    </security-role-ref>\n");
            }
            MultipartDef multipartDef = servletDef.getMultipartDef();
            if (multipartDef != null) {
                sb.append("    <multipart-config>\n");
                WebXml.appendElement(sb, INDENT6, "location", multipartDef.getLocation());
                WebXml.appendElement(sb, INDENT6, "max-file-size", multipartDef.getMaxFileSize());
                WebXml.appendElement(sb, INDENT6, "max-request-size", multipartDef.getMaxRequestSize());
                WebXml.appendElement(sb, INDENT6, "file-size-threshold", multipartDef.getFileSizeThreshold());
                sb.append("    </multipart-config>\n");
            }
            sb.append("  </servlet>\n");
        }
        sb.append('\n');
        for (Map.Entry entry : this.servletMappings.entrySet()) {
            sb.append("  <servlet-mapping>\n");
            WebXml.appendElement(sb, INDENT4, "servlet-name", (String)entry.getValue());
            WebXml.appendElement(sb, INDENT4, "url-pattern", (String)entry.getKey());
            sb.append("  </servlet-mapping>\n");
        }
        sb.append('\n');
        if (this.sessionConfig != null) {
            sb.append("  <session-config>\n");
            WebXml.appendElement(sb, INDENT4, "session-timeout", this.sessionConfig.getSessionTimeout());
            sb.append("    <cookie-config>\n");
            WebXml.appendElement(sb, INDENT6, "name", this.sessionConfig.getCookieName());
            WebXml.appendElement(sb, INDENT6, "domain", this.sessionConfig.getCookieDomain());
            WebXml.appendElement(sb, INDENT6, "path", this.sessionConfig.getCookiePath());
            WebXml.appendElement(sb, INDENT6, "comment", this.sessionConfig.getCookieComment());
            WebXml.appendElement(sb, INDENT6, "http-only", this.sessionConfig.getCookieHttpOnly());
            WebXml.appendElement(sb, INDENT6, "secure", this.sessionConfig.getCookieSecure());
            WebXml.appendElement(sb, INDENT6, "max-age", this.sessionConfig.getCookieMaxAge());
            sb.append("    </cookie-config>\n");
            for (SessionTrackingMode sessionTrackingMode : this.sessionConfig.getSessionTrackingModes()) {
                WebXml.appendElement(sb, INDENT4, "tracking-mode", sessionTrackingMode.name());
            }
            sb.append("  </session-config>\n\n");
        }
        for (Map.Entry entry : this.mimeMappings.entrySet()) {
            sb.append("  <mime-mapping>\n");
            WebXml.appendElement(sb, INDENT4, "extension", (String)entry.getKey());
            WebXml.appendElement(sb, INDENT4, "mime-type", (String)entry.getValue());
            sb.append("  </mime-mapping>\n");
        }
        sb.append('\n');
        if (this.welcomeFiles.size() > 0) {
            sb.append("  <welcome-file-list>\n");
            for (String string : this.welcomeFiles) {
                WebXml.appendElement(sb, INDENT4, "welcome-file", string);
            }
            sb.append("  </welcome-file-list>\n\n");
        }
        for (ErrorPage errorPage : this.errorPages.values()) {
            sb.append("  <error-page>\n");
            if (errorPage.getExceptionType() == null) {
                WebXml.appendElement(sb, INDENT4, "error-code", Integer.toString(errorPage.getErrorCode()));
            } else {
                WebXml.appendElement(sb, INDENT4, "exception-type", errorPage.getExceptionType());
            }
            WebXml.appendElement(sb, INDENT4, "location", errorPage.getLocation());
            sb.append("  </error-page>\n");
        }
        sb.append('\n');
        if (this.taglibs.size() > 0 || this.jspPropertyGroups.size() > 0) {
            sb.append("  <jsp-config>\n");
            for (Map.Entry entry : this.taglibs.entrySet()) {
                sb.append("    <taglib>\n");
                WebXml.appendElement(sb, INDENT6, "taglib-uri", (String)entry.getKey());
                WebXml.appendElement(sb, INDENT6, "taglib-location", (String)entry.getValue());
                sb.append("    </taglib>\n");
            }
            for (JspPropertyGroup jspPropertyGroup : this.jspPropertyGroups) {
                sb.append("    <jsp-property-group>\n");
                WebXml.appendElement(sb, INDENT6, "url-pattern", jspPropertyGroup.getUrlPattern());
                WebXml.appendElement(sb, INDENT6, "el-ignored", jspPropertyGroup.getElIgnored());
                WebXml.appendElement(sb, INDENT6, "scripting-invalid", jspPropertyGroup.getScriptingInvalid());
                WebXml.appendElement(sb, INDENT6, "page-encoding", jspPropertyGroup.getPageEncoding());
                for (String prelude : jspPropertyGroup.getIncludePreludes()) {
                    WebXml.appendElement(sb, INDENT6, "include-prelude", prelude);
                }
                for (String coda : jspPropertyGroup.getIncludeCodas()) {
                    WebXml.appendElement(sb, INDENT6, "include-coda", coda);
                }
                WebXml.appendElement(sb, INDENT6, "is-xml", jspPropertyGroup.getIsXml());
                WebXml.appendElement(sb, INDENT6, "deferred-syntax-allowed-as-literal", jspPropertyGroup.getDeferredSyntax());
                WebXml.appendElement(sb, INDENT6, "trim-directive-whitespaces", jspPropertyGroup.getTrimWhitespace());
                WebXml.appendElement(sb, INDENT6, "default-content-type", jspPropertyGroup.getDefaultContentType());
                WebXml.appendElement(sb, INDENT6, "buffer", jspPropertyGroup.getBuffer());
                WebXml.appendElement(sb, INDENT6, "error-on-undeclared-namespace", jspPropertyGroup.getErrorOnUndeclaredNamespace());
                sb.append("    </jsp-property-group>\n");
            }
            sb.append("  </jsp-config>\n\n");
        }
        for (SecurityConstraint securityConstraint : this.securityConstraints) {
            sb.append("  <security-constraint>\n");
            WebXml.appendElement(sb, INDENT4, "display-name", securityConstraint.getDisplayName());
            for (SecurityCollection collection : securityConstraint.findCollections()) {
                sb.append("    <web-resource-collection>\n");
                WebXml.appendElement(sb, INDENT6, "web-resource-name", collection.getName());
                WebXml.appendElement(sb, INDENT6, "description", collection.getDescription());
                for (String urlPattern : collection.findPatterns()) {
                    WebXml.appendElement(sb, INDENT6, "url-pattern", urlPattern);
                }
                for (String method : collection.findMethods()) {
                    WebXml.appendElement(sb, INDENT6, "http-method", method);
                }
                for (String method : collection.findOmittedMethods()) {
                    WebXml.appendElement(sb, INDENT6, "http-method-omission", method);
                }
                sb.append("    </web-resource-collection>\n");
            }
            if (securityConstraint.findAuthRoles().length > 0) {
                sb.append("    <auth-constraint>\n");
                for (String role : securityConstraint.findAuthRoles()) {
                    WebXml.appendElement(sb, INDENT6, "role-name", role);
                }
                sb.append("    </auth-constraint>\n");
            }
            if (securityConstraint.getUserConstraint() != null) {
                sb.append("    <user-data-constraint>\n");
                WebXml.appendElement(sb, INDENT6, "transport-guarantee", securityConstraint.getUserConstraint());
                sb.append("    </user-data-constraint>\n");
            }
            sb.append("  </security-constraint>\n");
        }
        sb.append('\n');
        if (this.loginConfig != null) {
            sb.append("  <login-config>\n");
            WebXml.appendElement(sb, INDENT4, "auth-method", this.loginConfig.getAuthMethod());
            WebXml.appendElement(sb, INDENT4, "realm-name", this.loginConfig.getRealmName());
            if (this.loginConfig.getErrorPage() != null || this.loginConfig.getLoginPage() != null) {
                sb.append("    <form-login-config>\n");
                WebXml.appendElement(sb, INDENT6, "form-login-page", this.loginConfig.getLoginPage());
                WebXml.appendElement(sb, INDENT6, "form-error-page", this.loginConfig.getErrorPage());
                sb.append("    </form-login-config>\n");
            }
            sb.append("  </login-config>\n\n");
        }
        for (String string : this.securityRoles) {
            sb.append("  <security-role>\n");
            WebXml.appendElement(sb, INDENT4, "role-name", string);
            sb.append("  </security-role>\n");
        }
        for (ContextEnvironment contextEnvironment : this.envEntries.values()) {
            sb.append("  <env-entry>\n");
            WebXml.appendElement(sb, INDENT4, "description", contextEnvironment.getDescription());
            WebXml.appendElement(sb, INDENT4, "env-entry-name", contextEnvironment.getName());
            WebXml.appendElement(sb, INDENT4, "env-entry-type", contextEnvironment.getType());
            WebXml.appendElement(sb, INDENT4, "env-entry-value", contextEnvironment.getValue());
            for (InjectionTarget target : contextEnvironment.getInjectionTargets()) {
                sb.append("    <injection-target>\n");
                WebXml.appendElement(sb, INDENT6, "injection-target-class", target.getTargetClass());
                WebXml.appendElement(sb, INDENT6, "injection-target-name", target.getTargetName());
                sb.append("    </injection-target>\n");
            }
            sb.append("  </env-entry>\n");
        }
        sb.append('\n');
        for (ContextEjb contextEjb : this.ejbRefs.values()) {
            sb.append("  <ejb-ref>\n");
            WebXml.appendElement(sb, INDENT4, "description", contextEjb.getDescription());
            WebXml.appendElement(sb, INDENT4, "ejb-ref-name", contextEjb.getName());
            WebXml.appendElement(sb, INDENT4, "ejb-ref-type", contextEjb.getType());
            WebXml.appendElement(sb, INDENT4, "home", contextEjb.getHome());
            WebXml.appendElement(sb, INDENT4, "remote", contextEjb.getRemote());
            WebXml.appendElement(sb, INDENT4, "ejb-link", contextEjb.getLink());
            for (InjectionTarget target : contextEjb.getInjectionTargets()) {
                sb.append("    <injection-target>\n");
                WebXml.appendElement(sb, INDENT6, "injection-target-class", target.getTargetClass());
                WebXml.appendElement(sb, INDENT6, "injection-target-name", target.getTargetName());
                sb.append("    </injection-target>\n");
            }
            sb.append("  </ejb-ref>\n");
        }
        sb.append('\n');
        for (ContextLocalEjb contextLocalEjb : this.ejbLocalRefs.values()) {
            sb.append("  <ejb-local-ref>\n");
            WebXml.appendElement(sb, INDENT4, "description", contextLocalEjb.getDescription());
            WebXml.appendElement(sb, INDENT4, "ejb-ref-name", contextLocalEjb.getName());
            WebXml.appendElement(sb, INDENT4, "ejb-ref-type", contextLocalEjb.getType());
            WebXml.appendElement(sb, INDENT4, "local-home", contextLocalEjb.getHome());
            WebXml.appendElement(sb, INDENT4, "local", contextLocalEjb.getLocal());
            WebXml.appendElement(sb, INDENT4, "ejb-link", contextLocalEjb.getLink());
            for (InjectionTarget target : contextLocalEjb.getInjectionTargets()) {
                sb.append("    <injection-target>\n");
                WebXml.appendElement(sb, INDENT6, "injection-target-class", target.getTargetClass());
                WebXml.appendElement(sb, INDENT6, "injection-target-name", target.getTargetName());
                sb.append("    </injection-target>\n");
            }
            sb.append("  </ejb-local-ref>\n");
        }
        sb.append('\n');
        for (ContextService contextService : this.serviceRefs.values()) {
            sb.append("  <service-ref>\n");
            WebXml.appendElement(sb, INDENT4, "description", contextService.getDescription());
            WebXml.appendElement(sb, INDENT4, "display-name", contextService.getDisplayname());
            WebXml.appendElement(sb, INDENT4, "service-ref-name", contextService.getName());
            WebXml.appendElement(sb, INDENT4, "service-interface", contextService.getInterface());
            WebXml.appendElement(sb, INDENT4, "service-ref-type", contextService.getType());
            WebXml.appendElement(sb, INDENT4, "wsdl-file", contextService.getWsdlfile());
            WebXml.appendElement(sb, INDENT4, "jaxrpc-mapping-file", contextService.getJaxrpcmappingfile());
            String qname = contextService.getServiceqnameNamespaceURI();
            if (qname != null) {
                qname = qname + ":";
            }
            qname = qname + contextService.getServiceqnameLocalpart();
            WebXml.appendElement(sb, INDENT4, "service-qname", qname);
            Iterator<String> endpointIter = contextService.getServiceendpoints();
            while (endpointIter.hasNext()) {
                String endpoint = endpointIter.next();
                sb.append("    <port-component-ref>\n");
                WebXml.appendElement(sb, INDENT6, "service-endpoint-interface", endpoint);
                WebXml.appendElement(sb, INDENT6, "port-component-link", contextService.getProperty(endpoint));
                sb.append("    </port-component-ref>\n");
            }
            Iterator<String> handlerIter = contextService.getHandlers();
            while (handlerIter.hasNext()) {
                String handler = handlerIter.next();
                sb.append("    <handler>\n");
                ContextHandler ch = contextService.getHandler(handler);
                WebXml.appendElement(sb, INDENT6, "handler-name", ch.getName());
                WebXml.appendElement(sb, INDENT6, "handler-class", ch.getHandlerclass());
                sb.append("    </handler>\n");
            }
            for (InjectionTarget target : contextService.getInjectionTargets()) {
                sb.append("    <injection-target>\n");
                WebXml.appendElement(sb, INDENT6, "injection-target-class", target.getTargetClass());
                WebXml.appendElement(sb, INDENT6, "injection-target-name", target.getTargetName());
                sb.append("    </injection-target>\n");
            }
            sb.append("  </service-ref>\n");
        }
        sb.append('\n');
        for (ContextResource contextResource : this.resourceRefs.values()) {
            sb.append("  <resource-ref>\n");
            WebXml.appendElement(sb, INDENT4, "description", contextResource.getDescription());
            WebXml.appendElement(sb, INDENT4, "res-ref-name", contextResource.getName());
            WebXml.appendElement(sb, INDENT4, "res-type", contextResource.getType());
            WebXml.appendElement(sb, INDENT4, "res-auth", contextResource.getAuth());
            WebXml.appendElement(sb, INDENT4, "res-sharing-scope", contextResource.getScope());
            for (InjectionTarget target : contextResource.getInjectionTargets()) {
                sb.append("    <injection-target>\n");
                WebXml.appendElement(sb, INDENT6, "injection-target-class", target.getTargetClass());
                WebXml.appendElement(sb, INDENT6, "injection-target-name", target.getTargetName());
                sb.append("    </injection-target>\n");
            }
            sb.append("  </resource-ref>\n");
        }
        sb.append('\n');
        for (ContextResourceEnvRef contextResourceEnvRef : this.resourceEnvRefs.values()) {
            sb.append("  <resource-env-ref>\n");
            WebXml.appendElement(sb, INDENT4, "description", contextResourceEnvRef.getDescription());
            WebXml.appendElement(sb, INDENT4, "resource-env-ref-name", contextResourceEnvRef.getName());
            WebXml.appendElement(sb, INDENT4, "resource-env-ref-type", contextResourceEnvRef.getType());
            for (InjectionTarget target : contextResourceEnvRef.getInjectionTargets()) {
                sb.append("    <injection-target>\n");
                WebXml.appendElement(sb, INDENT6, "injection-target-class", target.getTargetClass());
                WebXml.appendElement(sb, INDENT6, "injection-target-name", target.getTargetName());
                sb.append("    </injection-target>\n");
            }
            sb.append("  </resource-env-ref>\n");
        }
        sb.append('\n');
        for (MessageDestinationRef messageDestinationRef : this.messageDestinationRefs.values()) {
            sb.append("  <message-destination-ref>\n");
            WebXml.appendElement(sb, INDENT4, "description", messageDestinationRef.getDescription());
            WebXml.appendElement(sb, INDENT4, "message-destination-ref-name", messageDestinationRef.getName());
            WebXml.appendElement(sb, INDENT4, "message-destination-type", messageDestinationRef.getType());
            WebXml.appendElement(sb, INDENT4, "message-destination-usage", messageDestinationRef.getUsage());
            WebXml.appendElement(sb, INDENT4, "message-destination-link", messageDestinationRef.getLink());
            for (InjectionTarget target : messageDestinationRef.getInjectionTargets()) {
                sb.append("    <injection-target>\n");
                WebXml.appendElement(sb, INDENT6, "injection-target-class", target.getTargetClass());
                WebXml.appendElement(sb, INDENT6, "injection-target-name", target.getTargetName());
                sb.append("    </injection-target>\n");
            }
            sb.append("  </message-destination-ref>\n");
        }
        sb.append('\n');
        for (MessageDestination messageDestination : this.messageDestinations.values()) {
            sb.append("  <message-destination>\n");
            WebXml.appendElement(sb, INDENT4, "description", messageDestination.getDescription());
            WebXml.appendElement(sb, INDENT4, "display-name", messageDestination.getDisplayName());
            WebXml.appendElement(sb, INDENT4, "message-destination-name", messageDestination.getName());
            sb.append("  </message-destination>\n");
        }
        sb.append('\n');
        if (this.localeEncodingMappings.size() > 0) {
            sb.append("  <locale-encoding-mapping-list>\n");
            for (Map.Entry entry : this.localeEncodingMappings.entrySet()) {
                sb.append("    <locale-encoding-mapping>\n");
                WebXml.appendElement(sb, INDENT6, "locale", (String)entry.getKey());
                WebXml.appendElement(sb, INDENT6, "encoding", (String)entry.getValue());
                sb.append("    </locale-encoding-mapping>\n");
            }
            sb.append("  </locale-encoding-mapping-list>\n");
        }
        sb.append("</web-app>");
        return sb.toString();
    }

    private static void appendElement(StringBuilder sb, String indent, String elementName, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        sb.append(indent);
        sb.append('<');
        sb.append(elementName);
        sb.append('>');
        sb.append(WebXml.escapeXml(value));
        sb.append("</");
        sb.append(elementName);
        sb.append(">\n");
    }

    private static void appendElement(StringBuilder sb, String indent, String elementName, Object value) {
        if (value == null) {
            return;
        }
        WebXml.appendElement(sb, indent, elementName, value.toString());
    }

    private static String escapeXml(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void configureContext(Context context) {
        Object descriptor;
        context.setPublicId(this.publicId);
        context.setEffectiveMajorVersion(this.getMajorVersion());
        context.setEffectiveMinorVersion(this.getMinorVersion());
        for (Map.Entry<String, String> entry : this.contextParams.entrySet()) {
            context.addParameter(entry.getKey(), entry.getValue());
        }
        context.setDisplayName(this.displayName);
        context.setDistributable(this.distributable);
        for (ContextLocalEjb contextLocalEjb : this.ejbLocalRefs.values()) {
            context.getNamingResources().addLocalEjb(contextLocalEjb);
        }
        for (ContextEjb contextEjb : this.ejbRefs.values()) {
            context.getNamingResources().addEjb(contextEjb);
        }
        for (ContextEnvironment contextEnvironment : this.envEntries.values()) {
            context.getNamingResources().addEnvironment(contextEnvironment);
        }
        for (ErrorPage errorPage : this.errorPages.values()) {
            context.addErrorPage(errorPage);
        }
        for (FilterDef filterDef : this.filters.values()) {
            if (filterDef.getAsyncSupported() == null) {
                filterDef.setAsyncSupported("false");
            }
            context.addFilterDef(filterDef);
        }
        for (FilterMap filterMap : this.filterMaps) {
            context.addFilterMap(filterMap);
        }
        for (JspPropertyGroup jspPropertyGroup : this.jspPropertyGroups) {
            descriptor = new ApplicationJspPropertyGroupDescriptor(jspPropertyGroup);
            context.getJspConfigDescriptor().getJspPropertyGroups().add(descriptor);
        }
        for (String string : this.listeners) {
            context.addApplicationListener(string);
        }
        for (Map.Entry entry : this.localeEncodingMappings.entrySet()) {
            context.addLocaleEncodingMappingParameter((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.loginConfig != null) {
            context.setLoginConfig(this.loginConfig);
        }
        for (MessageDestinationRef messageDestinationRef : this.messageDestinationRefs.values()) {
            context.getNamingResources().addMessageDestinationRef(messageDestinationRef);
        }
        context.setIgnoreAnnotations(this.metadataComplete);
        for (Map.Entry entry : this.mimeMappings.entrySet()) {
            context.addMimeMapping((String)entry.getKey(), (String)entry.getValue());
        }
        for (ContextResourceEnvRef contextResourceEnvRef : this.resourceEnvRefs.values()) {
            context.getNamingResources().addResourceEnvRef(contextResourceEnvRef);
        }
        for (ContextResource contextResource : this.resourceRefs.values()) {
            context.getNamingResources().addResource(contextResource);
        }
        for (SecurityConstraint securityConstraint : this.securityConstraints) {
            context.addConstraint(securityConstraint);
        }
        for (String string : this.securityRoles) {
            context.addSecurityRole(string);
        }
        for (ContextService contextService : this.serviceRefs.values()) {
            context.getNamingResources().addService(contextService);
        }
        for (ServletDef servletDef : this.servlets.values()) {
            Wrapper wrapper = context.createWrapper();
            if (servletDef.getLoadOnStartup() != null) {
                wrapper.setLoadOnStartup(servletDef.getLoadOnStartup());
            }
            if (servletDef.getEnabled() != null) {
                wrapper.setEnabled(servletDef.getEnabled());
            }
            wrapper.setName(servletDef.getServletName());
            Map<String, String> params = servletDef.getParameterMap();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                wrapper.addInitParameter(entry.getKey(), entry.getValue());
            }
            wrapper.setRunAs(servletDef.getRunAs());
            Set<SecurityRoleRef> roleRefs = servletDef.getSecurityRoleRefs();
            for (SecurityRoleRef roleRef : roleRefs) {
                wrapper.addSecurityReference(roleRef.getName(), roleRef.getLink());
            }
            wrapper.setServletClass(servletDef.getServletClass());
            MultipartDef multipartdef = servletDef.getMultipartDef();
            if (multipartdef != null) {
                if (multipartdef.getMaxFileSize() != null && multipartdef.getMaxRequestSize() != null && multipartdef.getFileSizeThreshold() != null) {
                    wrapper.setMultipartConfigElement(new MultipartConfigElement(multipartdef.getLocation(), Long.parseLong(multipartdef.getMaxFileSize()), Long.parseLong(multipartdef.getMaxRequestSize()), Integer.parseInt(multipartdef.getFileSizeThreshold())));
                } else {
                    wrapper.setMultipartConfigElement(new MultipartConfigElement(multipartdef.getLocation()));
                }
            }
            if (servletDef.getAsyncSupported() != null) {
                wrapper.setAsyncSupported(servletDef.getAsyncSupported());
            }
            wrapper.setOverridable(servletDef.isOverridable());
            context.addChild(wrapper);
        }
        for (Map.Entry entry : this.servletMappings.entrySet()) {
            context.addServletMapping((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.sessionConfig != null) {
            if (this.sessionConfig.getSessionTimeout() != null) {
                context.setSessionTimeout(this.sessionConfig.getSessionTimeout());
            }
            SessionCookieConfig scc = context.getServletContext().getSessionCookieConfig();
            scc.setName(this.sessionConfig.getCookieName());
            scc.setDomain(this.sessionConfig.getCookieDomain());
            scc.setPath(this.sessionConfig.getCookiePath());
            scc.setComment(this.sessionConfig.getCookieComment());
            if (this.sessionConfig.getCookieHttpOnly() != null) {
                scc.setHttpOnly(this.sessionConfig.getCookieHttpOnly().booleanValue());
            }
            if (this.sessionConfig.getCookieSecure() != null) {
                scc.setSecure(this.sessionConfig.getCookieSecure().booleanValue());
            }
            if (this.sessionConfig.getCookieMaxAge() != null) {
                scc.setMaxAge(this.sessionConfig.getCookieMaxAge().intValue());
            }
            if (this.sessionConfig.getSessionTrackingModes().size() > 0) {
                context.getServletContext().setSessionTrackingModes(this.sessionConfig.getSessionTrackingModes());
            }
        }
        for (Map.Entry entry : this.taglibs.entrySet()) {
            descriptor = new ApplicationTaglibDescriptor((String)entry.getValue(), (String)entry.getKey());
            context.getJspConfigDescriptor().getTaglibs().add(descriptor);
        }
        for (String string : this.welcomeFiles) {
            if (string == null || string.length() <= 0) continue;
            context.addWelcomeFile(string);
        }
        for (JspPropertyGroup jspPropertyGroup : this.jspPropertyGroups) {
            String jspServletName = context.findServletMapping("*.jsp");
            if (jspServletName == null) {
                jspServletName = "jsp";
            }
            if (context.findChild(jspServletName) != null) {
                context.addServletMapping(jspPropertyGroup.getUrlPattern(), jspServletName, true);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Skiping " + jspPropertyGroup.getUrlPattern() + " , no servlet " + jspServletName);
        }
    }

    public boolean merge(Set<WebXml> fragments) {
        WebXml temp = new WebXml();
        for (WebXml fragment : fragments) {
            if (WebXml.mergeMap(fragment.getContextParams(), this.contextParams, temp.getContextParams(), fragment, "Context Parameter")) continue;
            return false;
        }
        this.contextParams.putAll(temp.getContextParams());
        if (this.displayName == null) {
            for (WebXml fragment : fragments) {
                String value2 = fragment.getDisplayName();
                if (value2 == null) continue;
                if (temp.getDisplayName() == null) {
                    temp.setDisplayName(value2);
                    continue;
                }
                log.error(sm.getString("webXml.mergeConflictDisplayName", fragment.getName(), fragment.getURL()));
                return false;
            }
            this.displayName = temp.getDisplayName();
        }
        if (this.distributable) {
            for (WebXml fragment : fragments) {
                if (fragment.isDistributable()) continue;
                this.distributable = false;
                break;
            }
        }
        for (WebXml fragment : fragments) {
            if (WebXml.mergeResourceMap(fragment.getEjbLocalRefs(), this.ejbLocalRefs, temp.getEjbLocalRefs(), fragment)) continue;
            return false;
        }
        this.ejbLocalRefs.putAll(temp.getEjbLocalRefs());
        for (WebXml fragment : fragments) {
            if (WebXml.mergeResourceMap(fragment.getEjbRefs(), this.ejbRefs, temp.getEjbRefs(), fragment)) continue;
            return false;
        }
        this.ejbRefs.putAll(temp.getEjbRefs());
        for (WebXml fragment : fragments) {
            if (WebXml.mergeResourceMap(fragment.getEnvEntries(), this.envEntries, temp.getEnvEntries(), fragment)) continue;
            return false;
        }
        this.envEntries.putAll(temp.getEnvEntries());
        for (WebXml fragment : fragments) {
            if (WebXml.mergeMap(fragment.getErrorPages(), this.errorPages, temp.getErrorPages(), fragment, "Error Page")) continue;
            return false;
        }
        this.errorPages.putAll(temp.getErrorPages());
        ArrayList<FilterMap> filterMapsToAdd = new ArrayList<FilterMap>();
        for (WebXml fragment : fragments) {
            for (FilterMap filterMap : fragment.getFilterMappings()) {
                if (this.filterMappingNames.contains(filterMap.getFilterName())) continue;
                filterMapsToAdd.add(filterMap);
            }
        }
        for (FilterMap filterMap : filterMapsToAdd) {
            this.addFilterMapping(filterMap);
        }
        for (WebXml fragment : fragments) {
            for (Map.Entry<String, FilterDef> entry : fragment.getFilters().entrySet()) {
                if (this.filters.containsKey(entry.getKey())) {
                    WebXml.mergeFilter(entry.getValue(), this.filters.get(entry.getKey()), false);
                    continue;
                }
                if (temp.getFilters().containsKey(entry.getKey())) {
                    if (WebXml.mergeFilter(entry.getValue(), temp.getFilters().get(entry.getKey()), true)) continue;
                    log.error(sm.getString("webXml.mergeConflictFilter", entry.getKey(), fragment.getName(), fragment.getURL()));
                    return false;
                }
                temp.getFilters().put(entry.getKey(), entry.getValue());
            }
        }
        this.filters.putAll(temp.getFilters());
        for (WebXml fragment : fragments) {
            for (JspPropertyGroup jspPropertyGroup : fragment.getJspPropertyGroups()) {
                this.addJspPropertyGroup(jspPropertyGroup);
            }
        }
        for (WebXml fragment : fragments) {
            for (String string : fragment.getListeners()) {
                this.addListener(string);
            }
        }
        for (WebXml fragment : fragments) {
            if (WebXml.mergeMap(fragment.getLocalEncodingMappings(), this.localeEncodingMappings, temp.getLocalEncodingMappings(), fragment, "Locale Encoding Mapping")) continue;
            return false;
        }
        this.localeEncodingMappings.putAll(temp.getLocalEncodingMappings());
        if (this.getLoginConfig() == null) {
            LoginConfig tempLoginConfig = null;
            for (WebXml webXml : fragments) {
                LoginConfig loginConfig = webXml.loginConfig;
                if (loginConfig == null) continue;
                if (tempLoginConfig == null || loginConfig.equals(tempLoginConfig)) {
                    tempLoginConfig = loginConfig;
                    continue;
                }
                log.error(sm.getString("webXml.mergeConflictLoginConfig", webXml.getName(), webXml.getURL()));
            }
            this.loginConfig = tempLoginConfig;
        }
        for (WebXml fragment : fragments) {
            if (WebXml.mergeResourceMap(fragment.getMessageDestinationRefs(), this.messageDestinationRefs, temp.getMessageDestinationRefs(), fragment)) continue;
            return false;
        }
        this.messageDestinationRefs.putAll(temp.getMessageDestinationRefs());
        for (WebXml fragment : fragments) {
            if (WebXml.mergeResourceMap(fragment.getMessageDestinations(), this.messageDestinations, temp.getMessageDestinations(), fragment)) continue;
            return false;
        }
        this.messageDestinations.putAll(temp.getMessageDestinations());
        for (WebXml fragment : fragments) {
            if (WebXml.mergeMap(fragment.getMimeMappings(), this.mimeMappings, temp.getMimeMappings(), fragment, "Mime Mapping")) continue;
            return false;
        }
        this.mimeMappings.putAll(temp.getMimeMappings());
        for (WebXml fragment : fragments) {
            if (WebXml.mergeResourceMap(fragment.getResourceEnvRefs(), this.resourceEnvRefs, temp.getResourceEnvRefs(), fragment)) continue;
            return false;
        }
        this.resourceEnvRefs.putAll(temp.getResourceEnvRefs());
        for (WebXml fragment : fragments) {
            if (WebXml.mergeResourceMap(fragment.getResourceRefs(), this.resourceRefs, temp.getResourceRefs(), fragment)) continue;
            return false;
        }
        this.resourceRefs.putAll(temp.getResourceRefs());
        for (WebXml fragment : fragments) {
            for (SecurityConstraint securityConstraint : fragment.getSecurityConstraints()) {
                this.addSecurityConstraint(securityConstraint);
            }
        }
        for (WebXml fragment : fragments) {
            for (String string : fragment.getSecurityRoles()) {
                this.addSecurityRole(string);
            }
        }
        for (WebXml fragment : fragments) {
            if (WebXml.mergeResourceMap(fragment.getServiceRefs(), this.serviceRefs, temp.getServiceRefs(), fragment)) continue;
            return false;
        }
        this.serviceRefs.putAll(temp.getServiceRefs());
        ArrayList<Map.Entry<String, String>> servletMappingsToAdd = new ArrayList<Map.Entry<String, String>>();
        for (WebXml webXml : fragments) {
            for (Map.Entry<String, String> entry : webXml.getServletMappings().entrySet()) {
                if (this.servletMappingNames.contains(entry.getValue()) || this.servletMappings.containsKey(entry.getKey())) continue;
                servletMappingsToAdd.add(entry);
            }
        }
        for (Map.Entry entry : servletMappingsToAdd) {
            this.addServletMapping((String)entry.getKey(), (String)entry.getValue());
        }
        for (WebXml webXml : fragments) {
            for (Map.Entry<String, ServletDef> entry : webXml.getServlets().entrySet()) {
                if (this.servlets.containsKey(entry.getKey())) {
                    WebXml.mergeServlet(entry.getValue(), this.servlets.get(entry.getKey()), false);
                    continue;
                }
                if (temp.getServlets().containsKey(entry.getKey())) {
                    if (WebXml.mergeServlet(entry.getValue(), temp.getServlets().get(entry.getKey()), true)) continue;
                    log.error(sm.getString("webXml.mergeConflictServlet", entry.getKey(), webXml.getName(), webXml.getURL()));
                    return false;
                }
                temp.getServlets().put(entry.getKey(), entry.getValue());
            }
        }
        this.servlets.putAll(temp.getServlets());
        if (this.sessionConfig.getSessionTimeout() == null) {
            for (WebXml webXml : fragments) {
                Integer n = webXml.getSessionConfig().getSessionTimeout();
                if (n == null) continue;
                if (temp.getSessionConfig().getSessionTimeout() == null) {
                    temp.getSessionConfig().setSessionTimeout(n.toString());
                    continue;
                }
                if (n.equals(temp.getSessionConfig().getSessionTimeout())) continue;
                log.error(sm.getString("webXml.mergeConflictSessionTimeout", webXml.getName(), webXml.getURL()));
                return false;
            }
            if (temp.getSessionConfig().getSessionTimeout() != null) {
                this.sessionConfig.setSessionTimeout(temp.getSessionConfig().getSessionTimeout().toString());
            }
        }
        if (this.sessionConfig.getCookieName() == null) {
            for (WebXml webXml : fragments) {
                String string = webXml.getSessionConfig().getCookieName();
                if (string == null) continue;
                if (temp.getSessionConfig().getCookieName() == null) {
                    temp.getSessionConfig().setCookieName(string);
                    continue;
                }
                if (string.equals(temp.getSessionConfig().getCookieName())) continue;
                log.error(sm.getString("webXml.mergeConflictSessionCookieName", webXml.getName(), webXml.getURL()));
                return false;
            }
            this.sessionConfig.setCookieName(temp.getSessionConfig().getCookieName());
        }
        if (this.sessionConfig.getCookieDomain() == null) {
            for (WebXml webXml : fragments) {
                String string = webXml.getSessionConfig().getCookieDomain();
                if (string == null) continue;
                if (temp.getSessionConfig().getCookieDomain() == null) {
                    temp.getSessionConfig().setCookieDomain(string);
                    continue;
                }
                if (string.equals(temp.getSessionConfig().getCookieDomain())) continue;
                log.error(sm.getString("webXml.mergeConflictSessionCookieDomain", webXml.getName(), webXml.getURL()));
                return false;
            }
            this.sessionConfig.setCookieDomain(temp.getSessionConfig().getCookieDomain());
        }
        if (this.sessionConfig.getCookiePath() == null) {
            for (WebXml webXml : fragments) {
                String string = webXml.getSessionConfig().getCookiePath();
                if (string == null) continue;
                if (temp.getSessionConfig().getCookiePath() == null) {
                    temp.getSessionConfig().setCookiePath(string);
                    continue;
                }
                if (string.equals(temp.getSessionConfig().getCookiePath())) continue;
                log.error(sm.getString("webXml.mergeConflictSessionCookiePath", webXml.getName(), webXml.getURL()));
                return false;
            }
            this.sessionConfig.setCookiePath(temp.getSessionConfig().getCookiePath());
        }
        if (this.sessionConfig.getCookieComment() == null) {
            for (WebXml webXml : fragments) {
                String string = webXml.getSessionConfig().getCookieComment();
                if (string == null) continue;
                if (temp.getSessionConfig().getCookieComment() == null) {
                    temp.getSessionConfig().setCookieComment(string);
                    continue;
                }
                if (string.equals(temp.getSessionConfig().getCookieComment())) continue;
                log.error(sm.getString("webXml.mergeConflictSessionCookieComment", webXml.getName(), webXml.getURL()));
                return false;
            }
            this.sessionConfig.setCookieComment(temp.getSessionConfig().getCookieComment());
        }
        if (this.sessionConfig.getCookieHttpOnly() == null) {
            for (WebXml webXml : fragments) {
                Boolean bl = webXml.getSessionConfig().getCookieHttpOnly();
                if (bl == null) continue;
                if (temp.getSessionConfig().getCookieHttpOnly() == null) {
                    temp.getSessionConfig().setCookieHttpOnly(bl.toString());
                    continue;
                }
                if (bl.equals(temp.getSessionConfig().getCookieHttpOnly())) continue;
                log.error(sm.getString("webXml.mergeConflictSessionCookieHttpOnly", webXml.getName(), webXml.getURL()));
                return false;
            }
            if (temp.getSessionConfig().getCookieHttpOnly() != null) {
                this.sessionConfig.setCookieHttpOnly(temp.getSessionConfig().getCookieHttpOnly().toString());
            }
        }
        if (this.sessionConfig.getCookieSecure() == null) {
            for (WebXml webXml : fragments) {
                Boolean bl = webXml.getSessionConfig().getCookieSecure();
                if (bl == null) continue;
                if (temp.getSessionConfig().getCookieSecure() == null) {
                    temp.getSessionConfig().setCookieSecure(bl.toString());
                    continue;
                }
                if (bl.equals(temp.getSessionConfig().getCookieSecure())) continue;
                log.error(sm.getString("webXml.mergeConflictSessionCookieSecure", webXml.getName(), webXml.getURL()));
                return false;
            }
            if (temp.getSessionConfig().getCookieSecure() != null) {
                this.sessionConfig.setCookieSecure(temp.getSessionConfig().getCookieSecure().toString());
            }
        }
        if (this.sessionConfig.getCookieMaxAge() == null) {
            for (WebXml webXml : fragments) {
                Integer n = webXml.getSessionConfig().getCookieMaxAge();
                if (n == null) continue;
                if (temp.getSessionConfig().getCookieMaxAge() == null) {
                    temp.getSessionConfig().setCookieMaxAge(n.toString());
                    continue;
                }
                if (n.equals(temp.getSessionConfig().getCookieMaxAge())) continue;
                log.error(sm.getString("webXml.mergeConflictSessionCookieMaxAge", webXml.getName(), webXml.getURL()));
                return false;
            }
            if (temp.getSessionConfig().getCookieMaxAge() != null) {
                this.sessionConfig.setCookieMaxAge(temp.getSessionConfig().getCookieMaxAge().toString());
            }
        }
        if (this.sessionConfig.getSessionTrackingModes().size() == 0) {
            for (WebXml webXml : fragments) {
                EnumSet<SessionTrackingMode> enumSet = webXml.getSessionConfig().getSessionTrackingModes();
                if (enumSet.size() <= 0) continue;
                if (temp.getSessionConfig().getSessionTrackingModes().size() == 0) {
                    temp.getSessionConfig().getSessionTrackingModes().addAll(enumSet);
                    continue;
                }
                if (enumSet.equals(temp.getSessionConfig().getSessionTrackingModes())) continue;
                log.error(sm.getString("webXml.mergeConflictSessionTrackingMode", webXml.getName(), webXml.getURL()));
                return false;
            }
            this.sessionConfig.getSessionTrackingModes().addAll(temp.getSessionConfig().getSessionTrackingModes());
        }
        for (WebXml webXml : fragments) {
            if (WebXml.mergeMap(webXml.getTaglibs(), this.taglibs, temp.getTaglibs(), webXml, "Taglibs")) continue;
            return false;
        }
        this.taglibs.putAll(temp.getTaglibs());
        for (WebXml webXml : fragments) {
            if (!webXml.alwaysAddWelcomeFiles && this.welcomeFiles.size() != 0) continue;
            for (String string : webXml.getWelcomeFiles()) {
                this.addWelcomeFile(string);
            }
        }
        return true;
    }

    private static <T extends ResourceBase> boolean mergeResourceMap(Map<String, T> fragmentResources, Map<String, T> mainResources, Map<String, T> tempResources, WebXml fragment) {
        for (ResourceBase resource : fragmentResources.values()) {
            String resourceName = resource.getName();
            if (mainResources.containsKey(resourceName)) {
                ((ResourceBase)mainResources.get(resourceName)).getInjectionTargets().addAll(resource.getInjectionTargets());
                continue;
            }
            ResourceBase existingResource = (ResourceBase)tempResources.get(resourceName);
            if (existingResource != null) {
                if (existingResource.equals(resource)) continue;
                log.error(sm.getString("webXml.mergeConflictResource", resourceName, fragment.getName(), fragment.getURL()));
                return false;
            }
            tempResources.put(resourceName, resource);
        }
        return true;
    }

    private static <T> boolean mergeMap(Map<String, T> fragmentMap, Map<String, T> mainMap, Map<String, T> tempMap, WebXml fragment, String mapName) {
        for (Map.Entry<String, T> entry : fragmentMap.entrySet()) {
            String key = entry.getKey();
            if (mainMap.containsKey(key)) continue;
            T value = entry.getValue();
            if (tempMap.containsKey(key)) {
                if (value == null || value.equals(tempMap.get(key))) continue;
                log.error(sm.getString("webXml.mergeConflictString", mapName, key, fragment.getName(), fragment.getURL()));
                return false;
            }
            tempMap.put(key, value);
        }
        return true;
    }

    private static boolean mergeFilter(FilterDef src, FilterDef dest, boolean failOnConflict) {
        if (dest.getAsyncSupported() == null) {
            dest.setAsyncSupported(src.getAsyncSupported());
        } else if (src.getAsyncSupported() != null && failOnConflict && !src.getAsyncSupported().equals(dest.getAsyncSupported())) {
            return false;
        }
        if (dest.getFilterClass() == null) {
            dest.setFilterClass(src.getFilterClass());
        } else if (src.getFilterClass() != null && failOnConflict && !src.getFilterClass().equals(dest.getFilterClass())) {
            return false;
        }
        for (Map.Entry<String, String> srcEntry : src.getParameterMap().entrySet()) {
            if (dest.getParameterMap().containsKey(srcEntry.getKey())) {
                if (!failOnConflict || dest.getParameterMap().get(srcEntry.getKey()).equals(srcEntry.getValue())) continue;
                return false;
            }
            dest.addInitParameter(srcEntry.getKey(), srcEntry.getValue());
        }
        return true;
    }

    private static boolean mergeServlet(ServletDef src, ServletDef dest, boolean failOnConflict) {
        if (dest.getServletClass() != null && dest.getJspFile() != null) {
            return false;
        }
        if (src.getServletClass() != null && src.getJspFile() != null) {
            return false;
        }
        if (dest.getServletClass() == null && dest.getJspFile() == null) {
            dest.setServletClass(src.getServletClass());
            dest.setJspFile(src.getJspFile());
        } else if (failOnConflict) {
            if (!(src.getServletClass() == null || dest.getJspFile() == null && src.getServletClass().equals(dest.getServletClass()))) {
                return false;
            }
            if (!(src.getJspFile() == null || dest.getServletClass() == null && src.getJspFile().equals(dest.getJspFile()))) {
                return false;
            }
        }
        for (SecurityRoleRef securityRoleRef : src.getSecurityRoleRefs()) {
            dest.addSecurityRoleRef(securityRoleRef);
        }
        if (dest.getLoadOnStartup() == null) {
            if (src.getLoadOnStartup() != null) {
                dest.setLoadOnStartup(src.getLoadOnStartup().toString());
            }
        } else if (src.getLoadOnStartup() != null && failOnConflict && !src.getLoadOnStartup().equals(dest.getLoadOnStartup())) {
            return false;
        }
        if (dest.getEnabled() == null) {
            if (src.getEnabled() != null) {
                dest.setEnabled(src.getEnabled().toString());
            }
        } else if (src.getEnabled() != null && failOnConflict && !src.getEnabled().equals(dest.getEnabled())) {
            return false;
        }
        for (Map.Entry entry : src.getParameterMap().entrySet()) {
            if (dest.getParameterMap().containsKey(entry.getKey())) {
                if (!failOnConflict || dest.getParameterMap().get(entry.getKey()).equals(entry.getValue())) continue;
                return false;
            }
            dest.addInitParameter((String)entry.getKey(), (String)entry.getValue());
        }
        if (dest.getMultipartDef() == null) {
            dest.setMultipartDef(src.getMultipartDef());
        } else if (src.getMultipartDef() != null) {
            return WebXml.mergeMultipartDef(src.getMultipartDef(), dest.getMultipartDef(), failOnConflict);
        }
        if (dest.getAsyncSupported() == null) {
            if (src.getAsyncSupported() != null) {
                dest.setAsyncSupported(src.getAsyncSupported().toString());
            }
        } else if (src.getAsyncSupported() != null && failOnConflict && !src.getAsyncSupported().equals(dest.getAsyncSupported())) {
            return false;
        }
        return true;
    }

    private static boolean mergeMultipartDef(MultipartDef src, MultipartDef dest, boolean failOnConflict) {
        if (dest.getLocation() == null) {
            dest.setLocation(src.getLocation());
        } else if (src.getLocation() != null && failOnConflict && !src.getLocation().equals(dest.getLocation())) {
            return false;
        }
        if (dest.getFileSizeThreshold() == null) {
            dest.setFileSizeThreshold(src.getFileSizeThreshold());
        } else if (src.getFileSizeThreshold() != null && failOnConflict && !src.getFileSizeThreshold().equals(dest.getFileSizeThreshold())) {
            return false;
        }
        if (dest.getMaxFileSize() == null) {
            dest.setMaxFileSize(src.getMaxFileSize());
        } else if (src.getLocation() != null && failOnConflict && !src.getMaxFileSize().equals(dest.getMaxFileSize())) {
            return false;
        }
        if (dest.getMaxRequestSize() == null) {
            dest.setMaxRequestSize(src.getMaxRequestSize());
        } else if (src.getMaxRequestSize() != null && failOnConflict && !src.getMaxRequestSize().equals(dest.getMaxRequestSize())) {
            return false;
        }
        return true;
    }

    public static Set<WebXml> orderWebFragments(WebXml application, Map<String, WebXml> fragments) {
        boolean absoluteOrdering;
        LinkedHashSet<WebXml> orderedFragments = new LinkedHashSet<WebXml>();
        boolean bl = absoluteOrdering = application.getAbsoluteOrdering() != null;
        if (absoluteOrdering) {
            Set<String> requestedOrder = application.getAbsoluteOrdering();
            for (String requestedName : requestedOrder) {
                if (ORDER_OTHERS.equals(requestedName)) {
                    for (Map.Entry<String, WebXml> entry : fragments.entrySet()) {
                        WebXml fragment;
                        if (requestedOrder.contains(entry.getKey()) || (fragment = entry.getValue()) == null) continue;
                        orderedFragments.add(fragment);
                    }
                    continue;
                }
                WebXml fragment = fragments.get(requestedName);
                if (fragment != null) {
                    orderedFragments.add(fragment);
                    continue;
                }
                log.warn(sm.getString("webXml.wrongFragmentName", requestedName));
            }
        } else {
            String name;
            LinkedList<String> order = new LinkedList<String>();
            order.addAll(fragments.keySet());
            for (WebXml fragment : fragments.values()) {
                name = fragment.getName();
                if (fragment.getBeforeOrdering().contains(ORDER_OTHERS)) {
                    order.remove(name);
                    order.add(0, name);
                    continue;
                }
                if (!fragment.getAfterOrdering().contains(ORDER_OTHERS)) continue;
                order.remove(name);
                order.add(name);
            }
            for (WebXml fragment : fragments.values()) {
                name = fragment.getName();
                for (String before : fragment.getBeforeOrdering()) {
                    if (before.equals(ORDER_OTHERS) || !order.contains(before) || order.indexOf(before) >= order.indexOf(name)) continue;
                    order.remove(name);
                    order.add(order.indexOf(before), name);
                }
                for (String after : fragment.getAfterOrdering()) {
                    if (after.equals(ORDER_OTHERS) || !order.contains(after) || order.indexOf(after) <= order.indexOf(name)) continue;
                    order.remove(name);
                    order.add(order.indexOf(after) + 1, name);
                }
            }
            for (WebXml fragment : fragments.values()) {
                name = fragment.getName();
                for (String before : fragment.getBeforeOrdering()) {
                    if (before.equals(ORDER_OTHERS) || !order.contains(before) || order.indexOf(before) >= order.indexOf(name)) continue;
                    throw new IllegalArgumentException(sm.getString("webXml.mergeConflictOrder"));
                }
                for (String after : fragment.getAfterOrdering()) {
                    if (after.equals(ORDER_OTHERS) || !order.contains(after) || order.indexOf(after) <= order.indexOf(name)) continue;
                    throw new IllegalArgumentException(sm.getString("webXml.mergeConflictOrder"));
                }
            }
            for (String name2 : order) {
                orderedFragments.add(fragments.get(name2));
            }
        }
        return orderedFragments;
    }
}

