/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat7.osgi.httpservice;

import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.web.base.osgi.httpservice.DefaultHttpContextImpl;
import org.ow2.jonas.web.base.osgi.httpservice.JOnASHttpService;
import org.ow2.jonas.web.base.osgi.httpservice.OSGIResourcesServlet;
import org.ow2.jonas.web.tomcat7.JOnASContextConfig;
import org.ow2.jonas.web.tomcat7.Tomcat7Service;
import org.ow2.jonas.web.tomcat7.osgi.httpservice.OSGIContext;
import org.ow2.jonas.web.tomcat7.osgi.httpservice.OSGIWrapper;
import org.ow2.jonas.web.tomcat7.versioning.ContextFinder;

public class HttpServiceImpl
implements JOnASHttpService {
    private final Bundle callerBundle;
    private final Tomcat7Service tomcatService;
    private final String workDir;
    private List<OSGIWrapper> wrapperList = null;

    public HttpServiceImpl(Bundle bundle, Tomcat7Service tomcat7Service, String workDir) {
        this.callerBundle = bundle;
        this.tomcatService = tomcat7Service;
        this.workDir = workDir;
        this.wrapperList = new LinkedList<OSGIWrapper>();
    }

    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContextImpl(this.callerBundle);
    }

    public void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException, IllegalArgumentException {
        HttpContext context = null;
        context = httpContext == null ? this.createDefaultHttpContext() : httpContext;
        OSGIResourcesServlet servlet = new OSGIResourcesServlet(context, name);
        try {
            this.registerServlet(alias, (Servlet)servlet, null, context);
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServlet(String alias, Servlet servlet, Dictionary initParams, HttpContext context) throws ServletException, NamespaceException, IllegalArgumentException {
        if (!this.checkAlias(alias)) {
            throw new IllegalArgumentException(alias + " is not a valid alias.");
        }
        List<OSGIWrapper> list = this.wrapperList;
        synchronized (list) {
            for (OSGIWrapper osgiWrapper : this.wrapperList) {
                if (osgiWrapper.getServlet() != servlet) continue;
                throw new ServletException("servlet already registered");
            }
        }
        String versionID = null;
        String userURI = null;
        String[] parsedContext = this.parseContext(alias);
        String contextRoot = parsedContext[0];
        String servletPath = parsedContext[1];
        if (this.tomcatService.isVersioningEnabled()) {
            versionID = this.getVersionId();
            if (!contextRoot.contains(versionID)) {
                userURI = contextRoot;
                contextRoot = contextRoot + versionID;
            } else {
                userURI = contextRoot.replace(versionID, "");
            }
        }
        Host host = this.tomcatService.findHost("");
        Container hostContainer = host.findChild(contextRoot);
        OSGIContext osgiContext = null;
        if (context == null) {
            context = this.createDefaultHttpContext();
        }
        if (hostContainer == null) {
            osgiContext = new OSGIContext(context);
            osgiContext.setPath(contextRoot);
            osgiContext.setName(contextRoot);
            osgiContext.setTomcatService(this.tomcatService);
            osgiContext.setJ2EEServer(this.tomcatService.getJonasServerName());
            ObjectName j2eeServerOn = J2eeObjectName.J2EEServer((String)this.tomcatService.getDomainName(), (String)this.tomcatService.getJonasServerName());
            osgiContext.setServer(j2eeServerOn.toString());
            MBeanServer mbeanServer = this.tomcatService.getJmxService().getJmxServer();
            try {
                String[] as = (String[])mbeanServer.getAttribute(j2eeServerOn, "javaVMs");
                osgiContext.setJavaVMs(as);
            }
            catch (Exception e) {
                // empty catch block
            }
            osgiContext.setDocBase(new File(this.workDir).getAbsolutePath());
            osgiContext.setInjectionMap(new HashMap<String, Map<String, String>>());
            JOnASContextConfig config = new JOnASContextConfig();
            osgiContext.addLifecycleListener(config);
            host.addChild(osgiContext);
            try {
                if (this.tomcatService.isVersioningEnabled() && userURI != null) {
                    String policy = this.tomcatService.getVersioningService().getDefaultDeploymentPolicy();
                    ContextFinder.bindContextRoot(this.callerBundle.getSymbolicName(), userURI, osgiContext, policy);
                }
                ContextFinder.addNonVersionedContext(contextRoot);
            }
            catch (Exception e) {
                throw new JWebContainerServiceException("Failed binding versioned web context", (Throwable)e);
            }
        }
        if (hostContainer instanceof OSGIContext) {
            osgiContext = (OSGIContext)hostContainer;
        } else {
            throw new NamespaceException(contextRoot + " already registered.");
        }
        if (osgiContext.findChild(servletPath) != null) {
            throw new NamespaceException(servletPath + " already registered in the context " + contextRoot + ".");
        }
        OSGIWrapper osgiWrapper = new OSGIWrapper(servlet, context);
        osgiWrapper.setName(servletPath);
        osgiWrapper.setParentClassLoader(servlet.getClass().getClassLoader());
        if (initParams != null) {
            Enumeration elements = initParams.keys();
            while (elements.hasMoreElements()) {
                String name = (String)elements.nextElement();
                osgiWrapper.addInitParameter(name, (String)initParams.get(name));
            }
        }
        List<OSGIWrapper> list2 = this.wrapperList;
        synchronized (list2) {
            this.wrapperList.add(osgiWrapper);
            osgiContext.addChild(osgiWrapper);
            servlet.init((ServletConfig)osgiWrapper);
            osgiContext.addServletMapping(servletPath + "/*", osgiWrapper.getName(), true);
        }
    }

    public void unregister(String alias) throws IllegalArgumentException {
        OSGIWrapper osgiWrapper;
        Host host;
        Context ctx;
        if (!this.checkAlias(alias)) {
            throw new IllegalArgumentException(alias + " is not a valid alias.");
        }
        String versionID = null;
        if (this.tomcatService.isVersioningEnabled()) {
            versionID = this.getVersionId();
        }
        String[] parsedContext = this.parseContext(alias);
        String contextRoot = parsedContext[0];
        String servletPath = parsedContext[1];
        if (versionID != null && !contextRoot.contains(versionID)) {
            contextRoot = contextRoot + versionID;
        }
        if ((ctx = this.findContext(host = this.tomcatService.findHost(""), contextRoot)) == null) {
            throw new IllegalArgumentException(contextRoot + " is not registered.");
        }
        if (ctx instanceof OSGIContext) {
            OSGIContext osgiContext = (OSGIContext)ctx;
            osgiWrapper = (OSGIWrapper)osgiContext.findChild(servletPath);
            if (osgiWrapper == null) {
                throw new IllegalArgumentException(servletPath + " is not registered in " + contextRoot + ".");
            }
        } else {
            throw new IllegalArgumentException(contextRoot + " is not registered by this bundle " + this.callerBundle + ".");
        }
        this.removeWrapper(osgiWrapper, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWrapper(OSGIWrapper osgiWrapper, boolean removeFromList) {
        OSGIContext osgiContext = (OSGIContext)osgiWrapper.getParent();
        List<OSGIWrapper> list = this.wrapperList;
        synchronized (list) {
            if (removeFromList) {
                this.wrapperList.remove(osgiWrapper);
            }
            osgiContext.removeServletMapping(osgiWrapper.getName() + "/*");
            osgiContext.removeChild(osgiWrapper);
        }
        if (osgiContext.getChildren().length == 0) {
            Host host = (Host)osgiContext.getParent();
            host.removeChild(osgiContext);
            if (this.tomcatService.isVersioningEnabled()) {
                ContextFinder.unbindContextRoot(osgiContext.getPath());
            }
            ContextFinder.removeNonVersionedContext(osgiContext.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        List<OSGIWrapper> list = this.wrapperList;
        synchronized (list) {
            Iterator<OSGIWrapper> itWrapper = this.wrapperList.iterator();
            while (itWrapper.hasNext()) {
                OSGIWrapper osgiWrapper = itWrapper.next();
                itWrapper.remove();
                this.removeWrapper(osgiWrapper, false);
            }
        }
    }

    private Context findContext(Host host, String alias) {
        for (Container container : host.findChildren()) {
            if (!(container instanceof Context) || !alias.equals(((Context)container).getPath())) continue;
            return (Context)container;
        }
        return null;
    }

    private String[] parseContext(String alias) {
        int contextIndex = alias.indexOf(47, 1);
        if (contextIndex >= 0) {
            return new String[]{alias.substring(0, contextIndex), alias.substring(contextIndex)};
        }
        return new String[]{alias, ""};
    }

    private boolean checkAlias(String alias) {
        if (alias == null) {
            return false;
        }
        if (alias.equals("/")) {
            return true;
        }
        return alias.startsWith("/") && !alias.endsWith("/");
    }

    private String getVersionId() {
        String SNAPSHOT_WITH_DOT = ".SNAPSHOT";
        String SNAPSHOT_WITH_HYPHEN = "-SNAPSHOT";
        String bundleVersion = (String)this.callerBundle.getHeaders().get("Bundle-Version");
        if (bundleVersion.endsWith(".SNAPSHOT")) {
            bundleVersion = bundleVersion.substring(0, bundleVersion.length() - ".SNAPSHOT".length()) + "-SNAPSHOT";
        }
        return "-" + bundleVersion;
    }
}

