/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.correlate.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.probe.JasmineCollectorInfo;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollectorService;
import org.ow2.jasmine.probe.collectors.correlate.internal.CorrelateCollector;
import org.ow2.jasmine.probe.probemanager.ProbeManager;

@Component(name="CorrelateCollectorService")
@Provides
public class CorrelateCollectorService
extends JCollectorService
implements Pojo {
    private InstanceManager __IM;
    public static final String SHORT_DESC = "Correlate several source indicator's values.";
    public static final String LONG_DESC = "The indicator definition requires the correlate operation and a list of source indicators.";
    public static final String SOURCE_DESC = "Source indicators should have their value composed of only one result (current limitation). The result must be a Number.\nFor some operators (div|sub|percent), only 2 sources are required.";
    public static final int SOURCE_MIN = 2;
    public static final int SOURCE_MAX = 3;
    public static final String PROP_OP = "op";
    public static final String PROP_OP_DESC = "Correlate operation. Must be one of : add|sub|mul|div|percent";
    public static final int OP_ADD = 1;
    public static final int OP_SUB = 2;
    public static final int OP_MUL = 3;
    public static final int OP_DIV = 4;
    public static final int OP_PERCENT = 5;
    private boolean __FindicatorType;
    @ServiceProperty(name="indicator.type", value="correlate")
    private String indicatorType;
    private boolean __FprobeManager;
    @Requires
    ProbeManager probeManager;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe;
    private boolean __MgetDependantIndicators$org_ow2_jasmine_probe_JasmineIndicator;
    private boolean __MisNumeric$java_lang_String;

    String __getindicatorType() {
        if (!this.__FindicatorType) {
            return this.indicatorType;
        }
        return (String)this.__IM.onGet((Object)this, "indicatorType");
    }

    void __setindicatorType(String string) {
        if (!this.__FindicatorType) {
            this.indicatorType = string;
            return;
        }
        this.__IM.onSet((Object)this, "indicatorType", (Object)string);
    }

    ProbeManager __getprobeManager() {
        if (!this.__FprobeManager) {
            return this.probeManager;
        }
        return (ProbeManager)this.__IM.onGet((Object)this, "probeManager");
    }

    void __setprobeManager(ProbeManager probeManager) {
        if (!this.__FprobeManager) {
            this.probeManager = probeManager;
            return;
        }
        this.__IM.onSet((Object)this, "probeManager", (Object)probeManager);
    }

    public CorrelateCollectorService() {
        this(null);
    }

    private CorrelateCollectorService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setprobeManager(null);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        this.collectorInfo = new JasmineCollectorInfo();
        this.collectorInfo.setType(this.__getindicatorType());
        this.collectorInfo.setShortDesc(SHORT_DESC);
        this.collectorInfo.setLongDesc(LONG_DESC);
        this.collectorInfo.setSourceDesc(SOURCE_DESC);
        this.collectorInfo.setSourceMin(2);
        this.collectorInfo.setSourceMax(3);
        this.properties = new ArrayList();
        this.properties.add(new JasminePropertyInfo(PROP_OP, PROP_OP_DESC, true));
        this.collectorInfo.setPropertyInfos(this.properties);
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() {
        this.removeCollectors(null, null);
    }

    public JasmineCollector getCollector(JasmineIndicator jasmineIndicator, JasmineProbe jasmineProbe) throws JasmineCollectorException {
        JasmineCollector jasmineCollector;
        if (!this.__MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe) {
            return this.__getCollector(jasmineIndicator, jasmineProbe);
        }
        try {
            this.__IM.onEntry((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe", new Object[]{jasmineIndicator, jasmineProbe});
            jasmineCollector = this.__getCollector(jasmineIndicator, jasmineProbe);
            this.__IM.onExit((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe", (Object)jasmineCollector);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe", throwable);
            throw throwable;
        }
        return jasmineCollector;
    }

    private JasmineCollector __getCollector(JasmineIndicator indicator, JasmineProbe probe) throws JasmineCollectorException {
        if (!indicator.getType().equals(this.__getindicatorType())) {
            this.logger.error((Object)("Bad type: " + indicator.getType()), new Object[0]);
            throw new JasmineCollectorException("Bad type: " + indicator.getType());
        }
        Map props = indicator.getProperties();
        String operation = (String)props.get(PROP_OP);
        if (operation == null) {
            String err = "Operation not defined in " + indicator.getName();
            this.logger.error((Object)err, new Object[0]);
            throw new JasmineCollectorException(err);
        }
        int ope = 0;
        if (operation.equalsIgnoreCase("add")) {
            ope = 1;
        } else if (operation.equalsIgnoreCase("sub")) {
            ope = 2;
        } else if (operation.equalsIgnoreCase("mul")) {
            ope = 3;
        } else if (operation.equalsIgnoreCase("div")) {
            ope = 4;
        } else if (operation.equalsIgnoreCase("percent")) {
            ope = 5;
        } else {
            String err = "Operation not supported in CorrelateCollectorService: " + operation;
            this.logger.error((Object)err, new Object[0]);
            throw new JasmineCollectorException(err);
        }
        ArrayList<JasmineCollector> sources = new ArrayList<JasmineCollector>();
        List inames = indicator.getSources();
        if (inames == null) {
            String err = "No sources defined in " + indicator.getName();
            this.logger.error((Object)err, new Object[0]);
            throw new JasmineCollectorException(err);
        }
        for (String iname : inames) {
            JasmineCollector source = null;
            try {
                source = this.__getprobeManager().getCollector(iname, probe.getId());
            }
            catch (JasmineProbeException e) {
                this.logger.error((Object)("Cannot get value: " + (Object)((Object)e)), new Object[0]);
                throw new JasmineCollectorException(e.getMessage());
            }
            sources.add(source);
        }
        CorrelateCollector collector = new CorrelateCollector(probe.getId(), indicator, probe.getPeriod(), ope, sources);
        this.addCollector(indicator.getName(), collector);
        return collector;
    }

    public List<String> getDependantIndicators(JasmineIndicator jasmineIndicator) {
        List<String> list;
        if (!this.__MgetDependantIndicators$org_ow2_jasmine_probe_JasmineIndicator) {
            return this.__getDependantIndicators(jasmineIndicator);
        }
        try {
            this.__IM.onEntry((Object)this, "getDependantIndicators$org_ow2_jasmine_probe_JasmineIndicator", new Object[]{jasmineIndicator});
            list = this.__getDependantIndicators(jasmineIndicator);
            this.__IM.onExit((Object)this, "getDependantIndicators$org_ow2_jasmine_probe_JasmineIndicator", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDependantIndicators$org_ow2_jasmine_probe_JasmineIndicator", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getDependantIndicators(JasmineIndicator indic) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String iname : indic.getSources()) {
            if (this.isNumeric(iname)) continue;
            ret.add(iname);
        }
        return ret;
    }

    private boolean isNumeric(String string) {
        boolean bl;
        if (!this.__MisNumeric$java_lang_String) {
            return this.__isNumeric(string);
        }
        try {
            this.__IM.onEntry((Object)this, "isNumeric$java_lang_String", new Object[]{string});
            bl = this.__isNumeric(string);
            this.__IM.onExit((Object)this, "isNumeric$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isNumeric$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isNumeric(String s) {
        return s.matches("((-|\\+)?[0-9]+(\\.[0-9]+)?)+");
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("probeManager")) {
                this.__FprobeManager = true;
            }
            if (set.contains("indicatorType")) {
                this.__FindicatorType = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe")) {
                this.__MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe = true;
            }
            if (set.contains("getDependantIndicators$org_ow2_jasmine_probe_JasmineIndicator")) {
                this.__MgetDependantIndicators$org_ow2_jasmine_probe_JasmineIndicator = true;
            }
            if (set.contains("isNumeric$java_lang_String")) {
                this.__MisNumeric$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

