/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.report.extensions.endpoints.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.endpoint.collector.IEndpoint;
import org.ow2.jonas.report.api.IReportExtension;
import org.ow2.jonas.report.extensions.endpoints.generated.EndpointType;
import org.ow2.jonas.report.extensions.endpoints.generated.Endpoints;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class EndpointsReportExtension
implements IReportExtension,
Pojo {
    private InstanceManager __IM;
    public static final Log logger = LogFactory.getLog(EndpointsReportExtension.class);
    public static final String XSD_PATH = "xsd/endpoints-report.xsd";
    private boolean __Fendpoints;
    private List<IEndpoint> endpoints;
    private boolean __MgenerateReport;
    private boolean __MgetXsd;
    private boolean __MgetRootClass;
    private boolean __MbindEndpoint$org_ow2_jonas_endpoint_collector_IEndpoint;
    private boolean __MunbindEndpoint$org_ow2_jonas_endpoint_collector_IEndpoint;

    List __getendpoints() {
        if (!this.__Fendpoints) {
            return this.endpoints;
        }
        return (List)this.__IM.onGet((Object)this, "endpoints");
    }

    void __setendpoints(List list) {
        if (!this.__Fendpoints) {
            this.endpoints = list;
            return;
        }
        this.__IM.onSet((Object)this, "endpoints", (Object)list);
    }

    public EndpointsReportExtension() {
        this(null);
    }

    private EndpointsReportExtension(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setendpoints(new ArrayList());
    }

    public Object generateReport() {
        Object object;
        if (!this.__MgenerateReport) {
            return this.__M_generateReport();
        }
        try {
            this.__IM.onEntry((Object)this, "generateReport", new Object[0]);
            object = this.__M_generateReport();
            this.__IM.onExit((Object)this, "generateReport", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generateReport", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_generateReport() {
        Endpoints endpoints = new Endpoints();
        List<EndpointType> endpointTypeList = endpoints.getEndpoint();
        for (IEndpoint endpoint : this.__getendpoints()) {
            EndpointType endpointType = new EndpointType();
            endpointType.setHost(endpoint.getHost());
            endpointType.setProtocol(endpoint.getProtocol());
            endpointType.setUrl(endpoint.getUrl());
            endpointType.setSource(endpoint.getSource());
            endpointType.setPort(endpoint.getPort());
            endpointTypeList.add(endpointType);
        }
        return endpoints;
    }

    public Source getXsd() {
        Source source;
        if (!this.__MgetXsd) {
            return this.__M_getXsd();
        }
        try {
            this.__IM.onEntry((Object)this, "getXsd", new Object[0]);
            source = this.__M_getXsd();
            this.__IM.onExit((Object)this, "getXsd", (Object)source);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getXsd", throwable);
            throw throwable;
        }
        return source;
    }

    private Source __M_getXsd() {
        InputStream xsd = this.getRootClass().getClassLoader().getResourceAsStream(XSD_PATH);
        StreamSource source = null;
        if (xsd != null) {
            source = new StreamSource(xsd);
        } else {
            logger.error((Object)"Cannot find XSD xsd/endpoints-report.xsd", new Object[0]);
        }
        return source;
    }

    public Class getRootClass() {
        Class clazz;
        if (!this.__MgetRootClass) {
            return this.__M_getRootClass();
        }
        try {
            this.__IM.onEntry((Object)this, "getRootClass", new Object[0]);
            clazz = this.__M_getRootClass();
            this.__IM.onExit((Object)this, "getRootClass", (Object)clazz);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRootClass", throwable);
            throw throwable;
        }
        return clazz;
    }

    private Class __M_getRootClass() {
        return Endpoints.class;
    }

    public void bindEndpoint(IEndpoint iEndpoint) {
        if (!this.__MbindEndpoint$org_ow2_jonas_endpoint_collector_IEndpoint) {
            this.__M_bindEndpoint(iEndpoint);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindEndpoint$org_ow2_jonas_endpoint_collector_IEndpoint", new Object[]{iEndpoint});
            this.__M_bindEndpoint(iEndpoint);
            this.__IM.onExit((Object)this, "bindEndpoint$org_ow2_jonas_endpoint_collector_IEndpoint", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindEndpoint$org_ow2_jonas_endpoint_collector_IEndpoint", throwable);
            throw throwable;
        }
    }

    private void __M_bindEndpoint(IEndpoint endpoint) {
        if (!this.__getendpoints().contains(endpoint)) {
            this.__getendpoints().add(endpoint);
        }
    }

    public void unbindEndpoint(IEndpoint iEndpoint) {
        if (!this.__MunbindEndpoint$org_ow2_jonas_endpoint_collector_IEndpoint) {
            this.__M_unbindEndpoint(iEndpoint);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindEndpoint$org_ow2_jonas_endpoint_collector_IEndpoint", new Object[]{iEndpoint});
            this.__M_unbindEndpoint(iEndpoint);
            this.__IM.onExit((Object)this, "unbindEndpoint$org_ow2_jonas_endpoint_collector_IEndpoint", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindEndpoint$org_ow2_jonas_endpoint_collector_IEndpoint", throwable);
            throw throwable;
        }
    }

    private void __M_unbindEndpoint(IEndpoint endpoint) {
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("endpoints")) {
            this.__Fendpoints = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("generateReport")) {
                this.__MgenerateReport = true;
            }
            if (set.contains("getXsd")) {
                this.__MgetXsd = true;
            }
            if (set.contains("getRootClass")) {
                this.__MgetRootClass = true;
            }
            if (set.contains("bindEndpoint$org_ow2_jonas_endpoint_collector_IEndpoint")) {
                this.__MbindEndpoint$org_ow2_jonas_endpoint_collector_IEndpoint = true;
            }
            if (set.contains("unbindEndpoint$org_ow2_jonas_endpoint_collector_IEndpoint")) {
                this.__MunbindEndpoint$org_ow2_jonas_endpoint_collector_IEndpoint = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

