/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import javax.ejb.EJBException;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.RemoveException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.ejb21.EJBInvocation;
import org.ow2.jonas.lib.ejb21.JLocal;
import org.ow2.jonas.lib.ejb21.JSessionFactory;
import org.ow2.jonas.lib.ejb21.JSessionSwitch;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;

public abstract class JSessionLocal
extends JLocal {
    protected JSessionFactory bf;
    protected JSessionSwitch bs;

    public JSessionLocal(JSessionFactory bf) {
        super(bf);
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        this.bf = bf;
    }

    public abstract void remove() throws RemoveException;

    public EJBLocalHome getEJBLocalHome() {
        return this.bf.getLocalHome();
    }

    public Object getPrimaryKey() throws EJBException {
        throw new EJBException("Session bean has no primary key");
    }

    public boolean isIdentical(EJBLocalObject obj) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        boolean ret = false;
        JSessionFactory sf = this.bf;
        if (sf.isStateful()) {
            if (obj != null) {
                ret = obj.equals(this);
            }
        } else if (obj != null) {
            try {
                JSessionLocal ejb2 = (JSessionLocal)obj;
                JSessionSwitch bs2 = ejb2.getSessionSwitch();
                JSessionFactory bf2 = bs2.getBeanFactory();
                ret = bf2.equals(sf);
            }
            catch (Exception e) {
                TraceEjb.logger.log(BasicLevel.WARN, (Object)("exception:" + e));
                throw new EJBException("isIdentical failed", e);
            }
        }
        return ret;
    }

    public void setSessionSwitch(JSessionSwitch bs) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        this.bs = bs;
    }

    public JSessionSwitch getSessionSwitch() {
        return this.bs;
    }

    public RequestCtx preInvoke(int txa) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        RequestCtx rctx = this.bf.preInvoke(txa);
        this.bs.setMustCommit(rctx.mustCommit);
        this.bs.enlistConnections(rctx.currTx);
        return rctx;
    }

    public void checkSecurity(EJBInvocation ejbInv) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        this.bf.checkSecurity(ejbInv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(RequestCtx rctx) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        this.bs.delistConnections(rctx.currTx);
        this.bs.saveBeanTx();
        try {
            this.bf.postInvoke(rctx);
            Object var3_2 = null;
            this.bs.releaseICtx(rctx, rctx.sysExc != null);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.bs.releaseICtx(rctx, rctx.sysExc != null);
            throw throwable;
        }
    }
}

