/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.manager;

import java.util.ArrayList;
import java.util.List;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.JasmineProbeResult;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collector.JasmineCollectorService;
import org.ow2.jasmine.probe.manager.internal.JProbeManager;
import org.ow2.jasmine.probe.outer.JasmineOuter;
import org.ow2.jasmine.probe.outer.JasmineOuterException;
import org.ow2.jasmine.probe.outer.JasmineOuterService;
import org.ow2.jasmine.probe.outers.JOuter;
import org.ow2.jasmine.probe.probescheduler.SchedulerException;
import org.ow2.jasmine.probe.probescheduler.TaskReference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JProbe
implements Runnable {
    protected static Log logger = LogFactory.getLog(JProbe.class);
    private JasmineProbe probeDef;
    private JProbeManager probeMgr;
    private TaskReference task;
    private List<JasmineCollector> collectors;
    private List<JasmineOuter> outers;
    private List<JasmineTarget> targets;

    public JProbe(JasmineProbe def, JProbeManager mgr) {
        this.probeDef = def;
        this.probeMgr = mgr;
        def.setError("");
        this.outers = new ArrayList<JasmineOuter>();
        this.collectors = new ArrayList<JasmineCollector>();
        this.targets = new ArrayList<JasmineTarget>();
    }

    public JasmineProbe getProbeDef() {
        return this.probeDef;
    }

    public int getStatus() {
        return this.probeDef.getStatus();
    }

    public void setStatus(int state) {
        this.probeDef.setStatus(state);
    }

    public void setError(String mess) {
        this.probeDef.setError(mess);
    }

    public boolean isRunning() {
        return this.getStatus() == 2 || this.getStatus() == 1;
    }

    public void resume() throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        try {
            this.buildTargets();
        }
        catch (JasmineProbeException e) {
            this.targets.clear();
            throw e;
        }
        try {
            this.buildOuters();
        }
        catch (JasmineProbeException e) {
            this.outers.clear();
            throw e;
        }
        if (this.outers.isEmpty()) {
            String errorMess = "Cannot start probe " + this.probeDef.getId() + " as no output definied";
            JasmineProbeException e = new JasmineProbeException(errorMess);
            logger.error((Object)"Cannot start probe {0} as no output defined", new Object[]{this.probeDef.getId()});
            this.probeMgr.setProbeState(this, 3, errorMess);
            throw e;
        }
        try {
            this.buildCollectors();
        }
        catch (JasmineProbeException e) {
            this.collectors.clear();
            this.probeMgr.setProbeState(this, 3, e.getMessage());
            throw e;
        }
        for (JasmineCollector collector : this.collectors) {
            if (collector != null) {
                collector.startPolling();
                continue;
            }
            logger.error((Object)"Cannot start probe {0}. Found null elements in its collectors list", new Object[]{this.probeDef.getId()});
            this.probeMgr.setProbeState(this, 3, "Found null in collector list");
            return;
        }
        try {
            long ms = (long)this.probeDef.getPeriod() * 1000L;
            this.task = this.probeMgr.getScheduler().schedulePeriodicTask(null, (Runnable)this, 0L, ms);
            logger.debug((Object)(this.probeDef.getId() + " should be started now"), new Object[0]);
            this.probeMgr.setProbeState(this, 2, null);
        }
        catch (SchedulerException e) {
            logger.error((Object)"Error when trying to start probe : {0}: {1}", new Object[]{this.probeDef.getId(), e});
            this.probeMgr.setProbeState(this, 3, e.getMessage());
        }
    }

    public void resetTimer() {
        logger.debug((Object)(this.probeDef.getId() + " timer reset to " + this.probeDef.getPeriod()), new Object[0]);
        long ms = (long)this.probeDef.getPeriod() * 1000L;
        this.task.changeTimeout(ms);
    }

    public void resetIndicators() {
        try {
            this.removeCollectors();
        }
        catch (JasmineProbeException e) {
            this.probeMgr.setProbeState(this, 3, null);
        }
    }

    public void resetOutputs() {
        this.removeOuters();
    }

    public void resetTargets() {
        try {
            this.removeTargets();
        }
        catch (JasmineProbeException e) {
            this.probeMgr.setProbeState(this, 3, null);
        }
    }

    public void resetTarget(JasmineTarget target) {
        try {
            this.removeTarget(target);
        }
        catch (JasmineProbeException e) {
            this.probeMgr.setProbeState(this, 3, null);
        }
    }

    public boolean suspend() {
        boolean ret = this.isRunning();
        if (this.task != null) {
            this.task.cancel(true);
            this.task = null;
        }
        for (JasmineOuter outer : this.outers) {
            outer.flushData();
        }
        for (JasmineCollector collector : this.collectors) {
            collector.stopPolling();
        }
        this.probeMgr.setProbeState(this, 0, null);
        return ret;
    }

    @Override
    public void run() {
        logger.debug((Object)"", new Object[0]);
        JasmineProbeResult result = new JasmineProbeResult(this.probeDef.getId());
        for (JasmineCollector collector : this.collectors) {
            try {
                JasmineIndicatorValue val = collector.getLastResult();
                if (val != null) {
                    result.addValue(val);
                    continue;
                }
                logger.debug((Object)"No result found for indicator {0} in probe {1}", new Object[]{collector.getIndicatorName(), this.probeDef.getId()});
            }
            catch (JasmineCollectorException e) {
                logger.warn((Object)("Cannot get results for {0} in probe {1} : " + (Object)((Object)e)), new Object[]{collector.getIndicatorName(), this.probeDef.getId()});
            }
            catch (NullPointerException e) {
                logger.error((Object)"NPE in run method", new Object[]{e});
            }
        }
        for (JasmineOuter outer : this.outers) {
            outer.publishData(result);
        }
    }

    private void buildOuters() throws JasmineProbeException {
        if (!this.outers.isEmpty()) {
            boolean rebuild = false;
            for (JasmineOuter outer : this.outers) {
                if (!outer.isRemoved()) continue;
                rebuild = true;
                break;
            }
            if (rebuild) {
                this.outers.clear();
            } else {
                return;
            }
        }
        for (String outputname : this.probeDef.getOutputList()) {
            JasmineOutput output = this.probeMgr.getOutput(outputname);
            if (output == null) {
                logger.error((Object)("unknown output : " + outputname), new Object[0]);
                throw new JasmineProbeException("unknown output : " + outputname);
            }
            JasmineOuterService jos = this.probeMgr.getOuterService(output.getType());
            if (jos == null) {
                logger.error((Object)"No OuterService found for {0} having type {1}", new Object[]{outputname, output.getType()});
                throw new JasmineProbeException("No OuterService found for " + outputname);
            }
            JasmineOuter jo = null;
            try {
                jo = jos.getOuter(output);
            }
            catch (JasmineOuterException e) {
                logger.error((Object)("Could not get the Outer for " + outputname + ": " + (Object)((Object)e)), new Object[0]);
                throw new JasmineProbeException("Could not get the Outer for " + outputname);
            }
            this.outers.add(jo);
        }
    }

    private void removeOuters() {
        for (JasmineOuter outer : this.outers) {
            JasmineOutput output = ((JOuter)outer).getOutput();
            JasmineOuterService jos = this.probeMgr.getOuterService(output.getType());
            if (jos == null) continue;
            jos.removeOuters(output.getName());
        }
        this.outers.clear();
    }

    private void removeTargets() throws JasmineProbeException {
        ArrayList<JasmineTarget> toRemove = new ArrayList<JasmineTarget>();
        for (JasmineTarget target : this.targets) {
            toRemove.add(target);
        }
        for (JasmineTarget target : toRemove) {
            this.removeTarget(target);
        }
    }

    private void removeTarget(JasmineTarget target) throws JasmineProbeException {
        boolean ok = true;
        ArrayList<String> allindics = new ArrayList<String>();
        String name = target.getName();
        if (this.targets.contains(target)) {
            for (JasmineCollector coll : this.collectors) {
                allindics.add(coll.getIndicatorName());
            }
            this.targets.clear();
        } else {
            for (JasmineCollector coll : this.collectors) {
                String indicname = coll.getIndicatorName();
                allindics.add(indicname);
                try {
                    JasmineIndicator indic = this.probeMgr.getIndicator(indicname);
                    JasmineCollectorService jcs = this.probeMgr.getCollectorService(indic.getType());
                    allindics.addAll(jcs.getDependantIndicators(indic));
                }
                catch (JasmineProbeException e) {
                    logger.error((Object)"Cannot remove targets for probe {0}. Seems that JasmineIndicator {1} does not exists anymore.", new Object[]{this.probeDef.getId(), indicname});
                    ok = false;
                }
            }
        }
        for (String indicname : allindics) {
            try {
                JasmineIndicator indic = this.probeMgr.getIndicator(indicname);
                JasmineCollectorService jcs = this.probeMgr.getCollectorService(indic.getType());
                jcs.removeTarget(name);
                jcs.removeCollectors(indicname, this.probeDef.getId());
            }
            catch (JasmineProbeException e) {
                logger.error((Object)"Cannot remove targets for probe {0}. Seems that JasmineIndicator {1} does not exists anymore.", new Object[]{this.probeDef.getId(), indicname});
                ok = false;
            }
        }
        if (!ok) {
            throw new JasmineProbeException("Errors when trying to remove the targets for probe: " + this.probeDef.getId());
        }
    }

    private void buildTargets() throws JasmineProbeException {
        if (!this.targets.isEmpty()) {
            return;
        }
        for (String targetname : this.probeDef.getTargetList()) {
            JasmineTarget target = this.probeMgr.getTarget(targetname);
            if (target == null) {
                logger.error((Object)("unknown target : " + targetname), new Object[0]);
                throw new JasmineProbeException("unknown target : " + targetname);
            }
            this.targets.add(target);
        }
    }

    private void buildCollectors() throws JasmineProbeException {
        if (!this.collectors.isEmpty()) {
            boolean rebuild = false;
            for (JasmineCollector coll : this.collectors) {
                if (!coll.isRemoved()) continue;
                rebuild = true;
                break;
            }
            if (rebuild) {
                for (JasmineCollector coll : this.collectors) {
                    if (coll.isRemoved()) continue;
                    coll.stopPolling();
                    coll.remove();
                }
                this.collectors.clear();
            } else {
                return;
            }
        }
        for (String indicname : this.probeDef.getIndicatorList()) {
            JasmineIndicator indic = this.probeMgr.getIndicator(indicname);
            if (indic == null) {
                logger.error((Object)("unknown indicator : " + indicname), new Object[0]);
                throw new JasmineProbeException("unknown indicator : " + indicname);
            }
            JasmineCollectorService jcs = this.probeMgr.getCollectorService(indic.getType());
            if (jcs == null) {
                logger.error((Object)"No CollectorService found for {0} having type {1}", new Object[]{indicname, indic.getType()});
                throw new JasmineProbeException("No CollectorService found for " + indicname);
            }
            JasmineCollector coll = null;
            try {
                coll = jcs.getCollector(indic, this.probeDef);
            }
            catch (JasmineCollectorException e) {
                logger.error((Object)("Could not get the Collector for " + indicname + ": " + (Object)((Object)e)), new Object[0]);
                throw new JasmineProbeException("Could not get the Collector for " + indicname + " (" + e.getMessage() + ")");
            }
            this.collectors.add(coll);
        }
    }

    private void removeCollectors() throws JasmineProbeException {
        boolean ok = true;
        ArrayList<String> allindics = new ArrayList<String>();
        for (JasmineCollector coll : this.collectors) {
            String indicname = coll.getIndicatorName();
            allindics.add(indicname);
            try {
                JasmineIndicator indic = this.probeMgr.getIndicator(indicname);
                JasmineCollectorService jcs = this.probeMgr.getCollectorService(indic.getType());
                allindics.addAll(jcs.getDependantIndicators(indic));
            }
            catch (JasmineProbeException e) {
                logger.error((Object)"Cannot remove collectors for probe {0}. Seems that JasmineIndicator {1} does not exists anymore.", new Object[]{this.probeDef.getId(), indicname});
                ok = false;
            }
        }
        for (String indicname : allindics) {
            JasmineIndicator indic = this.probeMgr.getIndicator(indicname);
            JasmineCollectorService jcs = this.probeMgr.getCollectorService(indic.getType());
            jcs.removeCollectors(indicname, this.probeDef.getId());
        }
        this.collectors.clear();
        if (!ok) {
            throw new JasmineProbeException("Errors when trying to remove the collectors for probe: " + this.probeDef.getId());
        }
    }
}

