/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.manager.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.ObjectName;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Unbind;
import org.apache.felix.ipojo.annotations.Validate;
import org.osgi.framework.ServiceReference;
import org.ow2.jasmine.probe.JProbeManagerMXBean;
import org.ow2.jasmine.probe.JasmineCollectorInfo;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineOutput;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.JasmineProbeListener;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.PropertyMissingException;
import org.ow2.jasmine.probe.SourceNumberException;
import org.ow2.jasmine.probe.TypeNotSupportedException;
import org.ow2.jasmine.probe.api.generated.IndicatorBaseType;
import org.ow2.jasmine.probe.api.generated.ObjectFactory;
import org.ow2.jasmine.probe.api.generated.OutputBaseType;
import org.ow2.jasmine.probe.api.generated.ProbeConfig;
import org.ow2.jasmine.probe.api.generated.ProbeType;
import org.ow2.jasmine.probe.api.generated.PropType;
import org.ow2.jasmine.probe.api.generated.StatusType;
import org.ow2.jasmine.probe.api.generated.TargetBaseType;
import org.ow2.jasmine.probe.collector.JasmineAggregateService;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collector.JasmineCollectorService;
import org.ow2.jasmine.probe.manager.JProbe;
import org.ow2.jasmine.probe.mbeans.AB;
import org.ow2.jasmine.probe.mbeans.CD;
import org.ow2.jasmine.probe.mbeans.TestOpenMBean;
import org.ow2.jasmine.probe.outer.JasmineOuterService;
import org.ow2.jasmine.probe.outers.JOuterService;
import org.ow2.jasmine.probe.probemanager.ProbeManager;
import org.ow2.jasmine.probe.probescheduler.SchedulerService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component(name="JasmineProbeManagerService")
@Provides
public class JProbeManager
implements JasmineProbeManager,
ProbeManager,
JProbeManagerMXBean,
Pojo {
    private InstanceManager __IM;
    protected static Log logger = LogFactory.getLog(JProbe.class);
    private boolean __FprobeConfig;
    private ProbeConfig probeConfig;
    private boolean __Fprobedefs;
    private Map<String, JasmineProbe> probedefs;
    private boolean __Foutputs;
    private Map<String, JasmineOutput> outputs;
    private boolean __Findicators;
    private Map<String, JasmineIndicator> indicators;
    private boolean __Ftargets;
    private Map<String, JasmineTarget> targets;
    private boolean __Fprobes;
    private Map<String, JProbe> probes;
    private boolean __Fouterservices;
    private Map<String, JasmineOuterService> outerservices;
    private boolean __Fcollectorservices;
    private Map<String, JasmineCollectorService> collectorservices;
    private boolean __Faggregateservices;
    private Map<String, JasmineAggregateService> aggregateservices;
    private boolean __FprobeListeners;
    private List<JasmineProbeListener> probeListeners;
    private boolean __FdefaultOutputList;
    private List<String> defaultOutputList;
    private boolean __FprobeCount;
    private int probeCount;
    private boolean __FmbeanObjectName;
    private ObjectName mbeanObjectName;
    private boolean __FjasmineProbeScheduler;
    @Requires
    protected SchedulerService jasmineProbeScheduler;
    private boolean __FjmxService;
    @Requires
    protected JmxService jmxService;
    private boolean __Mstart;
    private boolean __MregisterMBeans;
    private boolean __MunregisterMBeans;
    private boolean __Mstop;
    private boolean __MbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference;
    private boolean __MunbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference;
    private boolean __MbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference;
    private boolean __MunbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference;
    private boolean __MbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference;
    private boolean __MunbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference;
    private boolean __MgetScheduler;
    private boolean __MgetOuterService$java_lang_String;
    private boolean __MgetCollectorService$java_lang_String;
    private boolean __McreateProbe$org_ow2_jasmine_probe_JasmineProbe;
    private boolean __MremoveProbe$java_lang_String;
    private boolean __MremoveAllProbes;
    private boolean __MgetProbes;
    private boolean __MlistProbes;
    private boolean __MgetProbe$java_lang_String;
    private boolean __MstartProbe$java_lang_String;
    private boolean __MstopProbe$java_lang_String;
    private boolean __MstartAllProbes;
    private boolean __MstopAllProbes;
    private boolean __MchangeProbe$org_ow2_jasmine_probe_JasmineProbe;
    private boolean __MchangeProbePeriod$java_lang_String$int;
    private boolean __McreateOutput$org_ow2_jasmine_probe_JasmineOutput;
    private boolean __MchangeOutput$org_ow2_jasmine_probe_JasmineOutput;
    private boolean __MremoveOutput$java_lang_String;
    private boolean __MlistOutputs$java_lang_String;
    private boolean __MgetOutputs;
    private boolean __MaddDefaultOutput$java_lang_String;
    private boolean __MlistDefaultOutputs;
    private boolean __MremoveDefaultOutput$java_lang_String;
    private boolean __MgetOutputs$java_lang_String;
    private boolean __MgetOutput$java_lang_String;
    private boolean __MgetOutputPropertyInfos$java_lang_String;
    private boolean __MgetOutputTypes;
    private boolean __MgetOutputCurrentUse$java_lang_String;
    private boolean __McreateIndicator$org_ow2_jasmine_probe_JasmineIndicator;
    private boolean __MchangeIndicator$org_ow2_jasmine_probe_JasmineIndicator;
    private boolean __MremoveIndicator$java_lang_String;
    private boolean __MgetIndicator$java_lang_String;
    private boolean __MgetIndicators;
    private boolean __MgetIndicators$java_lang_String;
    private boolean __MlistIndicators$java_lang_String;
    private boolean __MgetIndicatorTypeInfo$java_lang_String;
    private boolean __MgetIndicatorTypes;
    private boolean __MgetIndicatorCurrentUse$java_lang_String;
    private boolean __McreateTarget$org_ow2_jasmine_probe_JasmineTarget;
    private boolean __MchangeTarget$org_ow2_jasmine_probe_JasmineTarget;
    private boolean __MremoveTarget$java_lang_String;
    private boolean __MlistTargets;
    private boolean __MgetTargets;
    private boolean __MgetTarget$java_lang_String;
    private boolean __MgetTargetPropertyInfos$java_lang_String;
    private boolean __MgetTargetTypes;
    private boolean __MaddProbeListener$org_ow2_jasmine_probe_JasmineProbeListener;
    private boolean __MremoveProbeListener$org_ow2_jasmine_probe_JasmineProbeListener;
    private boolean __MsaveConfig$java_lang_String;
    private boolean __MloadConfig$java_lang_String;
    private boolean __MgetCollector$java_lang_String$java_lang_String;
    private boolean __MgetAggregateFuntions;
    private boolean __MgetAggregate$java_lang_String;
    private boolean __MgetDomainName;
    private boolean __MgetServerName;
    private boolean __McreateOutputInternal$org_ow2_jasmine_probe_JasmineOutput$boolean;
    private boolean __McreateIndicatorInternal$org_ow2_jasmine_probe_JasmineIndicator$boolean;
    private boolean __MgetNewProbeId;
    private boolean __MreadConfig;
    private boolean __MsaveConfigFile$java_io_OutputStream;
    private boolean __MloadConfigFile$java_io_InputStream;
    private boolean __MisDefUsed$java_lang_Object$boolean;
    private boolean __MprobesUsingDef$java_lang_Object$boolean;
    private boolean __MprobeUsingDef$org_ow2_jasmine_probe_JasmineProbe$java_lang_Object;
    private boolean __MsetProbeState$org_ow2_jasmine_probe_manager_JProbe$int$java_lang_String;
    private boolean __MstartWaitingProbes;
    private boolean __MgetRecursiveIndicatorList$org_ow2_jasmine_probe_JasmineProbe;

    ProbeConfig __getprobeConfig() {
        if (!this.__FprobeConfig) {
            return this.probeConfig;
        }
        return (ProbeConfig)this.__IM.onGet((Object)this, "probeConfig");
    }

    void __setprobeConfig(ProbeConfig probeConfig) {
        if (!this.__FprobeConfig) {
            this.probeConfig = probeConfig;
            return;
        }
        this.__IM.onSet((Object)this, "probeConfig", (Object)probeConfig);
    }

    Map __getprobedefs() {
        if (!this.__Fprobedefs) {
            return this.probedefs;
        }
        return (Map)this.__IM.onGet((Object)this, "probedefs");
    }

    void __setprobedefs(Map map) {
        if (!this.__Fprobedefs) {
            this.probedefs = map;
            return;
        }
        this.__IM.onSet((Object)this, "probedefs", (Object)map);
    }

    Map __getoutputs() {
        if (!this.__Foutputs) {
            return this.outputs;
        }
        return (Map)this.__IM.onGet((Object)this, "outputs");
    }

    void __setoutputs(Map map) {
        if (!this.__Foutputs) {
            this.outputs = map;
            return;
        }
        this.__IM.onSet((Object)this, "outputs", (Object)map);
    }

    Map __getindicators() {
        if (!this.__Findicators) {
            return this.indicators;
        }
        return (Map)this.__IM.onGet((Object)this, "indicators");
    }

    void __setindicators(Map map) {
        if (!this.__Findicators) {
            this.indicators = map;
            return;
        }
        this.__IM.onSet((Object)this, "indicators", (Object)map);
    }

    Map __gettargets() {
        if (!this.__Ftargets) {
            return this.targets;
        }
        return (Map)this.__IM.onGet((Object)this, "targets");
    }

    void __settargets(Map map) {
        if (!this.__Ftargets) {
            this.targets = map;
            return;
        }
        this.__IM.onSet((Object)this, "targets", (Object)map);
    }

    Map __getprobes() {
        if (!this.__Fprobes) {
            return this.probes;
        }
        return (Map)this.__IM.onGet((Object)this, "probes");
    }

    void __setprobes(Map map) {
        if (!this.__Fprobes) {
            this.probes = map;
            return;
        }
        this.__IM.onSet((Object)this, "probes", (Object)map);
    }

    Map __getouterservices() {
        if (!this.__Fouterservices) {
            return this.outerservices;
        }
        return (Map)this.__IM.onGet((Object)this, "outerservices");
    }

    void __setouterservices(Map map) {
        if (!this.__Fouterservices) {
            this.outerservices = map;
            return;
        }
        this.__IM.onSet((Object)this, "outerservices", (Object)map);
    }

    Map __getcollectorservices() {
        if (!this.__Fcollectorservices) {
            return this.collectorservices;
        }
        return (Map)this.__IM.onGet((Object)this, "collectorservices");
    }

    void __setcollectorservices(Map map) {
        if (!this.__Fcollectorservices) {
            this.collectorservices = map;
            return;
        }
        this.__IM.onSet((Object)this, "collectorservices", (Object)map);
    }

    Map __getaggregateservices() {
        if (!this.__Faggregateservices) {
            return this.aggregateservices;
        }
        return (Map)this.__IM.onGet((Object)this, "aggregateservices");
    }

    void __setaggregateservices(Map map) {
        if (!this.__Faggregateservices) {
            this.aggregateservices = map;
            return;
        }
        this.__IM.onSet((Object)this, "aggregateservices", (Object)map);
    }

    List __getprobeListeners() {
        if (!this.__FprobeListeners) {
            return this.probeListeners;
        }
        return (List)this.__IM.onGet((Object)this, "probeListeners");
    }

    void __setprobeListeners(List list) {
        if (!this.__FprobeListeners) {
            this.probeListeners = list;
            return;
        }
        this.__IM.onSet((Object)this, "probeListeners", (Object)list);
    }

    List __getdefaultOutputList() {
        if (!this.__FdefaultOutputList) {
            return this.defaultOutputList;
        }
        return (List)this.__IM.onGet((Object)this, "defaultOutputList");
    }

    void __setdefaultOutputList(List list) {
        if (!this.__FdefaultOutputList) {
            this.defaultOutputList = list;
            return;
        }
        this.__IM.onSet((Object)this, "defaultOutputList", (Object)list);
    }

    int __getprobeCount() {
        if (!this.__FprobeCount) {
            return this.probeCount;
        }
        Object object = this.__IM.onGet((Object)this, "probeCount");
        Integer n = (Integer)object;
        return n;
    }

    void __setprobeCount(int n) {
        if (!this.__FprobeCount) {
            this.probeCount = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "probeCount", (Object)n2);
    }

    ObjectName __getmbeanObjectName() {
        if (!this.__FmbeanObjectName) {
            return this.mbeanObjectName;
        }
        return (ObjectName)this.__IM.onGet((Object)this, "mbeanObjectName");
    }

    void __setmbeanObjectName(ObjectName objectName) {
        if (!this.__FmbeanObjectName) {
            this.mbeanObjectName = objectName;
            return;
        }
        this.__IM.onSet((Object)this, "mbeanObjectName", (Object)objectName);
    }

    SchedulerService __getjasmineProbeScheduler() {
        if (!this.__FjasmineProbeScheduler) {
            return this.jasmineProbeScheduler;
        }
        return (SchedulerService)this.__IM.onGet((Object)this, "jasmineProbeScheduler");
    }

    void __setjasmineProbeScheduler(SchedulerService schedulerService) {
        if (!this.__FjasmineProbeScheduler) {
            this.jasmineProbeScheduler = schedulerService;
            return;
        }
        this.__IM.onSet((Object)this, "jasmineProbeScheduler", (Object)schedulerService);
    }

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    public JProbeManager() {
        this(null);
    }

    private JProbeManager(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setprobeConfig(null);
        this.__setprobedefs(new TreeMap());
        this.__setoutputs(new TreeMap());
        this.__setindicators(new TreeMap());
        this.__settargets(new TreeMap());
        this.__setprobes(new HashMap());
        this.__setouterservices(new HashMap());
        this.__setcollectorservices(new HashMap());
        this.__setaggregateservices(new HashMap());
        this.__setprobeListeners(new ArrayList());
        this.__setdefaultOutputList(new ArrayList());
        this.__setprobeCount(0);
        this.__setmbeanObjectName(null);
        this.__setjasmineProbeScheduler(null);
        this.__setjmxService(null);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        logger.debug((Object)"JasmineProbeManager service activated.", new Object[0]);
        try {
            this.readConfig();
        }
        catch (Exception e) {
            logger.error((Object)"Cannot read configuration", new Object[0]);
        }
        try {
            this.__setmbeanObjectName(new ObjectName("jasmine:dest=probe-manager"));
            this.__getjmxService().registerMBean((Object)this, this.__getmbeanObjectName());
        }
        catch (Exception e) {
            logger.error((Object)("Cannot register mbean: " + e), new Object[0]);
        }
        this.registerMBeans();
    }

    private void registerMBeans() {
        if (!this.__MregisterMBeans) {
            this.__registerMBeans();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "registerMBeans", new Object[0]);
            this.__registerMBeans();
            this.__IM.onExit((Object)this, "registerMBeans", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerMBeans", throwable);
            throw throwable;
        }
    }

    private void __registerMBeans() {
        try {
            ObjectName mbeanObjectName = ObjectName.getInstance("jasmine:dest=open-manager");
            AB ab_1 = new AB(1, 2);
            AB ab_2 = new AB(3, 4);
            AB ab_3 = new AB(5, 6);
            Long l_1 = new Long(2356L);
            Long l_2 = new Long(45678L);
            Long l_3 = new Long(1000004L);
            Long[] longs = new Long[]{l_1, l_2, l_3};
            CD cd = new CD(longs, ab_3);
            ObjectName[] ons = new ObjectName[]{mbeanObjectName};
            AB[] elems = new AB[]{ab_1, ab_2};
            TestOpenMBean testMbean = new TestOpenMBean(ab_1, ab_2, cd, longs, elems, ons);
            this.__getjmxService().registerMBean((Object)testMbean, mbeanObjectName);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot register mbean: " + e), new Object[0]);
        }
    }

    private void unregisterMBeans() {
        if (!this.__MunregisterMBeans) {
            this.__unregisterMBeans();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unregisterMBeans", new Object[0]);
            this.__unregisterMBeans();
            this.__IM.onExit((Object)this, "unregisterMBeans", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregisterMBeans", throwable);
            throw throwable;
        }
    }

    private void __unregisterMBeans() {
        try {
            ObjectName mbeanObjectName = ObjectName.getInstance("jasmine:dest=open-manager");
            this.__getjmxService().unregisterMBean(mbeanObjectName);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot unregister mbean: " + e), new Object[0]);
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() {
        logger.debug((Object)"JasmineProbeManager service stopped.", new Object[0]);
        this.__getjmxService().unregisterMBean(this.__getmbeanObjectName());
        this.unregisterMBeans();
    }

    protected void bindOuterService(JasmineOuterService jasmineOuterService, ServiceReference serviceReference) {
        if (!this.__MbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference) {
            this.__bindOuterService(jasmineOuterService, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference", new Object[]{jasmineOuterService, serviceReference});
            this.__bindOuterService(jasmineOuterService, serviceReference);
            this.__IM.onExit((Object)this, "bindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Bind(aggregate=true, optional=true)
    private void __bindOuterService(JasmineOuterService jos, ServiceReference sr) {
        String type = (String)sr.getProperty("output.type");
        if (type == null) {
            logger.warn((Object)"A service providing implementation for a JASMINe Probe Output type must use 'output.type' property to specify that type", new Object[0]);
            return;
        }
        String mess = "A service for " + type + " output";
        JasmineOuterService old = (JasmineOuterService)this.__getouterservices().get(type);
        if (old != null) {
            logger.warn((Object)(mess + " already deployed"), new Object[0]);
            return;
        }
        this.__getouterservices().put(type, jos);
        ((JOuterService)jos).setJmxService(this.__getjmxService());
        logger.info((Object)(mess + " deployed to JASMINe Probe"), new Object[0]);
        this.startWaitingProbes();
    }

    protected void unbindOuterService(JasmineOuterService jasmineOuterService, ServiceReference serviceReference) {
        if (!this.__MunbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference) {
            this.__unbindOuterService(jasmineOuterService, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference", new Object[]{jasmineOuterService, serviceReference});
            this.__unbindOuterService(jasmineOuterService, serviceReference);
            this.__IM.onExit((Object)this, "unbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Unbind(aggregate=true, optional=true)
    private void __unbindOuterService(JasmineOuterService jos, ServiceReference sr) {
        String[] outputNames;
        String type = (String)sr.getProperty("output.type");
        if (type == null) {
            logger.warn((Object)"Undeploying a service providing implementation for a JASMINe Probe Output that has not defined 'output.type' property", new Object[0]);
            return;
        }
        if (this.__getouterservices().get(type) == null) {
            return;
        }
        for (String outputName : outputNames = this.listOutputs(type)) {
            block3: for (JasmineProbe probe : this.__getprobedefs().values()) {
                if (probe.getStatus() != 2) continue;
                for (String output : probe.getOutputList()) {
                    if (!output.equals(outputName)) continue;
                    logger.warn((Object)"Stop probe {0}", new Object[]{probe.getId()});
                    try {
                        this.stopProbe(probe.getId());
                    }
                    catch (JasmineProbeException e) {
                        logger.error((Object)e, new Object[0]);
                    }
                    continue block3;
                }
            }
        }
        this.__getouterservices().remove(type);
    }

    protected void bindCollectorService(JasmineCollectorService jasmineCollectorService, ServiceReference serviceReference) {
        if (!this.__MbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference) {
            this.__bindCollectorService(jasmineCollectorService, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference", new Object[]{jasmineCollectorService, serviceReference});
            this.__bindCollectorService(jasmineCollectorService, serviceReference);
            this.__IM.onExit((Object)this, "bindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Bind(aggregate=true, optional=true)
    private void __bindCollectorService(JasmineCollectorService jcs, ServiceReference sr) {
        String type = (String)sr.getProperty("indicator.type");
        if (type == null) {
            logger.warn((Object)"A service providing implementation for a JASMINe Probe Indicator type must use 'indicator.type' property to specify that type", new Object[0]);
            return;
        }
        String mess = "A service for " + type + " indicator";
        JasmineCollectorService old = (JasmineCollectorService)this.__getcollectorservices().get(type);
        if (old != null) {
            logger.warn((Object)(mess + " already deployed"), new Object[0]);
            return;
        }
        this.__getcollectorservices().put(type, jcs);
        logger.info((Object)(mess + " deployed to JASMINe Probe"), new Object[0]);
        this.startWaitingProbes();
    }

    protected void unbindCollectorService(JasmineCollectorService jasmineCollectorService, ServiceReference serviceReference) {
        if (!this.__MunbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference) {
            this.__unbindCollectorService(jasmineCollectorService, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference", new Object[]{jasmineCollectorService, serviceReference});
            this.__unbindCollectorService(jasmineCollectorService, serviceReference);
            this.__IM.onExit((Object)this, "unbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Unbind(aggregate=true, optional=true)
    private void __unbindCollectorService(JasmineCollectorService jcs, ServiceReference sr) {
        String[] indicatorNames;
        String type = (String)sr.getProperty("indicator.type");
        if (type == null) {
            logger.warn((Object)"Undeploying a service providing implementation for a JASMINe Probe Indicator that has not defined 'indicator.type' property", new Object[0]);
            return;
        }
        if (this.__getcollectorservices().get(type) == null) {
            return;
        }
        for (String indicatorName : indicatorNames = this.listIndicators(type)) {
            block3: for (JasmineProbe probe : this.__getprobedefs().values()) {
                if (probe.getStatus() != 2) continue;
                for (String indic : this.getRecursiveIndicatorList(probe)) {
                    if (!indic.equals(indicatorName)) continue;
                    logger.warn((Object)"Stop probe {0}", new Object[]{probe.getId()});
                    try {
                        this.stopProbe(probe.getId());
                    }
                    catch (JasmineProbeException e) {
                        logger.error((Object)e, new Object[0]);
                    }
                    continue block3;
                }
            }
        }
        this.__getcollectorservices().remove(type);
    }

    protected void bindAggregateService(JasmineAggregateService jasmineAggregateService, ServiceReference serviceReference) {
        if (!this.__MbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference) {
            this.__bindAggregateService(jasmineAggregateService, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference", new Object[]{jasmineAggregateService, serviceReference});
            this.__bindAggregateService(jasmineAggregateService, serviceReference);
            this.__IM.onExit((Object)this, "bindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Bind(aggregate=true, optional=true)
    private void __bindAggregateService(JasmineAggregateService jas, ServiceReference sr) {
        String type = (String)sr.getProperty("aggregate.type");
        if (type == null) {
            logger.warn((Object)"A service providing specific implementation for an aggregate JASMINe Probe Indicator must define 'aggregate.type' property to specify its aggregate function", new Object[0]);
            return;
        }
        JasmineAggregateService old = (JasmineAggregateService)this.__getaggregateservices().get(type);
        if (old != null) {
            logger.warn((Object)("A service providing implementation for an aggregate JASMINe Probe Indicator already defined for " + type + " function. Please check deployment plan and undeploy old service !"), new Object[0]);
            return;
        }
        this.__getaggregateservices().put(type, jas);
        logger.info((Object)"A service providing implementation for an aggregate JASMINe Probe Indicator with {0} function deployed to JasmineProbe", new Object[]{type});
    }

    protected void unbindAggregateService(JasmineAggregateService jasmineAggregateService, ServiceReference serviceReference) {
        if (!this.__MunbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference) {
            this.__unbindAggregateService(jasmineAggregateService, serviceReference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference", new Object[]{jasmineAggregateService, serviceReference});
            this.__unbindAggregateService(jasmineAggregateService, serviceReference);
            this.__IM.onExit((Object)this, "unbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    @Unbind(aggregate=true, optional=true)
    private void __unbindAggregateService(JasmineAggregateService jas, ServiceReference sr) {
        String type = (String)sr.getProperty("aggregate.type");
        if (type == null) {
            logger.warn((Object)"Undeploying a service providing implementation for an aggregate JASMINe Probe Indicator that has not defined 'indicator.type' property", new Object[0]);
            return;
        }
        if (this.__getaggregateservices().containsKey(type)) {
            this.__getaggregateservices().remove(type);
            logger.info((Object)"A service providing implementation for an aggregate JASMINe Probe Indicator with {0} function undeployed from JasmineProbe", new Object[]{type});
            logger.info((Object)"{0} JasmineAggregateService unbound into JasmineProbe.", new Object[]{type});
        }
    }

    public SchedulerService getScheduler() {
        SchedulerService schedulerService;
        if (!this.__MgetScheduler) {
            return this.__getScheduler();
        }
        try {
            this.__IM.onEntry((Object)this, "getScheduler", new Object[0]);
            schedulerService = this.__getScheduler();
            this.__IM.onExit((Object)this, "getScheduler", (Object)schedulerService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getScheduler", throwable);
            throw throwable;
        }
        return schedulerService;
    }

    private SchedulerService __getScheduler() {
        return this.__getjasmineProbeScheduler();
    }

    public JasmineOuterService getOuterService(String string) {
        JasmineOuterService jasmineOuterService;
        if (!this.__MgetOuterService$java_lang_String) {
            return this.__getOuterService(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getOuterService$java_lang_String", new Object[]{string});
            jasmineOuterService = this.__getOuterService(string);
            this.__IM.onExit((Object)this, "getOuterService$java_lang_String", (Object)jasmineOuterService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOuterService$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineOuterService;
    }

    private JasmineOuterService __getOuterService(String type) {
        return (JasmineOuterService)this.__getouterservices().get(type);
    }

    public JasmineCollectorService getCollectorService(String string) {
        JasmineCollectorService jasmineCollectorService;
        if (!this.__MgetCollectorService$java_lang_String) {
            return this.__getCollectorService(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getCollectorService$java_lang_String", new Object[]{string});
            jasmineCollectorService = this.__getCollectorService(string);
            this.__IM.onExit((Object)this, "getCollectorService$java_lang_String", (Object)jasmineCollectorService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCollectorService$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineCollectorService;
    }

    private JasmineCollectorService __getCollectorService(String type) {
        return (JasmineCollectorService)this.__getcollectorservices().get(type);
    }

    public synchronized String createProbe(JasmineProbe jasmineProbe) throws JasmineProbeException {
        String string;
        if (!this.__McreateProbe$org_ow2_jasmine_probe_JasmineProbe) {
            return this.__createProbe(jasmineProbe);
        }
        try {
            this.__IM.onEntry((Object)this, "createProbe$org_ow2_jasmine_probe_JasmineProbe", new Object[]{jasmineProbe});
            string = this.__createProbe(jasmineProbe);
            this.__IM.onExit((Object)this, "createProbe$org_ow2_jasmine_probe_JasmineProbe", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createProbe$org_ow2_jasmine_probe_JasmineProbe", throwable);
            throw throwable;
        }
        return string;
    }

    private String __createProbe(JasmineProbe probe) throws JasmineProbeException {
        String id = probe.getId();
        logger.debug((Object)("creating probe " + id), new Object[0]);
        if (id == null) {
            if (probe.getIndicatorList().size() == 1) {
                String strindic = (String)probe.getIndicatorList().get(0);
                boolean found = false;
                for (JasmineProbe p : this.__getprobedefs().values()) {
                    if (!p.getId().equals(strindic)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    id = strindic;
                }
            }
            if (id == null) {
                id = this.getNewProbeId();
            }
            probe.setId(id);
        } else {
            JasmineProbe p = (JasmineProbe)this.__getprobedefs().get(id);
            if (p != null) {
                throw new JasmineProbeException("Probe id " + id + " already used");
            }
        }
        if (probe.getIndicatorList() == null || probe.getIndicatorList().isEmpty()) {
            throw new JasmineProbeException("A probe must have at least one indicator");
        }
        if (probe.getOutputList() == null || probe.getOutputList().isEmpty()) {
            probe.setOutputList(this.__getdefaultOutputList());
        }
        this.__getprobedefs().put(id, probe);
        return id;
    }

    public synchronized void removeProbe(String string) throws JasmineProbeException {
        if (!this.__MremoveProbe$java_lang_String) {
            this.__removeProbe(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeProbe$java_lang_String", new Object[]{string});
            this.__removeProbe(string);
            this.__IM.onExit((Object)this, "removeProbe$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeProbe$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeProbe(String probeId) throws JasmineProbeException {
        JasmineProbe def = (JasmineProbe)this.__getprobedefs().get(probeId);
        if (def == null) {
            throw new JasmineProbeException("Cannot remove probe with non-existent id " + probeId);
        }
        JProbe probe = (JProbe)this.__getprobes().get(probeId);
        if (probe != null) {
            probe.suspend();
            probe.resetIndicators();
            probe.resetOutputs();
            probe.resetTargets();
            this.__getprobes().remove(probeId);
        }
        logger.debug((Object)("removing probe " + probeId), new Object[0]);
        this.__getprobedefs().remove(probeId);
    }

    public synchronized void removeAllProbes() throws JasmineProbeException {
        if (!this.__MremoveAllProbes) {
            this.__removeAllProbes();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeAllProbes", new Object[0]);
            this.__removeAllProbes();
            this.__IM.onExit((Object)this, "removeAllProbes", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeAllProbes", throwable);
            throw throwable;
        }
    }

    private void __removeAllProbes() throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        ArrayList<String> namelist = new ArrayList<String>();
        for (String n : this.__getprobedefs().keySet()) {
            namelist.add(n);
        }
        for (String name : namelist) {
            this.removeProbe(name);
        }
    }

    public synchronized List<JasmineProbe> getProbes() {
        List<JasmineProbe> list;
        if (!this.__MgetProbes) {
            return this.__getProbes();
        }
        try {
            this.__IM.onEntry((Object)this, "getProbes", new Object[0]);
            list = this.__getProbes();
            this.__IM.onExit((Object)this, "getProbes", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProbes", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasmineProbe> __getProbes() {
        logger.debug((Object)"", new Object[0]);
        ArrayList<JasmineProbe> ret = new ArrayList<JasmineProbe>();
        Iterator keys = ((TreeMap)this.__getprobedefs()).keySet().iterator();
        while (keys.hasNext()) {
            ret.add((JasmineProbe)this.__getprobedefs().get(keys.next()));
        }
        return ret;
    }

    public synchronized String[] listProbes() {
        String[] stringArray;
        if (!this.__MlistProbes) {
            return this.__listProbes();
        }
        try {
            this.__IM.onEntry((Object)this, "listProbes", new Object[0]);
            stringArray = this.__listProbes();
            this.__IM.onExit((Object)this, "listProbes", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "listProbes", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __listProbes() {
        logger.debug((Object)"", new Object[0]);
        ArrayList ret = new ArrayList();
        Iterator keys = ((TreeMap)this.__getprobedefs()).keySet().iterator();
        while (keys.hasNext()) {
            ret.add(keys.next());
        }
        return ret.toArray(new String[0]);
    }

    public synchronized JasmineProbe getProbe(String string) throws JasmineProbeException {
        JasmineProbe jasmineProbe;
        if (!this.__MgetProbe$java_lang_String) {
            return this.__getProbe(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getProbe$java_lang_String", new Object[]{string});
            jasmineProbe = this.__getProbe(string);
            this.__IM.onExit((Object)this, "getProbe$java_lang_String", (Object)jasmineProbe);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getProbe$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineProbe;
    }

    private JasmineProbe __getProbe(String probeId) throws JasmineProbeException {
        JasmineProbe def = (JasmineProbe)this.__getprobedefs().get(probeId);
        if (def == null) {
            throw new JasmineProbeException("Cannot find probe with id " + probeId);
        }
        return def;
    }

    public synchronized void startProbe(String string) throws JasmineProbeException {
        if (!this.__MstartProbe$java_lang_String) {
            this.__startProbe(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startProbe$java_lang_String", new Object[]{string});
            this.__startProbe(string);
            this.__IM.onExit((Object)this, "startProbe$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startProbe$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __startProbe(String probeId) throws JasmineProbeException {
        logger.debug((Object)probeId, new Object[0]);
        JasmineProbe def = (JasmineProbe)this.__getprobedefs().get(probeId);
        if (def == null) {
            throw new JasmineProbeException("Cannot start probe with non-existent id " + probeId);
        }
        JProbe running = (JProbe)this.__getprobes().get(probeId);
        if (running != null) {
            switch (running.getStatus()) {
                case 2: {
                    logger.info((Object)("Probe already running: " + probeId), new Object[0]);
                    return;
                }
                case 1: {
                    logger.info((Object)("Probe already started: " + probeId), new Object[0]);
                    return;
                }
                case 3: {
                    logger.info((Object)("restarting a failed probe: " + probeId), new Object[0]);
                    break;
                }
                case 0: {
                    logger.info((Object)("restarting a stopped probe: " + probeId), new Object[0]);
                    break;
                }
                default: {
                    logger.warn((Object)("Bad state for: " + probeId), new Object[0]);
                    break;
                }
            }
        } else {
            running = new JProbe(def, this);
            this.__getprobes().put(probeId, running);
        }
        running.resume();
    }

    public synchronized void stopProbe(String string) throws JasmineProbeException {
        if (!this.__MstopProbe$java_lang_String) {
            this.__stopProbe(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopProbe$java_lang_String", new Object[]{string});
            this.__stopProbe(string);
            this.__IM.onExit((Object)this, "stopProbe$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopProbe$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __stopProbe(String probeId) throws JasmineProbeException {
        logger.debug((Object)probeId, new Object[0]);
        JasmineProbe def = (JasmineProbe)this.__getprobedefs().get(probeId);
        if (def == null) {
            throw new JasmineProbeException("Cannot start probe with non-existent id " + probeId);
        }
        JProbe running = (JProbe)this.__getprobes().get(probeId);
        if (running == null) {
            throw new JasmineProbeException("This probe is not running: " + probeId);
        }
        running.suspend();
    }

    public synchronized void startAllProbes() throws JasmineProbeException {
        if (!this.__MstartAllProbes) {
            this.__startAllProbes();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startAllProbes", new Object[0]);
            this.__startAllProbes();
            this.__IM.onExit((Object)this, "startAllProbes", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startAllProbes", throwable);
            throw throwable;
        }
    }

    private void __startAllProbes() throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        for (JasmineProbe probe : this.__getprobedefs().values()) {
            try {
                this.startProbe(probe.getId());
            }
            catch (Exception e) {
                logger.warn((Object)("could not start probe " + probe.getId() + " :" + e), new Object[0]);
            }
        }
    }

    public synchronized void stopAllProbes() throws JasmineProbeException {
        if (!this.__MstopAllProbes) {
            this.__stopAllProbes();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopAllProbes", new Object[0]);
            this.__stopAllProbes();
            this.__IM.onExit((Object)this, "stopAllProbes", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopAllProbes", throwable);
            throw throwable;
        }
    }

    private void __stopAllProbes() throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        for (JProbe probe : this.__getprobes().values()) {
            try {
                probe.suspend();
            }
            catch (Exception e) {
                logger.warn((Object)("could not stop probe " + probe.getProbeDef().getId() + " :" + e), new Object[0]);
            }
        }
    }

    public synchronized void changeProbe(JasmineProbe jasmineProbe) throws JasmineProbeException {
        if (!this.__MchangeProbe$org_ow2_jasmine_probe_JasmineProbe) {
            this.__changeProbe(jasmineProbe);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "changeProbe$org_ow2_jasmine_probe_JasmineProbe", new Object[]{jasmineProbe});
            this.__changeProbe(jasmineProbe);
            this.__IM.onExit((Object)this, "changeProbe$org_ow2_jasmine_probe_JasmineProbe", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "changeProbe$org_ow2_jasmine_probe_JasmineProbe", throwable);
            throw throwable;
        }
    }

    private void __changeProbe(JasmineProbe newdef) throws JasmineProbeException {
        String probeId = newdef.getId();
        logger.debug((Object)probeId, new Object[0]);
        JasmineProbe def = (JasmineProbe)this.__getprobedefs().get(probeId);
        if (def == null) {
            throw new JasmineProbeException("Probe not found: " + probeId);
        }
        boolean restart = false;
        JProbe running = (JProbe)this.__getprobes().get(probeId);
        if (running != null) {
            restart = running.suspend();
        }
        if (newdef.getPeriod() > 0) {
            def.setPeriod(newdef.getPeriod());
        }
        if (newdef.getOutputList().size() > 0) {
            def.setOutputList(newdef.getOutputList());
            if (running != null) {
                running.resetOutputs();
            }
        }
        if (newdef.getIndicatorList().size() > 0) {
            def.setIndicatorList(newdef.getIndicatorList());
            if (running != null) {
                running.resetIndicators();
            }
        }
        if (newdef.getTargetList().size() > 0) {
            def.setTargetList(newdef.getTargetList());
            if (running != null) {
                running.resetTargets();
            }
        }
        if (restart) {
            try {
                running.resume();
            }
            catch (JasmineProbeException e) {
                logger.warn((Object)"Probe {0} changed. It was stopped but could not be restarted: {1}", new Object[]{probeId, e.getMessage()});
            }
        }
    }

    public void changeProbePeriod(String string, int n) throws JasmineProbeException {
        if (!this.__MchangeProbePeriod$java_lang_String$int) {
            this.__changeProbePeriod(string, n);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "changeProbePeriod$java_lang_String$int", new Object[]{string, new Integer(n)});
            this.__changeProbePeriod(string, n);
            this.__IM.onExit((Object)this, "changeProbePeriod$java_lang_String$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "changeProbePeriod$java_lang_String$int", throwable);
            throw throwable;
        }
    }

    private void __changeProbePeriod(String probeId, int period) throws JasmineProbeException {
        JasmineProbe def = (JasmineProbe)this.__getprobedefs().get(probeId);
        def.setPeriod(period);
        JProbe running = (JProbe)this.__getprobes().get(probeId);
        if (running != null && running.isRunning()) {
            running.resetTimer();
        }
    }

    public String createOutput(JasmineOutput jasmineOutput) throws JasmineProbeException {
        String string;
        if (!this.__McreateOutput$org_ow2_jasmine_probe_JasmineOutput) {
            return this.__createOutput(jasmineOutput);
        }
        try {
            this.__IM.onEntry((Object)this, "createOutput$org_ow2_jasmine_probe_JasmineOutput", new Object[]{jasmineOutput});
            string = this.__createOutput(jasmineOutput);
            this.__IM.onExit((Object)this, "createOutput$org_ow2_jasmine_probe_JasmineOutput", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createOutput$org_ow2_jasmine_probe_JasmineOutput", throwable);
            throw throwable;
        }
        return string;
    }

    private String __createOutput(JasmineOutput newoutput) throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        return this.createOutputInternal(newoutput, true);
    }

    public void changeOutput(JasmineOutput jasmineOutput) throws JasmineProbeException {
        if (!this.__MchangeOutput$org_ow2_jasmine_probe_JasmineOutput) {
            this.__changeOutput(jasmineOutput);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "changeOutput$org_ow2_jasmine_probe_JasmineOutput", new Object[]{jasmineOutput});
            this.__changeOutput(jasmineOutput);
            this.__IM.onExit((Object)this, "changeOutput$org_ow2_jasmine_probe_JasmineOutput", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "changeOutput$org_ow2_jasmine_probe_JasmineOutput", throwable);
            throw throwable;
        }
    }

    private void __changeOutput(JasmineOutput newdef) throws JasmineProbeException {
        String name = newdef.getName();
        logger.debug((Object)name, new Object[0]);
        JasmineOutput olddef = (JasmineOutput)this.__getoutputs().get(name);
        if (olddef == null) {
            throw new JasmineProbeException("This output does not exist: " + name);
        }
        List<JasmineProbe> probesUsingOld = this.probesUsingDef(olddef, true);
        for (JasmineProbe usingOld : probesUsingOld) {
            JProbe running = (JProbe)this.__getprobes().get(usingOld.getId());
            running.suspend();
            running.resetOutputs();
        }
        JasmineOuterService jos = (JasmineOuterService)this.__getouterservices().get(olddef.getType());
        if (jos != null) {
            jos.removeOuters(name);
        }
        if (newdef.getType() != null) {
            olddef.setType(newdef.getType());
        }
        for (String key : newdef.getProperties().keySet()) {
            String newval = (String)newdef.getProperties().get(key);
            if (newval == null || newval.isEmpty()) {
                olddef.getProperties().remove(key);
                continue;
            }
            olddef.getProperties().put(key, newval);
        }
        for (JasmineProbe usingOld : probesUsingOld) {
            JProbe running = (JProbe)this.__getprobes().get(usingOld.getId());
            running.resume();
        }
    }

    public void removeOutput(String string) throws JasmineProbeException {
        if (!this.__MremoveOutput$java_lang_String) {
            this.__removeOutput(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeOutput$java_lang_String", new Object[]{string});
            this.__removeOutput(string);
            this.__IM.onExit((Object)this, "removeOutput$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeOutput$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeOutput(String name) throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        JasmineOutput output = (JasmineOutput)this.__getoutputs().get(name);
        if (output == null) {
            throw new JasmineProbeException("This output does not exist: " + name);
        }
        if (this.isDefUsed(output, true)) {
            throw new JasmineProbeException("This output is used and cannot be removed: " + name);
        }
        JasmineOuterService jos = (JasmineOuterService)this.__getouterservices().get(output.getType());
        if (jos != null) {
            jos.removeOuters(name);
        }
        this.__getoutputs().remove(name);
    }

    public synchronized String[] listOutputs(String string) {
        String[] stringArray;
        if (!this.__MlistOutputs$java_lang_String) {
            return this.__listOutputs(string);
        }
        try {
            this.__IM.onEntry((Object)this, "listOutputs$java_lang_String", new Object[]{string});
            stringArray = this.__listOutputs(string);
            this.__IM.onExit((Object)this, "listOutputs$java_lang_String", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "listOutputs$java_lang_String", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __listOutputs(String type) {
        logger.debug((Object)"", new Object[0]);
        ArrayList<String> ret = new ArrayList<String>();
        for (String name : ((TreeMap)this.__getoutputs()).keySet()) {
            if (type == null) {
                ret.add(name);
                continue;
            }
            JasmineOutput out = (JasmineOutput)this.__getoutputs().get(name);
            if (!type.equals(out.getType())) continue;
            ret.add(name);
        }
        return ret.toArray(new String[0]);
    }

    public synchronized List<JasmineOutput> getOutputs() {
        List<JasmineOutput> list;
        if (!this.__MgetOutputs) {
            return this.__getOutputs();
        }
        try {
            this.__IM.onEntry((Object)this, "getOutputs", new Object[0]);
            list = this.__getOutputs();
            this.__IM.onExit((Object)this, "getOutputs", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOutputs", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasmineOutput> __getOutputs() {
        logger.debug((Object)"", new Object[0]);
        ArrayList<JasmineOutput> ret = new ArrayList<JasmineOutput>();
        Iterator keys = ((TreeMap)this.__getoutputs()).keySet().iterator();
        while (keys.hasNext()) {
            ret.add((JasmineOutput)this.__getoutputs().get(keys.next()));
        }
        return ret;
    }

    public void addDefaultOutput(String string) throws JasmineProbeException {
        if (!this.__MaddDefaultOutput$java_lang_String) {
            this.__addDefaultOutput(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addDefaultOutput$java_lang_String", new Object[]{string});
            this.__addDefaultOutput(string);
            this.__IM.onExit((Object)this, "addDefaultOutput$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addDefaultOutput$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __addDefaultOutput(String name) throws JasmineProbeException {
        if (!this.__getoutputs().containsKey(name)) {
            throw new JasmineProbeException("This output does not exist: " + name);
        }
        this.__getdefaultOutputList().add(name);
    }

    public synchronized String[] listDefaultOutputs() {
        String[] stringArray;
        if (!this.__MlistDefaultOutputs) {
            return this.__listDefaultOutputs();
        }
        try {
            this.__IM.onEntry((Object)this, "listDefaultOutputs", new Object[0]);
            stringArray = this.__listDefaultOutputs();
            this.__IM.onExit((Object)this, "listDefaultOutputs", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "listDefaultOutputs", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __listDefaultOutputs() {
        logger.debug((Object)"", new Object[0]);
        ArrayList<String> ret = new ArrayList<String>();
        for (String id : this.__getdefaultOutputList()) {
            ret.add(id);
        }
        return ret.toArray(new String[0]);
    }

    public void removeDefaultOutput(String string) throws JasmineProbeException {
        if (!this.__MremoveDefaultOutput$java_lang_String) {
            this.__removeDefaultOutput(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeDefaultOutput$java_lang_String", new Object[]{string});
            this.__removeDefaultOutput(string);
            this.__IM.onExit((Object)this, "removeDefaultOutput$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeDefaultOutput$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeDefaultOutput(String name) throws JasmineProbeException {
        if (!this.__getdefaultOutputList().contains(name)) {
            throw new JasmineProbeException("This output is not a default output: " + name);
        }
    }

    public synchronized List<JasmineOutput> getOutputs(String string) {
        List<JasmineOutput> list;
        if (!this.__MgetOutputs$java_lang_String) {
            return this.__getOutputs(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getOutputs$java_lang_String", new Object[]{string});
            list = this.__getOutputs(string);
            this.__IM.onExit((Object)this, "getOutputs$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOutputs$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasmineOutput> __getOutputs(String type) {
        logger.debug((Object)"", new Object[0]);
        ArrayList<JasmineOutput> ret = new ArrayList<JasmineOutput>();
        Iterator keys = ((TreeMap)this.__getoutputs()).keySet().iterator();
        while (keys.hasNext()) {
            JasmineOutput output = (JasmineOutput)this.__getoutputs().get(keys.next());
            if (!output.getType().equals(type)) continue;
            ret.add(output);
        }
        return ret;
    }

    public synchronized JasmineOutput getOutput(String string) throws JasmineProbeException {
        JasmineOutput jasmineOutput;
        if (!this.__MgetOutput$java_lang_String) {
            return this.__getOutput(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getOutput$java_lang_String", new Object[]{string});
            jasmineOutput = this.__getOutput(string);
            this.__IM.onExit((Object)this, "getOutput$java_lang_String", (Object)jasmineOutput);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOutput$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineOutput;
    }

    private JasmineOutput __getOutput(String id) throws JasmineProbeException {
        logger.debug((Object)"", new Object[0]);
        JasmineOutput def = (JasmineOutput)this.__getoutputs().get(id);
        if (def == null) {
            throw new JasmineProbeException("Cannot find output with id " + id);
        }
        return def;
    }

    public List<JasminePropertyInfo> getOutputPropertyInfos(String string) {
        List<JasminePropertyInfo> list;
        if (!this.__MgetOutputPropertyInfos$java_lang_String) {
            return this.__getOutputPropertyInfos(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getOutputPropertyInfos$java_lang_String", new Object[]{string});
            list = this.__getOutputPropertyInfos(string);
            this.__IM.onExit((Object)this, "getOutputPropertyInfos$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOutputPropertyInfos$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasminePropertyInfo> __getOutputPropertyInfos(String type) {
        if (type == null || type.length() == 0) {
            logger.error((Object)"No type provided", new Object[0]);
            return null;
        }
        logger.debug((Object)type, new Object[0]);
        JasmineOuterService jos = (JasmineOuterService)this.__getouterservices().get(type);
        if (jos == null) {
            logger.error((Object)("No OuterService found for type " + type), new Object[0]);
            return null;
        }
        return jos.getPropertiesInfo();
    }

    public synchronized Set<String> getOutputTypes() {
        Set<String> set;
        if (!this.__MgetOutputTypes) {
            return this.__getOutputTypes();
        }
        try {
            this.__IM.onEntry((Object)this, "getOutputTypes", new Object[0]);
            set = this.__getOutputTypes();
            this.__IM.onExit((Object)this, "getOutputTypes", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOutputTypes", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<String> __getOutputTypes() {
        return this.__getouterservices().keySet();
    }

    public synchronized Set<String> getOutputCurrentUse(String string) throws JasmineProbeException {
        Set<String> set;
        if (!this.__MgetOutputCurrentUse$java_lang_String) {
            return this.__getOutputCurrentUse(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getOutputCurrentUse$java_lang_String", new Object[]{string});
            set = this.__getOutputCurrentUse(string);
            this.__IM.onExit((Object)this, "getOutputCurrentUse$java_lang_String", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOutputCurrentUse$java_lang_String", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<String> __getOutputCurrentUse(String name) throws JasmineProbeException {
        HashSet<String> ret = new HashSet<String>();
        for (JasmineProbe probe : this.__getprobedefs().values()) {
            for (String output : probe.getOutputList()) {
                if (!output.equals(name)) continue;
                ret.add(probe.getId());
            }
        }
        return ret;
    }

    public String createIndicator(JasmineIndicator jasmineIndicator) throws JasmineProbeException {
        String string;
        if (!this.__McreateIndicator$org_ow2_jasmine_probe_JasmineIndicator) {
            return this.__createIndicator(jasmineIndicator);
        }
        try {
            this.__IM.onEntry((Object)this, "createIndicator$org_ow2_jasmine_probe_JasmineIndicator", new Object[]{jasmineIndicator});
            string = this.__createIndicator(jasmineIndicator);
            this.__IM.onExit((Object)this, "createIndicator$org_ow2_jasmine_probe_JasmineIndicator", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createIndicator$org_ow2_jasmine_probe_JasmineIndicator", throwable);
            throw throwable;
        }
        return string;
    }

    private String __createIndicator(JasmineIndicator newindic) throws JasmineProbeException {
        return this.createIndicatorInternal(newindic, true);
    }

    public void changeIndicator(JasmineIndicator jasmineIndicator) throws JasmineProbeException {
        if (!this.__MchangeIndicator$org_ow2_jasmine_probe_JasmineIndicator) {
            this.__changeIndicator(jasmineIndicator);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "changeIndicator$org_ow2_jasmine_probe_JasmineIndicator", new Object[]{jasmineIndicator});
            this.__changeIndicator(jasmineIndicator);
            this.__IM.onExit((Object)this, "changeIndicator$org_ow2_jasmine_probe_JasmineIndicator", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "changeIndicator$org_ow2_jasmine_probe_JasmineIndicator", throwable);
            throw throwable;
        }
    }

    private void __changeIndicator(JasmineIndicator newdef) throws JasmineProbeException {
        String name = newdef.getName();
        logger.debug((Object)name, new Object[0]);
        JasmineIndicator olddef = (JasmineIndicator)this.__getindicators().get(name);
        if (olddef == null) {
            throw new JasmineProbeException("This indicator does not exists: " + name);
        }
        List<JasmineProbe> probesUsingOld = this.probesUsingDef(olddef, true);
        for (JasmineProbe usingOld : probesUsingOld) {
            JProbe running = (JProbe)this.__getprobes().get(usingOld.getId());
            running.suspend();
            running.resetIndicators();
        }
        JasmineCollectorService jcs = (JasmineCollectorService)this.__getcollectorservices().get(olddef.getType());
        if (jcs != null) {
            jcs.removeCollectors(name, null);
        }
        if (newdef.getType() != null) {
            olddef.setType(newdef.getType());
        }
        if (newdef.getScale() != olddef.getScale()) {
            olddef.setScale(newdef.getScale());
        }
        if (!newdef.getSources().isEmpty()) {
            olddef.setSources(newdef.getSources());
        }
        for (String key : newdef.getProperties().keySet()) {
            String newval = (String)newdef.getProperties().get(key);
            if (newval == null || newval.isEmpty()) {
                olddef.getProperties().remove(key);
                continue;
            }
            olddef.getProperties().put(key, newval);
        }
        for (JasmineProbe usingOld : probesUsingOld) {
            JProbe running = (JProbe)this.__getprobes().get(usingOld.getId());
            running.resume();
        }
    }

    public void removeIndicator(String string) throws JasmineProbeException {
        if (!this.__MremoveIndicator$java_lang_String) {
            this.__removeIndicator(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeIndicator$java_lang_String", new Object[]{string});
            this.__removeIndicator(string);
            this.__IM.onExit((Object)this, "removeIndicator$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeIndicator$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeIndicator(String name) throws JasmineProbeException {
        logger.debug((Object)name, new Object[0]);
        JasmineIndicator indic = (JasmineIndicator)this.__getindicators().get(name);
        if (indic == null) {
            throw new JasmineProbeException("This indicator does not exist: " + name);
        }
        if (this.isDefUsed(indic, true)) {
            throw new JasmineProbeException("This indicator is used and cannot be removed: " + name);
        }
        JasmineCollectorService jcs = (JasmineCollectorService)this.__getcollectorservices().get(indic.getType());
        if (jcs != null) {
            jcs.removeCollectors(name, null);
        }
        this.__getindicators().remove(name);
    }

    public synchronized JasmineIndicator getIndicator(String string) throws JasmineProbeException {
        JasmineIndicator jasmineIndicator;
        if (!this.__MgetIndicator$java_lang_String) {
            return this.__getIndicator(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getIndicator$java_lang_String", new Object[]{string});
            jasmineIndicator = this.__getIndicator(string);
            this.__IM.onExit((Object)this, "getIndicator$java_lang_String", (Object)jasmineIndicator);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getIndicator$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineIndicator;
    }

    private JasmineIndicator __getIndicator(String name) throws JasmineProbeException {
        logger.debug((Object)name, new Object[0]);
        JasmineIndicator def = (JasmineIndicator)this.__getindicators().get(name);
        if (def == null) {
            throw new JasmineProbeException("Cannot find indicator " + name);
        }
        return def;
    }

    public synchronized List<JasmineIndicator> getIndicators() {
        List<JasmineIndicator> list;
        if (!this.__MgetIndicators) {
            return this.__getIndicators();
        }
        try {
            this.__IM.onEntry((Object)this, "getIndicators", new Object[0]);
            list = this.__getIndicators();
            this.__IM.onExit((Object)this, "getIndicators", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getIndicators", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasmineIndicator> __getIndicators() {
        logger.debug((Object)"", new Object[0]);
        ArrayList<JasmineIndicator> ret = new ArrayList<JasmineIndicator>();
        Iterator keys = ((TreeMap)this.__getindicators()).keySet().iterator();
        while (keys.hasNext()) {
            ret.add((JasmineIndicator)this.__getindicators().get(keys.next()));
        }
        return ret;
    }

    public synchronized List<JasmineIndicator> getIndicators(String string) {
        List<JasmineIndicator> list;
        if (!this.__MgetIndicators$java_lang_String) {
            return this.__getIndicators(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getIndicators$java_lang_String", new Object[]{string});
            list = this.__getIndicators(string);
            this.__IM.onExit((Object)this, "getIndicators$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getIndicators$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasmineIndicator> __getIndicators(String type) {
        logger.debug((Object)"", new Object[0]);
        ArrayList<JasmineIndicator> ret = new ArrayList<JasmineIndicator>();
        Iterator keys = ((TreeMap)this.__getindicators()).keySet().iterator();
        while (keys.hasNext()) {
            JasmineIndicator indic = (JasmineIndicator)this.__getindicators().get(keys.next());
            if (!indic.getType().equals(type)) continue;
            ret.add(indic);
        }
        return ret;
    }

    public synchronized String[] listIndicators(String string) {
        String[] stringArray;
        if (!this.__MlistIndicators$java_lang_String) {
            return this.__listIndicators(string);
        }
        try {
            this.__IM.onEntry((Object)this, "listIndicators$java_lang_String", new Object[]{string});
            stringArray = this.__listIndicators(string);
            this.__IM.onExit((Object)this, "listIndicators$java_lang_String", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "listIndicators$java_lang_String", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __listIndicators(String type) {
        logger.debug((Object)"", new Object[0]);
        ArrayList<String> ret = new ArrayList<String>();
        for (String name : ((TreeMap)this.__getindicators()).keySet()) {
            if (type == null) {
                ret.add(name);
                continue;
            }
            JasmineIndicator indic = (JasmineIndicator)this.__getindicators().get(name);
            if (!type.equals(indic.getType())) continue;
            ret.add(name);
        }
        return ret.toArray(new String[0]);
    }

    public JasmineCollectorInfo getIndicatorTypeInfo(String string) {
        JasmineCollectorInfo jasmineCollectorInfo;
        if (!this.__MgetIndicatorTypeInfo$java_lang_String) {
            return this.__getIndicatorTypeInfo(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getIndicatorTypeInfo$java_lang_String", new Object[]{string});
            jasmineCollectorInfo = this.__getIndicatorTypeInfo(string);
            this.__IM.onExit((Object)this, "getIndicatorTypeInfo$java_lang_String", (Object)jasmineCollectorInfo);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getIndicatorTypeInfo$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineCollectorInfo;
    }

    private JasmineCollectorInfo __getIndicatorTypeInfo(String type) {
        if (type == null || type.length() == 0) {
            logger.error((Object)"No type provided", new Object[0]);
            return null;
        }
        logger.debug((Object)type, new Object[0]);
        JasmineCollectorService jcs = (JasmineCollectorService)this.__getcollectorservices().get(type);
        if (jcs == null) {
            logger.error((Object)("No CollectorService found for type " + type), new Object[0]);
            return null;
        }
        return jcs.getCollectorInfo();
    }

    public synchronized Set<String> getIndicatorTypes() {
        Set<String> set;
        if (!this.__MgetIndicatorTypes) {
            return this.__getIndicatorTypes();
        }
        try {
            this.__IM.onEntry((Object)this, "getIndicatorTypes", new Object[0]);
            set = this.__getIndicatorTypes();
            this.__IM.onExit((Object)this, "getIndicatorTypes", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getIndicatorTypes", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<String> __getIndicatorTypes() {
        logger.debug((Object)"", new Object[0]);
        return this.__getcollectorservices().keySet();
    }

    public synchronized Set<String> getIndicatorCurrentUse(String string) throws JasmineProbeException {
        Set<String> set;
        if (!this.__MgetIndicatorCurrentUse$java_lang_String) {
            return this.__getIndicatorCurrentUse(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getIndicatorCurrentUse$java_lang_String", new Object[]{string});
            set = this.__getIndicatorCurrentUse(string);
            this.__IM.onExit((Object)this, "getIndicatorCurrentUse$java_lang_String", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getIndicatorCurrentUse$java_lang_String", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<String> __getIndicatorCurrentUse(String name) throws JasmineProbeException {
        HashSet<String> ret = new HashSet<String>();
        for (JasmineProbe probe : this.__getprobedefs().values()) {
            for (String indic : this.getRecursiveIndicatorList(probe)) {
                if (!indic.equals(name)) continue;
                ret.add(probe.getId());
            }
        }
        return ret;
    }

    public synchronized String createTarget(JasmineTarget jasmineTarget) throws JasmineProbeException {
        String string;
        if (!this.__McreateTarget$org_ow2_jasmine_probe_JasmineTarget) {
            return this.__createTarget(jasmineTarget);
        }
        try {
            this.__IM.onEntry((Object)this, "createTarget$org_ow2_jasmine_probe_JasmineTarget", new Object[]{jasmineTarget});
            string = this.__createTarget(jasmineTarget);
            this.__IM.onExit((Object)this, "createTarget$org_ow2_jasmine_probe_JasmineTarget", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createTarget$org_ow2_jasmine_probe_JasmineTarget", throwable);
            throw throwable;
        }
        return string;
    }

    private String __createTarget(JasmineTarget newtarget) throws JasmineProbeException {
        String name = newtarget.getName();
        if (name == null || name.length() == 0) {
            throw new JasmineProbeException("No valid target name");
        }
        logger.debug((Object)name, new Object[0]);
        JasmineTarget oldtarget = (JasmineTarget)this.__gettargets().get(name);
        if (oldtarget != null) {
            logger.debug((Object)("target already known: " + name), new Object[0]);
            if (oldtarget.equals((Object)newtarget)) {
                return name;
            }
            logger.warn((Object)("old definition: " + oldtarget), new Object[0]);
            logger.warn((Object)("new definition: " + newtarget), new Object[0]);
            if (this.isDefUsed(oldtarget, true)) {
                throw new JasmineProbeException(name + " target cannot be re-created as a running probe is using it");
            }
            List<JasmineProbe> probesUsingOld = this.probesUsingDef(oldtarget, false);
            for (JasmineProbe usingOld : probesUsingOld) {
                JProbe running = (JProbe)this.__getprobes().get(usingOld.getId());
                if (running == null) continue;
                running.resetTarget(oldtarget);
            }
            this.__gettargets().remove(name);
        }
        this.__gettargets().put(name, newtarget);
        return name;
    }

    public void changeTarget(JasmineTarget jasmineTarget) throws JasmineProbeException {
        if (!this.__MchangeTarget$org_ow2_jasmine_probe_JasmineTarget) {
            this.__changeTarget(jasmineTarget);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "changeTarget$org_ow2_jasmine_probe_JasmineTarget", new Object[]{jasmineTarget});
            this.__changeTarget(jasmineTarget);
            this.__IM.onExit((Object)this, "changeTarget$org_ow2_jasmine_probe_JasmineTarget", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "changeTarget$org_ow2_jasmine_probe_JasmineTarget", throwable);
            throw throwable;
        }
    }

    private void __changeTarget(JasmineTarget newdef) throws JasmineProbeException {
        JProbe running;
        String name = newdef.getName();
        logger.debug((Object)name, new Object[0]);
        JasmineTarget olddef = (JasmineTarget)this.__gettargets().get(name);
        if (olddef == null) {
            throw new JasmineProbeException("This target does not exist: " + name);
        }
        List<JasmineProbe> runningProbesUsingOld = this.probesUsingDef(olddef, true);
        for (JasmineProbe usingOld : runningProbesUsingOld) {
            JProbe running2 = (JProbe)this.__getprobes().get(usingOld.getId());
            running2.suspend();
        }
        if (newdef.getType() != null) {
            olddef.setType(newdef.getType());
        }
        for (String key : newdef.getProperties().keySet()) {
            String newval = (String)newdef.getProperties().get(key);
            if (newval == null || newval.isEmpty()) {
                olddef.getProperties().remove(key);
                continue;
            }
            logger.debug((Object)(key + "=" + newval), new Object[0]);
            olddef.getProperties().put(key, newval);
        }
        List<JasmineProbe> probesUsingOld = this.probesUsingDef(olddef, false);
        for (JasmineProbe usingOld : probesUsingOld) {
            running = (JProbe)this.__getprobes().get(usingOld.getId());
            if (running == null) continue;
            running.resetTargets();
        }
        for (JasmineProbe usingOld : runningProbesUsingOld) {
            running = (JProbe)this.__getprobes().get(usingOld.getId());
            running.resume();
        }
    }

    public void removeTarget(String string) throws JasmineProbeException {
        if (!this.__MremoveTarget$java_lang_String) {
            this.__removeTarget(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeTarget$java_lang_String", new Object[]{string});
            this.__removeTarget(string);
            this.__IM.onExit((Object)this, "removeTarget$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeTarget$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeTarget(String name) throws JasmineProbeException {
        logger.debug((Object)name, new Object[0]);
        JasmineTarget target = (JasmineTarget)this.__gettargets().get(name);
        if (target == null) {
            throw new JasmineProbeException("This target does not exist: " + name);
        }
        if (this.isDefUsed(target, true)) {
            throw new JasmineProbeException("This target is used and cannot be removed: " + name);
        }
        List<JasmineProbe> probesUsingOld = this.probesUsingDef(target, false);
        for (JasmineProbe usingOld : probesUsingOld) {
            JProbe running = (JProbe)this.__getprobes().get(usingOld.getId());
            if (running == null) continue;
            running.resetTargets();
        }
        this.__gettargets().remove(name);
    }

    public synchronized String[] listTargets() {
        String[] stringArray;
        if (!this.__MlistTargets) {
            return this.__listTargets();
        }
        try {
            this.__IM.onEntry((Object)this, "listTargets", new Object[0]);
            stringArray = this.__listTargets();
            this.__IM.onExit((Object)this, "listTargets", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "listTargets", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __listTargets() {
        logger.debug((Object)"", new Object[0]);
        ArrayList ret = new ArrayList();
        Iterator keys = ((TreeMap)this.__gettargets()).keySet().iterator();
        while (keys.hasNext()) {
            ret.add(keys.next());
        }
        return ret.toArray(new String[0]);
    }

    public synchronized List<JasmineTarget> getTargets() {
        List<JasmineTarget> list;
        if (!this.__MgetTargets) {
            return this.__getTargets();
        }
        try {
            this.__IM.onEntry((Object)this, "getTargets", new Object[0]);
            list = this.__getTargets();
            this.__IM.onExit((Object)this, "getTargets", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTargets", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasmineTarget> __getTargets() {
        logger.debug((Object)"", new Object[0]);
        ArrayList<JasmineTarget> ret = new ArrayList<JasmineTarget>();
        Iterator keys = ((TreeMap)this.__gettargets()).keySet().iterator();
        while (keys.hasNext()) {
            ret.add((JasmineTarget)this.__gettargets().get(keys.next()));
        }
        return ret;
    }

    public JasmineTarget getTarget(String string) {
        JasmineTarget jasmineTarget;
        if (!this.__MgetTarget$java_lang_String) {
            return this.__getTarget(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getTarget$java_lang_String", new Object[]{string});
            jasmineTarget = this.__getTarget(string);
            this.__IM.onExit((Object)this, "getTarget$java_lang_String", (Object)jasmineTarget);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTarget$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineTarget;
    }

    private JasmineTarget __getTarget(String name) {
        JasmineTarget target = (JasmineTarget)this.__gettargets().get(name);
        return target;
    }

    public List<JasminePropertyInfo> getTargetPropertyInfos(String string) {
        List<JasminePropertyInfo> list;
        if (!this.__MgetTargetPropertyInfos$java_lang_String) {
            return this.__getTargetPropertyInfos(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getTargetPropertyInfos$java_lang_String", new Object[]{string});
            list = this.__getTargetPropertyInfos(string);
            this.__IM.onExit((Object)this, "getTargetPropertyInfos$java_lang_String", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTargetPropertyInfos$java_lang_String", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasminePropertyInfo> __getTargetPropertyInfos(String type) {
        if (type == null || type.length() == 0) {
            logger.error((Object)"No type provided", new Object[0]);
            return null;
        }
        logger.debug((Object)type, new Object[0]);
        ArrayList<JasminePropertyInfo> ret = new ArrayList<JasminePropertyInfo>();
        ret.add(new JasminePropertyInfo("url", "target jmx URL", true));
        ret.add(new JasminePropertyInfo("user", "user name to access the target", false));
        ret.add(new JasminePropertyInfo("password", "password associated to the user name", false));
        ret.add(new JasminePropertyInfo("protocolProviders", "optional protocol provider", false));
        return ret;
    }

    public synchronized Set<String> getTargetTypes() {
        Set<String> set;
        if (!this.__MgetTargetTypes) {
            return this.__getTargetTypes();
        }
        try {
            this.__IM.onEntry((Object)this, "getTargetTypes", new Object[0]);
            set = this.__getTargetTypes();
            this.__IM.onExit((Object)this, "getTargetTypes", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTargetTypes", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<String> __getTargetTypes() {
        logger.debug((Object)"", new Object[0]);
        HashSet<String> ret = new HashSet<String>();
        ret.add("jmx");
        return ret;
    }

    public synchronized void addProbeListener(JasmineProbeListener jasmineProbeListener) {
        if (!this.__MaddProbeListener$org_ow2_jasmine_probe_JasmineProbeListener) {
            this.__addProbeListener(jasmineProbeListener);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addProbeListener$org_ow2_jasmine_probe_JasmineProbeListener", new Object[]{jasmineProbeListener});
            this.__addProbeListener(jasmineProbeListener);
            this.__IM.onExit((Object)this, "addProbeListener$org_ow2_jasmine_probe_JasmineProbeListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addProbeListener$org_ow2_jasmine_probe_JasmineProbeListener", throwable);
            throw throwable;
        }
    }

    private void __addProbeListener(JasmineProbeListener listener) {
        logger.debug((Object)"", new Object[0]);
        this.__getprobeListeners().add(listener);
    }

    public synchronized void removeProbeListener(JasmineProbeListener jasmineProbeListener) {
        if (!this.__MremoveProbeListener$org_ow2_jasmine_probe_JasmineProbeListener) {
            this.__removeProbeListener(jasmineProbeListener);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeProbeListener$org_ow2_jasmine_probe_JasmineProbeListener", new Object[]{jasmineProbeListener});
            this.__removeProbeListener(jasmineProbeListener);
            this.__IM.onExit((Object)this, "removeProbeListener$org_ow2_jasmine_probe_JasmineProbeListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeProbeListener$org_ow2_jasmine_probe_JasmineProbeListener", throwable);
            throw throwable;
        }
    }

    private void __removeProbeListener(JasmineProbeListener listener) {
        logger.debug((Object)"", new Object[0]);
        this.__getprobeListeners().remove(listener);
    }

    public void saveConfig(String string) throws JasmineProbeException {
        if (!this.__MsaveConfig$java_lang_String) {
            this.__saveConfig(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "saveConfig$java_lang_String", new Object[]{string});
            this.__saveConfig(string);
            this.__IM.onExit((Object)this, "saveConfig$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "saveConfig$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __saveConfig(String path) throws JasmineProbeException {
        logger.debug((Object)path, new Object[0]);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(new File(JProp.getConfDir(), "probe-config.xml"));
        }
        catch (FileNotFoundException e) {
            throw new JasmineProbeException("Cannot write the config file 'probe-config.xml'" + e);
        }
        if (outputStream == null) {
            throw new JasmineProbeException("Cannot write the config file 'probe-config.xml'");
        }
        try {
            this.saveConfigFile(outputStream);
        }
        catch (Exception e) {
            logger.warn((Object)("could not save config: " + e), new Object[0]);
            throw new JasmineProbeException("could not save config: " + e.getMessage());
        }
    }

    public void loadConfig(String string) throws JasmineProbeException {
        if (!this.__MloadConfig$java_lang_String) {
            this.__loadConfig(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "loadConfig$java_lang_String", new Object[]{string});
            this.__loadConfig(string);
            this.__IM.onExit((Object)this, "loadConfig$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadConfig$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __loadConfig(String path) throws JasmineProbeException {
        logger.debug((Object)path, new Object[0]);
        try {
            this.loadConfigFile(new FileInputStream(path));
        }
        catch (Exception e) {
            logger.warn((Object)("Cannot load config file: " + e), new Object[0]);
            throw new JasmineProbeException("Cannot load config file: " + e.getMessage());
        }
        this.startWaitingProbes();
    }

    public synchronized JasmineCollector getCollector(String string, String string2) throws JasmineProbeException {
        JasmineCollector jasmineCollector;
        if (!this.__MgetCollector$java_lang_String$java_lang_String) {
            return this.__getCollector(string, string2);
        }
        try {
            this.__IM.onEntry((Object)this, "getCollector$java_lang_String$java_lang_String", new Object[]{string, string2});
            jasmineCollector = this.__getCollector(string, string2);
            this.__IM.onExit((Object)this, "getCollector$java_lang_String$java_lang_String", (Object)jasmineCollector);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCollector$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineCollector;
    }

    private JasmineCollector __getCollector(String indicatorName, String probeid) throws JasmineProbeException {
        JasmineIndicator indicator = (JasmineIndicator)this.__getindicators().get(indicatorName);
        if (indicator == null) {
            throw new JasmineProbeException("Cannot return collector for non-existent indicator " + indicatorName);
        }
        JasmineCollectorService jcs = (JasmineCollectorService)this.__getcollectorservices().get(indicator.getType());
        if (jcs == null) {
            logger.error((Object)"No CollectorService found for {0} having type {1}", new Object[]{indicatorName, indicator.getType()});
            throw new JasmineProbeException("No CollectorService found for " + indicatorName);
        }
        JasmineCollector collector = null;
        try {
            collector = jcs.getCollector(indicator, (JasmineProbe)this.__getprobedefs().get(probeid));
        }
        catch (JasmineCollectorException e) {
            logger.error((Object)("Cannot get Collector for indicator " + indicatorName + ": " + (Object)((Object)e)), new Object[0]);
            throw new JasmineProbeException("Cannot get Collector for indicator " + indicatorName);
        }
        return collector;
    }

    public synchronized List<String> getAggregateFuntions() {
        List<String> list;
        if (!this.__MgetAggregateFuntions) {
            return this.__getAggregateFuntions();
        }
        try {
            this.__IM.onEntry((Object)this, "getAggregateFuntions", new Object[0]);
            list = this.__getAggregateFuntions();
            this.__IM.onExit((Object)this, "getAggregateFuntions", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAggregateFuntions", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getAggregateFuntions() {
        if (!this.__getaggregateservices().isEmpty()) {
            ArrayList<String> functions = new ArrayList<String>();
            Set keySet = this.__getaggregateservices().keySet();
            for (String function : keySet) {
                functions.add(function);
            }
            return functions;
        }
        return null;
    }

    public synchronized JasmineAggregateService getAggregate(String string) {
        JasmineAggregateService jasmineAggregateService;
        if (!this.__MgetAggregate$java_lang_String) {
            return this.__getAggregate(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getAggregate$java_lang_String", new Object[]{string});
            jasmineAggregateService = this.__getAggregate(string);
            this.__IM.onExit((Object)this, "getAggregate$java_lang_String", (Object)jasmineAggregateService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getAggregate$java_lang_String", throwable);
            throw throwable;
        }
        return jasmineAggregateService;
    }

    private JasmineAggregateService __getAggregate(String key) {
        if (this.__getaggregateservices().containsKey(key)) {
            return (JasmineAggregateService)this.__getaggregateservices().get(key);
        }
        return null;
    }

    public String getDomainName() {
        String string;
        if (!this.__MgetDomainName) {
            return this.__getDomainName();
        }
        try {
            this.__IM.onEntry((Object)this, "getDomainName", new Object[0]);
            string = this.__getDomainName();
            this.__IM.onExit((Object)this, "getDomainName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDomainName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getDomainName() {
        return this.__getjmxService().getDomainName();
    }

    public String getServerName() {
        String string;
        if (!this.__MgetServerName) {
            return this.__getServerName();
        }
        try {
            this.__IM.onEntry((Object)this, "getServerName", new Object[0]);
            string = this.__getServerName();
            this.__IM.onExit((Object)this, "getServerName", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getServerName", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getServerName() {
        return this.__getjmxService().getJonasServerName();
    }

    private synchronized String createOutputInternal(JasmineOutput jasmineOutput, boolean bl) throws JasmineProbeException {
        String string;
        if (!this.__McreateOutputInternal$org_ow2_jasmine_probe_JasmineOutput$boolean) {
            return this.__createOutputInternal(jasmineOutput, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "createOutputInternal$org_ow2_jasmine_probe_JasmineOutput$boolean", new Object[]{jasmineOutput, new Boolean(bl)});
            string = this.__createOutputInternal(jasmineOutput, bl);
            this.__IM.onExit((Object)this, "createOutputInternal$org_ow2_jasmine_probe_JasmineOutput$boolean", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createOutputInternal$org_ow2_jasmine_probe_JasmineOutput$boolean", throwable);
            throw throwable;
        }
        return string;
    }

    private String __createOutputInternal(JasmineOutput newoutput, boolean check) throws JasmineProbeException {
        String name = newoutput.getName();
        if (name == null || name.length() == 0) {
            throw new JasmineProbeException("No valid output name");
        }
        String type = newoutput.getType();
        if (type == null) {
            throw new JasmineProbeException("No type provided");
        }
        JasmineOutput oldoutput = (JasmineOutput)this.__getoutputs().get(name);
        if (oldoutput != null) {
            logger.debug((Object)(name + " output is already created"), new Object[0]);
            if (oldoutput.equals((Object)newoutput)) {
                return name;
            }
        }
        if (check) {
            JasmineOuterService jos = (JasmineOuterService)this.__getouterservices().get(type);
            if (jos == null) {
                throw new TypeNotSupportedException("Output type not supported: " + type);
            }
            String missinglist = "";
            for (JasminePropertyInfo jpi : jos.getPropertiesInfo()) {
                if (!jpi.isRequired()) continue;
                boolean found = false;
                for (String key : newoutput.getProperties().keySet()) {
                    if (!key.equals(jpi.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                missinglist = missinglist + " " + jpi.getName();
            }
            if (missinglist.length() > 0) {
                logger.warn((Object)("Missing mandatory properties:" + missinglist), new Object[0]);
                for (String key : newoutput.getProperties().keySet()) {
                    logger.warn((Object)("found " + key), new Object[0]);
                }
                throw new PropertyMissingException("Missing mandatory properties:" + missinglist);
            }
        }
        if (oldoutput != null) {
            logger.warn((Object)("old definition: " + oldoutput), new Object[0]);
            logger.warn((Object)("new definition: " + newoutput), new Object[0]);
            if (this.isDefUsed(oldoutput, true)) {
                throw new JasmineProbeException(name + " output cannot be re-created as a running probe is using it");
            }
            List<JasmineProbe> probesUsingOld = this.probesUsingDef(oldoutput, false);
            for (JasmineProbe usingOld : probesUsingOld) {
                JProbe running = (JProbe)this.__getprobes().get(usingOld.getId());
                if (running == null) continue;
                running.resetOutputs();
            }
            this.__getoutputs().remove(name);
        }
        this.__getoutputs().put(name, newoutput);
        return name;
    }

    public synchronized String createIndicatorInternal(JasmineIndicator jasmineIndicator, boolean bl) throws JasmineProbeException {
        String string;
        if (!this.__McreateIndicatorInternal$org_ow2_jasmine_probe_JasmineIndicator$boolean) {
            return this.__createIndicatorInternal(jasmineIndicator, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "createIndicatorInternal$org_ow2_jasmine_probe_JasmineIndicator$boolean", new Object[]{jasmineIndicator, new Boolean(bl)});
            string = this.__createIndicatorInternal(jasmineIndicator, bl);
            this.__IM.onExit((Object)this, "createIndicatorInternal$org_ow2_jasmine_probe_JasmineIndicator$boolean", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createIndicatorInternal$org_ow2_jasmine_probe_JasmineIndicator$boolean", throwable);
            throw throwable;
        }
        return string;
    }

    private String __createIndicatorInternal(JasmineIndicator newindic, boolean check) throws JasmineProbeException {
        String name = newindic.getName();
        if (name == null || name.length() == 0) {
            throw new JasmineProbeException("Automatic indicator name is not supported yet");
        }
        String type = newindic.getType();
        if (type == null) {
            this.__getindicators().get(name);
            throw new TypeNotSupportedException("No type provided");
        }
        JasmineIndicator oldindic = (JasmineIndicator)this.__getindicators().get(name);
        if (oldindic != null) {
            logger.debug((Object)(name + " indicator is already created"), new Object[0]);
            if (oldindic.equals((Object)newindic)) {
                return name;
            }
        }
        if (check) {
            JasmineCollectorService jcs = (JasmineCollectorService)this.__getcollectorservices().get(type);
            if (jcs == null) {
                throw new TypeNotSupportedException("Indicator type not supported: " + type);
            }
            JasmineCollectorInfo info = jcs.getCollectorInfo();
            String missinglist = "";
            for (JasminePropertyInfo jpi : info.getPropertyInfos()) {
                if (!jpi.isRequired()) continue;
                boolean found = false;
                for (String key : newindic.getProperties().keySet()) {
                    if (!key.equals(jpi.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                missinglist = missinglist + " " + jpi.getName();
            }
            if (missinglist.length() > 0) {
                throw new PropertyMissingException("Missing mandatory properties:" + missinglist);
            }
            if (newindic.getSources().size() < info.getSourceMin()) {
                throw new SourceNumberException("Missing source indicator. Minimum number is " + info.getSourceMin());
            }
            if (newindic.getSources().size() > info.getSourceMax() && info.getSourceMax() < 3) {
                throw new SourceNumberException("Too manysource indicators. Maximum number is " + info.getSourceMax());
            }
        }
        if (oldindic != null) {
            logger.warn((Object)("old definition: " + oldindic), new Object[0]);
            logger.warn((Object)("new definition: " + newindic), new Object[0]);
            if (this.isDefUsed(oldindic, true)) {
                throw new JasmineProbeException(name + " indicator cannot be re-created as a running probe is using it");
            }
            List<JasmineProbe> probesUsingOld = this.probesUsingDef(oldindic, false);
            for (JasmineProbe usingOld : probesUsingOld) {
                JProbe running = (JProbe)this.__getprobes().get(usingOld.getId());
                if (running == null) continue;
                running.resetIndicators();
            }
            this.__getindicators().remove(name);
        }
        this.__getindicators().put(name, newindic);
        return name;
    }

    private synchronized String getNewProbeId() {
        String string;
        if (!this.__MgetNewProbeId) {
            return this.__getNewProbeId();
        }
        try {
            this.__IM.onEntry((Object)this, "getNewProbeId", new Object[0]);
            string = this.__getNewProbeId();
            this.__IM.onExit((Object)this, "getNewProbeId", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getNewProbeId", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getNewProbeId() {
        String ret = "probe-0";
        boolean found = false;
        block0: while (!found) {
            StringBuilder stringBuilder = new StringBuilder().append("probe-");
            JProbeManager jProbeManager = this;
            int n = jProbeManager.__getprobeCount() + 1;
            jProbeManager.__setprobeCount(n);
            ret = stringBuilder.append(n).toString();
            found = true;
            for (JasmineProbe p : this.__getprobedefs().values()) {
                if (!p.getId().equals(ret)) continue;
                found = false;
                continue block0;
            }
        }
        return ret;
    }

    private void readConfig() throws Exception {
        if (!this.__MreadConfig) {
            this.__readConfig();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "readConfig", new Object[0]);
            this.__readConfig();
            this.__IM.onExit((Object)this, "readConfig", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "readConfig", throwable);
            throw throwable;
        }
    }

    private void __readConfig() throws Exception {
        String configurationFile = "probe-config.xml";
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        InputStream resource = null;
        try {
            resource = loader.getResourceAsStream(configurationFile);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot find probe-config.xml: " + e), new Object[0]);
            throw e;
        }
        if (resource == null) {
            logger.error((Object)"Cannot find probe-config.xml", new Object[0]);
            return;
        }
        logger.debug((Object)"Parsing probe-config.xml", new Object[0]);
        this.loadConfigFile(resource);
    }

    private void saveConfigFile(OutputStream outputStream) throws Exception {
        if (!this.__MsaveConfigFile$java_io_OutputStream) {
            this.__saveConfigFile(outputStream);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "saveConfigFile$java_io_OutputStream", new Object[]{outputStream});
            this.__saveConfigFile(outputStream);
            this.__IM.onExit((Object)this, "saveConfigFile$java_io_OutputStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "saveConfigFile$java_io_OutputStream", throwable);
            throw throwable;
        }
    }

    private void __saveConfigFile(OutputStream resource) throws Exception {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.__setprobeConfig(new ProbeConfig());
            ArrayList<OutputBaseType> olist = new ArrayList<OutputBaseType>();
            for (JasmineOutput jo : this.__getoutputs().values()) {
                OutputBaseType output = new OutputBaseType();
                output.setName(jo.getName());
                output.setType(jo.getType());
                for (String key : jo.getProperties().keySet()) {
                    PropType pv = new PropType();
                    pv.setKey(key);
                    pv.setValue((String)jo.getProperties().get(key));
                    output.getProperty().add(pv);
                }
                output.setDefault(Boolean.valueOf(false));
                for (String on : this.__getdefaultOutputList()) {
                    if (!on.equals(jo.getName())) continue;
                    output.setDefault(Boolean.valueOf(true));
                }
                olist.add(output);
            }
            this.__getprobeConfig().setOutput(olist);
            ArrayList<TargetBaseType> tlist = new ArrayList<TargetBaseType>();
            for (JasmineTarget jt : this.__gettargets().values()) {
                TargetBaseType target = new TargetBaseType();
                target.setName(jt.getName());
                target.setType(jt.getType());
                for (String key : jt.getProperties().keySet()) {
                    PropType pv = new PropType();
                    pv.setKey(key);
                    pv.setValue((String)jt.getProperties().get(key));
                    target.getProperty().add(pv);
                }
                tlist.add(target);
            }
            this.__getprobeConfig().setTarget(tlist);
            ArrayList<IndicatorBaseType> ilist = new ArrayList<IndicatorBaseType>();
            for (JasmineIndicator ji : this.__getindicators().values()) {
                IndicatorBaseType indic = new IndicatorBaseType();
                indic.setName(ji.getName());
                indic.setType(ji.getType());
                indic.setScale(new Integer(ji.getScale()));
                indic.setSource(ji.getSources());
                for (String key : ji.getProperties().keySet()) {
                    PropType pv = new PropType();
                    pv.setKey(key);
                    pv.setValue((String)ji.getProperties().get(key));
                    indic.getProperty().add(pv);
                }
                ilist.add(indic);
            }
            this.__getprobeConfig().setIndicator(ilist);
            ArrayList<ProbeType> plist = new ArrayList<ProbeType>();
            for (JasmineProbe jp : this.__getprobedefs().values()) {
                ProbeType pdata = new ProbeType();
                pdata.setId(jp.getId());
                pdata.setPeriod(new Integer(jp.getPeriod()));
                ArrayList<String> onlist = new ArrayList<String>();
                for (String output : jp.getOutputList()) {
                    onlist.add(output);
                }
                pdata.setOutput(onlist);
                ArrayList<String> talist = new ArrayList<String>();
                for (String target : jp.getTargetList()) {
                    talist.add(target);
                }
                pdata.setTarget(talist);
                ArrayList<String> inlist = new ArrayList<String>();
                for (String ind : jp.getIndicatorList()) {
                    inlist.add(ind);
                }
                pdata.setIndicator(inlist);
                switch (jp.getStatus()) {
                    case 0: 
                    case 3: {
                        pdata.setStatus(StatusType.STOPPED);
                        break;
                    }
                    case 1: 
                    case 2: {
                        pdata.setStatus(StatusType.STARTED);
                    }
                }
                plist.add(pdata);
            }
            this.__getprobeConfig().setProbe(plist);
            marshaller.marshal((Object)this.__getprobeConfig(), resource);
        }
        catch (Exception e) {
            logger.error((Object)("Error while writing probe-config.xml: " + e), new Object[0]);
            throw new JasmineProbeException("Error while writing probe-config.xml: " + e);
        }
        finally {
            try {
                resource.close();
            }
            catch (IOException ignore) {}
        }
    }

    private synchronized void loadConfigFile(InputStream inputStream) throws JasmineProbeException {
        if (!this.__MloadConfigFile$java_io_InputStream) {
            this.__loadConfigFile(inputStream);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "loadConfigFile$java_io_InputStream", new Object[]{inputStream});
            this.__loadConfigFile(inputStream);
            this.__IM.onExit((Object)this, "loadConfigFile$java_io_InputStream", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadConfigFile$java_io_InputStream", throwable);
            throw throwable;
        }
    }

    private void __loadConfigFile(InputStream resource) throws JasmineProbeException {
        try {
            HashMap<String, String> props;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            this.__setprobeConfig((ProbeConfig)unmarshaller.unmarshal(resource));
            for (OutputBaseType output : this.__getprobeConfig().getOutput()) {
                JasmineOutput jo = new JasmineOutput();
                jo.setName(output.getName());
                jo.setType(output.getType());
                if (output.getDefault()) {
                    this.__getdefaultOutputList().add(output.getName());
                }
                props = new HashMap<String, String>();
                for (PropType param : output.getProperty()) {
                    props.put(param.getKey(), param.getValue());
                }
                jo.setProperties(props);
                this.createOutputInternal(jo, false);
            }
            for (TargetBaseType target : this.__getprobeConfig().getTarget()) {
                JasmineTarget jt = new JasmineTarget();
                jt.setName(target.getName());
                props = new HashMap();
                for (PropType param : target.getProperty()) {
                    props.put(param.getKey(), param.getValue());
                }
                jt.setProperties(props);
                this.createTarget(jt);
            }
            for (IndicatorBaseType indic : this.__getprobeConfig().getIndicator()) {
                JasmineIndicator ji = new JasmineIndicator();
                ji.setName(indic.getName());
                ji.setType(indic.getType());
                ji.setScale(indic.getScale());
                ji.setSources(indic.getSource());
                props = new HashMap();
                for (PropType param : indic.getProperty()) {
                    props.put(param.getKey(), param.getValue());
                }
                ji.setProperties(props);
                this.createIndicatorInternal(ji, false);
            }
            for (ProbeType probe : this.__getprobeConfig().getProbe()) {
                StatusType status;
                JasmineProbe jp = new JasmineProbe();
                jp.setId(probe.getId());
                jp.setPeriod(probe.getPeriod().intValue());
                jp.setOutputList(probe.getOutput());
                jp.setIndicatorList(probe.getIndicator());
                jp.setTargetList(probe.getTarget());
                if (probe.getStatus() != null && (status = probe.getStatus()).equals((Object)StatusType.STARTED)) {
                    jp.setStatus(4);
                }
                this.createProbe(jp);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error in probe-config.xml: " + e), new Object[0]);
            throw new JasmineProbeException("Error in probe-config.xml: " + e);
        }
        finally {
            try {
                resource.close();
            }
            catch (IOException ignore) {}
        }
    }

    private synchronized boolean isDefUsed(Object object, boolean bl) {
        boolean bl2;
        if (!this.__MisDefUsed$java_lang_Object$boolean) {
            return this.__isDefUsed(object, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "isDefUsed$java_lang_Object$boolean", new Object[]{object, new Boolean(bl)});
            bl2 = this.__isDefUsed(object, bl);
            this.__IM.onExit((Object)this, "isDefUsed$java_lang_Object$boolean", (Object)new Boolean(bl2));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isDefUsed$java_lang_Object$boolean", throwable);
            throw throwable;
        }
        return bl2;
    }

    private boolean __isDefUsed(Object def, boolean checkrun) {
        for (JasmineProbe probe : this.__getprobedefs().values()) {
            boolean used = this.probeUsingDef(probe, def);
            if (!used || checkrun && probe.getStatus() != 2 && probe.getStatus() != 1 && probe.getStatus() != 4) continue;
            return true;
        }
        return false;
    }

    private synchronized List<JasmineProbe> probesUsingDef(Object object, boolean bl) {
        List<JasmineProbe> list;
        if (!this.__MprobesUsingDef$java_lang_Object$boolean) {
            return this.__probesUsingDef(object, bl);
        }
        try {
            this.__IM.onEntry((Object)this, "probesUsingDef$java_lang_Object$boolean", new Object[]{object, new Boolean(bl)});
            list = this.__probesUsingDef(object, bl);
            this.__IM.onExit((Object)this, "probesUsingDef$java_lang_Object$boolean", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "probesUsingDef$java_lang_Object$boolean", throwable);
            throw throwable;
        }
        return list;
    }

    private List<JasmineProbe> __probesUsingDef(Object def, boolean checkrun) {
        ArrayList<JasmineProbe> result = new ArrayList<JasmineProbe>();
        for (JasmineProbe probe : this.__getprobedefs().values()) {
            boolean used = this.probeUsingDef(probe, def);
            if (!used || checkrun && probe.getStatus() != 2 && probe.getStatus() != 1 && probe.getStatus() != 4) continue;
            result.add(probe);
        }
        return result;
    }

    private boolean probeUsingDef(JasmineProbe jasmineProbe, Object object) {
        boolean bl;
        if (!this.__MprobeUsingDef$org_ow2_jasmine_probe_JasmineProbe$java_lang_Object) {
            return this.__probeUsingDef(jasmineProbe, object);
        }
        try {
            this.__IM.onEntry((Object)this, "probeUsingDef$org_ow2_jasmine_probe_JasmineProbe$java_lang_Object", new Object[]{jasmineProbe, object});
            bl = this.__probeUsingDef(jasmineProbe, object);
            this.__IM.onExit((Object)this, "probeUsingDef$org_ow2_jasmine_probe_JasmineProbe$java_lang_Object", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "probeUsingDef$org_ow2_jasmine_probe_JasmineProbe$java_lang_Object", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __probeUsingDef(JasmineProbe probe, Object artifact) {
        String name = null;
        boolean targetArtifact = false;
        boolean indicArtifact = false;
        if (artifact instanceof JasmineIndicator) {
            name = ((JasmineIndicator)artifact).getName();
            indicArtifact = true;
            if (probe.getIndicatorList().contains(name)) {
                return true;
            }
        } else if (artifact instanceof JasmineOutput) {
            name = ((JasmineOutput)artifact).getName();
            if (probe.getOutputList().contains(name)) {
                return true;
            }
        } else if (artifact instanceof JasmineTarget) {
            name = ((JasmineTarget)artifact).getName();
            targetArtifact = true;
            if (probe.getTargetList().contains(name)) {
                return true;
            }
        } else {
            return false;
        }
        boolean used = false;
        if (indicArtifact || targetArtifact) {
            List<String> indicNames = this.getRecursiveIndicatorList(probe);
            if (indicArtifact && indicNames.contains(name)) {
                used = true;
            } else if (targetArtifact) {
                for (String indicName : indicNames) {
                    JasmineIndicator indic = (JasmineIndicator)this.__getindicators().get(indicName);
                    JasmineCollectorService jcs = (JasmineCollectorService)this.__getcollectorservices().get(indic.getType());
                    List usedTargets = jcs.getDependantTargets(indic);
                    if (usedTargets.isEmpty() || !usedTargets.contains(name)) continue;
                    used = true;
                    break;
                }
            }
        }
        return used;
    }

    public synchronized void setProbeState(JProbe jProbe, int n, String string) {
        if (!this.__MsetProbeState$org_ow2_jasmine_probe_manager_JProbe$int$java_lang_String) {
            this.__setProbeState(jProbe, n, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setProbeState$org_ow2_jasmine_probe_manager_JProbe$int$java_lang_String", new Object[]{jProbe, new Integer(n), string});
            this.__setProbeState(jProbe, n, string);
            this.__IM.onExit((Object)this, "setProbeState$org_ow2_jasmine_probe_manager_JProbe$int$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setProbeState$org_ow2_jasmine_probe_manager_JProbe$int$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setProbeState(JProbe running, int state, String message) {
        logger.debug((Object)("state =" + state), new Object[0]);
        running.setStatus(state);
        running.setError(message);
        for (JasmineProbeListener listener : this.__getprobeListeners()) {
            listener.notifyEvent(running.getProbeDef());
        }
    }

    private synchronized void startWaitingProbes() {
        if (!this.__MstartWaitingProbes) {
            this.__startWaitingProbes();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startWaitingProbes", new Object[0]);
            this.__startWaitingProbes();
            this.__IM.onExit((Object)this, "startWaitingProbes", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startWaitingProbes", throwable);
            throw throwable;
        }
    }

    private void __startWaitingProbes() {
        for (JasmineProbe probe : this.__getprobedefs().values()) {
            if (probe.getStatus() != 4 && probe.getStatus() != 3) continue;
            logger.debug((Object)(probe.getId() + " trying to start"), new Object[0]);
            JProbe running = new JProbe(probe, this);
            try {
                running.resume();
            }
            catch (JasmineProbeException e) {
                logger.warn((Object)("Cannot start probe now: " + probe.getId()), new Object[0]);
                continue;
            }
            this.__getprobes().put(probe.getId(), running);
        }
    }

    private synchronized List<String> getRecursiveIndicatorList(JasmineProbe jasmineProbe) {
        List<String> list;
        if (!this.__MgetRecursiveIndicatorList$org_ow2_jasmine_probe_JasmineProbe) {
            return this.__getRecursiveIndicatorList(jasmineProbe);
        }
        try {
            this.__IM.onEntry((Object)this, "getRecursiveIndicatorList$org_ow2_jasmine_probe_JasmineProbe", new Object[]{jasmineProbe});
            list = this.__getRecursiveIndicatorList(jasmineProbe);
            this.__IM.onExit((Object)this, "getRecursiveIndicatorList$org_ow2_jasmine_probe_JasmineProbe", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRecursiveIndicatorList$org_ow2_jasmine_probe_JasmineProbe", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getRecursiveIndicatorList(JasmineProbe probe) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String iname : probe.getIndicatorList()) {
            JasmineCollectorService jcs;
            ret.add(iname);
            JasmineIndicator indic = (JasmineIndicator)this.__getindicators().get(iname);
            if (indic == null || (jcs = (JasmineCollectorService)this.__getcollectorservices().get(indic.getType())) == null) continue;
            List full = jcs.getDependantIndicators(indic);
            ret.addAll(full);
        }
        return ret;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("jasmineProbeScheduler")) {
                this.__FjasmineProbeScheduler = true;
            }
            if (set.contains("probeListeners")) {
                this.__FprobeListeners = true;
            }
            if (set.contains("probedefs")) {
                this.__Fprobedefs = true;
            }
            if (set.contains("collectorservices")) {
                this.__Fcollectorservices = true;
            }
            if (set.contains("mbeanObjectName")) {
                this.__FmbeanObjectName = true;
            }
            if (set.contains("defaultOutputList")) {
                this.__FdefaultOutputList = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
            if (set.contains("indicators")) {
                this.__Findicators = true;
            }
            if (set.contains("probes")) {
                this.__Fprobes = true;
            }
            if (set.contains("probeCount")) {
                this.__FprobeCount = true;
            }
            if (set.contains("outerservices")) {
                this.__Fouterservices = true;
            }
            if (set.contains("aggregateservices")) {
                this.__Faggregateservices = true;
            }
            if (set.contains("outputs")) {
                this.__Foutputs = true;
            }
            if (set.contains("targets")) {
                this.__Ftargets = true;
            }
            if (set.contains("probeConfig")) {
                this.__FprobeConfig = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("registerMBeans")) {
                this.__MregisterMBeans = true;
            }
            if (set.contains("unregisterMBeans")) {
                this.__MunregisterMBeans = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("bindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference")) {
                this.__MbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("unbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference")) {
                this.__MunbindOuterService$org_ow2_jasmine_probe_outer_JasmineOuterService$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("bindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference")) {
                this.__MbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("unbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference")) {
                this.__MunbindCollectorService$org_ow2_jasmine_probe_collector_JasmineCollectorService$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("bindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference")) {
                this.__MbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("unbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference")) {
                this.__MunbindAggregateService$org_ow2_jasmine_probe_collector_JasmineAggregateService$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("getScheduler")) {
                this.__MgetScheduler = true;
            }
            if (set.contains("getOuterService$java_lang_String")) {
                this.__MgetOuterService$java_lang_String = true;
            }
            if (set.contains("getCollectorService$java_lang_String")) {
                this.__MgetCollectorService$java_lang_String = true;
            }
            if (set.contains("createProbe$org_ow2_jasmine_probe_JasmineProbe")) {
                this.__McreateProbe$org_ow2_jasmine_probe_JasmineProbe = true;
            }
            if (set.contains("removeProbe$java_lang_String")) {
                this.__MremoveProbe$java_lang_String = true;
            }
            if (set.contains("removeAllProbes")) {
                this.__MremoveAllProbes = true;
            }
            if (set.contains("getProbes")) {
                this.__MgetProbes = true;
            }
            if (set.contains("listProbes")) {
                this.__MlistProbes = true;
            }
            if (set.contains("getProbe$java_lang_String")) {
                this.__MgetProbe$java_lang_String = true;
            }
            if (set.contains("startProbe$java_lang_String")) {
                this.__MstartProbe$java_lang_String = true;
            }
            if (set.contains("stopProbe$java_lang_String")) {
                this.__MstopProbe$java_lang_String = true;
            }
            if (set.contains("startAllProbes")) {
                this.__MstartAllProbes = true;
            }
            if (set.contains("stopAllProbes")) {
                this.__MstopAllProbes = true;
            }
            if (set.contains("changeProbe$org_ow2_jasmine_probe_JasmineProbe")) {
                this.__MchangeProbe$org_ow2_jasmine_probe_JasmineProbe = true;
            }
            if (set.contains("changeProbePeriod$java_lang_String$int")) {
                this.__MchangeProbePeriod$java_lang_String$int = true;
            }
            if (set.contains("createOutput$org_ow2_jasmine_probe_JasmineOutput")) {
                this.__McreateOutput$org_ow2_jasmine_probe_JasmineOutput = true;
            }
            if (set.contains("changeOutput$org_ow2_jasmine_probe_JasmineOutput")) {
                this.__MchangeOutput$org_ow2_jasmine_probe_JasmineOutput = true;
            }
            if (set.contains("removeOutput$java_lang_String")) {
                this.__MremoveOutput$java_lang_String = true;
            }
            if (set.contains("listOutputs$java_lang_String")) {
                this.__MlistOutputs$java_lang_String = true;
            }
            if (set.contains("getOutputs")) {
                this.__MgetOutputs = true;
            }
            if (set.contains("addDefaultOutput$java_lang_String")) {
                this.__MaddDefaultOutput$java_lang_String = true;
            }
            if (set.contains("listDefaultOutputs")) {
                this.__MlistDefaultOutputs = true;
            }
            if (set.contains("removeDefaultOutput$java_lang_String")) {
                this.__MremoveDefaultOutput$java_lang_String = true;
            }
            if (set.contains("getOutputs$java_lang_String")) {
                this.__MgetOutputs$java_lang_String = true;
            }
            if (set.contains("getOutput$java_lang_String")) {
                this.__MgetOutput$java_lang_String = true;
            }
            if (set.contains("getOutputPropertyInfos$java_lang_String")) {
                this.__MgetOutputPropertyInfos$java_lang_String = true;
            }
            if (set.contains("getOutputTypes")) {
                this.__MgetOutputTypes = true;
            }
            if (set.contains("getOutputCurrentUse$java_lang_String")) {
                this.__MgetOutputCurrentUse$java_lang_String = true;
            }
            if (set.contains("createIndicator$org_ow2_jasmine_probe_JasmineIndicator")) {
                this.__McreateIndicator$org_ow2_jasmine_probe_JasmineIndicator = true;
            }
            if (set.contains("changeIndicator$org_ow2_jasmine_probe_JasmineIndicator")) {
                this.__MchangeIndicator$org_ow2_jasmine_probe_JasmineIndicator = true;
            }
            if (set.contains("removeIndicator$java_lang_String")) {
                this.__MremoveIndicator$java_lang_String = true;
            }
            if (set.contains("getIndicator$java_lang_String")) {
                this.__MgetIndicator$java_lang_String = true;
            }
            if (set.contains("getIndicators")) {
                this.__MgetIndicators = true;
            }
            if (set.contains("getIndicators$java_lang_String")) {
                this.__MgetIndicators$java_lang_String = true;
            }
            if (set.contains("listIndicators$java_lang_String")) {
                this.__MlistIndicators$java_lang_String = true;
            }
            if (set.contains("getIndicatorTypeInfo$java_lang_String")) {
                this.__MgetIndicatorTypeInfo$java_lang_String = true;
            }
            if (set.contains("getIndicatorTypes")) {
                this.__MgetIndicatorTypes = true;
            }
            if (set.contains("getIndicatorCurrentUse$java_lang_String")) {
                this.__MgetIndicatorCurrentUse$java_lang_String = true;
            }
            if (set.contains("createTarget$org_ow2_jasmine_probe_JasmineTarget")) {
                this.__McreateTarget$org_ow2_jasmine_probe_JasmineTarget = true;
            }
            if (set.contains("changeTarget$org_ow2_jasmine_probe_JasmineTarget")) {
                this.__MchangeTarget$org_ow2_jasmine_probe_JasmineTarget = true;
            }
            if (set.contains("removeTarget$java_lang_String")) {
                this.__MremoveTarget$java_lang_String = true;
            }
            if (set.contains("listTargets")) {
                this.__MlistTargets = true;
            }
            if (set.contains("getTargets")) {
                this.__MgetTargets = true;
            }
            if (set.contains("getTarget$java_lang_String")) {
                this.__MgetTarget$java_lang_String = true;
            }
            if (set.contains("getTargetPropertyInfos$java_lang_String")) {
                this.__MgetTargetPropertyInfos$java_lang_String = true;
            }
            if (set.contains("getTargetTypes")) {
                this.__MgetTargetTypes = true;
            }
            if (set.contains("addProbeListener$org_ow2_jasmine_probe_JasmineProbeListener")) {
                this.__MaddProbeListener$org_ow2_jasmine_probe_JasmineProbeListener = true;
            }
            if (set.contains("removeProbeListener$org_ow2_jasmine_probe_JasmineProbeListener")) {
                this.__MremoveProbeListener$org_ow2_jasmine_probe_JasmineProbeListener = true;
            }
            if (set.contains("saveConfig$java_lang_String")) {
                this.__MsaveConfig$java_lang_String = true;
            }
            if (set.contains("loadConfig$java_lang_String")) {
                this.__MloadConfig$java_lang_String = true;
            }
            if (set.contains("getCollector$java_lang_String$java_lang_String")) {
                this.__MgetCollector$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getAggregateFuntions")) {
                this.__MgetAggregateFuntions = true;
            }
            if (set.contains("getAggregate$java_lang_String")) {
                this.__MgetAggregate$java_lang_String = true;
            }
            if (set.contains("getDomainName")) {
                this.__MgetDomainName = true;
            }
            if (set.contains("getServerName")) {
                this.__MgetServerName = true;
            }
            if (set.contains("createOutputInternal$org_ow2_jasmine_probe_JasmineOutput$boolean")) {
                this.__McreateOutputInternal$org_ow2_jasmine_probe_JasmineOutput$boolean = true;
            }
            if (set.contains("createIndicatorInternal$org_ow2_jasmine_probe_JasmineIndicator$boolean")) {
                this.__McreateIndicatorInternal$org_ow2_jasmine_probe_JasmineIndicator$boolean = true;
            }
            if (set.contains("getNewProbeId")) {
                this.__MgetNewProbeId = true;
            }
            if (set.contains("readConfig")) {
                this.__MreadConfig = true;
            }
            if (set.contains("saveConfigFile$java_io_OutputStream")) {
                this.__MsaveConfigFile$java_io_OutputStream = true;
            }
            if (set.contains("loadConfigFile$java_io_InputStream")) {
                this.__MloadConfigFile$java_io_InputStream = true;
            }
            if (set.contains("isDefUsed$java_lang_Object$boolean")) {
                this.__MisDefUsed$java_lang_Object$boolean = true;
            }
            if (set.contains("probesUsingDef$java_lang_Object$boolean")) {
                this.__MprobesUsingDef$java_lang_Object$boolean = true;
            }
            if (set.contains("probeUsingDef$org_ow2_jasmine_probe_JasmineProbe$java_lang_Object")) {
                this.__MprobeUsingDef$org_ow2_jasmine_probe_JasmineProbe$java_lang_Object = true;
            }
            if (set.contains("setProbeState$org_ow2_jasmine_probe_manager_JProbe$int$java_lang_String")) {
                this.__MsetProbeState$org_ow2_jasmine_probe_manager_JProbe$int$java_lang_String = true;
            }
            if (set.contains("startWaitingProbes")) {
                this.__MstartWaitingProbes = true;
            }
            if (set.contains("getRecursiveIndicatorList$org_ow2_jasmine_probe_JasmineProbe")) {
                this.__MgetRecursiveIndicatorList$org_ow2_jasmine_probe_JasmineProbe = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

