/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.pool;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.mule.config.PoolingProfile;
import org.mule.config.pool.CommonsPoolProxyFactory;
import org.mule.impl.MuleDescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Startable;
import org.mule.umo.lifecycle.Stoppable;
import org.mule.umo.model.UMOModel;
import org.mule.util.ObjectFactory;
import org.mule.util.ObjectPool;

public class CommonsPoolProxyPool
implements ObjectPool {
    protected static final Log logger = LogFactory.getLog((Class)CommonsPoolProxyPool.class);
    protected GenericObjectPool pool;
    protected ObjectFactory factory;
    private List components;

    public CommonsPoolProxyPool(MuleDescriptor descriptor, UMOModel model, ObjectFactory factory, PoolingProfile pp) {
        this.factory = factory;
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxIdle = pp.getMaxIdle();
        config.maxActive = pp.getMaxActive();
        config.maxWait = pp.getMaxWait();
        config.whenExhaustedAction = (byte)pp.getExhaustedAction();
        this.init(descriptor, model, config);
    }

    public CommonsPoolProxyPool(MuleDescriptor descriptor, UMOModel model, GenericObjectPool.Config config) {
        this.init(descriptor, model, config);
    }

    private void init(MuleDescriptor descriptor, UMOModel model, GenericObjectPool.Config config) {
        this.components = new ArrayList();
        if (this.factory == null) {
            this.setFactory(new CommonsPoolProxyFactory(descriptor, model));
        }
        this.pool = new GenericObjectPool((PoolableObjectFactory)((Object)this.factory), config);
        if (this.factory instanceof CommonsPoolProxyFactory) {
            ((CommonsPoolProxyFactory)this.factory).setPool(this);
        }
    }

    public Object borrowObject() throws Exception {
        return this.pool.borrowObject();
    }

    public void returnObject(Object object) throws Exception {
        this.pool.returnObject(object);
    }

    public int getSize() {
        return this.pool.getNumActive();
    }

    public int getMaxSize() {
        return this.pool.getMaxActive();
    }

    public void setFactory(ObjectFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPool() {
        List list = this.components;
        synchronized (list) {
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                ((Disposable)i.next()).dispose();
            }
            this.components.clear();
        }
        this.pool.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAdd(Object proxy) {
        List list = this.components;
        synchronized (list) {
            this.components.add(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemove(Object proxy) {
        List list = this.components;
        synchronized (list) {
            boolean wasRemoved = this.components.remove(proxy);
            if (wasRemoved) {
                ((Disposable)proxy).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws UMOException {
        List list = this.components;
        synchronized (list) {
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                ((Startable)i.next()).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws UMOException {
        List list = this.components;
        synchronized (list) {
            Iterator i = this.components.iterator();
            while (i.hasNext()) {
                ((Stoppable)i.next()).stop();
            }
        }
    }
}

