/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleTransactionConfig;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.AbstractConnector;
import org.mule.providers.service.TransportFactory;
import org.mule.providers.service.TransportFactoryException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransactionConfig;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.security.UMOEndpointSecurityFilter;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassUtils;
import org.mule.util.MuleObjectHelper;
import org.mule.util.ObjectNameHelper;
import org.mule.util.StringUtils;

public class ImmutableMuleEndpoint
implements UMOImmutableEndpoint {
    protected static final Log logger = LogFactory.getLog((Class)ImmutableMuleEndpoint.class);
    protected UMOConnector connector = null;
    protected UMOEndpointURI endpointUri = null;
    protected UMOTransformer transformer = null;
    protected UMOTransformer responseTransformer = null;
    protected String name = null;
    protected String type = "senderAndReceiver";
    protected Map properties = null;
    protected UMOTransactionConfig transactionConfig = null;
    protected UMOFilter filter = null;
    protected boolean deleteUnacceptedMessages = false;
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected UMOEndpointSecurityFilter securityFilter = null;
    protected Boolean synchronous = null;
    protected Boolean remoteSync = null;
    protected Integer remoteSyncTimeout = null;
    protected boolean streaming = false;
    protected String initialState = "started";
    protected String endpointEncoding = null;
    protected int createConnector = 0;

    private ImmutableMuleEndpoint() {
    }

    public ImmutableMuleEndpoint(String name, UMOEndpointURI endpointUri, UMOConnector connector, UMOTransformer transformer, String type, int createConnector, String endpointEncoding, Map props) {
        this.name = name;
        this.connector = connector;
        this.createConnector = createConnector;
        this.endpointEncoding = endpointEncoding;
        this.type = type;
        if (endpointUri != null) {
            this.endpointUri = new MuleEndpointURI(endpointUri);
        }
        if (transformer != null) {
            transformer.setEndpoint(this);
            this.transformer = transformer;
        }
        this.properties = new ConcurrentHashMap();
        if (props != null) {
            this.properties.putAll(props);
        }
        if (endpointUri != null) {
            this.properties.putAll(endpointUri.getParams());
        }
        if (!(this instanceof MuleEndpoint)) {
            this.properties = Collections.unmodifiableMap(this.properties);
        }
        this.transactionConfig = new MuleTransactionConfig();
    }

    public ImmutableMuleEndpoint(UMOImmutableEndpoint source) {
        this();
        this.initFromDescriptor(source);
    }

    public ImmutableMuleEndpoint(String endpointName, boolean receiver) throws UMOException {
        this();
        String type = receiver ? "receiver" : "sender";
        UMOEndpoint p = ImmutableMuleEndpoint.getOrCreateEndpointForUri(new MuleEndpointURI(endpointName), type);
        this.initFromDescriptor(p);
    }

    protected void initFromDescriptor(UMOImmutableEndpoint source) {
        if (this.name == null) {
            this.name = source.getName();
        }
        if (this.endpointUri == null && source.getEndpointURI() != null) {
            this.endpointUri = new MuleEndpointURI(source.getEndpointURI());
        }
        if (this.endpointEncoding == null) {
            this.endpointEncoding = source.getEncoding();
        }
        if (this.connector == null) {
            this.connector = source.getConnector();
        }
        if (this.transformer == null) {
            this.transformer = source.getTransformer();
        }
        if (this.transformer != null) {
            this.transformer.setEndpoint(this);
        }
        if (this.responseTransformer == null) {
            this.responseTransformer = source.getResponseTransformer();
        }
        if (this.responseTransformer != null) {
            this.responseTransformer.setEndpoint(this);
        }
        this.properties = new ConcurrentHashMap();
        if (source.getProperties() != null) {
            this.properties.putAll(source.getProperties());
        }
        if (this.endpointUri != null && this.endpointUri.getParams() != null) {
            this.properties.putAll(this.endpointUri.getParams());
        }
        if (!(this instanceof MuleEndpoint)) {
            this.properties = Collections.unmodifiableMap(this.properties);
        }
        this.type = source.getType();
        this.transactionConfig = source.getTransactionConfig();
        this.deleteUnacceptedMessages = source.isDeleteUnacceptedMessages();
        this.initialState = source.getInitialState();
        this.remoteSyncTimeout = new Integer(source.getRemoteSyncTimeout());
        this.remoteSync = source.isRemoteSync();
        this.filter = source.getFilter();
        this.securityFilter = source.getSecurityFilter();
    }

    public UMOEndpointURI getEndpointURI() {
        return this.endpointUri;
    }

    public String getEncoding() {
        return this.endpointEncoding;
    }

    public String getType() {
        return this.type;
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public String getName() {
        return this.name;
    }

    public UMOTransformer getTransformer() {
        return this.transformer;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Object clone() {
        MuleEndpoint clone = new MuleEndpoint(this.name, this.endpointUri, this.connector, this.transformer, this.type, this.createConnector, this.endpointEncoding, this.properties);
        clone.setTransactionConfig(this.transactionConfig);
        clone.setFilter(this.filter);
        clone.setSecurityFilter(this.securityFilter);
        if (this.remoteSync != null) {
            clone.setRemoteSync(this.isRemoteSync());
        }
        if (this.remoteSyncTimeout != null) {
            clone.setRemoteSyncTimeout(this.getRemoteSyncTimeout());
        }
        if (this.synchronous != null) {
            clone.setSynchronous(this.synchronous);
        }
        clone.setDeleteUnacceptedMessages(this.deleteUnacceptedMessages);
        clone.setInitialState(this.initialState);
        if (this.initialised.get()) {
            try {
                clone.initialise();
            }
            catch (InitialisationException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return clone;
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        String sanitizedEndPointUri = null;
        URI uri = null;
        if (this.endpointUri != null) {
            sanitizedEndPointUri = this.endpointUri.toString();
            uri = this.endpointUri.getUri();
        }
        if (uri != null && uri.getRawUserInfo() != null && uri.getScheme() != null && uri.getHost() != null && uri.getRawPath() != null) {
            Pattern sanitizerPattern = Pattern.compile("(.*):.*");
            Matcher sanitizerMatcher = sanitizerPattern.matcher(uri.getRawUserInfo());
            if (sanitizerMatcher.matches()) {
                sanitizedEndPointUri = uri.getScheme() + "://" + sanitizerMatcher.group(1) + ":<password>" + "@" + uri.getHost() + uri.getRawPath();
            }
            if (uri.getRawQuery() != null) {
                sanitizedEndPointUri = sanitizedEndPointUri + "?" + uri.getRawQuery();
            }
        }
        return ClassUtils.getClassName(this.getClass()) + "{endpointUri=" + sanitizedEndPointUri + ", connector=" + this.connector + ", transformer=" + this.transformer + ", name='" + this.name + "'" + ", type='" + this.type + "'" + ", properties=" + this.properties + ", transactionConfig=" + this.transactionConfig + ", filter=" + this.filter + ", deleteUnacceptedMessages=" + this.deleteUnacceptedMessages + ", initialised=" + this.initialised + ", securityFilter=" + this.securityFilter + ", synchronous=" + this.synchronous + ", initialState=" + this.initialState + ", createConnector=" + this.createConnector + ", remoteSync=" + this.remoteSync + ", remoteSyncTimeout=" + this.remoteSyncTimeout + ", endpointEncoding=" + this.endpointEncoding + "}";
    }

    public String getProtocol() {
        return this.connector.getProtocol();
    }

    public boolean canReceive() {
        return this.getType().equals("receiver") || this.getType().equals("senderAndReceiver");
    }

    public boolean canSend() {
        return this.getType().equals("sender") || this.getType().equals("senderAndReceiver");
    }

    public UMOTransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableMuleEndpoint)) {
            return false;
        }
        ImmutableMuleEndpoint immutableMuleProviderDescriptor = (ImmutableMuleEndpoint)o;
        if (!this.connector.getName().equals(immutableMuleProviderDescriptor.connector.getName())) {
            return false;
        }
        if (this.endpointUri != null && immutableMuleProviderDescriptor.endpointUri != null ? !this.endpointUri.getAddress().equals(immutableMuleProviderDescriptor.endpointUri.getAddress()) : immutableMuleProviderDescriptor.endpointUri != null) {
            return false;
        }
        if (!this.name.equals(immutableMuleProviderDescriptor.name)) {
            return false;
        }
        return this.type.equals(immutableMuleProviderDescriptor.type);
    }

    public int hashCode() {
        int result = this.appendHash(0, this.connector);
        result = this.appendHash(result, this.endpointUri);
        result = this.appendHash(result, this.name);
        result = this.appendHash(result, this.type);
        return result;
    }

    private int appendHash(int hash, Object component) {
        int delta = component != null ? component.hashCode() : 0;
        return 29 * hash + delta;
    }

    public UMOFilter getFilter() {
        return this.filter;
    }

    public static UMOEndpoint createEndpointFromUri(UMOEndpointURI uri, String type) throws UMOException {
        return TransportFactory.createEndpoint(uri, type);
    }

    public static UMOEndpoint getEndpointFromUri(String uri) {
        UMOEndpoint endpoint = null;
        if (uri != null) {
            String endpointString = MuleManager.getInstance().lookupEndpointIdentifier(uri, uri);
            endpoint = MuleManager.getInstance().lookupEndpoint(endpointString);
        }
        return endpoint;
    }

    public static UMOEndpoint getEndpointFromUri(UMOEndpointURI uri) throws UMOException {
        String endpointName = uri.getEndpointName();
        if (endpointName != null) {
            String endpointString = MuleManager.getInstance().lookupEndpointIdentifier(endpointName, endpointName);
            UMOEndpoint endpoint = MuleManager.getInstance().lookupEndpoint(endpointString);
            if (endpoint != null && StringUtils.isNotEmpty(uri.getAddress())) {
                endpoint.setEndpointURI(uri);
            }
            return endpoint;
        }
        return null;
    }

    public static UMOEndpoint getOrCreateEndpointForUri(String uriIdentifier, String type) throws UMOException {
        UMOEndpoint endpoint = ImmutableMuleEndpoint.getEndpointFromUri(uriIdentifier);
        if (endpoint == null) {
            endpoint = ImmutableMuleEndpoint.createEndpointFromUri(new MuleEndpointURI(uriIdentifier), type);
        } else if (endpoint.getType().equals("senderAndReceiver")) {
            endpoint.setType(type);
        } else if (!endpoint.getType().equals(type)) {
            throw new IllegalArgumentException("Endpoint matching: " + uriIdentifier + " is not of type: " + type + ". It is of type: " + endpoint.getType());
        }
        return endpoint;
    }

    public static UMOEndpoint getOrCreateEndpointForUri(UMOEndpointURI uri, String type) throws UMOException {
        UMOEndpoint endpoint = ImmutableMuleEndpoint.getEndpointFromUri(uri);
        if (endpoint == null) {
            endpoint = ImmutableMuleEndpoint.createEndpointFromUri(uri, type);
        }
        return endpoint;
    }

    public boolean isDeleteUnacceptedMessages() {
        return this.deleteUnacceptedMessages;
    }

    public void initialise() throws InitialisationException {
        String rsTimeout;
        String rs;
        if (this.initialised.get()) {
            logger.debug((Object)("Already initialised: " + this.toString()));
            return;
        }
        if (this.connector == null) {
            if (this.endpointUri.getConnectorName() != null) {
                this.connector = MuleManager.getInstance().lookupConnector(this.endpointUri.getConnectorName());
                if (this.connector == null) {
                    throw new IllegalArgumentException("Connector not found: " + this.endpointUri.getConnectorName());
                }
            } else {
                try {
                    this.connector = TransportFactory.getOrCreateConnectorByProtocol(this);
                    if (this.connector == null) {
                        throw new InitialisationException(CoreMessages.connectorWithProtocolNotRegistered(this.endpointUri.getScheme()), (Object)this);
                    }
                }
                catch (TransportFactoryException e) {
                    throw new InitialisationException(CoreMessages.failedToCreateConnectorFromUri(this.endpointUri), e, this);
                }
            }
            if (this.endpointUri.getEndpointName() != null && this.name == null) {
                this.name = this.endpointUri.getEndpointName();
            }
        }
        this.name = ObjectNameHelper.getEndpointName(this);
        String sync = this.endpointUri.getParams().getProperty("synchronous", null);
        if (sync != null) {
            this.synchronous = Boolean.valueOf(sync);
        }
        if (this.properties != null && this.endpointUri.getParams() != null) {
            this.properties.putAll(this.endpointUri.getParams());
        }
        if (this.endpointUri.getTransformers() != null) {
            try {
                this.transformer = MuleObjectHelper.getTransformer(this.endpointUri.getTransformers(), ",");
            }
            catch (MuleException e) {
                throw new InitialisationException(e, (Object)this);
            }
        }
        if (this.transformer == null && this.connector instanceof AbstractConnector) {
            if ("sender".equals(this.type)) {
                this.transformer = ((AbstractConnector)this.connector).getDefaultOutboundTransformer();
            } else if ("senderAndReceiver".equals(this.type)) {
                this.transformer = ((AbstractConnector)this.connector).getDefaultOutboundTransformer();
                this.responseTransformer = ((AbstractConnector)this.connector).getDefaultInboundTransformer();
            } else {
                this.transformer = ((AbstractConnector)this.connector).getDefaultInboundTransformer();
            }
        }
        if (this.transformer != null) {
            this.transformer.setEndpoint(this);
        }
        if (this.endpointUri.getResponseTransformers() != null) {
            try {
                this.responseTransformer = MuleObjectHelper.getTransformer(this.endpointUri.getResponseTransformers(), ",");
            }
            catch (MuleException e) {
                throw new InitialisationException(e, (Object)this);
            }
        }
        if (this.responseTransformer == null && "receiver".equals(this.type) && this.connector instanceof AbstractConnector) {
            this.responseTransformer = ((AbstractConnector)this.connector).getDefaultResponseTransformer();
        }
        if (this.responseTransformer != null) {
            this.responseTransformer.setEndpoint(this);
        }
        if (this.securityFilter != null) {
            this.securityFilter.setEndpoint(this);
            this.securityFilter.initialise();
        }
        if ((rs = (String)this.endpointUri.getParams().remove("remoteSync")) != null) {
            this.remoteSync = Boolean.valueOf(rs);
        }
        if ((rsTimeout = (String)this.endpointUri.getParams().remove("remoteSyncTimeout")) != null) {
            this.remoteSyncTimeout = Integer.valueOf(rsTimeout);
        }
        this.initialised.set(true);
    }

    public UMOEndpointSecurityFilter getSecurityFilter() {
        return this.securityFilter;
    }

    public boolean isSynchronous() {
        if (this.synchronous == null) {
            return MuleManager.getConfiguration().isSynchronous();
        }
        return this.synchronous;
    }

    public boolean isSynchronousSet() {
        return this.synchronous != null;
    }

    public int getCreateConnector() {
        return this.createConnector;
    }

    public boolean isRemoteSync() {
        if (this.remoteSync == null) {
            this.remoteSync = this.connector == null || this.connector.isRemoteSyncEnabled() ? Boolean.valueOf(MuleManager.getConfiguration().isRemoteSync()) : Boolean.FALSE;
        }
        return this.remoteSync;
    }

    public int getRemoteSyncTimeout() {
        if (this.remoteSyncTimeout == null) {
            this.remoteSyncTimeout = new Integer(MuleManager.getConfiguration().getSynchronousEventTimeout());
        }
        return this.remoteSyncTimeout;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public UMOTransformer getResponseTransformer() {
        return this.responseTransformer;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public Object getProperty(Object key) {
        Object value = this.properties.get(key);
        if (value == null) {
            value = this.endpointUri.getParams().get(key);
        }
        return value;
    }

    public void dispatch(UMOEvent event) throws DispatchException {
        if (this.connector == null) {
            throw new IllegalStateException("The connector on the endpoint: " + this.toString() + "is null. Please contact dev@mule.codehaus.org");
        }
        this.connector.dispatch(this, event);
    }

    public UMOMessage receive(long timeout) throws Exception {
        if (this.connector != null) {
            return this.connector.receive(this, timeout);
        }
        throw new IllegalStateException("The connector on the endpoint: " + this.toString() + "is null. Please contact dev@mule.codehaus.org");
    }

    public UMOMessage send(UMOEvent event) throws DispatchException {
        if (this.connector != null) {
            return this.connector.send(this, event);
        }
        throw new IllegalStateException("The connector on the endpoint: " + this.toString() + "is null. Please contact dev@mule.codehaus.org");
    }
}

