/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.admin;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.RequestContext;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.internal.notifications.AdminNotification;
import org.mule.impl.message.ExceptionPayload;
import org.mule.impl.model.ModelHelper;
import org.mule.providers.AbstractConnector;
import org.mule.providers.NullPayload;
import org.mule.transformers.wire.WireFormat;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.UMOTransformer;

public class MuleManagerComponent
implements Callable,
Initialisable {
    protected static final Log logger = LogFactory.getLog((Class)MuleManagerComponent.class);
    public static final String MANAGER_COMPONENT_NAME = "_muleManagerComponent";
    public static final String MANAGER_ENDPOINT_NAME = "_muleManagerEndpoint";
    protected WireFormat wireFormat;

    public void initialise() throws InitialisationException {
        if (this.wireFormat == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("wireFormat"), (Object)this);
        }
    }

    public Object onCall(UMOEventContext context) throws Exception {
        logger.debug((Object)"Message received by MuleManagerComponent");
        ByteArrayInputStream in = new ByteArrayInputStream(context.getTransformedMessageAsBytes());
        AdminNotification action = (AdminNotification)this.wireFormat.read(in);
        Object result = 604 == action.getAction() ? this.invokeAction(action, context) : (603 == action.getAction() || 602 == action.getAction() ? this.sendAction(action, context) : (601 == action.getAction() ? this.receiveAction(action, context) : this.handleException(null, new MuleException(CoreMessages.eventTypeNotRecognised("AdminNotification:" + action.getAction())))));
        return result;
    }

    protected Object invokeAction(AdminNotification action, UMOEventContext context) throws UMOException {
        String destComponent = null;
        UMOMessage result = null;
        String endpoint = action.getResourceIdentifier();
        destComponent = action.getResourceIdentifier().startsWith("mule:") ? endpoint.substring(endpoint.lastIndexOf("/") + 1) : endpoint;
        if (destComponent != null) {
            MuleSession session = new MuleSession(ModelHelper.getComponent(destComponent));
            MuleEndpoint ep = new MuleEndpoint(RequestContext.getEvent().getEndpoint());
            ep.setTransformer(null);
            UMOEvent event = new MuleEvent(action.getMessage(), (UMOImmutableEndpoint)ep, context.getSession(), context.isSynchronous());
            event = RequestContext.setEvent(event);
            if (context.isSynchronous()) {
                result = session.getComponent().sendEvent(event);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.wireFormat.write(out, result);
                return out.toByteArray();
            }
            session.getComponent().dispatchEvent(event);
            return null;
        }
        return this.handleException(result, new MuleException(CoreMessages.couldNotDetermineDestinationComponentFromEndpoint(endpoint)));
    }

    protected Object sendAction(AdminNotification action, UMOEventContext context) throws UMOException {
        UMOMessage result = null;
        try {
            MuleEndpoint endpoint = new MuleEndpoint(action.getResourceIdentifier(), false);
            if (602 == action.getAction()) {
                context.dispatchEvent(action.getMessage(), endpoint);
                return null;
            }
            endpoint.setRemoteSync(true);
            result = context.sendEvent(action.getMessage(), endpoint);
            if (result == null) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.wireFormat.write(out, result);
            return out.toByteArray();
        }
        catch (Exception e) {
            return this.handleException(result, e);
        }
    }

    protected Object receiveAction(AdminNotification action, UMOEventContext context) throws UMOException {
        UMOMessage result = null;
        try {
            MuleEndpointURI endpointUri = new MuleEndpointURI(action.getResourceIdentifier());
            UMOEndpoint endpoint = MuleEndpoint.getOrCreateEndpointForUri(endpointUri, "sender");
            long timeout = MapUtils.getLongValue((Map)action.getProperties(), (Object)"MULE_EVENT_TIMEOUT", (long)MuleManager.getConfiguration().getSynchronousEventTimeout());
            MuleEndpointURI ep = new MuleEndpointURI(action.getResourceIdentifier());
            result = endpoint.getConnector().receive(ep, timeout);
            if (result != null) {
                UMOTransformer trans = ((AbstractConnector)endpoint.getConnector()).getDefaultInboundTransformer();
                if (trans != null) {
                    Object payload = trans.transform(result.getPayload());
                    result = new MuleMessage(payload, result);
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.wireFormat.write(out, result);
                return out.toByteArray();
            }
            return null;
        }
        catch (Exception e) {
            return this.handleException(result, e);
        }
    }

    public static final UMODescriptor getDescriptor(UMOConnector connector, UMOEndpointURI endpointUri, WireFormat wireFormat) throws UMOException {
        MuleEndpoint endpoint = new MuleEndpoint();
        endpoint.setConnector(connector);
        endpoint.setEndpointURI(endpointUri);
        endpoint.setName(MANAGER_ENDPOINT_NAME);
        endpoint.setType("receiver");
        MuleDescriptor descriptor = new MuleDescriptor();
        descriptor.setName(MANAGER_COMPONENT_NAME);
        descriptor.setInboundEndpoint(endpoint);
        descriptor.setImplementation(MuleManagerComponent.class.getName());
        descriptor.setContainerManaged(false);
        HashMap<String, WireFormat> props = new HashMap<String, WireFormat>();
        props.put("wireFormat", wireFormat);
        descriptor.setProperties(props);
        return descriptor;
    }

    protected String handleException(UMOMessage result, Throwable e) {
        logger.error((Object)("Failed to process admin request: " + e.getMessage()), e);
        if (result == null) {
            result = new MuleMessage((Object)NullPayload.getInstance(), (Map)null);
        }
        result.setExceptionPayload(new ExceptionPayload(e));
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.wireFormat.write(out, result);
            return out.toString(MuleManager.getConfiguration().getEncoding());
        }
        catch (Exception e1) {
            logger.error((Object)("Failed to format message, using direct string (details at debug level): " + e1.getMessage()));
            logger.debug((Object)e1.toString(), (Throwable)e1);
            return e.getMessage();
        }
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }
}

