/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.notifications;

import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.provider.UMOConnectable;

public class ConnectionNotification
extends UMOServerNotification {
    private static final long serialVersionUID = -6455441938378523145L;
    public static final int CONNECTION_CONNECTED = 701;
    public static final int CONNECTION_FAILED = 702;
    public static final int CONNECTION_DISCONNECTED = 703;
    private static final transient String[] ACTIONS = new String[]{"connected", "connect failed", "disconnected"};

    public ConnectionNotification(UMOConnectable resource, String identifier, int action) {
        super(resource, action);
        this.resourceIdentifier = identifier;
    }

    protected String getPayloadToString() {
        if (this.source instanceof UMOConnectable) {
            return ((UMOConnectable)this.source).getConnectionDescription();
        }
        return this.source.toString();
    }

    protected String getActionName(int action) {
        int i = action - 700;
        if (i - 1 > ACTIONS.length) {
            return String.valueOf(action);
        }
        return ACTIONS[i - 1];
    }

    public String getType() {
        if (this.action == 703) {
            return "warn";
        }
        if (this.action == 702) {
            return "error";
        }
        return "info";
    }
}

