/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model.seda;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.mule.MuleManager;
import org.mule.MuleRuntimeException;
import org.mule.config.PoolingProfile;
import org.mule.config.QueueProfile;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.FailedToQueueEventException;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleEvent;
import org.mule.impl.model.AbstractComponent;
import org.mule.impl.model.DefaultMuleProxy;
import org.mule.impl.model.MuleProxy;
import org.mule.impl.model.seda.SedaModel;
import org.mule.management.stats.ComponentStatistics;
import org.mule.management.stats.SedaComponentStatistics;
import org.mule.umo.ComponentException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.util.ObjectPool;
import org.mule.util.queue.QueueSession;

public class SedaComponent
extends AbstractComponent
implements Work,
WorkListener {
    public static final String QUEUE_PROFILE_PROPERTY = "queueProfile";
    public static final String POOLING_PROFILE_PROPERTY = "poolingProfile";
    private static final long serialVersionUID = 7711976708670893015L;
    protected ObjectPool proxyPool;
    protected MuleProxy componentProxy;
    protected UMOWorkManager workManager;
    protected String descriptorQueueName;
    protected int queueTimeout = 0;
    protected boolean enablePooling = true;
    protected boolean componentPerRequest = false;
    protected PoolingProfile poolingProfile;
    protected QueueProfile queueProfile;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SedaComponent(MuleDescriptor descriptor, SedaModel model) {
        super(descriptor, model);
        this.descriptorQueueName = descriptor.getName() + ".component";
        this.queueTimeout = model.getQueueTimeout();
        this.enablePooling = model.isEnablePooling();
        this.componentPerRequest = model.isComponentPerRequest();
        this.poolingProfile = model.getPoolingProfile();
        this.queueProfile = model.getQueueProfile();
    }

    public synchronized void doInitialise() throws InitialisationException {
        ThreadingProfile tp = this.descriptor.getThreadingProfile();
        this.workManager = tp.createWorkManager(this.descriptor.getName());
        this.queueProfile = this.descriptor.getQueueProfile();
        if (this.queueProfile == null) {
            this.queueProfile = ((SedaModel)this.model).getQueueProfile();
        }
        this.poolingProfile = this.descriptor.getPoolingProfile();
        if (this.poolingProfile == null) {
            this.poolingProfile = ((SedaModel)this.model).getPoolingProfile();
        }
        try {
            this.queueProfile.configureQueue(this.descriptorQueueName);
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InitialisationException(CoreMessages.objectFailedToInitialise("Component Queue"), e, this);
        }
    }

    protected ComponentStatistics createStatistics() {
        return new SedaComponentStatistics(this.getName(), this.descriptor.getThreadingProfile().getMaxThreadsActive(), this.poolingProfile.getMaxActive());
    }

    protected ObjectPool createPool() throws InitialisationException {
        return this.getPoolingProfile().getPoolFactory().createPool(this.descriptor, this.model, this.getPoolingProfile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void initialisePool() throws InitialisationException {
        try {
            block16: {
                block15: {
                    initPolicy = this.getPoolingProfile().getInitialisationPolicy();
                    if (initPolicy != 2) break block15;
                    numToBorrow = this.getPoolingProfile().getMaxActive();
                    holderList = new ArrayList<Object>(numToBorrow);
                    try {
                        for (t = 0; t < numToBorrow; ++t) {
                            holderList.add(this.proxyPool.borrowObject());
                        }
                        var6_7 = null;
                    }
                    catch (Throwable var5_15) {
                        var6_8 = null;
                        for (t = 0; t < holderList.size(); ++t) {
                            obj = holderList.get(t);
                            if (obj == null) continue;
                            this.proxyPool.returnObject(obj);
                            continue;
                        }
                        throw var5_15;
                    }
                    for (t = 0; t < holderList.size(); ++t) {
                        obj = holderList.get(t);
                        if (obj == null) continue;
                        this.proxyPool.returnObject(obj);
                        continue;
                    }
                    break block16;
                }
                if (initPolicy == 1) {
                    obj = null;
                    try {
                        obj = this.proxyPool.borrowObject();
                        var11_16 = null;
                        ** if (obj == null) goto lbl-1000
                    }
                    catch (Throwable var10_18) {
                        var11_17 = null;
                        if (obj != null) {
                            this.proxyPool.returnObject(obj);
                        }
                        throw var10_18;
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.proxyPool.returnObject(obj);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
            }
            this.poolInitialised.set(true);
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.objectFailedToInitialise("Proxy Pool"), e, this);
        }
    }

    protected MuleProxy createComponentProxy() throws InitialisationException {
        try {
            Object component = this.lookupComponent();
            DefaultMuleProxy componentProxy = new DefaultMuleProxy(component, this.descriptor, this.model);
            ((SedaComponentStatistics)this.getStatistics()).setComponentPoolSize(-1);
            componentProxy.setStatistics(this.getStatistics());
            componentProxy.start();
            return componentProxy;
        }
        catch (UMOException e) {
            throw new InitialisationException(e, (Object)this);
        }
    }

    public void doForceStop() throws UMOException {
        this.doStop();
    }

    public void doStop() throws UMOException {
        if (MuleManager.getInstance().getQueueManager().getQueueSession().getQueue(this.descriptor.getName() + ".component").size() > 0) {
            try {
                this.stopping.whenFalse(null);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.workManager.stop();
        if (this.proxyPool != null) {
            try {
                this.proxyPool.stop();
                this.proxyPool.clearPool();
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to stop component pool: " + e.getMessage()), (Throwable)e);
            }
            this.poolInitialised.set(false);
        } else if (this.componentProxy != null) {
            this.componentProxy.stop();
        }
    }

    public void doStart() throws UMOException {
        try {
            if (!this.poolInitialised.get() && this.enablePooling) {
                this.proxyPool = this.createPool();
                this.initialisePool();
                this.proxyPool.start();
            } else if (!this.componentPerRequest) {
                this.componentProxy = this.createComponentProxy();
            }
            this.workManager.start();
            this.workManager.scheduleWork(this, Long.MAX_VALUE, null, this);
        }
        catch (Exception e) {
            throw new LifecycleException(CoreMessages.failedToStart("Component: " + this.descriptor.getName()), e, this);
        }
    }

    protected void doDispose() {
        try {
            if (this.workManager != null) {
                this.workManager.dispose();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Component Thread Pool did not close properly: " + e));
        }
        try {
            if (this.proxyPool != null) {
                this.proxyPool.clearPool();
            } else if (this.componentProxy != null) {
                this.componentProxy.dispose();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Proxy Pool did not close properly: " + e));
        }
    }

    protected void doDispatch(UMOEvent event) throws UMOException {
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventASync();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Component: " + this.descriptor.getName() + " has received asynchronous event on: " + event.getEndpoint().getEndpointURI()));
        }
        try {
            this.enqueue(event);
            if (this.stats.isEnabled()) {
                this.stats.incQueuedEvent();
            }
        }
        catch (Exception e) {
            FailedToQueueEventException e1 = new FailedToQueueEventException(CoreMessages.interruptedQueuingEventFor(this.getName()), event.getMessage(), this, e);
            this.handleException(e1);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Event added to queue for: " + this.descriptor.getName()));
        }
    }

    public UMOMessage doSend(UMOEvent event) throws UMOException {
        UMOMessage result = null;
        MuleProxy proxy = null;
        try {
            proxy = this.getProxy();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this + " : got proxy for " + event.getId() + " = " + proxy));
            }
            result = (UMOMessage)proxy.onCall(event);
        }
        catch (UMOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ComponentException(event.getMessage(), this, (Throwable)e);
        }
        finally {
            this.releaseProxy(proxy);
        }
        return result;
    }

    ObjectPool getProxyPool() {
        return this.proxyPool;
    }

    public int getQueueSize() {
        QueueSession queueSession = MuleManager.getInstance().getQueueManager().getQueueSession();
        return queueSession.getQueue(this.descriptor.getName()).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MuleEvent event = null;
        MuleProxy proxy = null;
        QueueSession queueSession = MuleManager.getInstance().getQueueManager().getQueueSession();
        while (!this.stopped.get()) {
            try {
                this.paused.whenFalse(null);
                if (this.stopping.get() && (queueSession == null || queueSession.getQueue(this.descriptorQueueName).size() == 0)) {
                    this.stopping.set(false);
                    break;
                }
                event = (MuleEvent)this.dequeue();
                if (event == null) continue;
                if (this.stats.isEnabled()) {
                    this.stats.decQueuedEvent();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Component: " + this.descriptor.getName() + " dequeued event on: " + event.getEndpoint().getEndpointURI()));
                }
                proxy = this.getProxy();
                proxy.start();
                proxy.onEvent(queueSession, event);
                this.workManager.scheduleWork(proxy, Long.MAX_VALUE, null, this);
            }
            catch (Exception e) {
                this.releaseProxy(proxy);
                if (e instanceof InterruptedException) {
                    this.stopping.set(false);
                    break;
                }
                if (e instanceof NoSuchElementException) {
                    this.handleException(new ComponentException(CoreMessages.proxyPoolTimedOut(), event == null ? null : event.getMessage(), this, e));
                    continue;
                }
                if (e instanceof UMOException) {
                    this.handleException(e);
                    continue;
                }
                if (e instanceof WorkException) {
                    this.handleException(new ComponentException(CoreMessages.eventProcessingFailedFor(this.descriptor.getName()), event == null ? null : event.getMessage(), this, e));
                    continue;
                }
                this.handleException(new ComponentException(CoreMessages.failedToGetPooledObject(), event == null ? null : event.getMessage(), this, e));
            }
            finally {
                this.stopping.set(false);
            }
        }
    }

    protected MuleProxy getProxy() throws Exception {
        MuleProxy proxy;
        if (this.proxyPool != null) {
            proxy = (MuleProxy)this.proxyPool.borrowObject();
            ((SedaComponentStatistics)this.getStatistics()).setComponentPoolSize(this.proxyPool.getSize());
        } else {
            proxy = this.componentPerRequest ? this.createComponentProxy() : this.componentProxy;
        }
        proxy.setStatistics(this.getStatistics());
        return proxy;
    }

    public void release() {
        this.stopping.set(false);
    }

    protected void enqueue(UMOEvent event) throws Exception {
        QueueSession session = MuleManager.getInstance().getQueueManager().getQueueSession();
        session.getQueue(this.descriptorQueueName).put(event);
    }

    protected UMOEvent dequeue() throws Exception {
        QueueSession queueSession = MuleManager.getInstance().getQueueManager().getQueueSession();
        return (UMOEvent)queueSession.getQueue(this.descriptorQueueName).poll(this.queueTimeout);
    }

    public void workAccepted(WorkEvent event) {
        this.handleWorkException(event, "workAccepted");
    }

    public void workRejected(WorkEvent event) {
        this.handleWorkException(event, "workRejected");
        if (event.getWork() instanceof MuleProxy) {
            this.releaseProxy((MuleProxy)event.getWork());
        }
    }

    public void workStarted(WorkEvent event) {
        this.handleWorkException(event, "workStarted");
    }

    public void workCompleted(WorkEvent event) {
        this.handleWorkException(event, "workCompleted");
        if (event.getWork() instanceof MuleProxy) {
            this.releaseProxy((MuleProxy)event.getWork());
        }
    }

    protected void handleWorkException(WorkEvent event, String type) {
        if (event == null || event.getException() == null) {
            return;
        }
        Throwable e = event.getException();
        if (event.getException().getCause() != null) {
            e = event.getException().getCause();
        }
        this.logger.error((Object)("Work caused exception on '" + type + "'. Work being executed was: " + event.getWork().toString()));
        if (!(e instanceof Exception)) {
            throw new MuleRuntimeException(CoreMessages.componentCausedErrorIs(this.getName()), e);
        }
        this.handleException((Exception)e);
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public QueueProfile getQueueProfile() {
        return this.queueProfile;
    }

    public void setQueueProfile(QueueProfile queueProfile) {
        this.queueProfile = queueProfile;
    }

    private void releaseProxy(MuleProxy proxy) {
        if (proxy == null) {
            return;
        }
        try {
            this.doReleaseProxy(proxy);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void doReleaseProxy(MuleProxy proxy) throws Exception {
        if (!$assertionsDisabled && proxy == null) {
            throw new AssertionError();
        }
        if (this.proxyPool != null) {
            this.proxyPool.returnObject(proxy);
            ((SedaComponentStatistics)this.getStatistics()).setComponentPoolSize(this.proxyPool.getSize());
        } else if (this.componentPerRequest) {
            proxy.dispose();
        }
    }

    static {
        $assertionsDisabled = !SedaComponent.class.desiredAssertionStatus();
    }
}

