/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import org.mule.MuleException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.impl.ThreadSafeAccess;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.providers.file.i18n.FileMessages;
import org.mule.providers.file.transformers.FileToByteArray;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.util.ObjectUtils;

public class FileMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = 4127485947547548996L;
    private static final FileToByteArray transformer = new FileToByteArray();
    private File file = null;
    private byte[] contents = null;

    public FileMessageAdapter(Object message) throws MessagingException {
        if (!(message instanceof File)) {
            throw new MessageTypeNotSupportedException(message, this.getClass());
        }
        this.setMessage((File)message);
    }

    protected FileMessageAdapter(FileMessageAdapter template) {
        super(template);
        this.file = template.file;
        this.contents = template.contents;
    }

    public Object getPayload() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPayloadAsBytes() throws Exception {
        FileMessageAdapter fileMessageAdapter = this;
        synchronized (fileMessageAdapter) {
            if (this.contents == null) {
                try {
                    this.contents = (byte[])transformer.transform(this.file);
                }
                catch (Exception noPayloadException) {
                    throw new MuleException(CoreMessages.failedToReadPayload(), (Throwable)noPayloadException);
                }
            }
            return this.contents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPayloadAsString(String encoding) throws Exception {
        FileMessageAdapter fileMessageAdapter = this;
        synchronized (fileMessageAdapter) {
            return new String(this.getPayloadAsBytes(), encoding);
        }
    }

    protected void setMessage(File message) throws MessagingException {
        Exception fileInvalidException;
        boolean fileIsValid;
        try {
            fileIsValid = message != null && message.isFile();
            fileInvalidException = null;
        }
        catch (Exception ex) {
            fileInvalidException = ex;
            fileIsValid = false;
        }
        if (!fileIsValid) {
            Object exceptionArg = fileInvalidException != null ? fileInvalidException : ObjectUtils.toString(message, "null");
            Message msg = FileMessages.fileDoesNotExist(ObjectUtils.toString(message, "null"));
            throw new MessagingException(msg, exceptionArg);
        }
        this.file = message;
        this.contents = null;
        this.setProperty("originalFilename", this.file.getName());
        this.setProperty("directory", this.file.getParent());
    }

    public String getUniqueId() {
        return this.file.getAbsolutePath();
    }

    public ThreadSafeAccess newThreadCopy() {
        return new FileMessageAdapter(this);
    }
}

