/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.IOException;
import java.net.Socket;
import java.security.cert.Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.resource.spi.work.Work;
import org.mule.providers.http.HttpMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;

public class HttpsMessageReceiver
extends HttpMessageReceiver {
    public HttpsMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
    }

    protected Work createWork(Socket socket) throws IOException {
        return new HttpsWorker(socket);
    }

    private class HttpsWorker
    extends HttpMessageReceiver.HttpWorker
    implements HandshakeCompletedListener {
        private Certificate[] peerCertificateChain;
        private Certificate[] localCertificateChain;

        public HttpsWorker(Socket socket) throws IOException {
            super(socket);
            ((SSLSocket)socket).addHandshakeCompletedListener(this);
        }

        protected void preRouteMessage(UMOMessage message) {
            super.preRouteMessage(message);
            if (this.peerCertificateChain != null) {
                message.setProperty("PEER_CERTIFICATES", this.peerCertificateChain);
            }
            if (this.localCertificateChain != null) {
                message.setProperty("LOCAL_CERTIFICATES", this.localCertificateChain);
            }
        }

        public void handshakeCompleted(HandshakeCompletedEvent event) {
            this.localCertificateChain = event.getLocalCertificates();
            try {
                this.peerCertificateChain = event.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                HttpsMessageReceiver.this.logger.debug((Object)("Cannot get peer certificate chain: " + e.getMessage()));
            }
        }
    }
}

