/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import java.text.MessageFormat;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsSupport;

public class Jms11Support
implements JmsSupport {
    protected Context context;
    protected boolean jndiDestinations = false;
    protected boolean forceJndiDestinations = false;
    protected JmsConnector connector;
    protected static final Log logger = LogFactory.getLog(Jms11Support.class);

    public Jms11Support(JmsConnector connector, Context context, boolean jndiDestinations, boolean forceJndiDestinations) {
        this.connector = connector;
        this.context = context;
        this.jndiDestinations = jndiDestinations;
        this.forceJndiDestinations = forceJndiDestinations;
    }

    public Connection createConnection(ConnectionFactory connectionFactory, String username, String password) throws JMSException {
        logger.debug((Object)"");
        if (connectionFactory == null) {
            throw new IllegalArgumentException("connectionFactory cannot be null");
        }
        return connectionFactory.createConnection(username, password);
    }

    public Connection createConnection(ConnectionFactory connectionFactory) throws JMSException {
        logger.debug((Object)"");
        if (connectionFactory == null) {
            throw new IllegalArgumentException("connectionFactory cannot be null");
        }
        return connectionFactory.createConnection();
    }

    public Session createSession(Connection connection, boolean topic, boolean transacted, int ackMode, boolean noLocal) throws JMSException {
        logger.debug((Object)"");
        return connection.createSession(transacted, transacted ? 0 : ackMode);
    }

    public MessageProducer createProducer(Session session, Destination destination, boolean topic) throws JMSException {
        logger.debug((Object)"");
        return session.createProducer(destination);
    }

    public MessageConsumer createConsumer(Session session, Destination destination, boolean topic) throws JMSException {
        logger.debug((Object)"");
        return this.createConsumer(session, destination, null, false, null, topic);
    }

    public MessageConsumer createConsumer(Session session, Destination destination, String messageSelector, boolean noLocal, String durableName, boolean topic) throws JMSException {
        logger.debug((Object)"");
        if (durableName == null) {
            if (topic) {
                return session.createConsumer(destination, messageSelector, noLocal);
            }
            return session.createConsumer(destination, messageSelector);
        }
        if (topic) {
            return session.createDurableSubscriber((Topic)destination, durableName, messageSelector, noLocal);
        }
        throw new JMSException("A durable subscriber name was set but the destination was not a Topic");
    }

    public Destination createDestination(Session session, String name, boolean topic) throws JMSException {
        logger.debug((Object)"");
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null when creating a destination");
        }
        if (name == null) {
            throw new IllegalArgumentException("Destination name cannot be null when creating a destination");
        }
        if (this.jndiDestinations) {
            if (this.context == null) {
                throw new IllegalArgumentException("Jndi Context name cannot be null when looking up a destination");
            }
            Destination dest = this.getJndiDestination(name);
            if (dest != null) {
                return dest;
            }
            if (this.forceJndiDestinations) {
                throw new JMSException("JNDI destination not found with name: " + name);
            }
        }
        if (topic) {
            return session.createTopic(name);
        }
        return session.createQueue(name);
    }

    protected Destination getJndiDestination(String name) throws JMSException {
        Object temp;
        logger.debug((Object)"");
        try {
            temp = this.context.lookup(name);
        }
        catch (NamingException e) {
            throw new JMSException(MessageFormat.format("Failed to look up destination {0}. Reason: {1}", name, e.getMessage()));
        }
        if (temp != null) {
            if (temp instanceof Destination) {
                return (Destination)temp;
            }
            if (this.forceJndiDestinations) {
                throw new JMSException("JNDI destination not found with name: " + name);
            }
        }
        return null;
    }

    public Destination createTemporaryDestination(Session session, boolean topic) throws JMSException {
        logger.debug((Object)"");
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null when creating a destination");
        }
        if (topic) {
            return session.createTemporaryTopic();
        }
        return session.createTemporaryQueue();
    }

    public void send(MessageProducer producer, Message message, boolean topic) throws JMSException {
        logger.debug((Object)"");
        this.send(producer, message, this.connector.isPersistentDelivery(), 4, 0L, topic);
    }

    public void send(MessageProducer producer, Message message, Destination dest, boolean topic) throws JMSException {
        logger.debug((Object)"");
        this.send(producer, message, dest, this.connector.isPersistentDelivery(), 4, 0L, topic);
    }

    public void send(MessageProducer producer, Message message, boolean persistent, int priority, long ttl, boolean topic) throws JMSException {
        logger.debug((Object)"");
        producer.send(message, persistent ? 2 : 1, priority, ttl);
    }

    public void send(MessageProducer producer, Message message, Destination dest, boolean persistent, int priority, long ttl, boolean topic) throws JMSException {
        logger.debug((Object)"");
        producer.send(dest, message, persistent ? 2 : 1, priority, ttl);
    }
}

