/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.udp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.providers.udp.UdpConnector;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.util.MapUtils;

public class UdpSocketFactory
implements KeyedPoolableObjectFactory {
    protected final transient Log logger = LogFactory.getLog((Class)UdpSocketFactory.class);

    public Object makeObject(Object key) throws Exception {
        DatagramSocket socket;
        UMOImmutableEndpoint ep = (UMOImmutableEndpoint)key;
        if (ep.getType() == "receiver") {
            int port = ep.getEndpointURI().getPort();
            String host = ep.getEndpointURI().getHost();
            socket = port > 0 ? ("null".equalsIgnoreCase(host) ? this.createSocket(port) : this.createSocket(port, InetAddress.getByName(host))) : this.createSocket();
        } else {
            socket = this.createSocket();
        }
        UdpConnector connector = (UdpConnector)ep.getConnector();
        if (connector.getReceiveBufferSize() != -1 && socket.getReceiveBufferSize() != connector.getReceiveBufferSize()) {
            socket.setReceiveBufferSize(connector.getReceiveBufferSize());
        }
        if (connector.getSendBufferSize() != -1 && socket.getSendBufferSize() != connector.getSendBufferSize()) {
            socket.setSendBufferSize(connector.getSendBufferSize());
        }
        if (connector.getReceiveTimeout() != -1 && socket.getSoTimeout() != connector.getReceiveTimeout()) {
            socket.setSoTimeout(connector.getSendTimeout());
        }
        socket.setBroadcast(connector.isBroadcast());
        return socket;
    }

    public void destroyObject(Object key, Object object) throws Exception {
        Socket socket = (Socket)object;
        if (!socket.isClosed()) {
            socket.close();
        }
    }

    public boolean validateObject(Object key, Object object) {
        DatagramSocket socket = (DatagramSocket)object;
        return !socket.isClosed();
    }

    public void activateObject(Object key, Object object) throws Exception {
    }

    public void passivateObject(Object key, Object object) throws Exception {
        UMOImmutableEndpoint ep = (UMOImmutableEndpoint)key;
        boolean keepSocketOpen = MapUtils.getBooleanValue((Map)ep.getProperties(), (Object)"keepSendSocketOpen", (boolean)((UdpConnector)ep.getConnector()).isKeepSendSocketOpen());
        DatagramSocket socket = (DatagramSocket)object;
        if (!keepSocketOpen && socket != null) {
            socket.close();
        }
    }

    protected DatagramSocket createSocket() throws IOException {
        return new DatagramSocket();
    }

    protected DatagramSocket createSocket(int port) throws IOException {
        return new DatagramSocket(port);
    }

    protected DatagramSocket createSocket(int port, InetAddress inetAddress) throws IOException {
        return new DatagramSocket(port, inetAddress);
    }
}

