/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.mule.providers.jms;

import java.util.ArrayList;
import javax.jms.JMSException;
import javax.jms.Session;
import org.mule.providers.jms.JmsConnector;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOTransaction;

public class JasmineJmsConnector
extends JmsConnector {
    private ArrayList<Session> sessionCache = new ArrayList();
    private int count = 0;

    public JasmineJmsConnector() {
        this.logger.debug((Object)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(boolean transacted, boolean topic) throws JMSException {
        UMOTransaction tx;
        if (!this.isConnected()) {
            throw new JMSException("Not connected");
        }
        Session session = this.getSessionFromTransaction();
        if (session != null) {
            this.logger.debug((Object)"session retrieved from tx");
            return session;
        }
        ArrayList<Session> arrayList = this.sessionCache;
        synchronized (arrayList) {
            if (++this.count % 5000 == 0) {
                this.logger.warn((Object)("Close all sessions from cache: " + this.sessionCache.size()));
                while (!this.sessionCache.isEmpty()) {
                    session = this.sessionCache.remove(0);
                    session.close();
                }
                session = null;
            }
            if (!this.sessionCache.isEmpty()) {
                session = this.sessionCache.remove(0);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("session " + session + " retrieved from cache " + this.sessionCache.size()));
                }
            }
        }
        if (session == null) {
            session = this.getJmsSupport().createSession(this.getConnection(), topic, transacted, this.getAcknowledgementMode(), this.isNoLocal());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("new session created " + session));
            }
        }
        if ((tx = TransactionCoordination.getInstance().getTransaction()) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Binding session " + session + " to current transaction " + tx));
            }
            try {
                tx.bindResource(this.getConnection(), session);
            }
            catch (TransactionException e) {
                this.closeQuietly(session);
                throw new RuntimeException("Could not bind session to current transaction", e);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Session session) throws JMSException {
        if (session != null) {
            ArrayList<Session> arrayList = this.sessionCache;
            synchronized (arrayList) {
                this.sessionCache.add(session);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Return Session " + session + " in the cache " + this.sessionCache.size()));
            }
        }
    }
}

