/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.probe.JasmineCollectorInfo;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.collectors.JCollectorService;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollector;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollectorBase;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollectorSimple;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxWorker;
import org.ow2.jasmine.probe.jmx.JmxBrowserService;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionService;
import org.ow2.jasmine.probe.probemanager.ProbeManager;

@Component(name="JmxCollectorService")
@Provides
public class JmxCollectorService
extends JCollectorService
implements JmxBrowserService,
Pojo {
    private InstanceManager __IM;
    public static final String SHORT_DESC = "Get monitoring data from MBeans registered in an MBean server.";
    public static final String LONG_DESC = "MBean name (or filter) should be conform to the MBean ObjectName syntax.\nOne or more attributes or fragments can be specified.";
    public static final String SOURCE_DESC = "No source indicator used.";
    public static final int SOURCE_MIN = 0;
    public static final int SOURCE_MAX = 0;
    public static final String PROP_TARGET = "target";
    public static final String PROP_TARGET_DESC = "JMX target name. If not specified, a target must be specified by a probe using this indicator.";
    public static final String PROP_MBEAN = "mbean";
    public static final String PROP_MBEAN_DESC = "OBJECT_NAME or OBJECT_NAME pattern. Allows to determine the MBean(s) to be polled.";
    public static final String PROP_ATTR = "attr";
    public static final String PROP_ATTR_DESC = "Comma separated list of attributes or attribute fragment names. If not specified, all attribute of the mbean.";
    public static final String PROP_TEST = "test";
    public static final String DEFAULT_SERVER = "unknown";
    public static final String DEFAULT_DOMAIN = "unknown_domain";
    private boolean __FworkerList;
    private HashMap<String, JmxWorker> workerList;
    public static final String VALUE_ALL = "all";
    private boolean __FindicatorType;
    @ServiceProperty(name="indicator.type", value="jmx")
    private String indicatorType;
    private boolean __FjmxConnectionService;
    @Requires
    private JmxConnectionService jmxConnectionService;
    private boolean __FprobeManager;
    @Requires
    ProbeManager probeManager;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe;
    private boolean __MgetDependantTargets$org_ow2_jasmine_probe_JasmineIndicator;
    private boolean __MremoveTarget$java_lang_String;

    HashMap __getworkerList() {
        if (!this.__FworkerList) {
            return this.workerList;
        }
        return (HashMap)this.__IM.onGet((Object)this, "workerList");
    }

    void __setworkerList(HashMap hashMap) {
        if (!this.__FworkerList) {
            this.workerList = hashMap;
            return;
        }
        this.__IM.onSet((Object)this, "workerList", (Object)hashMap);
    }

    String __getindicatorType() {
        if (!this.__FindicatorType) {
            return this.indicatorType;
        }
        return (String)this.__IM.onGet((Object)this, "indicatorType");
    }

    void __setindicatorType(String string) {
        if (!this.__FindicatorType) {
            this.indicatorType = string;
            return;
        }
        this.__IM.onSet((Object)this, "indicatorType", (Object)string);
    }

    JmxConnectionService __getjmxConnectionService() {
        if (!this.__FjmxConnectionService) {
            return this.jmxConnectionService;
        }
        return (JmxConnectionService)this.__IM.onGet((Object)this, "jmxConnectionService");
    }

    void __setjmxConnectionService(JmxConnectionService jmxConnectionService) {
        if (!this.__FjmxConnectionService) {
            this.jmxConnectionService = jmxConnectionService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxConnectionService", (Object)jmxConnectionService);
    }

    ProbeManager __getprobeManager() {
        if (!this.__FprobeManager) {
            return this.probeManager;
        }
        return (ProbeManager)this.__IM.onGet((Object)this, "probeManager");
    }

    void __setprobeManager(ProbeManager probeManager) {
        if (!this.__FprobeManager) {
            this.probeManager = probeManager;
            return;
        }
        this.__IM.onSet((Object)this, "probeManager", (Object)probeManager);
    }

    public JmxCollectorService() {
        this(null);
    }

    private JmxCollectorService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setworkerList(new HashMap());
        this.__setjmxConnectionService(null);
        this.__setprobeManager(null);
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        this.collectorInfo = new JasmineCollectorInfo();
        this.collectorInfo.setType(this.__getindicatorType());
        this.collectorInfo.setShortDesc(SHORT_DESC);
        this.collectorInfo.setLongDesc(LONG_DESC);
        this.collectorInfo.setSourceDesc(SOURCE_DESC);
        this.collectorInfo.setSourceMin(0);
        this.collectorInfo.setSourceMax(0);
        this.properties = new ArrayList();
        this.properties.add(new JasminePropertyInfo(PROP_TARGET, PROP_TARGET_DESC, false));
        this.properties.add(new JasminePropertyInfo(PROP_MBEAN, PROP_MBEAN_DESC, true));
        this.properties.add(new JasminePropertyInfo(PROP_ATTR, PROP_ATTR_DESC, false));
        this.collectorInfo.setPropertyInfos(this.properties);
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() {
        this.removeCollectors(null, null);
        for (JmxWorker worker : this.__getworkerList().values()) {
            worker.remove();
        }
    }

    public synchronized JasmineCollector getCollector(JasmineIndicator jasmineIndicator, JasmineProbe jasmineProbe) throws JasmineCollectorException {
        JasmineCollector jasmineCollector;
        if (!this.__MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe) {
            return this.__getCollector(jasmineIndicator, jasmineProbe);
        }
        try {
            this.__IM.onEntry((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe", new Object[]{jasmineIndicator, jasmineProbe});
            jasmineCollector = this.__getCollector(jasmineIndicator, jasmineProbe);
            this.__IM.onExit((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe", (Object)jasmineCollector);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe", throwable);
            throw throwable;
        }
        return jasmineCollector;
    }

    private JasmineCollector __getCollector(JasmineIndicator indicator, JasmineProbe probe) throws JasmineCollectorException {
        if (!indicator.getType().equals(this.__getindicatorType())) {
            this.logger.error((Object)("Bad type: " + indicator.getType()), new Object[0]);
            throw new JasmineCollectorException("Bad type: " + indicator.getType());
        }
        String probeTarget = null;
        if (!probe.getTargetList().isEmpty()) {
            probeTarget = (String)probe.getTargetList().get(0);
        }
        Map props = indicator.getProperties();
        String mbean = (String)props.get(PROP_MBEAN);
        String attr = (String)props.get(PROP_ATTR);
        String test = (String)props.get(PROP_TEST);
        String targetName = null;
        targetName = probeTarget != null ? probeTarget : (String)props.get(PROP_TARGET);
        if (targetName == null) {
            this.logger.error((Object)"Undefined target for probe {0} and indicator {1} ", new Object[]{probe.getId(), indicator.getName()});
            throw new JasmineCollectorException("Undefined target for probe " + probe.getId() + " and indicator " + indicator.getName());
        }
        JasmineTarget target = this.__getprobeManager().getTarget(targetName);
        if (target == null) {
            this.logger.error((Object)("Unknown target: " + target), new Object[0]);
            throw new JasmineCollectorException("Unknown target: " + targetName);
        }
        if (target.getProperties().isEmpty()) {
            this.logger.error((Object)"Wrong definition for target: {0}. Properties are missing.", new Object[]{targetName});
            throw new JasmineCollectorException("Wrong definition for target: " + targetName);
        }
        if (target.getProperties().get("url") == null) {
            this.logger.error((Object)"Wrong definition for target: {0}. Property url is missing.", new Object[]{targetName});
            throw new JasmineCollectorException("Wrong definition for target: " + targetName);
        }
        JmxCollectorBase collector = null;
        if ("true".equals(test)) {
            JCollector coll = this.getCollector(indicator.getName(), probe.getId());
            if (coll == null) {
                collector = new JmxCollectorSimple(probe.getId(), indicator, probe.getPeriod(), mbean, attr);
                ((JmxCollectorSimple)collector).setJmxConnectionService(this.__getjmxConnectionService());
                ((JmxCollectorSimple)collector).setTarget(target);
                this.addCollector(indicator.getName(), collector);
            } else if (coll instanceof JmxCollectorSimple) {
                JmxCollectorSimple collThread = (JmxCollectorSimple)coll;
                ++collThread.nb;
                collector = collThread;
            }
        } else {
            collector = new JmxCollector(probe.getId(), indicator, probe.getPeriod(), mbean, attr);
            JmxWorker worker = null;
            if (this.__getworkerList().containsKey(targetName)) {
                worker = (JmxWorker)this.__getworkerList().get(targetName);
            } else {
                worker = new JmxWorker(target, this.__getjmxConnectionService());
                this.__getworkerList().put(targetName, worker);
            }
            worker.addCollector((JmxCollector)collector);
            this.addCollector(indicator.getName(), collector);
        }
        return collector;
    }

    public List<String> getDependantTargets(JasmineIndicator jasmineIndicator) {
        List<String> list;
        if (!this.__MgetDependantTargets$org_ow2_jasmine_probe_JasmineIndicator) {
            return this.__getDependantTargets(jasmineIndicator);
        }
        try {
            this.__IM.onEntry((Object)this, "getDependantTargets$org_ow2_jasmine_probe_JasmineIndicator", new Object[]{jasmineIndicator});
            list = this.__getDependantTargets(jasmineIndicator);
            this.__IM.onExit((Object)this, "getDependantTargets$org_ow2_jasmine_probe_JasmineIndicator", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDependantTargets$org_ow2_jasmine_probe_JasmineIndicator", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getDependantTargets(JasmineIndicator indic) {
        ArrayList<String> ret = new ArrayList<String>();
        Map props = indic.getProperties();
        for (String key : props.keySet()) {
            if (!PROP_TARGET.equals(key)) continue;
            ret.add((String)props.get(key));
        }
        return ret;
    }

    public synchronized void removeTarget(String string) {
        if (!this.__MremoveTarget$java_lang_String) {
            this.__removeTarget(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeTarget$java_lang_String", new Object[]{string});
            this.__removeTarget(string);
            this.__IM.onExit((Object)this, "removeTarget$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeTarget$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __removeTarget(String targetName) {
        JmxWorker workerToremove = (JmxWorker)this.__getworkerList().get(targetName);
        if (workerToremove != null) {
            workerToremove.remove();
            this.__getworkerList().remove(targetName);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("probeManager")) {
                this.__FprobeManager = true;
            }
            if (set.contains("indicatorType")) {
                this.__FindicatorType = true;
            }
            if (set.contains("workerList")) {
                this.__FworkerList = true;
            }
            if (set.contains("jmxConnectionService")) {
                this.__FjmxConnectionService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("getCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe")) {
                this.__MgetCollector$org_ow2_jasmine_probe_JasmineIndicator$org_ow2_jasmine_probe_JasmineProbe = true;
            }
            if (set.contains("getDependantTargets$org_ow2_jasmine_probe_JasmineIndicator")) {
                this.__MgetDependantTargets$org_ow2_jasmine_probe_JasmineIndicator = true;
            }
            if (set.contains("removeTarget$java_lang_String")) {
                this.__MremoveTarget$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

